/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.media;

import java.util.HashSet;
import java.util.Set;

import org.videolan.vlma.model.StreamingStrategy;

public class MediaProgramAdd {

    private String sap;

    private String priority;

    private StreamingStrategy.Protocol protocol;

    private StreamingStrategy.Encapsulation mux;

    private AnnouncementCheckbox[] announcements;

    private int mediaId;

    public MediaProgramAdd() {
        announcements = new AnnouncementCheckbox[StreamingStrategy.Announcement.values().length];
        int i = 0;
        for (StreamingStrategy.Announcement announcement : StreamingStrategy.Announcement.values()) {
            AnnouncementCheckbox ac = new AnnouncementCheckbox();
            ac.setAnnouncement(announcement);
            announcements[i++] = ac;
        }
    }

    public StreamingStrategy.Protocol[] getProtocols() {
        return StreamingStrategy.Protocol.values();
    }

    public StreamingStrategy.Encapsulation[] getMuxs() {
        return StreamingStrategy.Encapsulation.values();
    }

    public String getPriority() {
        return priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getSap() {
        return sap;
    }

    public void setSap(String sap) {
        this.sap = sap;
    }

    public int getMediaId() {
        return mediaId;
    }

    public void setMediaId(int mediaId) {
        this.mediaId = mediaId;
    }

    public StreamingStrategy.Encapsulation getMux() {
        return mux;
    }

    public void setMux(StreamingStrategy.Encapsulation mux) {
        this.mux = mux;
    }

    public StreamingStrategy.Protocol getProtocol() {
        return protocol;
    }

    public void setProtocol(StreamingStrategy.Protocol protocol) {
        this.protocol = protocol;
    }

    public AnnouncementCheckbox[] getAnnouncementCheckboxes() {
        return announcements;
    }

    public void setAnnouncementCheckboxes(AnnouncementCheckbox[] announcements) {
        this.announcements = announcements;
    }

    public Set<StreamingStrategy.Announcement> getAnnouncements() {
        Set<StreamingStrategy.Announcement> result = new HashSet<StreamingStrategy.Announcement>();
        for(AnnouncementCheckbox a : getAnnouncementCheckboxes()) {
            if (a.getChecked())
                result.add(a.getAnnouncement());
        }
        return result;
    }

    public void setAnnouncements(Set<StreamingStrategy.Announcement> announcements) {
        for(AnnouncementCheckbox a : getAnnouncementCheckboxes()) {
            a.setChecked(announcements.contains(a.getAnnouncement()));
        }
    }

    public class AnnouncementCheckbox {

        private boolean checked;

        private StreamingStrategy.Announcement announcement;

        public StreamingStrategy.Announcement getAnnouncement() {
            return announcement;
        }

        public void setAnnouncement(StreamingStrategy.Announcement announcement) {
            this.announcement = announcement;
        }

        public boolean getChecked() {
            return checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }

    }
}
