/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Timer;
import java.util.TimerTask;
import org.jrobin.core.RrdFileBackend;

public class RrdNioBackend
extends RrdFileBackend {
    public static final boolean SHOULD_GC = true;
    private static final Timer syncTimer;
    private int syncMode;
    MappedByteBuffer byteBuffer;
    private TimerTask syncTask;

    protected RrdNioBackend(String string, boolean bl, int n, int n2, int n3) throws IOException {
        super(string, bl, n);
        this.map(bl);
        this.syncMode = n2;
        if (n2 == 5 && !bl) {
            this.createSyncTask(n3);
        }
    }

    private void map(boolean bl) throws IOException {
        long l = this.getLength();
        if (l > 0L) {
            FileChannel.MapMode mapMode = bl ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            this.byteBuffer = this.channel.map(mapMode, 0L, l);
        } else {
            this.byteBuffer = null;
        }
    }

    private void createSyncTask(int n) {
        this.syncTask = new TimerTask(){

            public void run() {
                RrdNioBackend.this.sync();
            }
        };
        syncTimer.schedule(this.syncTask, (long)n * 1000L, (long)n * 1000L);
    }

    protected void setLength(long l) throws IOException {
        if (l < this.getLength()) {
            this.byteBuffer = null;
            System.gc();
        }
        super.setLength(l);
        this.map(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(long l, byte[] byArray) {
        MappedByteBuffer mappedByteBuffer = this.byteBuffer;
        synchronized (mappedByteBuffer) {
            this.byteBuffer.position((int)l);
            this.byteBuffer.put(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(long l, byte[] byArray) {
        MappedByteBuffer mappedByteBuffer = this.byteBuffer;
        synchronized (mappedByteBuffer) {
            this.byteBuffer.position((int)l);
            this.byteBuffer.get(byArray);
        }
    }

    public void close() throws IOException {
        if (this.syncTask != null) {
            this.syncTask.cancel();
        }
        super.close();
        this.byteBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        if (this.byteBuffer != null) {
            MappedByteBuffer mappedByteBuffer = this.byteBuffer;
            synchronized (mappedByteBuffer) {
                this.byteBuffer.force();
            }
        }
    }

    protected void beforeUpdate() {
        if (this.syncMode == 1) {
            this.sync();
        }
    }

    protected void afterUpdate() {
        if (this.syncMode == 2) {
            this.sync();
        }
    }

    protected void beforeFetch() {
        if (this.syncMode == 3) {
            this.sync();
        }
    }

    protected void afterFetch() {
        if (this.syncMode == 4) {
            this.sync();
        }
    }

    static {
        final Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(){

            public void run() {
                runtime.runFinalization();
                runtime.gc();
            }
        });
        syncTimer = new Timer(true);
    }
}

