/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.notifier;

import java.io.IOException;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.videolan.vlma.notifier.IRCNotifier;
import org.videolan.vlma.notifier.Notifier;
import rath.msnm.MSNMessenger;
import rath.msnm.SwitchboardSession;
import rath.msnm.msg.MimeMessage;

public class MSNNotifier
extends Notifier {
    private static final Logger logger = Logger.getLogger(IRCNotifier.class);
    private Configuration configuration;
    private MSNMessenger msnm;
    private String login;
    private String pass;
    private List<String> recipients;

    private void connect() {
        this.login = this.configuration.getString("vlma.notification.msn.login");
        this.pass = this.configuration.getString("vlma.notification.msn.pass");
        this.recipients = this.configuration.getList("vlma.notification.msn.recipients");
        this.msnm = new MSNMessenger(this.login, this.pass);
        this.msnm.setInitialStatus("NLN");
        this.msnm.login();
    }

    public void init() {
        if (this.isMSNEnabled()) {
            this.connect();
        }
    }

    private boolean isMSNEnabled() {
        List tmp = this.configuration.getList("vlma.notification.msn.recipients");
        return tmp != null && tmp.size() > 0;
    }

    public void sendNotification(String message) {
        if (this.isMSNEnabled()) {
            if (this.msnm == null || !this.msnm.isLoggedIn()) {
                this.connect();
            }
            MimeMessage msg = new MimeMessage();
            msg.setKind(2);
            msg.setMessage(message);
            SwitchboardSession ss = null;
            for (String recipient : this.recipients) {
                ss = null;
                try {
                    while (ss == null) {
                        ss = this.msnm.doCallWait(recipient);
                    }
                    ss.sendInstantMessage(msg);
                }
                catch (IOException e) {
                    logger.error((Object)"Could not send message", (Throwable)e);
                }
                catch (InterruptedException e) {
                    logger.error((Object)"Could not send message", (Throwable)e);
                }
            }
        }
    }

    public void destroy() {
        if (this.msnm != null && this.msnm.isLoggedIn()) {
            this.msnm.logout();
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

