/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.enums;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.core.enums.LabeledEnumResolver;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;
import org.springframework.util.ClassUtils;

public abstract class AbstractCachingLabeledEnumResolver
implements LabeledEnumResolver {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private final CachingMapDecorator labeledEnumCache = new CachingMapDecorator(true){

        protected Object create(Object key) {
            Class enumType = (Class)key;
            Set typeEnums = AbstractCachingLabeledEnumResolver.this.findLabeledEnums(enumType);
            if (typeEnums == null || typeEnums.isEmpty()) {
                throw new IllegalArgumentException("Unsupported labeled enumeration type '" + key + "': " + "make sure you've properly defined this enumeration! " + "If it is static, are the class and its fields public/static/final?");
            }
            HashMap<Comparable, LabeledEnum> typeEnumMap = new HashMap<Comparable, LabeledEnum>(typeEnums.size());
            Iterator it = typeEnums.iterator();
            while (it.hasNext()) {
                LabeledEnum labeledEnum = (LabeledEnum)it.next();
                typeEnumMap.put(labeledEnum.getCode(), labeledEnum);
            }
            Map cachedValue = Collections.unmodifiableMap(typeEnumMap);
            if (ClassUtils.isCacheSafe(enumType, this.getClass().getClassLoader())) {
                return cachedValue;
            }
            if (AbstractCachingLabeledEnumResolver.this.logger.isDebugEnabled()) {
                AbstractCachingLabeledEnumResolver.this.logger.debug((Object)("Not strongly caching class [" + enumType.getName() + "] because it is not cache-safe"));
            }
            return new WeakReference(cachedValue);
        }
    };

    public Set getLabeledEnumSet(Class type) throws IllegalArgumentException {
        return new TreeSet(this.getLabeledEnumMap(type).values());
    }

    public Map getLabeledEnumMap(Class type) throws IllegalArgumentException {
        Assert.notNull(type, "No type specified");
        return (Map)this.labeledEnumCache.get(type);
    }

    public LabeledEnum getLabeledEnumByCode(Class type, Comparable code) throws IllegalArgumentException {
        Assert.notNull(code, "No enum code specified");
        Map typeEnums = this.getLabeledEnumMap(type);
        LabeledEnum codedEnum = (LabeledEnum)typeEnums.get(code);
        if (codedEnum == null) {
            throw new IllegalArgumentException("No enumeration with code '" + code + "'" + " of type [" + type.getName() + "] exists: this is likely a configuration error. " + "Make sure the code value matches a valid instance's code property!");
        }
        return codedEnum;
    }

    public LabeledEnum getLabeledEnumByLabel(Class type, String label) throws IllegalArgumentException {
        Map typeEnums = this.getLabeledEnumMap(type);
        Iterator it = typeEnums.values().iterator();
        while (it.hasNext()) {
            LabeledEnum value = (LabeledEnum)it.next();
            if (!value.getLabel().equalsIgnoreCase(label)) continue;
            return value;
        }
        throw new IllegalArgumentException("No enumeration with label '" + label + "' of type [" + type + "] exists: this is likely a configuration error. " + "Make sure the label string matches a valid instance's label property!");
    }

    protected abstract Set findLabeledEnums(Class var1);
}

