/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

public class XmlFriendlyReplacer {
    private String dollarReplacement;
    private String underscoreReplacement;

    public XmlFriendlyReplacer() {
        this("_-", "__");
    }

    public XmlFriendlyReplacer(String dollarReplacement, String underscoreReplacement) {
        this.dollarReplacement = dollarReplacement;
        this.underscoreReplacement = underscoreReplacement;
    }

    public String escapeName(String name) {
        StringBuffer result = new StringBuffer();
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (c == '$') {
                result.append(this.dollarReplacement);
                continue;
            }
            if (c == '_') {
                result.append(this.underscoreReplacement);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public String unescapeName(String name) {
        int underscoreReplacementInc = this.underscoreReplacement.length() - 1;
        int dollarReplacementInc = this.dollarReplacement.length() - 1;
        int length = name.length();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (name.startsWith(this.dollarReplacement, i)) {
                i += dollarReplacementInc;
                result.append('$');
                continue;
            }
            if (name.startsWith(this.underscoreReplacement, i)) {
                i += underscoreReplacementInc;
                result.append('_');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

