/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.Date;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.Plottable;

public class CubicSplineInterpolator
extends Plottable {
    private double[] x;
    private double[] y;
    private double[] y2;
    private int n;
    private int klo;
    private int khi;

    public CubicSplineInterpolator(long[] lArray, double[] dArray) throws RrdException {
        this.x = new double[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            this.x[i] = lArray[i];
        }
        this.y = dArray;
        this.validate();
        this.spline();
    }

    public CubicSplineInterpolator(Date[] dateArray, double[] dArray) throws RrdException {
        this.x = new double[dateArray.length];
        for (int i = 0; i < dateArray.length; ++i) {
            this.x[i] = Util.getTimestamp(dateArray[i]);
        }
        this.y = dArray;
        this.validate();
        this.spline();
    }

    public CubicSplineInterpolator(GregorianCalendar[] gregorianCalendarArray, double[] dArray) throws RrdException {
        this.x = new double[gregorianCalendarArray.length];
        for (int i = 0; i < gregorianCalendarArray.length; ++i) {
            this.x[i] = Util.getTimestamp(gregorianCalendarArray[i]);
        }
        this.y = dArray;
        this.validate();
        this.spline();
    }

    public CubicSplineInterpolator(double[] dArray, double[] dArray2) throws RrdException {
        this.x = dArray;
        this.y = dArray2;
        this.validate();
        this.spline();
    }

    private void validate() throws RrdException {
        boolean bl = true;
        if (this.x.length != this.y.length || this.x.length < 3) {
            bl = false;
        }
        for (int i = 0; i < this.x.length - 1 && bl; ++i) {
            if (!(this.x[i] >= this.x[i + 1]) && !Double.isNaN(this.y[i])) continue;
            bl = false;
        }
        if (!bl) {
            throw new RrdException("Invalid plottable data supplied");
        }
    }

    private void spline() {
        int n;
        this.n = this.x.length;
        this.y2 = new double[this.n];
        double[] dArray = new double[this.n - 1];
        this.y2[this.n - 1] = 0.0;
        this.y2[0] = 0.0;
        dArray[0] = 0.0;
        for (n = 1; n <= this.n - 2; ++n) {
            double d = (this.x[n] - this.x[n - 1]) / (this.x[n + 1] - this.x[n - 1]);
            double d2 = d * this.y2[n - 1] + 2.0;
            this.y2[n] = (d - 1.0) / d2;
            dArray[n] = (this.y[n + 1] - this.y[n]) / (this.x[n + 1] - this.x[n]) - (this.y[n] - this.y[n - 1]) / (this.x[n] - this.x[n - 1]);
            dArray[n] = (6.0 * dArray[n] / (this.x[n + 1] - this.x[n - 1]) - d * dArray[n - 1]) / d2;
        }
        for (n = this.n - 2; n >= 0; --n) {
            this.y2[n] = this.y2[n] * this.y2[n + 1] + dArray[n];
        }
        this.klo = 0;
        this.khi = this.n - 1;
    }

    public double getValue(double d) {
        if (d < this.x[0] || d > this.x[this.n - 1]) {
            return Double.NaN;
        }
        if (d < this.x[this.klo] || d > this.x[this.khi]) {
            this.klo = 0;
            this.khi = this.n - 1;
        }
        while (this.khi - this.klo > 1) {
            int n = (this.khi + this.klo) / 2;
            if (this.x[n] > d) {
                this.khi = n;
                continue;
            }
            this.klo = n;
        }
        double d2 = this.x[this.khi] - this.x[this.klo];
        double d3 = (this.x[this.khi] - d) / d2;
        double d4 = (d - this.x[this.klo]) / d2;
        return d3 * this.y[this.klo] + d4 * this.y[this.khi] + ((d3 * d3 * d3 - d3) * this.y2[this.klo] + (d4 * d4 * d4 - d4) * this.y2[this.khi]) * (d2 * d2) / 6.0;
    }

    public double getValue(long l) {
        return this.getValue((double)l);
    }
}

