/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.support.JstlUtils;
import org.springframework.web.servlet.view.InternalResourceView;

public class JstlView
extends InternalResourceView {
    private MessageSource messageSource;

    public JstlView() {
    }

    public JstlView(String url) {
        super(url);
    }

    public JstlView(String url, MessageSource messageSource) {
        this(url);
        this.messageSource = messageSource;
    }

    protected void initApplicationContext(ApplicationContext context) {
        if (this.messageSource == null) {
            this.messageSource = context;
        }
        super.initApplicationContext(context);
    }

    protected void initServletContext(ServletContext servletContext) {
        this.messageSource = JstlUtils.getJstlAwareMessageSource(servletContext, this.messageSource);
        super.initServletContext(servletContext);
    }

    protected void exposeHelpers(HttpServletRequest request) throws Exception {
        JstlUtils.exposeLocalizationContext(request, this.messageSource);
    }
}

