/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.math.BigInteger;
import snmp.SNMPBadValueException;
import snmp.SNMPInteger;

public class SNMPCounter32
extends SNMPInteger {
    private static BigInteger maxValue = new BigInteger("4294967295");

    public SNMPCounter32() {
        this(0L);
    }

    public SNMPCounter32(long l) {
        this.tag = (byte)65;
        this.value = new BigInteger(new Long(l).toString());
        this.value = this.value.mod(maxValue);
    }

    protected SNMPCounter32(byte[] byArray) throws SNMPBadValueException {
        this.tag = (byte)65;
        this.extractValueFromBEREncoding(byArray);
        this.value = this.value.mod(maxValue);
    }

    public void setValue(Object object) throws SNMPBadValueException {
        if (object instanceof BigInteger) {
            this.value = (BigInteger)object;
            this.value = this.value.mod(maxValue);
        } else if (object instanceof Integer) {
            this.value = new BigInteger(object.toString());
            this.value = this.value.mod(maxValue);
        } else if (object instanceof String) {
            this.value = this.value = new BigInteger((String)object);
            this.value = this.value.mod(maxValue);
        } else {
            throw new SNMPBadValueException(" Counter32: bad object supplied to set value ");
        }
    }
}

