/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.common.medias;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlMedia;
import org.videolan.vlma.common.medias.VlMediaGroup;
import org.videolan.vlma.common.medias.VlSatChannel;
import org.videolan.vlma.common.programs.IVlProgram;

public class VlTNTChannel
extends VlMedia {
    public static final String SAP_GROUP = "TNT";
    private static final Logger logger = Logger.getLogger(VlTNTChannel.class);
    private int frequency;
    private int sid;
    private String fullname;

    public void setProgram(IVlProgram program) {
        super.setProgram(program);
        this.updateSapGroup();
    }

    protected void updateSapGroup() {
        if (this.program != null) {
            this.program.setSapGroup(SAP_GROUP);
        }
    }

    public int getSid() {
        return this.sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public boolean equals(Object o) {
        if (o.getClass().equals(VlTNTChannel.class)) {
            VlTNTChannel c = (VlTNTChannel)o;
            logger.log(Level.DEBUG, "Comparaison de " + this.getName() + " et " + c.getName());
            return c.getFrequency() == this.frequency && c.getSid() == this.sid && c.name.equals(this.name);
        }
        return false;
    }

    public boolean sameGroup(IVlMedia media) {
        if (media.getClass() == VlTNTChannel.class) {
            VlTNTChannel c = (VlTNTChannel)media;
            return c.getFrequency() == this.frequency;
        }
        return false;
    }

    public boolean belongsToGroup(VlMediaGroup group) {
        if (!group.medias.isEmpty()) {
            return this.sameGroup(group.medias.get(0));
        }
        return false;
    }

    public int hashCode() {
        return this.frequency + this.name.hashCode();
    }

    public int compareTo(IVlMedia other) {
        if (other == null) {
            return -1;
        }
        if (other.getClass().equals(VlSatChannel.class)) {
            return 1;
        }
        if (other.getClass().equals(VlTNTChannel.class)) {
            VlTNTChannel channel = (VlTNTChannel)other;
            if (channel.getFrequency() < this.frequency) {
                return 1;
            }
            if (channel.getFrequency() > this.frequency) {
                return -1;
            }
            return this.name.compareTo(channel.getName());
        }
        return -1;
    }

    public int getId() {
        return this.hashCode();
    }
}

