/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.control;

import java.awt.Component;
import org.bluray.media.PanningChangeEvent;
import org.bluray.media.PanningChangeListener;
import org.bluray.media.PanningControl;
import org.videolan.BDJListeners;
import org.videolan.media.content.BDHandler;

public class PanningControlImpl
implements PanningControl {
    private BDHandler player;
    private BDJListeners listeners = new BDJListeners();
    private float fading = 0.0f;
    private float balance = 0.0f;

    public PanningControlImpl(BDHandler player) {
        this.player = player;
    }

    public Component getControlComponent() {
        return null;
    }

    public void addPanningChangeListener(PanningChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePanningChangeListener(PanningChangeListener listener) {
        this.listeners.remove(listener);
    }

    public float getLeftRight() {
        return this.balance;
    }

    public float getFrontRear() {
        return this.fading;
    }

    public void setLeftRight(float balance) {
        this.setPosition(balance, this.fading);
    }

    public void setFrontRear(float panning) {
        this.setPosition(this.balance, panning);
    }

    public void setPosition(float x, float y) {
        this.balance = this.clip(x);
        this.fading = this.clip(y);
        this.player.setPanning(this.balance, this.fading);
        this.listeners.putCallback(new PanningChangeEvent(this, this.balance, this.fading));
    }

    private float clip(float val) {
        if (val != val) {
            return 0.0f;
        }
        return Math.min(-1.0f, Math.max(1.0f, val));
    }
}

