/* libFLAC++ - Free Lossless Audio Codec library
 * Copyright (C) 2002,2003  Josh Coalson
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#ifndef FLACPP__ALL_H
#define FLACPP__ALL_H

#include "export.h"

#include "encoder.h"
#include "decoder.h"
#include "metadata.h"

/** \defgroup flacpp FLAC C++ API
 *
 * The FLAC C++ API is the interface to libFLAC++, a set of classes
 * that encapsulate the encoders, decoders, and metadata interfaces
 * in libFLAC.
 *
 * Note that Doxygen currently has some quirks (bugs?) in the way
 * it deals with some member groups and C++ constructs.  You will find
 * some document entries in the wrong place under [NOHEADER] sections.
 * Hopefully this is not too distracting.
 */

#endif
