/*
 * Real Audio 1.0 (14.4K)
 * Copyright (c) 2003 the ffmpeg project
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "avcodec.h"

#define DATABLOCK1	20			/* size of 14.4 input block in bytes */
#define DATACHUNK1	1440			/* size of 14.4 input chunk in bytes */
#define AUDIOBLOCK	160			/* size of output block in 16-bit words (320 bytes) */
#define AUDIOBUFFER	12288			/* size of output buffer in 16-bit words (24576 bytes) */
/* consts */
#define NBLOCKS		4				/* number of segments within a block */
#define BLOCKSIZE	40				/* (quarter) block size in 16-bit words (80 bytes) */
#define HALFBLOCK	20				/* BLOCKSIZE/2 */
#define BUFFERSIZE	146				/* for do_output */


/* internal globals */
typedef struct {
	unsigned int	 resetflag, val, oldval;
	unsigned int	 unpacked[28];		/* buffer for unpacked input */
	unsigned int	*iptr;				/* pointer to current input (from unpacked) */
	unsigned int	 gval;
	unsigned short	*gsp;
	unsigned int	 gbuf1[8];
	unsigned short	 gbuf2[120];
	signed   short	 output_buffer[40];
	unsigned int	*decptr;			/* decoder ptr */
	signed   short	*decsp;

	/* the swapped buffers */
	unsigned int	 swapb1a[10];
	unsigned int	 swapb2a[10];
	unsigned int	 swapb1b[10];
	unsigned int	 swapb2b[10];
	unsigned int	*swapbuf1;
	unsigned int	*swapbuf2;
	unsigned int	*swapbuf1alt;
	unsigned int	*swapbuf2alt;

	unsigned int buffer[5];
	unsigned short int buffer_2[148];
	unsigned short int buffer_a[40];
	unsigned short int buffer_b[40];
	unsigned short int buffer_c[40];
	unsigned short int buffer_d[40];

	unsigned short int work[50];
	unsigned short *sptr;

	int buffer1[10];
	int buffer2[10];

	signed short wavtable1[2304];
	unsigned short wavtable2[2304];
} Real144_internal;

/* 14.4 data tables */
const unsigned short sqrt_table[4096]={
0x0000,0x0400,0x05a8,0x06ed,0x0800,0x08f1,0x09cc,0x0a95,
0x0b50,0x0c00,0x0ca6,0x0d44,0x0ddb,0x0e6c,0x0ef7,0x0f7d,
0x1000,0x107e,0x10f8,0x116f,0x11e3,0x1254,0x12c2,0x132e,
0x1398,0x1400,0x1465,0x14c8,0x152a,0x158a,0x15e8,0x1645,
0x16a0,0x16fa,0x1752,0x17aa,0x1800,0x1854,0x18a8,0x18fa,
0x194c,0x199c,0x19ec,0x1a3a,0x1a88,0x1ad5,0x1b21,0x1b6c,
0x1bb6,0x1c00,0x1c48,0x1c90,0x1cd8,0x1d1e,0x1d64,0x1daa,
0x1dee,0x1e33,0x1e76,0x1eb9,0x1efb,0x1f3d,0x1f7e,0x1fbf,
0x2000,0x203f,0x207f,0x20bd,0x20fc,0x2139,0x2177,0x21b4,
0x21f0,0x222d,0x2268,0x22a4,0x22df,0x2319,0x2353,0x238d,
0x23c6,0x2400,0x2438,0x2471,0x24a9,0x24e0,0x2518,0x254f,
0x2585,0x25bc,0x25f2,0x2628,0x265d,0x2693,0x26c8,0x26fc,
0x2731,0x2765,0x2799,0x27cc,0x2800,0x2833,0x2865,0x2898,
0x28ca,0x28fc,0x292e,0x2960,0x2991,0x29c2,0x29f3,0x2a24,
0x2a54,0x2a85,0x2ab5,0x2ae5,0x2b14,0x2b44,0x2b73,0x2ba2,
0x2bd1,0x2c00,0x2c2e,0x2c5c,0x2c8a,0x2cb8,0x2ce6,0x2d13,
0x2d41,0x2d6e,0x2d9b,0x2dc8,0x2df4,0x2e21,0x2e4d,0x2e79,
0x2ea5,0x2ed1,0x2efd,0x2f28,0x2f54,0x2f7f,0x2faa,0x2fd5,
0x3000,0x302a,0x3055,0x307f,0x30a9,0x30d3,0x30fd,0x3127,
0x3150,0x317a,0x31a3,0x31cc,0x31f5,0x321e,0x3247,0x3270,
0x3298,0x32c1,0x32e9,0x3311,0x3339,0x3361,0x3389,0x33b0,
0x33d8,0x3400,0x3427,0x344e,0x3475,0x349c,0x34c3,0x34ea,
0x3510,0x3537,0x355d,0x3584,0x35aa,0x35d0,0x35f6,0x361c,
0x3642,0x3667,0x368d,0x36b2,0x36d8,0x36fd,0x3722,0x3747,
0x376c,0x3791,0x37b6,0x37db,0x3800,0x3824,0x3848,0x386d,
0x3891,0x38b5,0x38d9,0x38fd,0x3921,0x3945,0x3969,0x398c,
0x39b0,0x39d3,0x39f7,0x3a1a,0x3a3d,0x3a60,0x3a83,0x3aa6,
0x3ac9,0x3aec,0x3b0f,0x3b31,0x3b54,0x3b76,0x3b99,0x3bbb,
0x3bdd,0x3c00,0x3c22,0x3c44,0x3c66,0x3c87,0x3ca9,0x3ccb,
0x3ced,0x3d0e,0x3d30,0x3d51,0x3d72,0x3d94,0x3db5,0x3dd6,
0x3df7,0x3e18,0x3e39,0x3e5a,0x3e7b,0x3e9c,0x3ebc,0x3edd,
0x3efd,0x3f1e,0x3f3e,0x3f5f,0x3f7f,0x3f9f,0x3fbf,0x3fdf,
0x4000,0x401f,0x403f,0x405f,0x407f,0x409f,0x40be,0x40de,
0x40fe,0x411d,0x413c,0x415c,0x417b,0x419a,0x41ba,0x41d9,
0x41f8,0x4217,0x4236,0x4255,0x4273,0x4292,0x42b1,0x42d0,
0x42ee,0x430d,0x432b,0x434a,0x4368,0x4387,0x43a5,0x43c3,
0x43e1,0x4400,0x441e,0x443c,0x445a,0x4478,0x4495,0x44b3,
0x44d1,0x44ef,0x450c,0x452a,0x4548,0x4565,0x4583,0x45a0,
0x45be,0x45db,0x45f8,0x4615,0x4633,0x4650,0x466d,0x468a,
0x46a7,0x46c4,0x46e1,0x46fe,0x471b,0x4737,0x4754,0x4771,
0x478d,0x47aa,0x47c7,0x47e3,0x4800,0x481c,0x4838,0x4855,
0x4871,0x488d,0x48a9,0x48c6,0x48e2,0x48fe,0x491a,0x4936,
0x4952,0x496e,0x498a,0x49a5,0x49c1,0x49dd,0x49f9,0x4a14,
0x4a30,0x4a4b,0x4a67,0x4a83,0x4a9e,0x4ab9,0x4ad5,0x4af0,
0x4b0b,0x4b27,0x4b42,0x4b5d,0x4b78,0x4b93,0x4bae,0x4bca,
0x4be5,0x4c00,0x4c1a,0x4c35,0x4c50,0x4c6b,0x4c86,0x4ca1,
0x4cbb,0x4cd6,0x4cf1,0x4d0b,0x4d26,0x4d40,0x4d5b,0x4d75,
0x4d90,0x4daa,0x4dc4,0x4ddf,0x4df9,0x4e13,0x4e2d,0x4e48,
0x4e62,0x4e7c,0x4e96,0x4eb0,0x4eca,0x4ee4,0x4efe,0x4f18,
0x4f32,0x4f4c,0x4f65,0x4f7f,0x4f99,0x4fb3,0x4fcc,0x4fe6,
0x5000,0x5019,0x5033,0x504c,0x5066,0x507f,0x5099,0x50b2,
0x50cb,0x50e5,0x50fe,0x5117,0x5130,0x514a,0x5163,0x517c,
0x5195,0x51ae,0x51c7,0x51e0,0x51f9,0x5212,0x522b,0x5244,
0x525d,0x5276,0x528f,0x52a7,0x52c0,0x52d9,0x52f2,0x530a,
0x5323,0x533c,0x5354,0x536d,0x5385,0x539e,0x53b6,0x53cf,
0x53e7,0x5400,0x5418,0x5430,0x5449,0x5461,0x5479,0x5491,
0x54a9,0x54c2,0x54da,0x54f2,0x550a,0x5522,0x553a,0x5552,
0x556a,0x5582,0x559a,0x55b2,0x55ca,0x55e2,0x55fa,0x5611,
0x5629,0x5641,0x5659,0x5670,0x5688,0x56a0,0x56b7,0x56cf,
0x56e6,0x56fe,0x5716,0x572d,0x5745,0x575c,0x5773,0x578b,
0x57a2,0x57ba,0x57d1,0x57e8,0x5800,0x5817,0x582e,0x5845,
0x585c,0x5874,0x588b,0x58a2,0x58b9,0x58d0,0x58e7,0x58fe,
0x5915,0x592c,0x5943,0x595a,0x5971,0x5988,0x599f,0x59b5,
0x59cc,0x59e3,0x59fa,0x5a11,0x5a27,0x5a3e,0x5a55,0x5a6b,
0x5a82,0x5a99,0x5aaf,0x5ac6,0x5adc,0x5af3,0x5b09,0x5b20,
0x5b36,0x5b4d,0x5b63,0x5b7a,0x5b90,0x5ba6,0x5bbd,0x5bd3,
0x5be9,0x5c00,0x5c16,0x5c2c,0x5c42,0x5c58,0x5c6f,0x5c85,
0x5c9b,0x5cb1,0x5cc7,0x5cdd,0x5cf3,0x5d09,0x5d1f,0x5d35,
0x5d4b,0x5d61,0x5d77,0x5d8d,0x5da3,0x5db9,0x5dce,0x5de4,
0x5dfa,0x5e10,0x5e26,0x5e3b,0x5e51,0x5e67,0x5e7c,0x5e92,
0x5ea8,0x5ebd,0x5ed3,0x5ee9,0x5efe,0x5f14,0x5f29,0x5f3f,
0x5f54,0x5f6a,0x5f7f,0x5f95,0x5faa,0x5fbf,0x5fd5,0x5fea,
0x6000,0x6015,0x602a,0x603f,0x6055,0x606a,0x607f,0x6094,
0x60aa,0x60bf,0x60d4,0x60e9,0x60fe,0x6113,0x6128,0x613d,
0x6152,0x6168,0x617d,0x6192,0x61a7,0x61bb,0x61d0,0x61e5,
0x61fa,0x620f,0x6224,0x6239,0x624e,0x6263,0x6277,0x628c,
0x62a1,0x62b6,0x62ca,0x62df,0x62f4,0x6309,0x631d,0x6332,
0x6347,0x635b,0x6370,0x6384,0x6399,0x63ad,0x63c2,0x63d7,
0x63eb,0x6400,0x6414,0x6428,0x643d,0x6451,0x6466,0x647a,
0x648e,0x64a3,0x64b7,0x64cb,0x64e0,0x64f4,0x6508,0x651d,
0x6531,0x6545,0x6559,0x656e,0x6582,0x6596,0x65aa,0x65be,
0x65d2,0x65e6,0x65fa,0x660f,0x6623,0x6637,0x664b,0x665f,
0x6673,0x6687,0x669b,0x66af,0x66c3,0x66d6,0x66ea,0x66fe,
0x6712,0x6726,0x673a,0x674e,0x6761,0x6775,0x6789,0x679d,
0x67b1,0x67c4,0x67d8,0x67ec,0x6800,0x6813,0x6827,0x683b,
0x684e,0x6862,0x6875,0x6889,0x689d,0x68b0,0x68c4,0x68d7,
0x68eb,0x68fe,0x6912,0x6925,0x6939,0x694c,0x6960,0x6973,
0x6986,0x699a,0x69ad,0x69c1,0x69d4,0x69e7,0x69fb,0x6a0e,
0x6a21,0x6a35,0x6a48,0x6a5b,0x6a6e,0x6a82,0x6a95,0x6aa8,
0x6abb,0x6ace,0x6ae2,0x6af5,0x6b08,0x6b1b,0x6b2e,0x6b41,
0x6b54,0x6b67,0x6b7a,0x6b8d,0x6ba1,0x6bb4,0x6bc7,0x6bda,
0x6bed,0x6c00,0x6c12,0x6c25,0x6c38,0x6c4b,0x6c5e,0x6c71,
0x6c84,0x6c97,0x6caa,0x6cbc,0x6ccf,0x6ce2,0x6cf5,0x6d08,
0x6d1a,0x6d2d,0x6d40,0x6d53,0x6d65,0x6d78,0x6d8b,0x6d9e,
0x6db0,0x6dc3,0x6dd6,0x6de8,0x6dfb,0x6e0d,0x6e20,0x6e33,
0x6e45,0x6e58,0x6e6a,0x6e7d,0x6e8f,0x6ea2,0x6eb4,0x6ec7,
0x6ed9,0x6eec,0x6efe,0x6f11,0x6f23,0x6f36,0x6f48,0x6f5a,
0x6f6d,0x6f7f,0x6f92,0x6fa4,0x6fb6,0x6fc9,0x6fdb,0x6fed,
0x7000,0x7012,0x7024,0x7036,0x7049,0x705b,0x706d,0x707f,
0x7091,0x70a4,0x70b6,0x70c8,0x70da,0x70ec,0x70fe,0x7110,
0x7123,0x7135,0x7147,0x7159,0x716b,0x717d,0x718f,0x71a1,
0x71b3,0x71c5,0x71d7,0x71e9,0x71fb,0x720d,0x721f,0x7231,
0x7243,0x7255,0x7267,0x7279,0x728a,0x729c,0x72ae,0x72c0,
0x72d2,0x72e4,0x72f5,0x7307,0x7319,0x732b,0x733d,0x734e,
0x7360,0x7372,0x7384,0x7395,0x73a7,0x73b9,0x73ca,0x73dc,
0x73ee,0x7400,0x7411,0x7423,0x7434,0x7446,0x7458,0x7469,
0x747b,0x748c,0x749e,0x74b0,0x74c1,0x74d3,0x74e4,0x74f6,
0x7507,0x7519,0x752a,0x753c,0x754d,0x755f,0x7570,0x7581,
0x7593,0x75a4,0x75b6,0x75c7,0x75d8,0x75ea,0x75fb,0x760d,
0x761e,0x762f,0x7641,0x7652,0x7663,0x7674,0x7686,0x7697,
0x76a8,0x76ba,0x76cb,0x76dc,0x76ed,0x76fe,0x7710,0x7721,
0x7732,0x7743,0x7754,0x7766,0x7777,0x7788,0x7799,0x77aa,
0x77bb,0x77cc,0x77dd,0x77ee,0x7800,0x7811,0x7822,0x7833,
0x7844,0x7855,0x7866,0x7877,0x7888,0x7899,0x78aa,0x78bb,
0x78cc,0x78dd,0x78ee,0x78fe,0x790f,0x7920,0x7931,0x7942,
0x7953,0x7964,0x7975,0x7986,0x7996,0x79a7,0x79b8,0x79c9,
0x79da,0x79eb,0x79fb,0x7a0c,0x7a1d,0x7a2e,0x7a3e,0x7a4f,
0x7a60,0x7a71,0x7a81,0x7a92,0x7aa3,0x7ab3,0x7ac4,0x7ad5,
0x7ae5,0x7af6,0x7b07,0x7b17,0x7b28,0x7b39,0x7b49,0x7b5a,
0x7b6b,0x7b7b,0x7b8c,0x7b9c,0x7bad,0x7bbd,0x7bce,0x7bde,
0x7bef,0x7c00,0x7c10,0x7c21,0x7c31,0x7c41,0x7c52,0x7c62,
0x7c73,0x7c83,0x7c94,0x7ca4,0x7cb5,0x7cc5,0x7cd5,0x7ce6,
0x7cf6,0x7d07,0x7d17,0x7d27,0x7d38,0x7d48,0x7d58,0x7d69,
0x7d79,0x7d89,0x7d9a,0x7daa,0x7dba,0x7dcb,0x7ddb,0x7deb,
0x7dfb,0x7e0c,0x7e1c,0x7e2c,0x7e3c,0x7e4d,0x7e5d,0x7e6d,
0x7e7d,0x7e8d,0x7e9e,0x7eae,0x7ebe,0x7ece,0x7ede,0x7eee,
0x7efe,0x7f0f,0x7f1f,0x7f2f,0x7f3f,0x7f4f,0x7f5f,0x7f6f,
0x7f7f,0x7f8f,0x7f9f,0x7faf,0x7fbf,0x7fcf,0x7fdf,0x7fef,
0x8000,0x800f,0x801f,0x802f,0x803f,0x804f,0x805f,0x806f,
0x807f,0x808f,0x809f,0x80af,0x80bf,0x80cf,0x80df,0x80ef,
0x80ff,0x810e,0x811e,0x812e,0x813e,0x814e,0x815e,0x816d,
0x817d,0x818d,0x819d,0x81ad,0x81bc,0x81cc,0x81dc,0x81ec,
0x81fc,0x820b,0x821b,0x822b,0x823b,0x824a,0x825a,0x826a,
0x8279,0x8289,0x8299,0x82a8,0x82b8,0x82c8,0x82d7,0x82e7,
0x82f7,0x8306,0x8316,0x8326,0x8335,0x8345,0x8354,0x8364,
0x8374,0x8383,0x8393,0x83a2,0x83b2,0x83c1,0x83d1,0x83e0,
0x83f0,0x8400,0x840f,0x841f,0x842e,0x843e,0x844d,0x845c,
0x846c,0x847b,0x848b,0x849a,0x84aa,0x84b9,0x84c9,0x84d8,
0x84e7,0x84f7,0x8506,0x8516,0x8525,0x8534,0x8544,0x8553,
0x8562,0x8572,0x8581,0x8591,0x85a0,0x85af,0x85be,0x85ce,
0x85dd,0x85ec,0x85fc,0x860b,0x861a,0x862a,0x8639,0x8648,
0x8657,0x8667,0x8676,0x8685,0x8694,0x86a3,0x86b3,0x86c2,
0x86d1,0x86e0,0x86ef,0x86ff,0x870e,0x871d,0x872c,0x873b,
0x874a,0x8759,0x8769,0x8778,0x8787,0x8796,0x87a5,0x87b4,
0x87c3,0x87d2,0x87e1,0x87f0,0x8800,0x880f,0x881e,0x882d,
0x883c,0x884b,0x885a,0x8869,0x8878,0x8887,0x8896,0x88a5,
0x88b4,0x88c3,0x88d2,0x88e1,0x88f0,0x88ff,0x890e,0x891c,
0x892b,0x893a,0x8949,0x8958,0x8967,0x8976,0x8985,0x8994,
0x89a3,0x89b2,0x89c0,0x89cf,0x89de,0x89ed,0x89fc,0x8a0b,
0x8a19,0x8a28,0x8a37,0x8a46,0x8a55,0x8a64,0x8a72,0x8a81,
0x8a90,0x8a9f,0x8aad,0x8abc,0x8acb,0x8ada,0x8ae8,0x8af7,
0x8b06,0x8b15,0x8b23,0x8b32,0x8b41,0x8b50,0x8b5e,0x8b6d,
0x8b7c,0x8b8a,0x8b99,0x8ba8,0x8bb6,0x8bc5,0x8bd4,0x8be2,
0x8bf1,0x8c00,0x8c0e,0x8c1d,0x8c2b,0x8c3a,0x8c49,0x8c57,
0x8c66,0x8c74,0x8c83,0x8c91,0x8ca0,0x8caf,0x8cbd,0x8ccc,
0x8cda,0x8ce9,0x8cf7,0x8d06,0x8d14,0x8d23,0x8d31,0x8d40,
0x8d4e,0x8d5d,0x8d6b,0x8d7a,0x8d88,0x8d97,0x8da5,0x8db4,
0x8dc2,0x8dd1,0x8ddf,0x8ded,0x8dfc,0x8e0a,0x8e19,0x8e27,
0x8e36,0x8e44,0x8e52,0x8e61,0x8e6f,0x8e7d,0x8e8c,0x8e9a,
0x8ea9,0x8eb7,0x8ec5,0x8ed4,0x8ee2,0x8ef0,0x8eff,0x8f0d,
0x8f1b,0x8f2a,0x8f38,0x8f46,0x8f54,0x8f63,0x8f71,0x8f7f,
0x8f8e,0x8f9c,0x8faa,0x8fb8,0x8fc7,0x8fd5,0x8fe3,0x8ff1,
0x9000,0x900e,0x901c,0x902a,0x9038,0x9047,0x9055,0x9063,
0x9071,0x907f,0x908d,0x909c,0x90aa,0x90b8,0x90c6,0x90d4,
0x90e2,0x90f0,0x90ff,0x910d,0x911b,0x9129,0x9137,0x9145,
0x9153,0x9161,0x916f,0x917e,0x918c,0x919a,0x91a8,0x91b6,
0x91c4,0x91d2,0x91e0,0x91ee,0x91fc,0x920a,0x9218,0x9226,
0x9234,0x9242,0x9250,0x925e,0x926c,0x927a,0x9288,0x9296,
0x92a4,0x92b2,0x92c0,0x92ce,0x92dc,0x92ea,0x92f8,0x9306,
0x9314,0x9321,0x932f,0x933d,0x934b,0x9359,0x9367,0x9375,
0x9383,0x9391,0x939f,0x93ac,0x93ba,0x93c8,0x93d6,0x93e4,
0x93f2,0x9400,0x940d,0x941b,0x9429,0x9437,0x9445,0x9452,
0x9460,0x946e,0x947c,0x948a,0x9497,0x94a5,0x94b3,0x94c1,
0x94cf,0x94dc,0x94ea,0x94f8,0x9506,0x9513,0x9521,0x952f,
0x953c,0x954a,0x9558,0x9566,0x9573,0x9581,0x958f,0x959c,
0x95aa,0x95b8,0x95c5,0x95d3,0x95e1,0x95ee,0x95fc,0x960a,
0x9617,0x9625,0x9633,0x9640,0x964e,0x965c,0x9669,0x9677,
0x9684,0x9692,0x96a0,0x96ad,0x96bb,0x96c8,0x96d6,0x96e4,
0x96f1,0x96ff,0x970c,0x971a,0x9727,0x9735,0x9742,0x9750,
0x975d,0x976b,0x9779,0x9786,0x9794,0x97a1,0x97af,0x97bc,
0x97ca,0x97d7,0x97e5,0x97f2,0x9800,0x980d,0x981a,0x9828,
0x9835,0x9843,0x9850,0x985e,0x986b,0x9879,0x9886,0x9893,
0x98a1,0x98ae,0x98bc,0x98c9,0x98d6,0x98e4,0x98f1,0x98ff,
0x990c,0x9919,0x9927,0x9934,0x9942,0x994f,0x995c,0x996a,
0x9977,0x9984,0x9992,0x999f,0x99ac,0x99ba,0x99c7,0x99d4,
0x99e2,0x99ef,0x99fc,0x9a09,0x9a17,0x9a24,0x9a31,0x9a3f,
0x9a4c,0x9a59,0x9a66,0x9a74,0x9a81,0x9a8e,0x9a9b,0x9aa9,
0x9ab6,0x9ac3,0x9ad0,0x9ade,0x9aeb,0x9af8,0x9b05,0x9b12,
0x9b20,0x9b2d,0x9b3a,0x9b47,0x9b54,0x9b62,0x9b6f,0x9b7c,
0x9b89,0x9b96,0x9ba3,0x9bb1,0x9bbe,0x9bcb,0x9bd8,0x9be5,
0x9bf2,0x9c00,0x9c0d,0x9c1a,0x9c27,0x9c34,0x9c41,0x9c4e,
0x9c5b,0x9c68,0x9c75,0x9c83,0x9c90,0x9c9d,0x9caa,0x9cb7,
0x9cc4,0x9cd1,0x9cde,0x9ceb,0x9cf8,0x9d05,0x9d12,0x9d1f,
0x9d2c,0x9d39,0x9d46,0x9d53,0x9d60,0x9d6d,0x9d7a,0x9d87,
0x9d94,0x9da1,0x9dae,0x9dbb,0x9dc8,0x9dd5,0x9de2,0x9def,
0x9dfc,0x9e09,0x9e16,0x9e23,0x9e30,0x9e3d,0x9e4a,0x9e57,
0x9e64,0x9e71,0x9e7e,0x9e8b,0x9e98,0x9ea4,0x9eb1,0x9ebe,
0x9ecb,0x9ed8,0x9ee5,0x9ef2,0x9eff,0x9f0c,0x9f18,0x9f25,
0x9f32,0x9f3f,0x9f4c,0x9f59,0x9f66,0x9f72,0x9f7f,0x9f8c,
0x9f99,0x9fa6,0x9fb3,0x9fbf,0x9fcc,0x9fd9,0x9fe6,0x9ff3,
0xa000,0xa00c,0xa019,0xa026,0xa033,0xa03f,0xa04c,0xa059,
0xa066,0xa073,0xa07f,0xa08c,0xa099,0xa0a6,0xa0b2,0xa0bf,
0xa0cc,0xa0d9,0xa0e5,0xa0f2,0xa0ff,0xa10b,0xa118,0xa125,
0xa132,0xa13e,0xa14b,0xa158,0xa164,0xa171,0xa17e,0xa18a,
0xa197,0xa1a4,0xa1b0,0xa1bd,0xa1ca,0xa1d6,0xa1e3,0xa1f0,
0xa1fc,0xa209,0xa216,0xa222,0xa22f,0xa23c,0xa248,0xa255,
0xa261,0xa26e,0xa27b,0xa287,0xa294,0xa2a0,0xa2ad,0xa2ba,
0xa2c6,0xa2d3,0xa2df,0xa2ec,0xa2f8,0xa305,0xa312,0xa31e,
0xa32b,0xa337,0xa344,0xa350,0xa35d,0xa369,0xa376,0xa382,
0xa38f,0xa39b,0xa3a8,0xa3b5,0xa3c1,0xa3ce,0xa3da,0xa3e7,
0xa3f3,0xa400,0xa40c,0xa418,0xa425,0xa431,0xa43e,0xa44a,
0xa457,0xa463,0xa470,0xa47c,0xa489,0xa495,0xa4a2,0xa4ae,
0xa4ba,0xa4c7,0xa4d3,0xa4e0,0xa4ec,0xa4f9,0xa505,0xa511,
0xa51e,0xa52a,0xa537,0xa543,0xa54f,0xa55c,0xa568,0xa574,
0xa581,0xa58d,0xa59a,0xa5a6,0xa5b2,0xa5bf,0xa5cb,0xa5d7,
0xa5e4,0xa5f0,0xa5fc,0xa609,0xa615,0xa621,0xa62e,0xa63a,
0xa646,0xa653,0xa65f,0xa66b,0xa678,0xa684,0xa690,0xa69d,
0xa6a9,0xa6b5,0xa6c1,0xa6ce,0xa6da,0xa6e6,0xa6f2,0xa6ff,
0xa70b,0xa717,0xa724,0xa730,0xa73c,0xa748,0xa754,0xa761,
0xa76d,0xa779,0xa785,0xa792,0xa79e,0xa7aa,0xa7b6,0xa7c3,
0xa7cf,0xa7db,0xa7e7,0xa7f3,0xa800,0xa80c,0xa818,0xa824,
0xa830,0xa83c,0xa849,0xa855,0xa861,0xa86d,0xa879,0xa885,
0xa892,0xa89e,0xa8aa,0xa8b6,0xa8c2,0xa8ce,0xa8da,0xa8e6,
0xa8f3,0xa8ff,0xa90b,0xa917,0xa923,0xa92f,0xa93b,0xa947,
0xa953,0xa960,0xa96c,0xa978,0xa984,0xa990,0xa99c,0xa9a8,
0xa9b4,0xa9c0,0xa9cc,0xa9d8,0xa9e4,0xa9f0,0xa9fc,0xaa09,
0xaa15,0xaa21,0xaa2d,0xaa39,0xaa45,0xaa51,0xaa5d,0xaa69,
0xaa75,0xaa81,0xaa8d,0xaa99,0xaaa5,0xaab1,0xaabd,0xaac9,
0xaad5,0xaae1,0xaaed,0xaaf9,0xab05,0xab11,0xab1d,0xab29,
0xab35,0xab41,0xab4d,0xab58,0xab64,0xab70,0xab7c,0xab88,
0xab94,0xaba0,0xabac,0xabb8,0xabc4,0xabd0,0xabdc,0xabe8,
0xabf4,0xac00,0xac0b,0xac17,0xac23,0xac2f,0xac3b,0xac47,
0xac53,0xac5f,0xac6b,0xac76,0xac82,0xac8e,0xac9a,0xaca6,
0xacb2,0xacbe,0xacc9,0xacd5,0xace1,0xaced,0xacf9,0xad05,
0xad11,0xad1c,0xad28,0xad34,0xad40,0xad4c,0xad57,0xad63,
0xad6f,0xad7b,0xad87,0xad92,0xad9e,0xadaa,0xadb6,0xadc2,
0xadcd,0xadd9,0xade5,0xadf1,0xadfd,0xae08,0xae14,0xae20,
0xae2c,0xae37,0xae43,0xae4f,0xae5b,0xae66,0xae72,0xae7e,
0xae8a,0xae95,0xaea1,0xaead,0xaeb8,0xaec4,0xaed0,0xaedc,
0xaee7,0xaef3,0xaeff,0xaf0a,0xaf16,0xaf22,0xaf2e,0xaf39,
0xaf45,0xaf51,0xaf5c,0xaf68,0xaf74,0xaf7f,0xaf8b,0xaf97,
0xafa2,0xafae,0xafba,0xafc5,0xafd1,0xafdd,0xafe8,0xaff4,
0xb000,0xb00b,0xb017,0xb022,0xb02e,0xb03a,0xb045,0xb051,
0xb05c,0xb068,0xb074,0xb07f,0xb08b,0xb097,0xb0a2,0xb0ae,
0xb0b9,0xb0c5,0xb0d0,0xb0dc,0xb0e8,0xb0f3,0xb0ff,0xb10a,
0xb116,0xb121,0xb12d,0xb139,0xb144,0xb150,0xb15b,0xb167,
0xb172,0xb17e,0xb189,0xb195,0xb1a0,0xb1ac,0xb1b8,0xb1c3,
0xb1cf,0xb1da,0xb1e6,0xb1f1,0xb1fd,0xb208,0xb214,0xb21f,
0xb22b,0xb236,0xb242,0xb24d,0xb259,0xb264,0xb270,0xb27b,
0xb286,0xb292,0xb29d,0xb2a9,0xb2b4,0xb2c0,0xb2cb,0xb2d7,
0xb2e2,0xb2ee,0xb2f9,0xb305,0xb310,0xb31b,0xb327,0xb332,
0xb33e,0xb349,0xb355,0xb360,0xb36b,0xb377,0xb382,0xb38e,
0xb399,0xb3a4,0xb3b0,0xb3bb,0xb3c7,0xb3d2,0xb3dd,0xb3e9,
0xb3f4,0xb400,0xb40b,0xb416,0xb422,0xb42d,0xb438,0xb444,
0xb44f,0xb45a,0xb466,0xb471,0xb47c,0xb488,0xb493,0xb49f,
0xb4aa,0xb4b5,0xb4c1,0xb4cc,0xb4d7,0xb4e2,0xb4ee,0xb4f9,
0xb504,0xb510,0xb51b,0xb526,0xb532,0xb53d,0xb548,0xb554,
0xb55f,0xb56a,0xb575,0xb581,0xb58c,0xb597,0xb5a3,0xb5ae,
0xb5b9,0xb5c4,0xb5d0,0xb5db,0xb5e6,0xb5f1,0xb5fd,0xb608,
0xb613,0xb61e,0xb62a,0xb635,0xb640,0xb64b,0xb657,0xb662,
0xb66d,0xb678,0xb684,0xb68f,0xb69a,0xb6a5,0xb6b0,0xb6bc,
0xb6c7,0xb6d2,0xb6dd,0xb6e8,0xb6f4,0xb6ff,0xb70a,0xb715,
0xb720,0xb72c,0xb737,0xb742,0xb74d,0xb758,0xb763,0xb76f,
0xb77a,0xb785,0xb790,0xb79b,0xb7a6,0xb7b2,0xb7bd,0xb7c8,
0xb7d3,0xb7de,0xb7e9,0xb7f4,0xb800,0xb80b,0xb816,0xb821,
0xb82c,0xb837,0xb842,0xb84d,0xb858,0xb864,0xb86f,0xb87a,
0xb885,0xb890,0xb89b,0xb8a6,0xb8b1,0xb8bc,0xb8c7,0xb8d3,
0xb8de,0xb8e9,0xb8f4,0xb8ff,0xb90a,0xb915,0xb920,0xb92b,
0xb936,0xb941,0xb94c,0xb957,0xb962,0xb96d,0xb978,0xb983,
0xb98f,0xb99a,0xb9a5,0xb9b0,0xb9bb,0xb9c6,0xb9d1,0xb9dc,
0xb9e7,0xb9f2,0xb9fd,0xba08,0xba13,0xba1e,0xba29,0xba34,
0xba3f,0xba4a,0xba55,0xba60,0xba6b,0xba76,0xba81,0xba8c,
0xba97,0xbaa2,0xbaad,0xbab8,0xbac3,0xbace,0xbad8,0xbae3,
0xbaee,0xbaf9,0xbb04,0xbb0f,0xbb1a,0xbb25,0xbb30,0xbb3b,
0xbb46,0xbb51,0xbb5c,0xbb67,0xbb72,0xbb7d,0xbb88,0xbb92,
0xbb9d,0xbba8,0xbbb3,0xbbbe,0xbbc9,0xbbd4,0xbbdf,0xbbea,
0xbbf5,0xbc00,0xbc0a,0xbc15,0xbc20,0xbc2b,0xbc36,0xbc41,
0xbc4c,0xbc57,0xbc61,0xbc6c,0xbc77,0xbc82,0xbc8d,0xbc98,
0xbca3,0xbcad,0xbcb8,0xbcc3,0xbcce,0xbcd9,0xbce4,0xbcef,
0xbcf9,0xbd04,0xbd0f,0xbd1a,0xbd25,0xbd30,0xbd3a,0xbd45,
0xbd50,0xbd5b,0xbd66,0xbd70,0xbd7b,0xbd86,0xbd91,0xbd9c,
0xbda6,0xbdb1,0xbdbc,0xbdc7,0xbdd2,0xbddc,0xbde7,0xbdf2,
0xbdfd,0xbe08,0xbe12,0xbe1d,0xbe28,0xbe33,0xbe3d,0xbe48,
0xbe53,0xbe5e,0xbe68,0xbe73,0xbe7e,0xbe89,0xbe93,0xbe9e,
0xbea9,0xbeb4,0xbebe,0xbec9,0xbed4,0xbedf,0xbee9,0xbef4,
0xbeff,0xbf0a,0xbf14,0xbf1f,0xbf2a,0xbf34,0xbf3f,0xbf4a,
0xbf55,0xbf5f,0xbf6a,0xbf75,0xbf7f,0xbf8a,0xbf95,0xbf9f,
0xbfaa,0xbfb5,0xbfbf,0xbfca,0xbfd5,0xbfdf,0xbfea,0xbff5,
0xc000,0xc00a,0xc015,0xc01f,0xc02a,0xc035,0xc03f,0xc04a,
0xc055,0xc05f,0xc06a,0xc075,0xc07f,0xc08a,0xc095,0xc09f,
0xc0aa,0xc0b5,0xc0bf,0xc0ca,0xc0d4,0xc0df,0xc0ea,0xc0f4,
0xc0ff,0xc109,0xc114,0xc11f,0xc129,0xc134,0xc13e,0xc149,
0xc154,0xc15e,0xc169,0xc173,0xc17e,0xc189,0xc193,0xc19e,
0xc1a8,0xc1b3,0xc1bd,0xc1c8,0xc1d3,0xc1dd,0xc1e8,0xc1f2,
0xc1fd,0xc207,0xc212,0xc21d,0xc227,0xc232,0xc23c,0xc247,
0xc251,0xc25c,0xc266,0xc271,0xc27b,0xc286,0xc290,0xc29b,
0xc2a5,0xc2b0,0xc2bb,0xc2c5,0xc2d0,0xc2da,0xc2e5,0xc2ef,
0xc2fa,0xc304,0xc30f,0xc319,0xc324,0xc32e,0xc339,0xc343,
0xc34e,0xc358,0xc363,0xc36d,0xc377,0xc382,0xc38c,0xc397,
0xc3a1,0xc3ac,0xc3b6,0xc3c1,0xc3cb,0xc3d6,0xc3e0,0xc3eb,
0xc3f5,0xc400,0xc40a,0xc414,0xc41f,0xc429,0xc434,0xc43e,
0xc449,0xc453,0xc45d,0xc468,0xc472,0xc47d,0xc487,0xc492,
0xc49c,0xc4a6,0xc4b1,0xc4bb,0xc4c6,0xc4d0,0xc4da,0xc4e5,
0xc4ef,0xc4fa,0xc504,0xc50e,0xc519,0xc523,0xc52e,0xc538,
0xc542,0xc54d,0xc557,0xc562,0xc56c,0xc576,0xc581,0xc58b,
0xc595,0xc5a0,0xc5aa,0xc5b4,0xc5bf,0xc5c9,0xc5d4,0xc5de,
0xc5e8,0xc5f3,0xc5fd,0xc607,0xc612,0xc61c,0xc626,0xc631,
0xc63b,0xc645,0xc650,0xc65a,0xc664,0xc66f,0xc679,0xc683,
0xc68e,0xc698,0xc6a2,0xc6ac,0xc6b7,0xc6c1,0xc6cb,0xc6d6,
0xc6e0,0xc6ea,0xc6f5,0xc6ff,0xc709,0xc713,0xc71e,0xc728,
0xc732,0xc73d,0xc747,0xc751,0xc75b,0xc766,0xc770,0xc77a,
0xc784,0xc78f,0xc799,0xc7a3,0xc7ae,0xc7b8,0xc7c2,0xc7cc,
0xc7d7,0xc7e1,0xc7eb,0xc7f5,0xc800,0xc80a,0xc814,0xc81e,
0xc828,0xc833,0xc83d,0xc847,0xc851,0xc85c,0xc866,0xc870,
0xc87a,0xc884,0xc88f,0xc899,0xc8a3,0xc8ad,0xc8b7,0xc8c2,
0xc8cc,0xc8d6,0xc8e0,0xc8ea,0xc8f5,0xc8ff,0xc909,0xc913,
0xc91d,0xc928,0xc932,0xc93c,0xc946,0xc950,0xc95a,0xc965,
0xc96f,0xc979,0xc983,0xc98d,0xc997,0xc9a2,0xc9ac,0xc9b6,
0xc9c0,0xc9ca,0xc9d4,0xc9df,0xc9e9,0xc9f3,0xc9fd,0xca07,
0xca11,0xca1b,0xca26,0xca30,0xca3a,0xca44,0xca4e,0xca58,
0xca62,0xca6c,0xca76,0xca81,0xca8b,0xca95,0xca9f,0xcaa9,
0xcab3,0xcabd,0xcac7,0xcad1,0xcadc,0xcae6,0xcaf0,0xcafa,
0xcb04,0xcb0e,0xcb18,0xcb22,0xcb2c,0xcb36,0xcb40,0xcb4a,
0xcb55,0xcb5f,0xcb69,0xcb73,0xcb7d,0xcb87,0xcb91,0xcb9b,
0xcba5,0xcbaf,0xcbb9,0xcbc3,0xcbcd,0xcbd7,0xcbe1,0xcbeb,
0xcbf5,0xcc00,0xcc0a,0xcc14,0xcc1e,0xcc28,0xcc32,0xcc3c,
0xcc46,0xcc50,0xcc5a,0xcc64,0xcc6e,0xcc78,0xcc82,0xcc8c,
0xcc96,0xcca0,0xccaa,0xccb4,0xccbe,0xccc8,0xccd2,0xccdc,
0xcce6,0xccf0,0xccfa,0xcd04,0xcd0e,0xcd18,0xcd22,0xcd2c,
0xcd36,0xcd40,0xcd4a,0xcd54,0xcd5e,0xcd68,0xcd72,0xcd7c,
0xcd86,0xcd90,0xcd99,0xcda3,0xcdad,0xcdb7,0xcdc1,0xcdcb,
0xcdd5,0xcddf,0xcde9,0xcdf3,0xcdfd,0xce07,0xce11,0xce1b,
0xce25,0xce2f,0xce39,0xce43,0xce4c,0xce56,0xce60,0xce6a,
0xce74,0xce7e,0xce88,0xce92,0xce9c,0xcea6,0xceb0,0xceba,
0xcec3,0xcecd,0xced7,0xcee1,0xceeb,0xcef5,0xceff,0xcf09,
0xcf13,0xcf1d,0xcf26,0xcf30,0xcf3a,0xcf44,0xcf4e,0xcf58,
0xcf62,0xcf6c,0xcf75,0xcf7f,0xcf89,0xcf93,0xcf9d,0xcfa7,
0xcfb1,0xcfbb,0xcfc4,0xcfce,0xcfd8,0xcfe2,0xcfec,0xcff6,
0xd000,0xd009,0xd013,0xd01d,0xd027,0xd031,0xd03b,0xd044,
0xd04e,0xd058,0xd062,0xd06c,0xd076,0xd07f,0xd089,0xd093,
0xd09d,0xd0a7,0xd0b0,0xd0ba,0xd0c4,0xd0ce,0xd0d8,0xd0e1,
0xd0eb,0xd0f5,0xd0ff,0xd109,0xd112,0xd11c,0xd126,0xd130,
0xd13a,0xd143,0xd14d,0xd157,0xd161,0xd16b,0xd174,0xd17e,
0xd188,0xd192,0xd19b,0xd1a5,0xd1af,0xd1b9,0xd1c3,0xd1cc,
0xd1d6,0xd1e0,0xd1ea,0xd1f3,0xd1fd,0xd207,0xd211,0xd21a,
0xd224,0xd22e,0xd238,0xd241,0xd24b,0xd255,0xd25f,0xd268,
0xd272,0xd27c,0xd285,0xd28f,0xd299,0xd2a3,0xd2ac,0xd2b6,
0xd2c0,0xd2c9,0xd2d3,0xd2dd,0xd2e7,0xd2f0,0xd2fa,0xd304,
0xd30d,0xd317,0xd321,0xd32b,0xd334,0xd33e,0xd348,0xd351,
0xd35b,0xd365,0xd36e,0xd378,0xd382,0xd38b,0xd395,0xd39f,
0xd3a8,0xd3b2,0xd3bc,0xd3c6,0xd3cf,0xd3d9,0xd3e3,0xd3ec,
0xd3f6,0xd400,0xd409,0xd413,0xd41c,0xd426,0xd430,0xd439,
0xd443,0xd44d,0xd456,0xd460,0xd46a,0xd473,0xd47d,0xd487,
0xd490,0xd49a,0xd4a3,0xd4ad,0xd4b7,0xd4c0,0xd4ca,0xd4d4,
0xd4dd,0xd4e7,0xd4f0,0xd4fa,0xd504,0xd50d,0xd517,0xd521,
0xd52a,0xd534,0xd53d,0xd547,0xd551,0xd55a,0xd564,0xd56d,
0xd577,0xd581,0xd58a,0xd594,0xd59d,0xd5a7,0xd5b0,0xd5ba,
0xd5c4,0xd5cd,0xd5d7,0xd5e0,0xd5ea,0xd5f4,0xd5fd,0xd607,
0xd610,0xd61a,0xd623,0xd62d,0xd637,0xd640,0xd64a,0xd653,
0xd65d,0xd666,0xd670,0xd679,0xd683,0xd68c,0xd696,0xd6a0,
0xd6a9,0xd6b3,0xd6bc,0xd6c6,0xd6cf,0xd6d9,0xd6e2,0xd6ec,
0xd6f5,0xd6ff,0xd708,0xd712,0xd71b,0xd725,0xd72f,0xd738,
0xd742,0xd74b,0xd755,0xd75e,0xd768,0xd771,0xd77b,0xd784,
0xd78e,0xd797,0xd7a1,0xd7aa,0xd7b4,0xd7bd,0xd7c7,0xd7d0,
0xd7da,0xd7e3,0xd7ed,0xd7f6,0xd800,0xd809,0xd812,0xd81c,
0xd825,0xd82f,0xd838,0xd842,0xd84b,0xd855,0xd85e,0xd868,
0xd871,0xd87b,0xd884,0xd88e,0xd897,0xd8a0,0xd8aa,0xd8b3,
0xd8bd,0xd8c6,0xd8d0,0xd8d9,0xd8e3,0xd8ec,0xd8f5,0xd8ff,
0xd908,0xd912,0xd91b,0xd925,0xd92e,0xd938,0xd941,0xd94a,
0xd954,0xd95d,0xd967,0xd970,0xd979,0xd983,0xd98c,0xd996,
0xd99f,0xd9a9,0xd9b2,0xd9bb,0xd9c5,0xd9ce,0xd9d8,0xd9e1,
0xd9ea,0xd9f4,0xd9fd,0xda07,0xda10,0xda19,0xda23,0xda2c,
0xda35,0xda3f,0xda48,0xda52,0xda5b,0xda64,0xda6e,0xda77,
0xda81,0xda8a,0xda93,0xda9d,0xdaa6,0xdaaf,0xdab9,0xdac2,
0xdacb,0xdad5,0xdade,0xdae8,0xdaf1,0xdafa,0xdb04,0xdb0d,
0xdb16,0xdb20,0xdb29,0xdb32,0xdb3c,0xdb45,0xdb4e,0xdb58,
0xdb61,0xdb6a,0xdb74,0xdb7d,0xdb86,0xdb90,0xdb99,0xdba2,
0xdbac,0xdbb5,0xdbbe,0xdbc8,0xdbd1,0xdbda,0xdbe4,0xdbed,
0xdbf6,0xdc00,0xdc09,0xdc12,0xdc1b,0xdc25,0xdc2e,0xdc37,
0xdc41,0xdc4a,0xdc53,0xdc5d,0xdc66,0xdc6f,0xdc78,0xdc82,
0xdc8b,0xdc94,0xdc9e,0xdca7,0xdcb0,0xdcb9,0xdcc3,0xdccc,
0xdcd5,0xdcde,0xdce8,0xdcf1,0xdcfa,0xdd04,0xdd0d,0xdd16,
0xdd1f,0xdd29,0xdd32,0xdd3b,0xdd44,0xdd4e,0xdd57,0xdd60,
0xdd69,0xdd73,0xdd7c,0xdd85,0xdd8e,0xdd98,0xdda1,0xddaa,
0xddb3,0xddbd,0xddc6,0xddcf,0xddd8,0xdde2,0xddeb,0xddf4,
0xddfd,0xde06,0xde10,0xde19,0xde22,0xde2b,0xde35,0xde3e,
0xde47,0xde50,0xde59,0xde63,0xde6c,0xde75,0xde7e,0xde87,
0xde91,0xde9a,0xdea3,0xdeac,0xdeb5,0xdebf,0xdec8,0xded1,
0xdeda,0xdee3,0xdeed,0xdef6,0xdeff,0xdf08,0xdf11,0xdf1a,
0xdf24,0xdf2d,0xdf36,0xdf3f,0xdf48,0xdf52,0xdf5b,0xdf64,
0xdf6d,0xdf76,0xdf7f,0xdf89,0xdf92,0xdf9b,0xdfa4,0xdfad,
0xdfb6,0xdfbf,0xdfc9,0xdfd2,0xdfdb,0xdfe4,0xdfed,0xdff6,
0xe000,0xe009,0xe012,0xe01b,0xe024,0xe02d,0xe036,0xe03f,
0xe049,0xe052,0xe05b,0xe064,0xe06d,0xe076,0xe07f,0xe088,
0xe092,0xe09b,0xe0a4,0xe0ad,0xe0b6,0xe0bf,0xe0c8,0xe0d1,
0xe0db,0xe0e4,0xe0ed,0xe0f6,0xe0ff,0xe108,0xe111,0xe11a,
0xe123,0xe12c,0xe136,0xe13f,0xe148,0xe151,0xe15a,0xe163,
0xe16c,0xe175,0xe17e,0xe187,0xe190,0xe199,0xe1a3,0xe1ac,
0xe1b5,0xe1be,0xe1c7,0xe1d0,0xe1d9,0xe1e2,0xe1eb,0xe1f4,
0xe1fd,0xe206,0xe20f,0xe218,0xe221,0xe22b,0xe234,0xe23d,
0xe246,0xe24f,0xe258,0xe261,0xe26a,0xe273,0xe27c,0xe285,
0xe28e,0xe297,0xe2a0,0xe2a9,0xe2b2,0xe2bb,0xe2c4,0xe2cd,
0xe2d6,0xe2df,0xe2e8,0xe2f1,0xe2fa,0xe303,0xe30c,0xe315,
0xe31f,0xe328,0xe331,0xe33a,0xe343,0xe34c,0xe355,0xe35e,
0xe367,0xe370,0xe379,0xe382,0xe38b,0xe394,0xe39d,0xe3a6,
0xe3af,0xe3b8,0xe3c1,0xe3ca,0xe3d3,0xe3dc,0xe3e5,0xe3ee,
0xe3f7,0xe400,0xe408,0xe411,0xe41a,0xe423,0xe42c,0xe435,
0xe43e,0xe447,0xe450,0xe459,0xe462,0xe46b,0xe474,0xe47d,
0xe486,0xe48f,0xe498,0xe4a1,0xe4aa,0xe4b3,0xe4bc,0xe4c5,
0xe4ce,0xe4d7,0xe4e0,0xe4e9,0xe4f2,0xe4fa,0xe503,0xe50c,
0xe515,0xe51e,0xe527,0xe530,0xe539,0xe542,0xe54b,0xe554,
0xe55d,0xe566,0xe56f,0xe578,0xe580,0xe589,0xe592,0xe59b,
0xe5a4,0xe5ad,0xe5b6,0xe5bf,0xe5c8,0xe5d1,0xe5da,0xe5e3,
0xe5eb,0xe5f4,0xe5fd,0xe606,0xe60f,0xe618,0xe621,0xe62a,
0xe633,0xe63c,0xe644,0xe64d,0xe656,0xe65f,0xe668,0xe671,
0xe67a,0xe683,0xe68c,0xe694,0xe69d,0xe6a6,0xe6af,0xe6b8,
0xe6c1,0xe6ca,0xe6d3,0xe6db,0xe6e4,0xe6ed,0xe6f6,0xe6ff,
0xe708,0xe711,0xe71a,0xe722,0xe72b,0xe734,0xe73d,0xe746,
0xe74f,0xe758,0xe760,0xe769,0xe772,0xe77b,0xe784,0xe78d,
0xe795,0xe79e,0xe7a7,0xe7b0,0xe7b9,0xe7c2,0xe7cb,0xe7d3,
0xe7dc,0xe7e5,0xe7ee,0xe7f7,0xe800,0xe808,0xe811,0xe81a,
0xe823,0xe82c,0xe834,0xe83d,0xe846,0xe84f,0xe858,0xe861,
0xe869,0xe872,0xe87b,0xe884,0xe88d,0xe895,0xe89e,0xe8a7,
0xe8b0,0xe8b9,0xe8c1,0xe8ca,0xe8d3,0xe8dc,0xe8e5,0xe8ed,
0xe8f6,0xe8ff,0xe908,0xe911,0xe919,0xe922,0xe92b,0xe934,
0xe93c,0xe945,0xe94e,0xe957,0xe960,0xe968,0xe971,0xe97a,
0xe983,0xe98b,0xe994,0xe99d,0xe9a6,0xe9ae,0xe9b7,0xe9c0,
0xe9c9,0xe9d2,0xe9da,0xe9e3,0xe9ec,0xe9f5,0xe9fd,0xea06,
0xea0f,0xea18,0xea20,0xea29,0xea32,0xea3b,0xea43,0xea4c,
0xea55,0xea5e,0xea66,0xea6f,0xea78,0xea80,0xea89,0xea92,
0xea9b,0xeaa3,0xeaac,0xeab5,0xeabe,0xeac6,0xeacf,0xead8,
0xeae0,0xeae9,0xeaf2,0xeafb,0xeb03,0xeb0c,0xeb15,0xeb1d,
0xeb26,0xeb2f,0xeb38,0xeb40,0xeb49,0xeb52,0xeb5a,0xeb63,
0xeb6c,0xeb74,0xeb7d,0xeb86,0xeb8f,0xeb97,0xeba0,0xeba9,
0xebb1,0xebba,0xebc3,0xebcb,0xebd4,0xebdd,0xebe5,0xebee,
0xebf7,0xec00,0xec08,0xec11,0xec1a,0xec22,0xec2b,0xec34,
0xec3c,0xec45,0xec4e,0xec56,0xec5f,0xec68,0xec70,0xec79,
0xec82,0xec8a,0xec93,0xec9c,0xeca4,0xecad,0xecb5,0xecbe,
0xecc7,0xeccf,0xecd8,0xece1,0xece9,0xecf2,0xecfb,0xed03,
0xed0c,0xed15,0xed1d,0xed26,0xed2e,0xed37,0xed40,0xed48,
0xed51,0xed5a,0xed62,0xed6b,0xed74,0xed7c,0xed85,0xed8d,
0xed96,0xed9f,0xeda7,0xedb0,0xedb8,0xedc1,0xedca,0xedd2,
0xeddb,0xede4,0xedec,0xedf5,0xedfd,0xee06,0xee0f,0xee17,
0xee20,0xee28,0xee31,0xee3a,0xee42,0xee4b,0xee53,0xee5c,
0xee65,0xee6d,0xee76,0xee7e,0xee87,0xee8f,0xee98,0xeea1,
0xeea9,0xeeb2,0xeeba,0xeec3,0xeecc,0xeed4,0xeedd,0xeee5,
0xeeee,0xeef6,0xeeff,0xef08,0xef10,0xef19,0xef21,0xef2a,
0xef32,0xef3b,0xef43,0xef4c,0xef55,0xef5d,0xef66,0xef6e,
0xef77,0xef7f,0xef88,0xef90,0xef99,0xefa2,0xefaa,0xefb3,
0xefbb,0xefc4,0xefcc,0xefd5,0xefdd,0xefe6,0xefee,0xeff7,
0xf000,0xf008,0xf011,0xf019,0xf022,0xf02a,0xf033,0xf03b,
0xf044,0xf04c,0xf055,0xf05d,0xf066,0xf06e,0xf077,0xf07f,
0xf088,0xf090,0xf099,0xf0a1,0xf0aa,0xf0b2,0xf0bb,0xf0c3,
0xf0cc,0xf0d4,0xf0dd,0xf0e5,0xf0ee,0xf0f6,0xf0ff,0xf107,
0xf110,0xf118,0xf121,0xf129,0xf132,0xf13a,0xf143,0xf14b,
0xf154,0xf15c,0xf165,0xf16d,0xf176,0xf17e,0xf187,0xf18f,
0xf198,0xf1a0,0xf1a9,0xf1b1,0xf1ba,0xf1c2,0xf1cb,0xf1d3,
0xf1dc,0xf1e4,0xf1ec,0xf1f5,0xf1fd,0xf206,0xf20e,0xf217,
0xf21f,0xf228,0xf230,0xf239,0xf241,0xf24a,0xf252,0xf25a,
0xf263,0xf26b,0xf274,0xf27c,0xf285,0xf28d,0xf296,0xf29e,
0xf2a6,0xf2af,0xf2b7,0xf2c0,0xf2c8,0xf2d1,0xf2d9,0xf2e1,
0xf2ea,0xf2f2,0xf2fb,0xf303,0xf30c,0xf314,0xf31c,0xf325,
0xf32d,0xf336,0xf33e,0xf347,0xf34f,0xf357,0xf360,0xf368,
0xf371,0xf379,0xf381,0xf38a,0xf392,0xf39b,0xf3a3,0xf3ac,
0xf3b4,0xf3bc,0xf3c5,0xf3cd,0xf3d6,0xf3de,0xf3e6,0xf3ef,
0xf3f7,0xf400,0xf408,0xf410,0xf419,0xf421,0xf429,0xf432,
0xf43a,0xf443,0xf44b,0xf453,0xf45c,0xf464,0xf46d,0xf475,
0xf47d,0xf486,0xf48e,0xf496,0xf49f,0xf4a7,0xf4b0,0xf4b8,
0xf4c0,0xf4c9,0xf4d1,0xf4d9,0xf4e2,0xf4ea,0xf4f2,0xf4fb,
0xf503,0xf50c,0xf514,0xf51c,0xf525,0xf52d,0xf535,0xf53e,
0xf546,0xf54e,0xf557,0xf55f,0xf567,0xf570,0xf578,0xf580,
0xf589,0xf591,0xf599,0xf5a2,0xf5aa,0xf5b2,0xf5bb,0xf5c3,
0xf5cb,0xf5d4,0xf5dc,0xf5e4,0xf5ed,0xf5f5,0xf5fd,0xf606,
0xf60e,0xf616,0xf61f,0xf627,0xf62f,0xf638,0xf640,0xf648,
0xf651,0xf659,0xf661,0xf66a,0xf672,0xf67a,0xf682,0xf68b,
0xf693,0xf69b,0xf6a4,0xf6ac,0xf6b4,0xf6bd,0xf6c5,0xf6cd,
0xf6d6,0xf6de,0xf6e6,0xf6ee,0xf6f7,0xf6ff,0xf707,0xf710,
0xf718,0xf720,0xf728,0xf731,0xf739,0xf741,0xf74a,0xf752,
0xf75a,0xf762,0xf76b,0xf773,0xf77b,0xf784,0xf78c,0xf794,
0xf79c,0xf7a5,0xf7ad,0xf7b5,0xf7bd,0xf7c6,0xf7ce,0xf7d6,
0xf7de,0xf7e7,0xf7ef,0xf7f7,0xf800,0xf808,0xf810,0xf818,
0xf821,0xf829,0xf831,0xf839,0xf842,0xf84a,0xf852,0xf85a,
0xf863,0xf86b,0xf873,0xf87b,0xf883,0xf88c,0xf894,0xf89c,
0xf8a4,0xf8ad,0xf8b5,0xf8bd,0xf8c5,0xf8ce,0xf8d6,0xf8de,
0xf8e6,0xf8ef,0xf8f7,0xf8ff,0xf907,0xf90f,0xf918,0xf920,
0xf928,0xf930,0xf939,0xf941,0xf949,0xf951,0xf959,0xf962,
0xf96a,0xf972,0xf97a,0xf982,0xf98b,0xf993,0xf99b,0xf9a3,
0xf9ab,0xf9b4,0xf9bc,0xf9c4,0xf9cc,0xf9d4,0xf9dd,0xf9e5,
0xf9ed,0xf9f5,0xf9fd,0xfa06,0xfa0e,0xfa16,0xfa1e,0xfa26,
0xfa2f,0xfa37,0xfa3f,0xfa47,0xfa4f,0xfa58,0xfa60,0xfa68,
0xfa70,0xfa78,0xfa80,0xfa89,0xfa91,0xfa99,0xfaa1,0xfaa9,
0xfab1,0xfaba,0xfac2,0xfaca,0xfad2,0xfada,0xfae2,0xfaeb,
0xfaf3,0xfafb,0xfb03,0xfb0b,0xfb13,0xfb1c,0xfb24,0xfb2c,
0xfb34,0xfb3c,0xfb44,0xfb4c,0xfb55,0xfb5d,0xfb65,0xfb6d,
0xfb75,0xfb7d,0xfb85,0xfb8e,0xfb96,0xfb9e,0xfba6,0xfbae,
0xfbb6,0xfbbe,0xfbc7,0xfbcf,0xfbd7,0xfbdf,0xfbe7,0xfbef,
0xfbf7,0xfc00,0xfc08,0xfc10,0xfc18,0xfc20,0xfc28,0xfc30,
0xfc38,0xfc40,0xfc49,0xfc51,0xfc59,0xfc61,0xfc69,0xfc71,
0xfc79,0xfc81,0xfc8a,0xfc92,0xfc9a,0xfca2,0xfcaa,0xfcb2,
0xfcba,0xfcc2,0xfcca,0xfcd2,0xfcdb,0xfce3,0xfceb,0xfcf3,
0xfcfb,0xfd03,0xfd0b,0xfd13,0xfd1b,0xfd23,0xfd2c,0xfd34,
0xfd3c,0xfd44,0xfd4c,0xfd54,0xfd5c,0xfd64,0xfd6c,0xfd74,
0xfd7c,0xfd84,0xfd8d,0xfd95,0xfd9d,0xfda5,0xfdad,0xfdb5,
0xfdbd,0xfdc5,0xfdcd,0xfdd5,0xfddd,0xfde5,0xfded,0xfdf5,
0xfdfd,0xfe06,0xfe0e,0xfe16,0xfe1e,0xfe26,0xfe2e,0xfe36,
0xfe3e,0xfe46,0xfe4e,0xfe56,0xfe5e,0xfe66,0xfe6e,0xfe76,
0xfe7e,0xfe86,0xfe8e,0xfe97,0xfe9f,0xfea7,0xfeaf,0xfeb7,
0xfebf,0xfec7,0xfecf,0xfed7,0xfedf,0xfee7,0xfeef,0xfef7,
0xfeff,0xff07,0xff0f,0xff17,0xff1f,0xff27,0xff2f,0xff37,
0xff3f,0xff47,0xff4f,0xff57,0xff5f,0xff67,0xff6f,0xff77,
0xff7f,0xff87,0xff8f,0xff97,0xff9f,0xffa7,0xffaf,0xffb7,
0xffbf,0xffc7,0xffcf,0xffd7,0xffdf,0xffe7,0xffef,0xfff7};

const signed short wavtable1[2304]={
0x021d,0x03bc,0x0300,0xfc0d,0xfcd5,0xfd33,0xfdc5,0xfc83,
0xfdc0,0x036d,0x0245,0x0238,0xfc1b,0xfc31,0xfd7a,0xfd10,
0xfd6b,0xfd88,0x02a3,0x0313,0x027b,0xfdf9,0xfcba,0xfc2f,
0xfc86,0xfda3,0xfceb,0x0270,0x02dc,0x029c,0xfc83,0xfcd1,
0xfc44,0xfd06,0xfdf5,0xfc97,0x026f,0x0347,0x02b9,0xfc02,
0xfcaf,0xfdc5,0xfd09,0xfd50,0xfc4b,0x0280,0x02b5,0x03df,
0xfc9d,0xfd95,0xfd61,0xfce0,0xfc54,0xfc41,0x039d,0x02af,
0x0260,0xfd93,0xfddb,0xfccf,0xfcbb,0xfc64,0xfd2e,0x0228,
0x031d,0x023c,0xfca3,0xfd97,0xfc84,0xfdac,0xfd93,0xfd80,
0x0217,0x0340,0x031f,0xfc99,0xfcbc,0xfd77,0xfdd0,0xfd5c,
0xfd90,0x02fa,0x025d,0x0241,0xfc7a,0xfca5,0xfd56,0xfdc8,
0xfd34,0xfd76,0x0340,0x0231,0x03eb,0xfc6f,0xfcd1,0xfdda,
0xfd5c,0xfd98,0xfc2a,0x024e,0x02af,0x024c,0xfce7,0xfd59,
0xfcea,0xfd57,0xfc65,0xfd5b,0x0286,0x0385,0x02dc,0xfdc7,
0xfc64,0xfd7b,0xfcd0,0xfce6,0xfdf4,0x033c,0x02b1,0x0380,
0xfdd3,0xfd2b,0xfda5,0xfd62,0xfc61,0xfcf0,0x036b,0x0270,
0x0350,0xfdeb,0xfd2b,0xfdfc,0xfd14,0xfd08,0xfd42,0x023b,
0x03ae,0x03fe,0xfdf2,0xfdc6,0xfc53,0xfd82,0xfc9c,0xfc04,
0x0338,0x02e0,0x0283,0xfdaf,0xfdfb,0xfc63,0xfd69,0xfdee,
0xfcd8,0x0205,0x02fd,0x0200,0xfcfa,0xfdfa,0xfd01,0xfdf5,
0xfdc4,0xfdff,0x0232,0x038c,0x02f9,0xfc1b,0xfcbc,0xfd5d,
0xfd97,0xfcdb,0xfdca,0x02b6,0x0391,0x02a3,0xfd95,0xfc6c,
0xfda5,0xfc53,0xfcd1,0xfc85,0x02c0,0x020c,0x02a0,0xfd2e,
0xfc63,0xfd4f,0xfc37,0xfde6,0xfc8d,0x02d1,0x02f5,0x022e,
0xfdea,0xfcee,0xfcc6,0xfc06,0xfdcf,0xfda0,0x0374,0x0227,
0x0279,0xfc49,0xfdde,0xfd57,0xfd05,0xfdb0,0xfcf0,0x022e,
0x03ef,0x034e,0xfddb,0xfc65,0xfcc0,0xfda0,0xfc21,0xfd45,
0x03a4,0x02ea,0x0309,0xfd59,0xfd3d,0xfdca,0xfcaf,0xfde0,
0xfdb3,0x0236,0x0336,0x039e,0xfc72,0xfdff,0xfd18,0xfd8d,
0xfd6d,0xfcb9,0x0265,0x0303,0x0263,0xfc64,0xfd25,0xfc67,
0xfd23,0xfdbb,0xfd27,0x02e1,0x029f,0x03f0,0xfc39,0xfd2a,
0xfd6b,0xfded,0xfc90,0xfc1f,0x028b,0x0252,0x0243,0xfd0b,
0xfd1f,0xfd5f,0xfcc2,0xfd4d,0xfd71,0x0321,0x027c,0x0234,
0xfc1c,0xfc8d,0xfd42,0xfd8e,0xfce8,0xfd92,0x0354,0x038e,
0x02cf,0xfd0b,0xfda9,0xfd81,0xfd3b,0xfcd7,0xfc0c,0x03e6,
0x0266,0x023f,0xfda9,0xfdcf,0xfd4d,0xfc32,0xfd1f,0xfd79,
0x0299,0x03a7,0x0274,0xfda1,0xfcd0,0xfdc2,0xfca1,0xfcaa,
0xfcfd,0x0277,0x0254,0x033d,0xfd21,0xfc01,0xfc3a,0xfcf6,
0xfd4a,0xfd60,0x0284,0x039e,0x020e,0xfdb9,0xfd69,0xfc47,
0xfcd5,0xfcba,0xfde2,0x036f,0x03dc,0x0265,0xfcb0,0xfdf2,
0xfdb0,0xfd0d,0xfc47,0xfd22,0x03ad,0x02b4,0x02b5,0xfd83,
0xfd82,0xfc55,0xfc9e,0xfc57,0xfc54,0x0235,0x02a0,0x0240,
0xfd1a,0xfd83,0xfd0b,0xfd8f,0xfc8e,0xfd77,0x0223,0x0274,
0x02e4,0xfd61,0xfce9,0xfc73,0xfdb7,0xfcfd,0xfde9,0x027f,
0x0214,0x0219,0xfd67,0xfd61,0xfdd1,0xfce2,0xfdd6,0xfdcc,
0x03bb,0x025c,0x0256,0xfdcc,0xfdd2,0xfd3e,0xfc85,0xfd36,
0xfd45,0x0232,0x0244,0x0384,0xfd83,0xfc23,0xfc03,0xfd97,
0xfd6e,0xfce9,0x025b,0x0383,0x026d,0xfdee,0xfd23,0xfddf,
0xfd38,0xfceb,0xfd0d,0x02ea,0x0215,0x0270,0xfcf8,0xfc73,
0xfd76,0xfde1,0xfdd5,0xfd07,0x02d9,0x0202,0x02df,0xfd23,
0xfdf5,0xfd1d,0xfdf9,0xfdfb,0xfdf0,0x0355,0x0227,0x02b4,
0xfc69,0xfdbf,0xfd17,0xfd39,0xfdaf,0xfc58,0x03b5,0x03fa,
0x03ec,0xfc50,0xfc5d,0xfc19,0xfc90,0xfc0b,0xfc27,0x0220,
0x03dc,0x02df,0xfdf3,0xfcf3,0xfd3a,0xfdbe,0xfc46,0xfdf0,
0x0315,0x030e,0x0335,0xfda5,0xfd87,0xfd8c,0xfda0,0xfdaa,
0xfd6d,0x0381,0x0204,0x02f2,0xfc76,0xfd6b,0xfd07,0xfcee,
0xfdf7,0xfdd4,0x0205,0x02be,0x033c,0xfd3a,0xfcbb,0xfdc8,
0xfdf5,0xfc3d,0xfd62,0x024a,0x0332,0x02fb,0xfc57,0xfc96,
0xfd9f,0xfd60,0xfd72,0xfdc8,0x038b,0x028c,0x0250,0xfdbe,
0xfdf3,0xfd0e,0xfcdc,0xfcc2,0xfd52,0x0210,0x028c,0x0282,
0xfd5f,0xfd69,0xfcce,0xfdde,0xfcc2,0xfcda,0x0213,0x02c4,
0x030c,0xfd20,0xfcd5,0xfde4,0xfdd8,0xfc2b,0xfdad,0x029a,
0x0271,0x02d7,0xfcd3,0xfc4e,0xfc88,0xfc9d,0xfd05,0xfdfc,
0x03b3,0x02d7,0x022a,0xfd5f,0xfe00,0xfced,0xfc95,0xfdfb,
0xfda9,0x0225,0x0291,0x03d5,0xfd3f,0xfdf2,0xfd8a,0xfdb3,
0xfcb5,0xfc53,0x025d,0x0398,0x0354,0xfde0,0xfc10,0xfd02,
0xfd34,0xfcc5,0xfd3b,0x0270,0x026b,0x03d7,0xfd0d,0xfda9,
0xfdad,0xfd07,0xfd12,0xfc50,0x025d,0x038d,0x0223,0xfde7,
0xfd7a,0xfc35,0xfd35,0xfcd9,0xfdb8,0x02b2,0x03a7,0x0204,
0xfd89,0xfd47,0xfc50,0xfc5c,0xfca9,0xfdf7,0x02bc,0x0264,
0x0355,0xfcba,0xfdb8,0xfc03,0xfc41,0xfd24,0xfd39,0x02ff,
0x0340,0x023e,0xfd91,0xfca3,0xfc5b,0xfdc1,0xfd5c,0xfd7d,
0x020b,0x0382,0x039b,0xfc69,0xfc4f,0xfcd6,0xfde8,0xfceb,
0xfcbf,0x02d2,0x03be,0x02b3,0xfd5c,0xfc30,0xfd79,0xfc04,
0xfc80,0xfc59,0x0265,0x0303,0x03a0,0xfc64,0xfdd4,0xfd44,
0xfd22,0xfdbb,0xfcb6,0x02f6,0x02f5,0x0248,0xfdcf,0xfc9e,
0xfc9f,0xfdce,0xfdd0,0xfd65,0x0200,0x0237,0x0241,0xfdc9,
0xfdbf,0xfd81,0xfe00,0xfd8c,0xfd76,0x0267,0x027e,0x02ba,
0xfd02,0xfcb9,0xfc99,0xfd1d,0xfce5,0xfc46,0x023e,0x0282,
0x024d,0xfd30,0xfd6c,0xfd1d,0xfd7c,0xfcda,0xfd5b,0x03e1,
0x02aa,0x036e,0xfd6a,0xfcac,0xfdb7,0xfc3d,0xfc72,0xfd0f,
0x021b,0x037a,0x0391,0xfc55,0xfc3d,0xfce5,0xfdc7,0xfcf9,
0xfcd1,0x02b6,0x03a0,0x0220,0xfd8b,0xfd1e,0xfc25,0xfc53,
0xfcb6,0xfdbe,0x0325,0x0258,0x02a8,0xfc50,0xfde9,0xfce2,
0xfd87,0xfd40,0xfc77,0x021c,0x03b7,0x030e,0xfc14,0xfcc7,
0xfd29,0xfdc6,0xfc8c,0xfdab,0x0330,0x03b6,0x024e,0xfd0b,
0xfc53,0xfddc,0xfd76,0xfc8f,0xfd57,0x03bb,0x034f,0x032b,
0xfcea,0xfd0b,0xfd61,0xfc85,0xfd44,0xfd7d,0x0223,0x0373,
0x022c,0xfc4f,0xfdad,0xfc40,0xfdb6,0xfd06,0xfda3,0x028c,
0x0378,0x025c,0xfdcb,0xfcfe,0xfdf4,0xfcc1,0xfcfe,0xfd37,
0x035f,0x0249,0x0357,0xfc26,0xfd2f,0xfc2e,0xfd29,0xfd64,
0xfd35,0x03ff,0x03e5,0x0204,0xfc1b,0xfdfc,0xfc12,0xfc01,
0xfc34,0xfdf8,0x03a4,0x0266,0x0280,0xfdd0,0xfdb9,0xfcff,
0xfcae,0xfd1e,0xfce0,0x0273,0x0234,0x023d,0xfd4d,0xfd42,
0xfd89,0xfcff,0xfd93,0xfd7f,0x036c,0x0384,0x02d4,0xfcfe,
0xfd94,0xfd83,0xfd12,0xfce8,0xfe00,0x0203,0x0359,0x0380,
0xfca1,0xfc7a,0xfd12,0xfdf9,0xfd32,0xfcf0,0x0287,0x03b9,
0x036f,0xfda6,0xfdd5,0xfcce,0xfccf,0xfc88,0xfd0d,0x0326,
0x0356,0x0359,0xfd60,0xfd5d,0xfd35,0xfd86,0xfd38,0xfd32,
0x0221,0x0247,0x0277,0xfd93,0xfd60,0xfd31,0xfdbb,0xfd68,
0xfcf6,0x0291,0x0259,0x02ef,0xfcfc,0xfc3d,0xfc8e,0xfcb5,
0xfd3d,0xfdda,0x02e4,0x0389,0x031b,0xfd72,0xfdc1,0xfd40,
0xfde9,0xfcdf,0xfd96,0x0349,0x03f8,0x0238,0xfcbd,0xfc5a,
0xfdcc,0xfd4d,0xfc0f,0xfd89,0x02eb,0x024d,0x03d7,0xfca3,
0xfd32,0xfdca,0xfddf,0xfd59,0xfc4f,0x036e,0x0265,0x020e,
0xfdf2,0xfc7a,0xfd8a,0xfd0f,0xfd20,0xfde4,0x0360,0x02d3,
0x030b,0xfd9e,0xfd6f,0xfdda,0xfd27,0xfc02,0xfdb0,0x0216,
0x02a2,0x0306,0xfd41,0xfcd8,0xfc05,0xfdd3,0xfc89,0xfdb6,
0x03b6,0x0289,0x03ab,0xfda6,0xfc99,0xfdad,0xfc8f,0xfcc8,
0xfca3,0x024e,0x02bf,0x0383,0xfcd5,0xfdfa,0xfd96,0xfd58,
0xfc3a,0xfcea,0x026a,0x020f,0x0243,0xfd83,0xfd44,0xfdab,
0xfd16,0xfde1,0xfd6f,0x02d5,0x0287,0x03cc,0xfc6b,0xfd4f,
0xfd99,0xfdff,0xfcce,0xfc64,0x0281,0x0287,0x02c3,0xfcd6,
0xfc8b,0xfc83,0xfcdd,0xfccf,0xfc30,0x02da,0x0297,0x0284,
0xfc4e,0xfc68,0xfcbd,0xfdf7,0xfca4,0xfcd4,0x0327,0x023c,
0x0242,0xfc7a,0xfc70,0xfd7a,0xfd83,0xfd81,0xfd73,0x036f,
0x0263,0x0335,0xfdf4,0xfd3f,0xfc2d,0xfd0d,0xfd27,0xfd6e,
0x029b,0x02d9,0x0349,0xfc49,0xfddb,0xfda9,0xfc99,0xfdf9,
0xfd4c,0x030e,0x0249,0x02ef,0xfc81,0xfdc2,0xfca5,0xfdaa,
0xfd62,0xfdd9,0x0322,0x02dd,0x03d0,0xfdc2,0xfd03,0xfd45,
0xfd8c,0xfdf3,0xfc5d,0x0352,0x0367,0x02c4,0xfd2c,0xfdb4,
0xfda6,0xfd3e,0xfd1a,0xfc2d,0x0366,0x02e7,0x02c0,0xfd88,
0xfdaa,0xfc01,0xfd1d,0xfde4,0xfc36,0x03ad,0x0383,0x0249,
0xfcc5,0xfde6,0xfdfe,0xfc9e,0xfcea,0xfd63,0x03af,0x0278,
0x036b,0xfdba,0xfcda,0xfde3,0xfc9b,0xfcf3,0xfd13,0x03ff,
0x02dc,0x027e,0xfd25,0xfd83,0xfc70,0xfc02,0xfdf5,0xfce5,
0x030a,0x02f1,0x028f,0xfdc3,0xfc1b,0xfc3b,0xfdb0,0xfdd6,
0xfcb9,0x034b,0x03b1,0x03b1,0xfcf5,0xfcf5,0xfc97,0xfd4a,
0xfc97,0xfc97,0x03ae,0x03c9,0x023c,0xfc84,0xfdf1,0xfde2,
0xfc9d,0xfc6a,0xfd80,0x03f0,0x022f,0x0356,0xfdd9,0xfcb7,
0xfc5a,0xfc1f,0xfd9c,0xfd38,0x0364,0x02d9,0x0313,0xfd96,
0xfd64,0xfdd0,0xfd1f,0xfdf9,0xfda3,0x03ca,0x02ae,0x0223,
0xfd76,0xfdfa,0xfd23,0xfc69,0xfc69,0xfdb7,0x0217,0x027b,
0x02a2,0xfd68,0xfd3f,0xfcbc,0xfdd0,0xfcec,0xfc89,0x0230,
0x027c,0x033c,0xfd48,0xfc75,0xfdfe,0xfd9b,0xfcea,0xfd62,
0x03e2,0x0250,0x0341,0xfdc1,0xfcd7,0xfc3c,0xfc3a,0xfd52,
0xfd5b,0x0224,0x026d,0x02b6,0xfd67,0xfd19,0xfcb5,0xfdb5,
0xfd0d,0xfc52,0x0226,0x0321,0x03bb,0xfca3,0xfdff,0xfd14,
0xfdb1,0xfd8d,0xfc84,0x0246,0x020a,0x0286,0xfdae,0xfd21,
0xfd6d,0xfd69,0xfdeb,0xfcd1,0x025e,0x0271,0x0332,0xfd1d,
0xfc37,0xfc19,0xfd33,0xfd05,0xfd71,0x026f,0x024f,0x036a,
0xfd30,0xfded,0xfc0e,0xfd0a,0xfd55,0xfd16,0x029d,0x0217,
0x03e9,0xfd44,0xfd72,0xfdf5,0xfc94,0xfdd1,0xfc2d,0x02bd,
0x03aa,0x0250,0xfd7e,0xfcd6,0xfde2,0xfc40,0xfca4,0xfd54,
0x039d,0x0334,0x02e2,0xfd1b,0xfd65,0xfdb0,0xfcbd,0xfd6f,
0xfdeb,0x02df,0x0316,0x0220,0xfdc9,0xfcf3,0xfcb8,0xfdf1,
0xfd9e,0xfdbe,0x023f,0x0314,0x02a2,0xfc8a,0xfd0a,0xfdf9,
0xfd79,0xfda1,0xfc88,0x028f,0x030f,0x0210,0xfc15,0xfd5b,
0xfcd7,0xfcb8,0xfda9,0xfddf,0x020f,0x0201,0x02a5,0xfdef,
0xfd45,0xfd59,0xfde0,0xfdfe,0xfc7f,0x030e,0x0354,0x03ac,
0xfd75,0xfd32,0xfcf1,0xfdab,0xfd3b,0xfca1,0x0242,0x038e,
0x0201,0xfdfe,0xfdbb,0xfc6e,0xfd72,0xfcd7,0xfdfd,0x02b4,
0x0372,0x02de,0xfdac,0xfc1f,0xfd88,0xfc57,0xfd09,0xfdf2,
0x024a,0x02ab,0x02cb,0xfcf2,0xfcce,0xfc46,0xfd62,0xfc71,
0xfc19,0x02e3,0x0261,0x02cd,0xfc90,0xfdfa,0xfcaa,0xfdea,
0xfd2b,0xfc12,0x030a,0x0305,0x02b9,0xfdb4,0xfdee,0xfdf1,
0xfdb0,0xfdb8,0xfc49,0x039a,0x0311,0x032d,0xfd3d,0xfd24,
0xfd90,0xfcc2,0xfda6,0xfd7a,0x02fe,0x028b,0x03d8,0xfc32,
0xfd20,0xfd8e,0xfdc3,0xfcc5,0xfc4e,0x03d2,0x0254,0x0203,
0xfdc7,0xfc28,0xfda8,0xfc5a,0xfd4a,0xfdfa,0x0217,0x02f5,
0x021c,0xfce8,0xfdcb,0xfce1,0xfdd0,0xfdd1,0xfdc5,0x0296,
0x02af,0x024d,0xfc86,0xfd06,0xfce9,0xfca7,0xfc64,0xfd5a,
0x022a,0x0218,0x03d3,0xfdbc,0xfdee,0xfe00,0xfda7,0xfdcf,
0xfc58,0x02d3,0x03d6,0x02b2,0xfd4a,0xfc30,0xfd6a,0xfc02,
0xfc51,0xfc5c,0x03a8,0x03bc,0x020f,0xfc95,0xfc3b,0xfc26,
0xfca8,0xfc82,0xfde1,0x024e,0x03ea,0x0223,0xfdbf,0xfd89,
0xfde8,0xfd58,0xfc2c,0xfdb6,0x0205,0x028d,0x0339,0xfd6c,
0xfcbf,0xfdf2,0xfdf6,0xfcbe,0xfd68,0x0340,0x0250,0x03ce,
0xfc3c,0xfce8,0xfdcc,0xfd5b,0xfd52,0xfc60,0x0200,0x03bd,
0x0387,0xfc43,0xfc79,0xfcb4,0xfe00,0xfc82,0xfce4,0x0277,
0x0221,0x038a,0xfd60,0xfdd2,0xfc3b,0xfcf7,0xfdbb,0xfcde,
0x0202,0x02d0,0x0289,0xfd2d,0xfd74,0xfc6f,0xfdfc,0xfc0c,
0xfcc8,0x0254,0x02a7,0x02b6,0xfcea,0xfcd9,0xfc68,0xfd4b,
0xfc7c,0xfc54,0x0269,0x02e4,0x03d3,0xfc84,0xfdb2,0xfd3c,
0xfd19,0xfde9,0xfc58,0x02c7,0x02ad,0x036d,0xfc48,0xfd9f,
0xfdb5,0xfc25,0xfc6b,0xfd10,0x028f,0x0343,0x0350,0xfdea,
0xfde2,0xfd4d,0xfcba,0xfd57,0xfd42,0x02f2,0x0347,0x02ba,
0xfd96,0xfdfd,0xfdc3,0xfdd4,0xfd50,0xfc46,0x0367,0x0203,
0x0301,0xfc93,0xfd71,0xfcfa,0xfd1a,0xfdfa,0xfdbe,0x03bb,
0x0354,0x023d,0xfce5,0xfde9,0xfc45,0xfc84,0xfd3b,0xfd7d,
0x0280,0x035b,0x024b,0xfde7,0xfd21,0xfc26,0xfcdf,0xfd2f,
0xfd5e,0x0318,0x035f,0x022a,0xfd65,0xfca6,0xfc59,0xfd9c,
0xfd29,0xfda7,0x034b,0x02c4,0x02aa,0xfdb9,0xfdce,0xfc50,
0xfd4a,0xfc2d,0xfc72,0x03cb,0x0300,0x0228,0xfd28,0xfdf4,
0xfcc3,0xfc67,0xfdc0,0xfdac,0x037b,0x0218,0x02b2,0xfc59,
0xfda7,0xfd2c,0xfcf8,0xfdcd,0xfc5d,0x03f8,0x0230,0x0297,
0xfdd4,0xfd6d,0xfd29,0xfc0f,0xfd9a,0xfca4,0x021f,0x0366,
0x02a2,0xfc64,0xfd34,0xfdc3,0xfdbf,0xfd1d,0xfc87,0x0259,
0x03e7,0x0249,0xfdb6,0xfd52,0xfdc5,0xfd3f,0xfc31,0xfd64,
0x03b1,0x03c6,0x0379,0xfc84,0xfccb,0xfcb8,0xfc98,0xfc70,
0xfcfb,0x0211,0x0390,0x0309,0xfc51,0xfcdc,0xfd4c,0xfddd,
0xfcd4,0xfdb2,0x023e,0x03fc,0x02ca,0xfdc4,0xfcdf,0xfd39,
0xfd7d,0xfc08,0xfc1b,0x0261,0x039a,0x03a4,0xfddb,0xfdd5,
0xfcb8,0xfd2b,0xfcc1,0xfcb0,0x0256,0x030a,0x03a1,0xfc73,
0xfde1,0xfd3d,0xfd46,0xfdb0,0xfcb4,0x028b,0x0304,0x02e8,
0xfc2a,0xfc4d,0xfdcf,0xfcc5,0xfdba,0xfde3,0x02b3,0x03bd,
0x02d2,0xfd7a,0xfc30,0xfd5d,0xfc5a,0xfc82,0xfc04,0x02d9,
0x02fe,0x03d8,0xfdde,0xfd43,0xfd20,0xfdf8,0xfdc3,0xfc4f,
0x0223,0x0207,0x0278,0xfdd5,0xfd5d,0xfd80,0xfdb7,0xfdf2,
0xfcf4,0x0247,0x0214,0x039a,0xfda1,0xfdf3,0xfc40,0xfd68,
0xfdd6,0xfcc1,0x0279,0x03e3,0x025b,0xfd99,0xfd17,0xfdb6,
0xfcf1,0xfc38,0xfd3a,0x02a5,0x023b,0x036a,0xfd0b,0xfdbe,
0xfc2f,0xfc80,0xfd82,0xfd15,0x025a,0x0221,0x029a,0xfd7f,
0xfcf1,0xfd3b,0xfd3c,0xfdbc,0xfc9e,0x0273,0x021e,0x036b,
0xfd67,0xfde8,0xfc60,0xfcff,0xfdc1,0xfd14,0x02a0,0x03d7,
0x0256,0xfd7b,0xfcee,0xfdc1,0xfc8e,0xfc50,0xfd44,0x02b4,
0x03d3,0x02da,0xfd6a,0xfc24,0xfd46,0xfc57,0xfc57,0xfdf7,
0x029c,0x027a,0x0368,0xfcc5,0xfdc7,0xfde4,0xfc99,0xfcef,
0xfd1a,0x02c7,0x02c2,0x02a2,0xfc2a,0xfc57,0xfc5d,0xfc24,
0xfc31,0xfc87,0x02e3,0x03d1,0x0253,0xfd3e,0xfca4,0xfdc8,
0xfdea,0xfc5c,0xfd4d,0x02f7,0x0389,0x02fb,0xfd61,0xfdca,
0xfd5d,0xfdcd,0xfce1,0xfdc7,0x02f4,0x0246,0x02fb,0xfca4,
0xfdcd,0xfc9c,0xfdd2,0xfd69,0xfdc8,0x02ec,0x03f5,0x038c,
0xfd1b,0xfd68,0xfc7e,0xfddd,0xfc16,0xfcdb,0x0324,0x03a9,
0x03b6,0xfd20,0xfd16,0xfc9b,0xfd89,0xfca6,0xfc8e,0x0311,
0x021f,0x03e6,0xfcbf,0xfd02,0xfdef,0xfda6,0xfdc0,0xfc33,
0x03e7,0x02ac,0x03ae,0xfd64,0xfc68,0xfd8a,0xfc31,0xfc6d,
0xfc9c,0x0272,0x0279,0x03e4,0xfcfa,0xfd9f,0xfd98,0xfd03,
0xfcf1,0xfc36,0x0272,0x0237,0x0343,0xfd4b,0xfc03,0xfc63,
0xfd03,0xfd8c,0xfd57,0x02e3,0x023b,0x03cd,0xfcc7,0xfd42,
0xfde1,0xfdeb,0xfd83,0xfc63,0x028f,0x0301,0x02c3,0xfc28,
0xfc76,0xfded,0xfcb9,0xfdbf,0xfc2e,0x02be,0x03b8,0x023b,
0xfd73,0xfcef,0xfdec,0xfc3c,0xfc8a,0xfd82,0x02d7,0x02c8,
0x0202,0xfc0c,0xfd26,0xfd35,0xfdfc,0xfc22,0xfdfc,0x02e8,
0x02ae,0x02e5,0xfc1a,0xfde5,0xfc1e,0xfde3,0xfc67,0xfde8,
0x02db,0x0228,0x02ca,0xfceb,0xfc03,0xfcfc,0xfdf6,0xfdac,
0xfc1a,0x0338,0x03df,0x02d6,0xfce2,0xfdb7,0xfd41,0xfd68,
0xfc41,0xfdfd,0x031b,0x0267,0x0220,0xfc45,0xfcb4,0xfd73,
0xfd97,0xfd1e,0xfdbe,0x0366,0x023f,0x0338,0xfc2e,0xfd44,
0xfc62,0xfd1d,0xfd7a,0xfd68,0x0323,0x0340,0x039b,0xfd73,
0xfd2c,0xfd12,0xfd8a,0xfd5b,0xfcc0,0x0333,0x0347,0x0213,
0xfd61,0xfcaf,0xfc99,0xfd71,0xfd50,0xfdda,0x0377,0x0312,
0x0354,0xfd57,0xfd1e,0xfd72,0xfcff,0xfda5,0xfd3b,0x03a5,
0x02fc,0x023a,0xfd48,0xfdf9,0xfcad,0xfcae,0xfdc6,0xfd86,
0x02cc,0x038a,0x028e,0xfd86,0xfc6c,0xfdbd,0xfc15,0xfcde,
0xfcbb,0x0310,0x0324,0x0233,0xfd98,0xfca0,0xfc8b,0xfda7,
0xfd89,0xfd94,0x0306,0x0217,0x036c,0xfcd7,0xfd6a,0xfc6d,
0xfdb7,0xfdd1,0xfd13,0x0327,0x0256,0x0289,0xfc51,0xfc01,
0xfd0a,0xfd84,0xfd45,0xfcca,0x0331,0x02f7,0x02ce,0xfda2,
0xfdc3,0xfdeb,0xfd74,0xfdcd,0xfc10,0x033f,0x03e1,0x034e,
0xfcda,0xfd51,0xfccb,0xfd5d,0xfc3d,0xfd45,0x035a,0x0237,
0x025d,0xfc49,0xfc09,0xfd62,0xfd30,0xfd8c,0xfd34,0x036c,
0x03f4,0x028b,0xfc9e,0xfdd3,0xfd7d,0xfd12,0xfc17,0xfcc5,
0x0354,0x0224,0x0225,0xfc6f,0xfc6e,0xfdb4,0xfd3a,0xfdb5,
0xfdb3,0x037f,0x03f0,0x0367,0xfc8f,0xfd07,0xfca6,0xfcf2,
0xfc1f,0xfd1b,0x037c,0x03e8,0x024f,0xfc98,0xfdfd,0xfdbe,
0xfcf7,0xfc2f,0xfd55,0x03a7,0x0204,0x0344,0xfc50,0xfd04,
0xfcb4,0xfca9,0xfdf7,0xfd56,0x03a3,0x0264,0x0308,0xfdd3,
0xfd3e,0xfc5f,0xfcb1,0xfd23,0xfdb3,0x03c8,0x0266,0x0330,
0xfdbb,0xfcfd,0xfc2c,0xfc6d,0xfd1e,0xfd75,0x020c,0x0309,
0x02cf,0xfce4,0xfd1f,0xfdde,0xfde7,0xfdb2,0xfc0c,0x0225,
0x02b6,0x0312,0xfd18,0xfcb5,0xfdeb,0xfdb3,0xfc53,0xfda5,
0x0372,0x02f2,0x0216,0xfd77,0xfc68,0xfced,0xfd09,0xfdd5,
0xfdd3,0x0255,0x0345,0x02fe,0xfc2f,0xfc81,0xfd8d,0xfd47,
0xfd54,0xfdc2,0x027b,0x03ba,0x02c0,0xfdb0,0xfc97,0xfd70,
0xfcec,0xfc86,0xfc37,0x0323,0x0226,0x031e,0xfca1,0xfd8e,
0xfca6,0xfd8a,0xfdb1,0xfd92,0x02bb,0x028e,0x031e,0xfc82,
0xfddf,0xfc03,0xfc46,0xfcbb,0xfd92,0x039c,0x02ff,0x02e2,
0xfd4b,0xfd66,0xfdd7,0xfcbe,0xfdc1,0xfded,0x03ca,0x02a3,
0x0260,0xfd81,0xfdc0,0xfcdf,0xfc69,0xfc86,0xfd2e,0x0278,
0x02c2,0x02ac,0xfc97,0xfcb4,0xfc50,0xfcf4,0xfc30,0xfc6e,
0x035a,0x02ff,0x0233,0xfd7d,0xfc4f,0xfcb4,0xfd31,0xfdc2,
0xfd94,0x020f,0x02fd,0x02be,0xfcec,0xfd2c,0xfdf3,0xfde1,
0xfdc4,0xfc3c,0x022f,0x039c,0x03eb,0xfc0f,0xfddd,0xfc77,
0xfd9e,0xfcbf,0xfc29,0x026a,0x020c,0x0263,0xfd87,0xfd1e,
0xfd8f,0xfd15,0xfde8,0xfd27,0x03e7,0x03ae,0x03c3,0xfc68,
0xfc54,0xfc8a,0xfc30,0xfc9d,0xfc77,0x0223,0x0359,0x03a7,
0xfc6c,0xfc19,0xfcf1,0xfdb8,0xfd32,0xfcaa,0x02de,0x039e,
0x0239,0xfd67,0xfcce,0xfdfd,0xfdf1,0xfcba,0xfd86,0x03c7,
0x02ea,0x0227,0xfd3f,0xfdf8,0xfcdc,0xfc6f,0xfde0,0xfdaf,
0x0342,0x0279,0x0371,0xfdfd,0xfd32,0xfddf,0xfd59,0xfcf1,
0xfd0a,0x03ad,0x02bd,0x02d7,0xfd7b,0xfd64,0xfc1b,0xfc9f,
0xfc3f,0xfdfc,0x03b1,0x0234,0x027c,0xfdf7,0xfdb5,0xfd43,
0xfc97,0xfd91,0xfcea,0x0200,0x0233,0x0319,0xfdcd,0xfce6,
0xfc97,0xfe00,0xfd95,0xfd99,0x03d8,0x022c,0x023a,0xfdea,
0xfddc,0xfd94,0xfc4f,0xfda4,0xfd84,0x03d8,0x021c,0x02e4,
0xfdf9,0xfd38,0xfcf2,0xfc4e,0xfdc6,0xfde8,0x020f,0x02fc,
0x036a,0xfced,0xfc7b,0xfd74,0xfde1,0xfdc6,0xfd15,0x0212,
0x0298,0x03f6,0xfd50,0xfdf3,0xfd6e,0xfddb,0xfca2,0xfc13,
0x0222,0x0203,0x0209,0xfdda,0xfdd4,0xfdf3,0xfdb8,0xfdf9,
0xfded,0x022a,0x03a6,0x02a0,0xfc0d,0xfd28,0xfd9b,0xfda8,
0xfcac,0xfc8e,0x0256,0x03b1,0x022c,0xfdd8,0xfd76,0xfdff,
0xfd44,0xfc98,0xfda5,0x0273,0x0213,0x02dd,0xfd75,0xfc7d,
0xfd08,0xfcff,0xfdd9,0xfdf3,0x0240,0x03fc,0x03f6,0xfdc2,
0xfdc5,0xfc0d,0xfd76,0xfc08,0xfc13,0x026f,0x039c,0x0252,
0xfdcd,0xfd2c,0xfde7,0xfd09,0xfcbd,0xfd4d,0x02a6,0x038d,
0x025b,0xfda6,0xfce0,0xfde8,0xfc7d,0xfcd9,0xfd38,0x032e,
0x02e8,0x021f,0xfdb0,0xfc9f,0xfcea,0xfd78,0xfde3,0xfdbf};

const unsigned short wavtable2[2304]={
0x0e,0x0e,0x0e,0x14,0x14,0x13,0x15,0x14,0x14,0x0e,0x0e,0x0e,
0x14,0x14,0x14,0x14,0x15,0x15,0x0e,0x0d,0x0e,0x12,0x14,0x13,
0x15,0x12,0x15,0x0d,0x0d,0x0e,0x12,0x13,0x13,0x13,0x12,0x15,
0x0d,0x0e,0x0d,0x13,0x12,0x12,0x13,0x14,0x13,0x0d,0x0e,0x0f,
0x13,0x13,0x14,0x13,0x15,0x16,0x0d,0x0d,0x0d,0x11,0x11,0x12,
0x12,0x13,0x13,0x0c,0x0e,0x0d,0x12,0x11,0x13,0x11,0x14,0x13,
0x0d,0x0d,0x0d,0x12,0x12,0x11,0x13,0x12,0x12,0x0d,0x0d,0x0c,
0x12,0x11,0x11,0x12,0x13,0x11,0x0d,0x0c,0x0d,0x11,0x11,0x10,
0x12,0x11,0x12,0x0c,0x0d,0x0c,0x11,0x10,0x11,0x11,0x13,0x11,
0x0c,0x0d,0x0d,0x10,0x11,0x11,0x11,0x12,0x12,0x0c,0x0d,0x0d,
0x10,0x10,0x11,0x10,0x13,0x12,0x0c,0x0c,0x0d,0x0f,0x10,0x10,
0x10,0x11,0x12,0x0b,0x0d,0x0d,0x0f,0x0f,0x11,0x0f,0x12,0x12,
0x0d,0x0c,0x0d,0x10,0x11,0x11,0x12,0x10,0x13,0x0c,0x0c,0x0c,
0x10,0x10,0x10,0x11,0x10,0x11,0x0d,0x0c,0x0c,0x11,0x11,0x0f,
0x13,0x10,0x10,0x0d,0x0c,0x0b,0x10,0x10,0x0e,0x13,0x10,0x0f,
0x0c,0x0c,0x0c,0x10,0x10,0x10,0x11,0x11,0x11,0x0c,0x0d,0x0b,
0x10,0x0f,0x10,0x11,0x12,0x0f,0x0c,0x0c,0x0b,0x10,0x0e,0x0f,
0x10,0x11,0x0f,0x0b,0x0d,0x0c,0x0f,0x0f,0x10,0x0f,0x12,0x10,
0x0c,0x0c,0x0c,0x0f,0x0f,0x0f,0x10,0x10,0x10,0x0b,0x0c,0x0c,
0x0f,0x0e,0x0f,0x0f,0x10,0x10,0x0b,0x0c,0x0c,0x0f,0x0f,0x10,
0x0f,0x10,0x11,0x0b,0x0c,0x0d,0x0f,0x0f,0x10,0x0e,0x11,0x12,
0x0b,0x0c,0x0b,0x0f,0x0e,0x0f,0x0f,0x11,0x0f,0x0b,0x0c,0x0b,
0x0f,0x0e,0x0f,0x0e,0x11,0x0f,0x0b,0x0d,0x0c,0x0f,0x0e,0x10,
0x0e,0x12,0x11,0x0b,0x0c,0x0c,0x0e,0x0e,0x10,0x0e,0x11,0x11,
0x0c,0x0c,0x0c,0x0f,0x10,0x0f,0x11,0x10,0x11,0x0c,0x0b,0x0c,
0x0f,0x10,0x0f,0x11,0x0f,0x10,0x0c,0x0c,0x0b,0x0f,0x0f,0x0f,
0x11,0x10,0x0f,0x0c,0x0c,0x0b,0x0f,0x0e,0x0e,0x10,0x10,0x0f,
0x0d,0x0b,0x0b,0x0f,0x0f,0x0e,0x12,0x0f,0x0f,0x0c,0x0b,0x0a,
0x0f,0x0e,0x0d,0x11,0x0f,0x0d,0x0b,0x0b,0x0b,0x0e,0x0e,0x0e,
0x0f,0x0f,0x0e,0x0b,0x0b,0x0a,0x0e,0x0d,0x0d,0x0f,0x0f,0x0d,
0x0c,0x0b,0x0c,0x0e,0x0f,0x0f,0x10,0x0f,0x11,0x0b,0x0b,0x0c,
0x0e,0x0f,0x0f,0x0f,0x0f,0x10,0x0b,0x0c,0x0b,0x0e,0x0e,0x0e,
0x0f,0x10,0x0f,0x0b,0x0b,0x0b,0x0e,0x0e,0x0e,0x0e,0x0f,0x0f,
0x0b,0x0b,0x0c,0x0e,0x0e,0x0f,0x0e,0x0f,0x10,0x0b,0x0b,0x0c,
0x0e,0x0e,0x0f,0x0e,0x0f,0x11,0x0b,0x0c,0x0c,0x0e,0x0e,0x0f,
0x0e,0x10,0x10,0x0a,0x0c,0x0c,0x0d,0x0e,0x0f,0x0d,0x10,0x10,
0x0b,0x0c,0x0b,0x0e,0x0d,0x0e,0x0e,0x10,0x0e,0x0b,0x0b,0x0b,
0x0e,0x0d,0x0e,0x0e,0x0f,0x0e,0x0a,0x0c,0x0b,0x0e,0x0d,0x0e,
0x0d,0x11,0x0e,0x0a,0x0c,0x0b,0x0e,0x0d,0x0e,0x0d,0x10,0x0e,
0x0b,0x0b,0x0b,0x0d,0x0d,0x0e,0x0e,0x0f,0x0f,0x0a,0x0b,0x0b,
0x0d,0x0d,0x0e,0x0d,0x0f,0x0f,0x0a,0x0b,0x0c,0x0d,0x0e,0x0e,
0x0d,0x0f,0x10,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x0d,0x0f,0x10,
0x0b,0x0c,0x0b,0x0e,0x0d,0x0f,0x0e,0x10,0x0f,0x0a,0x0c,0x0c,
0x0e,0x0d,0x0f,0x0d,0x11,0x10,0x0a,0x0d,0x0c,0x0e,0x0e,0x10,
0x0d,0x12,0x10,0x0a,0x0c,0x0d,0x0e,0x0e,0x10,0x0d,0x11,0x12,
0x0a,0x0c,0x0b,0x0d,0x0d,0x0f,0x0d,0x10,0x0f,0x0a,0x0c,0x0b,
0x0d,0x0d,0x0f,0x0d,0x10,0x0f,0x0a,0x0c,0x0c,0x0e,0x0d,0x10,
0x0d,0x11,0x10,0x0a,0x0c,0x0c,0x0d,0x0e,0x10,0x0c,0x10,0x11,
0x0c,0x0b,0x0c,0x0f,0x10,0x0e,0x11,0x0e,0x10,0x0c,0x0b,0x0b,
0x0e,0x0f,0x0d,0x11,0x0e,0x0f,0x0b,0x0b,0x0c,0x0e,0x0e,0x0e,
0x0f,0x0e,0x10,0x0b,0x0b,0x0b,0x0d,0x0e,0x0e,0x0e,0x0e,0x0f,
0x0b,0x0a,0x0b,0x0d,0x0e,0x0d,0x0f,0x0d,0x0f,0x0b,0x0a,0x0b,
0x0d,0x0e,0x0d,0x0f,0x0d,0x0f,0x0c,0x0a,0x0a,0x0e,0x0e,0x0c,
0x11,0x0d,0x0d,0x0c,0x0a,0x0a,0x0d,0x0d,0x0b,0x10,0x0d,0x0c,
0x0b,0x0b,0x0b,0x0e,0x0e,0x0d,0x0f,0x0e,0x0e,0x0b,0x0b,0x0a,
0x0d,0x0d,0x0d,0x0f,0x0e,0x0d,0x0b,0x0b,0x0a,0x0e,0x0c,0x0d,
0x0e,0x0f,0x0d,0x0a,0x0c,0x0a,0x0e,0x0c,0x0d,0x0d,0x10,0x0c,
0x0b,0x0b,0x0b,0x0d,0x0e,0x0d,0x0e,0x0e,0x0f,0x0b,0x0b,0x0b,
0x0d,0x0d,0x0d,0x0e,0x0e,0x0e,0x0a,0x0b,0x0b,0x0d,0x0d,0x0e,
0x0d,0x0e,0x0f,0x0a,0x0b,0x0b,0x0c,0x0d,0x0d,0x0d,0x0e,0x0f,
0x0b,0x0a,0x0b,0x0d,0x0d,0x0d,0x0e,0x0d,0x0e,0x0b,0x0b,0x0a,
0x0d,0x0c,0x0d,0x0e,0x0e,0x0d,0x0b,0x0a,0x0a,0x0c,0x0c,0x0c,
0x0e,0x0d,0x0d,0x0a,0x0a,0x0a,0x0c,0x0c,0x0c,0x0d,0x0d,0x0d,
0x0b,0x0b,0x0a,0x0d,0x0c,0x0c,0x0e,0x0e,0x0c,0x0a,0x0b,0x0a,
0x0d,0x0c,0x0c,0x0d,0x0e,0x0c,0x0a,0x0b,0x0a,0x0c,0x0b,0x0c,
0x0d,0x0e,0x0c,0x0a,0x0b,0x0a,0x0c,0x0b,0x0c,0x0c,0x0e,0x0c,
0x0a,0x0a,0x0b,0x0c,0x0d,0x0d,0x0d,0x0d,0x0f,0x0a,0x0a,0x0b,
0x0c,0x0d,0x0d,0x0d,0x0d,0x0e,0x0a,0x0b,0x0b,0x0c,0x0c,0x0d,
0x0c,0x0e,0x0e,0x0a,0x0b,0x0b,0x0c,0x0d,0x0d,0x0c,0x0e,0x0f,
0x0a,0x0a,0x0b,0x0c,0x0c,0x0c,0x0c,0x0d,0x0e,0x0a,0x0a,0x0a,
0x0b,0x0c,0x0c,0x0c,0x0d,0x0d,0x0a,0x0a,0x0b,0x0b,0x0c,0x0c,
0x0c,0x0d,0x0e,0x09,0x0a,0x0b,0x0b,0x0c,0x0d,0x0b,0x0d,0x0e,
0x0b,0x0b,0x0b,0x0d,0x0d,0x0d,0x0e,0x0f,0x0e,0x0a,0x0b,0x0b,
0x0d,0x0c,0x0d,0x0d,0x0f,0x0e,0x0a,0x0b,0x0a,0x0d,0x0c,0x0d,
0x0d,0x0f,0x0d,0x0a,0x0b,0x0b,0x0d,0x0c,0x0d,0x0c,0x0f,0x0e,
0x0a,0x0b,0x0b,0x0d,0x0d,0x0e,0x0d,0x0f,0x0f,0x0a,0x0b,0x0b,
0x0d,0x0d,0x0e,0x0c,0x0f,0x0f,0x0a,0x0b,0x0b,0x0d,0x0d,0x0e,
0x0c,0x0f,0x0f,0x0a,0x0b,0x0c,0x0c,0x0d,0x0f,0x0c,0x0f,0x10,
0x0a,0x0c,0x0b,0x0e,0x0c,0x0e,0x0d,0x10,0x0e,0x0a,0x0c,0x0b,
0x0e,0x0c,0x0f,0x0c,0x11,0x0e,0x0a,0x0c,0x0c,0x0d,0x0d,0x0f,
0x0c,0x10,0x10,0x0a,0x0d,0x0c,0x0e,0x0d,0x10,0x0c,0x12,0x11,
0x0a,0x0c,0x0b,0x0d,0x0c,0x0f,0x0c,0x10,0x0f,0x0a,0x0c,0x0b,
0x0d,0x0c,0x0e,0x0c,0x10,0x0f,0x0a,0x0c,0x0c,0x0d,0x0d,0x0f,
0x0c,0x11,0x10,0x0a,0x0c,0x0c,0x0d,0x0d,0x10,0x0c,0x10,0x11,
0x0a,0x0c,0x0a,0x0d,0x0c,0x0e,0x0c,0x10,0x0d,0x0a,0x0c,0x0b,
0x0d,0x0c,0x0e,0x0c,0x10,0x0e,0x0a,0x0c,0x0a,0x0d,0x0b,0x0d,
0x0c,0x10,0x0d,0x0a,0x0b,0x0b,0x0c,0x0c,0x0e,0x0c,0x0f,0x0e,
0x0a,0x0b,0x0b,0x0c,0x0c,0x0d,0x0c,0x0e,0x0e,0x0a,0x0b,0x0b,
0x0c,0x0c,0x0e,0x0c,0x0f,0x0f,0x09,0x0b,0x0b,0x0c,0x0c,0x0e,
0x0b,0x0f,0x0f,0x09,0x0b,0x0c,0x0c,0x0d,0x0e,0x0b,0x0f,0x10,
0x0a,0x0c,0x0b,0x0d,0x0c,0x0f,0x0c,0x11,0x0e,0x09,0x0c,0x0b,
0x0d,0x0c,0x0f,0x0b,0x11,0x0f,0x09,0x0c,0x0c,0x0d,0x0c,0x0f,
0x0b,0x10,0x10,0x09,0x0c,0x0c,0x0d,0x0d,0x10,0x0b,0x11,0x11,
0x09,0x0c,0x0b,0x0d,0x0c,0x0f,0x0b,0x11,0x0e,0x09,0x0c,0x0c,
0x0d,0x0c,0x10,0x0b,0x11,0x10,0x09,0x0c,0x0c,0x0d,0x0c,0x0f,
0x0b,0x11,0x10,0x09,0x0d,0x0c,0x0d,0x0d,0x10,0x0b,0x12,0x11,
0x0c,0x0a,0x0b,0x0d,0x0e,0x0c,0x10,0x0c,0x0e,0x0b,0x0a,0x0a,
0x0c,0x0d,0x0c,0x0e,0x0c,0x0d,0x0a,0x0a,0x0b,0x0c,0x0d,0x0c,
0x0d,0x0c,0x0f,0x0a,0x0a,0x0a,0x0c,0x0c,0x0c,0x0d,0x0c,0x0d,
0x0b,0x09,0x0a,0x0c,0x0d,0x0b,0x0f,0x0b,0x0d,0x0b,0x0a,0x0a,
0x0c,0x0c,0x0b,0x0e,0x0c,0x0c,0x0a,0x0a,0x09,0x0b,0x0b,0x0b,
0x0d,0x0c,0x0b,0x0a,0x0a,0x09,0x0b,0x0b,0x0a,0x0d,0x0c,0x0a,
0x0a,0x0a,0x0a,0x0c,0x0c,0x0c,0x0d,0x0d,0x0d,0x0a,0x0a,0x0a,
0x0c,0x0b,0x0c,0x0c,0x0d,0x0d,0x0a,0x0a,0x0a,0x0b,0x0b,0x0b,
0x0c,0x0c,0x0d,0x0a,0x0a,0x0a,0x0b,0x0b,0x0b,0x0c,0x0c,0x0c,
0x0a,0x0a,0x0a,0x0c,0x0b,0x0b,0x0c,0x0d,0x0c,0x0a,0x0a,0x09,
0x0b,0x0b,0x0b,0x0c,0x0d,0x0b,0x09,0x0a,0x09,0x0b,0x0a,0x0b,
0x0b,0x0c,0x0b,0x09,0x0a,0x09,0x0b,0x0a,0x0b,0x0b,0x0d,0x0b,
0x0a,0x09,0x0b,0x0b,0x0c,0x0b,0x0d,0x0b,0x0e,0x0a,0x0a,0x0a,
0x0b,0x0c,0x0b,0x0d,0x0c,0x0d,0x0a,0x0a,0x0a,0x0b,0x0c,0x0c,
0x0c,0x0c,0x0d,0x09,0x0a,0x0a,0x0a,0x0b,0x0b,0x0b,0x0c,0x0d,
0x0a,0x09,0x0a,0x0b,0x0c,0x0a,0x0d,0x0b,0x0c,0x0a,0x09,0x0a,
0x0b,0x0b,0x0a,0x0c,0x0b,0x0c,0x09,0x0a,0x0a,0x0b,0x0b,0x0b,
0x0b,0x0c,0x0c,0x09,0x09,0x0a,0x0a,0x0a,0x0b,0x0b,0x0b,0x0c,
0x09,0x0a,0x0a,0x0b,0x0b,0x0c,0x0b,0x0d,0x0d,0x09,0x0a,0x0a,
0x0b,0x0b,0x0c,0x0b,0x0d,0x0d,0x09,0x0a,0x0b,0x0b,0x0b,0x0c,
0x0b,0x0c,0x0e,0x09,0x0a,0x0b,0x0b,0x0b,0x0c,0x0b,0x0d,0x0e,
0x09,0x0a,0x0a,0x0a,0x0a,0x0b,0x0b,0x0c,0x0c,0x09,0x0a,0x0a,
0x0a,0x0a,0x0b,0x0a,0x0c,0x0d,0x09,0x09,0x0a,0x0a,0x0a,0x0b,
0x0a,0x0b,0x0c,0x09,0x0a,0x0a,0x0a,0x0a,0x0c,0x0a,0x0c,0x0d,
0x0a,0x0b,0x0a,0x0c,0x0c,0x0d,0x0d,0x0e,0x0d,0x0a,0x0b,0x0a,
0x0c,0x0c,0x0d,0x0c,0x0e,0x0d,0x0a,0x0b,0x0a,0x0c,0x0b,0x0d,
0x0c,0x0f,0x0d,0x0a,0x0b,0x0a,0x0c,0x0b,0x0d,0x0c,0x0e,0x0d,
0x0a,0x0a,0x0a,0x0c,0x0b,0x0c,0x0c,0x0d,0x0d,0x0a,0x0a,0x0a,
0x0b,0x0b,0x0c,0x0c,0x0d,0x0d,0x09,0x0b,0x0a,0x0c,0x0b,0x0c,
0x0b,0x0e,0x0d,0x09,0x0b,0x0a,0x0b,0x0b,0x0c,0x0b,0x0e,0x0d,
0x0a,0x0b,0x0b,0x0c,0x0c,0x0d,0x0c,0x0e,0x0e,0x09,0x0b,0x0b,
0x0c,0x0c,0x0d,0x0b,0x0e,0x0e,0x09,0x0b,0x0b,0x0b,0x0c,0x0d,
0x0b,0x0e,0x0f,0x09,0x0b,0x0c,0x0b,0x0c,0x0e,0x0b,0x0e,0x10,
0x09,0x0b,0x0b,0x0c,0x0b,0x0d,0x0b,0x0e,0x0e,0x09,0x0b,0x0b,
0x0c,0x0c,0x0d,0x0b,0x0e,0x0e,0x09,0x0b,0x0b,0x0b,0x0c,0x0d,
0x0b,0x0e,0x0f,0x09,0x0b,0x0c,0x0b,0x0c,0x0e,0x0a,0x0e,0x10,
0x09,0x0b,0x0a,0x0c,0x0b,0x0d,0x0b,0x0f,0x0d,0x09,0x0b,0x0b,
0x0c,0x0b,0x0e,0x0b,0x0f,0x0e,0x09,0x0c,0x0a,0x0c,0x0b,0x0d,
0x0b,0x10,0x0d,0x09,0x0b,0x0b,0x0c,0x0b,0x0e,0x0b,0x0f,0x0e,
0x09,0x0b,0x0b,0x0c,0x0c,0x0e,0x0b,0x0f,0x0f,0x09,0x0b,0x0c,
0x0c,0x0c,0x0f,0x0b,0x0f,0x10,0x09,0x0c,0x0b,0x0c,0x0c,0x0e,
0x0b,0x10,0x0f,0x09,0x0c,0x0c,0x0c,0x0d,0x0f,0x0b,0x10,0x10,
0x09,0x0c,0x0b,0x0d,0x0b,0x0e,0x0b,0x11,0x0e,0x09,0x0c,0x0b,
0x0d,0x0c,0x0f,0x0b,0x11,0x0f,0x09,0x0c,0x0b,0x0c,0x0c,0x0e,
0x0a,0x10,0x0f,0x09,0x0c,0x0c,0x0c,0x0c,0x0f,0x0a,0x10,0x10,
0x09,0x0c,0x0b,0x0d,0x0b,0x0f,0x0a,0x11,0x0e,0x09,0x0d,0x0c,
0x0d,0x0c,0x10,0x0a,0x12,0x10,0x09,0x0d,0x0c,0x0d,0x0c,0x10,
0x0a,0x12,0x10,0x09,0x0c,0x0d,0x0d,0x0d,0x10,0x0a,0x11,0x12,
0x0a,0x0b,0x0a,0x0c,0x0b,0x0c,0x0c,0x0f,0x0c,0x09,0x0b,0x0a,
0x0c,0x0a,0x0c,0x0b,0x0f,0x0c,0x09,0x0a,0x0a,0x0b,0x0b,0x0c,
0x0b,0x0d,0x0c,0x09,0x0a,0x0a,0x0b,0x0a,0x0b,0x0a,0x0d,0x0c,
0x09,0x0b,0x0a,0x0c,0x0b,0x0c,0x0b,0x0e,0x0d,0x09,0x0b,0x0a,
0x0b,0x0b,0x0c,0x0b,0x0e,0x0d,0x09,0x0b,0x0a,0x0c,0x0b,0x0d,
0x0a,0x0f,0x0d,0x09,0x0b,0x0b,0x0c,0x0b,0x0e,0x0a,0x0f,0x0e,
0x09,0x0a,0x0a,0x0b,0x0b,0x0c,0x0a,0x0d,0x0d,0x09,0x0b,0x0a,
0x0b,0x0a,0x0c,0x0a,0x0e,0x0c,0x09,0x0a,0x0a,0x0b,0x0b,0x0c,
0x0a,0x0d,0x0d,0x09,0x0a,0x0b,0x0b,0x0b,0x0d,0x0a,0x0d,0x0e,
0x09,0x0b,0x0b,0x0b,0x0b,0x0d,0x0a,0x0e,0x0e,0x09,0x0b,0x0b,
0x0b,0x0c,0x0e,0x0a,0x0e,0x0f,0x09,0x0b,0x0b,0x0b,0x0b,0x0d,
0x0a,0x0e,0x0e,0x09,0x0b,0x0b,0x0b,0x0b,0x0e,0x0a,0x0e,0x0f,
0x09,0x0c,0x0a,0x0c,0x0b,0x0d,0x0b,0x10,0x0d,0x09,0x0c,0x0a,
0x0c,0x0b,0x0e,0x0a,0x10,0x0d,0x09,0x0b,0x0b,0x0c,0x0b,0x0e,
0x0a,0x0f,0x0e,0x09,0x0b,0x0b,0x0c,0x0c,0x0e,0x0a,0x0f,0x0f,
0x09,0x0c,0x0b,0x0c,0x0b,0x0e,0x0a,0x10,0x0f,0x09,0x0c,0x0c,
0x0c,0x0c,0x0f,0x0a,0x10,0x10,0x09,0x0c,0x0b,0x0d,0x0c,0x0f,
0x0a,0x11,0x0f,0x09,0x0d,0x0c,0x0d,0x0c,0x10,0x0a,0x12,0x11,
0x09,0x0b,0x0a,0x0c,0x0b,0x0d,0x0a,0x0f,0x0d,0x09,0x0c,0x0b,
0x0c,0x0b,0x0e,0x0a,0x10,0x0e,0x09,0x0c,0x0b,0x0c,0x0b,0x0e,
0x0a,0x10,0x0f,0x09,0x0b,0x0c,0x0c,0x0c,0x0f,0x0a,0x0f,0x10,
0x09,0x0c,0x0b,0x0c,0x0b,0x0f,0x0a,0x11,0x0e,0x09,0x0c,0x0c,
0x0c,0x0c,0x10,0x0a,0x11,0x10,0x08,0x0c,0x0b,0x0c,0x0b,0x0e,
0x09,0x10,0x0f,0x08,0x0c,0x0c,0x0c,0x0c,0x0f,0x09,0x11,0x10,
0x0a,0x09,0x09,0x0a,0x0b,0x0a,0x0c,0x0a,0x0b,0x09,0x09,0x09,
0x0a,0x0a,0x09,0x0b,0x0a,0x0a,0x09,0x0a,0x09,0x0a,0x0a,0x0a,
0x0b,0x0c,0x0b,0x09,0x09,0x09,0x0a,0x09,0x0a,0x0a,0x0b,0x0a,
0x09,0x09,0x0a,0x0a,0x0a,0x0b,0x0b,0x0b,0x0c,0x09,0x09,0x0a,
0x09,0x0a,0x0a,0x0a,0x0a,0x0c,0x09,0x09,0x09,0x09,0x09,0x0a,
0x0a,0x0b,0x0b,0x08,0x09,0x09,0x09,0x09,0x0a,0x09,0x0b,0x0b,
0x09,0x0a,0x09,0x0a,0x0a,0x0b,0x0a,0x0c,0x0b,0x08,0x0a,0x09,
0x0a,0x09,0x0a,0x09,0x0c,0x0b,0x08,0x0a,0x0a,0x0a,0x09,0x0b,
0x09,0x0c,0x0c,0x08,0x09,0x0a,0x09,0x0a,0x0b,0x09,0x0b,0x0d,
0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0a,0x0a,0x07,0x08,0x08,
0x07,0x07,0x07,0x07,0x08,0x08,0x08,0x0a,0x09,0x09,0x09,0x0a,
0x08,0x0c,0x0b,0x08,0x09,0x09,0x08,0x08,0x0a,0x08,0x0a,0x0b,
0x09,0x0b,0x0a,0x0b,0x0a,0x0c,0x0a,0x0f,0x0c,0x09,0x0b,0x0a,
0x0b,0x0a,0x0d,0x0a,0x0f,0x0c,0x09,0x0a,0x0a,0x0a,0x0a,0x0c,
0x0a,0x0d,0x0d,0x08,0x0a,0x0b,0x0a,0x0b,0x0d,0x09,0x0d,0x0e,
0x09,0x0b,0x0a,0x0b,0x0a,0x0d,0x0a,0x0f,0x0d,0x09,0x0b,0x0b,
0x0b,0x0b,0x0e,0x0a,0x0f,0x0e,0x08,0x0b,0x0b,0x0b,0x0b,0x0d,
0x09,0x0e,0x0e,0x08,0x0b,0x0c,0x0b,0x0b,0x0e,0x09,0x0f,0x10,
0x08,0x0a,0x09,0x0a,0x09,0x0b,0x09,0x0d,0x0b,0x08,0x0b,0x0a,
0x0b,0x0a,0x0c,0x09,0x0e,0x0d,0x08,0x0b,0x0a,0x0a,0x0a,0x0c,
0x09,0x0e,0x0d,0x08,0x0a,0x0b,0x0a,0x0b,0x0d,0x09,0x0d,0x0e,
0x08,0x0c,0x0b,0x0b,0x0a,0x0e,0x09,0x10,0x0e,0x08,0x0c,0x0b,
0x0b,0x0b,0x0e,0x09,0x10,0x0f,0x08,0x0b,0x0a,0x0a,0x0a,0x0c,
0x09,0x0e,0x0d,0x08,0x0b,0x0a,0x0a,0x0a,0x0d,0x08,0x0e,0x0d};

const signed short etable1[5120]={
0x0026,0xfffc,0x000f,0xfffc,0x000e,0xfff3,0x000c,0xfff5,
0xfffe,0xfffa,0xfffa,0xfff5,0xffd3,0xfff0,0xfff5,0xfff3,
0xfff9,0x0006,0xfff4,0x0004,0xffec,0x0003,0xfff0,0x000c,
0xffff,0x000c,0x002e,0x0018,0x0000,0x0021,0xfffd,0x0009,
0xfff4,0xfff4,0xfff8,0xfff9,0x0011,0xfffa,0x0000,0xfffe,
0x003c,0xfff0,0x0003,0xffea,0x000a,0xffe0,0x0000,0xffe4,
0xffef,0xffee,0xfffd,0xffe7,0xffdb,0xffe9,0xfff6,0x0003,
0x0002,0x0003,0x0000,0x0003,0xfff2,0x0000,0xfff2,0xffff,
0x0000,0x0002,0x0020,0x0009,0xffff,0x0019,0x0007,0x000d,
0xfffb,0x000d,0x0008,0x0001,0x0002,0x0008,0xfff6,0x0006,
0x001b,0xfff4,0x001c,0xfffe,0x0006,0xfff9,0x000f,0x0009,
0xfff5,0x0001,0xfff3,0xfff5,0xffd8,0x0004,0xffe3,0xfff2,
0xffed,0xfffb,0xffe9,0xfff8,0xffe2,0xfff3,0xffef,0x0000,
0xfff2,0x000c,0x0022,0x0014,0xfffe,0x0019,0x0002,0xfff0,
0xfffc,0xfff4,0x000f,0x0010,0x001d,0x0007,0x0018,0x000a,
0x0031,0xffe8,0x0010,0xffec,0x0002,0xffe6,0x0002,0xfff9,
0xffe7,0xfff6,0xfff5,0xffe7,0xffe0,0xfffd,0xffe5,0x0002,
0xfff8,0xfff8,0xfff5,0xfff7,0xffe8,0xffef,0xfff0,0xfff2,
0xfff3,0x0002,0x0014,0x0005,0xfffc,0x0011,0x000e,0xfff4,
0x0003,0x000d,0x0021,0x0019,0x000e,0x0017,0x000f,0x0013,
0x002e,0xfffa,0x0015,0x0008,0xfffe,0xfff0,0xfffb,0xfff8,
0xfff5,0x0004,0x0008,0x000f,0xffe8,0x0004,0xfffe,0xffe6,
0xfffd,0xfff0,0xfff0,0xfff2,0xfff7,0xfffe,0xffff,0x0004,
0x0013,0x0007,0x0024,0x0011,0x0009,0x000d,0x0000,0x001f,
0xfffb,0xfff4,0x0007,0xfff8,0x000b,0xfff1,0xfff3,0xfffc,
0x0044,0xffee,0x0009,0xfff7,0xfffa,0xffdd,0xffee,0xffe7,
0xffe6,0xfff9,0x000a,0x0001,0xfff0,0xfffd,0xffff,0xfff7,
0x0006,0xffed,0xfffc,0xfff1,0xfffc,0xfffa,0x0000,0xfff8,
0x0014,0xfffe,0x0017,0x0002,0x0007,0x0005,0x000c,0x0023,
0x0001,0x000d,0x0018,0x0000,0xfffd,0x0000,0xffea,0x0004,
0x0023,0xfff2,0x0022,0x000a,0xfff6,0xfff6,0xffff,0x000c,
0xffec,0x000c,0x0000,0x000f,0xffee,0x0018,0xffec,0xffe5,
0xfff2,0xffe4,0xffe5,0xffe5,0xffec,0xffed,0xfffe,0xfff8,
0x0005,0x0007,0x0019,0x000d,0x0005,0x0005,0x0006,0x0005,
0x0002,0xfff4,0x001f,0x000f,0x0017,0xffff,0x000c,0x0008,
0x0039,0xffe6,0x0016,0xfff9,0xfff2,0xffe4,0xfff2,0xfffd,
0xffdd,0x0000,0x0003,0x0001,0xfff5,0x0010,0xffee,0xfff6,
0xfffc,0xffe1,0xfff1,0xffe4,0xfff2,0xffe9,0xffff,0xffeb,
0x0007,0xfffe,0x000b,0xffff,0x0003,0xffff,0x0012,0x0009,
0x000a,0x000d,0x0031,0x0018,0x0008,0x000e,0x0002,0x0010,
0x0019,0x000f,0x0016,0x000b,0x0012,0x0004,0x000f,0xffea,
0x0008,0xfffe,0xffef,0xfff7,0xffd0,0xffec,0xffe2,0xffef,
0xfff0,0x000b,0xffff,0x0010,0x0002,0x000a,0xfffb,0x001a,
0xfffe,0xfffc,0x0016,0x0000,0x0002,0x000a,0xfffa,0x000d,
0xfff2,0x000a,0xffe9,0x0000,0x000a,0xfffe,0x0001,0x0000,
0x002f,0x0003,0x000b,0xfffa,0x000f,0xfff3,0x0002,0xffda,
0xfffa,0xfff3,0xfff1,0xffea,0xffd8,0xffe4,0xffe4,0x0000,
0xfffb,0x0008,0x000a,0x000f,0x0007,0x0007,0xfffc,0x000d,
0xffff,0xfff2,0x0009,0xfff2,0x0000,0x0002,0x0004,0x0012,
0xfff9,0x0024,0xfffa,0x0008,0xfffd,0x000d,0xfff9,0x0008,
0x000e,0x0007,0x0024,0x000d,0x000a,0x000a,0x0012,0x0000,
0x0000,0x0005,0xffe7,0xfff8,0xffd5,0x0000,0xffd0,0xffee,
0xffe5,0x0000,0xfff4,0x0003,0xfff9,0xfffa,0xfff9,0x000d,
0xfff1,0xfffb,0x000b,0xfffd,0x0000,0x0002,0x0000,0xfff4,
0xfffa,0x000a,0x0000,0x0017,0x0016,0x000b,0x001a,0x000c,
0x0024,0xfffb,0x0018,0xfffc,0x0007,0xfff9,0x0006,0xffef,
0xfff2,0xfffb,0xffea,0xffea,0xffdd,0xfff8,0xffd2,0xffff,
0xffef,0xfffd,0x0000,0x0002,0xfffe,0xfff6,0xfffb,0x0000,
0xfff2,0xfff1,0xfffe,0xffee,0xfffe,0xfffc,0x000b,0xfff9,
0x0001,0x0024,0x0012,0x0020,0x0007,0x001b,0x0011,0x0014,
0x0021,0x000d,0x001d,0x0018,0x0001,0x0001,0xfffe,0xffee,
0x0000,0x0009,0xfffd,0x0011,0xffe5,0x0000,0xffeb,0xffe2,
0xfff4,0xfff5,0xfffb,0xfffe,0x000c,0x0004,0x0009,0x0013,
0x0012,0xfff7,0x000d,0xfffa,0x000b,0xfff8,0xfffe,0x0023,
0xfff8,0x000a,0xfff9,0xffff,0x0004,0xfff5,0xfff6,0xfffe,
0x0037,0x0001,0x0011,0x0006,0xffff,0xfff0,0xfff1,0xffdd,
0xfff1,0xfffe,0x0000,0x0004,0xffed,0xfff8,0xffec,0xfff3,
0xffff,0xfff2,0x0007,0xfffd,0x0012,0x0000,0x000a,0x0005,
0x0013,0xffed,0x0000,0xffeb,0x0008,0xfff0,0x0009,0x0027,
0x0000,0x0024,0x000a,0x0007,0xfff7,0x0004,0xffec,0x0005,
0x0016,0x0005,0x002a,0x001a,0xfffa,0x0008,0x0001,0x0002,
0xfff7,0x0011,0xfff6,0x0012,0xffeb,0x0013,0xffd9,0xffe1,
0xffe9,0xffe9,0xfff0,0xfff1,0x0002,0xfff4,0x0007,0x0006,
0x0005,0xfff7,0x0001,0xfff6,0x0007,0xfff0,0x0004,0x0009,
0x0000,0x000a,0x0011,0x0016,0x0010,0x0002,0x000e,0x0009,
0x002c,0xfffa,0x001e,0x0008,0xfff7,0xfff6,0xfff5,0xfff2,
0xffe9,0x0005,0xfff8,0x0004,0xfff2,0x000c,0xffdb,0xfff2,
0xfff4,0xffe6,0xfffc,0xfff0,0x0008,0xfff0,0x0009,0xfff9,
0x0006,0xffed,0xfff4,0xffe7,0x0005,0xffe8,0x000f,0x000d,
0x0008,0x0024,0x0022,0x001f,0x0001,0x0012,0x0004,0x0012,
0xfffd,0xfffb,0xfff7,0xfff9,0x000f,0xffff,0x0005,0x000d,
0x0002,0x000c,0x0005,0x0002,0xffeb,0xffe9,0xfffe,0xfff0,
0x0000,0x0005,0xfffa,0x000d,0xffe9,0x0003,0xffe0,0x000a,
0xfff1,0x0008,0x002c,0x001c,0x0009,0x0025,0xfffe,0x000d,
0xfff7,0xfff1,0xfff4,0xffe5,0xfff9,0xfff4,0x0000,0xfff5,
0x0012,0xffef,0xffeb,0xffe7,0x000b,0xffed,0xfffa,0xfffd,
0xfff5,0x0000,0x0007,0xfff5,0xfff3,0xffe1,0xffff,0x0000,
0x0009,0x0001,0x0005,0x000c,0xffee,0x0000,0xffe1,0xfffe,
0xfff3,0xffff,0x001e,0x000e,0x0007,0x001d,0x0009,0x0012,
0xffff,0x000a,0x0004,0xffee,0xffea,0x0003,0xfff6,0xfffe,
0xfff3,0xfff3,0x0003,0xfffb,0x0007,0x0004,0x0009,0x0022,
0xfffb,0x0014,0xfffe,0x0003,0xfff0,0xfffd,0xffec,0xffef,
0xfff5,0xfff9,0xffef,0x0000,0xffde,0xfff3,0xffdf,0xfffe,
0xffe4,0x0008,0x0020,0x0018,0x0005,0x001d,0x0003,0xfff4,
0x0000,0xfff1,0x000b,0xfffd,0x0003,0x0002,0x0018,0x0001,
0x0008,0xffe7,0xfff8,0xffe9,0x0003,0xfff3,0xfffd,0x0011,
0xffec,0x0008,0x0000,0xfff6,0xfff8,0xfff5,0xffee,0x0000,
0xffff,0xfff6,0xfffb,0x0000,0xffe4,0xffef,0xffe0,0xfff1,
0xffe6,0xffff,0x0013,0x0009,0x0003,0x0015,0x000f,0xfff9,
0x0006,0x0009,0x001d,0x0005,0xfff6,0x0011,0x000f,0x0009,
0x0004,0xfffa,0xfffd,0x0005,0xffff,0xfffc,0xfff5,0x0010,
0xfffa,0x0017,0x0013,0x001d,0x0000,0xfffd,0x0006,0xffe2,
0x0003,0xffef,0xfff6,0xfffb,0xfff3,0xfffe,0xffef,0x0003,
0x0005,0x0003,0x0023,0x0015,0x0011,0x0011,0x0002,0x0023,
0xfffe,0xfff1,0x0003,0xffe4,0xfff3,0xffeb,0xfff3,0xfff3,
0x001a,0xffed,0xfff1,0xfff4,0xfffb,0xffea,0xffe8,0x0000,
0xffeb,0x000c,0x0015,0x000f,0x0008,0xfff5,0x0007,0xfff4,
0x000e,0xffec,0x0002,0xfffa,0xfff9,0xfffa,0xfff0,0xfff7,
0x0006,0xfffb,0x0015,0x0007,0x000f,0x000a,0x000d,0x0027,
0x0005,0x000a,0x0014,0xffed,0xffe4,0xfffb,0xffea,0xfffb,
0xfffb,0xfff1,0x0009,0x0007,0xfff7,0x0002,0xfff8,0x0025,
0xfff2,0x001f,0x000b,0x001d,0x0005,0x0010,0xfff5,0xffe2,
0xfff9,0xffe3,0xffeb,0xffee,0xffe9,0xffed,0xffee,0xfff7,
0xfff9,0x0003,0x0017,0x0011,0x000e,0x0009,0x0008,0x0009,
0x0006,0xfff1,0x001b,0xfffc,0xfffe,0xfffa,0x000c,0xffff,
0x0010,0xffe5,0xfffe,0xfff6,0xfff3,0xfff0,0xffec,0x0014,
0xffe3,0x0014,0x000e,0x0010,0x000d,0x0008,0xfff7,0xfff3,
0x0002,0xffdf,0xfff7,0xffed,0xffef,0xffe9,0xffef,0xffea,
0xfffa,0xfffa,0x0009,0x0002,0x000c,0x0002,0x0014,0x000d,
0x000d,0x000a,0x002d,0x0004,0xfff0,0x0008,0x0002,0x0007,
0xfff0,0x000e,0xfffe,0x0008,0x0014,0x0011,0x0009,0x0002,
0x000e,0x0010,0xfffa,0x0005,0xffe8,0xffe4,0xffeb,0xffec,
0xfff8,0x0009,0x0004,0x0019,0xffff,0x000b,0xffea,0x0018,
0xfff1,0xfff8,0x0015,0x0005,0x000b,0x000e,0xfffb,0x0012,
0xfff5,0x0007,0xffe5,0xffec,0xfff2,0xfff9,0x0001,0xfff7,
0x0006,0x0002,0xfff2,0xfff7,0x0010,0xffff,0xfffd,0xfff2,
0x0000,0x0005,0xfffd,0xfff8,0xfff0,0xffdc,0xffed,0xfffd,
0x0001,0x0006,0x0011,0x0018,0x0004,0x0007,0xffeb,0x000b,
0xfff2,0xffee,0x0007,0xfff7,0x0009,0x0007,0x0006,0x0016,
0xfffd,0x0021,0xfff6,0xfff5,0xffe4,0x0007,0xfff9,0x0000,
0xffe6,0x0006,0x000b,0x000a,0x000c,0x0017,0x000c,0x0017,
0x0005,0x0018,0xfff3,0x0005,0xffed,0xfff8,0xffda,0xffeb,
0xffec,0xfffe,0xfffa,0x000c,0xfff5,0xfffb,0xffe9,0x000b,
0xffe3,0xfff7,0x0009,0x0000,0x0007,0x0006,0x0001,0xfff9,
0xfffe,0x0007,0xfffd,0x0003,0xfffe,0x0006,0x001b,0x0003,
0xfffc,0xfffa,0x0000,0xfff9,0x0008,0x0004,0x0000,0x0006,
0xfff7,0x000d,0xfff5,0xfff9,0xfff5,0xfff1,0xffdb,0xfffc,
0xfff7,0xfffb,0x0005,0x000b,0xfffb,0xfff7,0xffea,0xffff,
0xffe5,0xffee,0xfffc,0xfff2,0x0005,0x0000,0x000c,0xfffd,
0x0004,0x0020,0x000e,0x000c,0xffef,0x0016,0x0011,0x000b,
0xfff8,0x000c,0x0003,0x0015,0x0003,0x000e,0xfff8,0x0005,
0x0004,0x001c,0x0007,0x0020,0xfffe,0xfff8,0xfff4,0xffde,
0xfffc,0xfff4,0x0001,0x0006,0x0009,0x0004,0xfff9,0x0011,
0x0004,0xfff3,0x000b,0xffff,0x0013,0xfffc,0x0000,0x0027,
0xfffc,0x0007,0xfff5,0xffeb,0xffec,0xfff0,0xfff6,0xfff5,
0x000d,0x0000,0xfff8,0x0003,0x0000,0xfffc,0xffeb,0xfff5,
0xfff7,0x0010,0x000a,0x0012,0x0005,0xfff0,0xfff6,0xfff0,
0x0005,0xfff1,0x000d,0x0005,0x000f,0x0001,0xfffa,0x0004,
0x0006,0xffe9,0xfffe,0xfff0,0x0011,0xfff4,0x000a,0x002c,
0x0003,0x0021,0x0006,0xfff4,0xffde,0xffff,0xffec,0xfffd,
0xffee,0x0004,0x0011,0x0017,0xfffc,0x0014,0xfffc,0x001a,
0xfffd,0x0024,0x0000,0x0020,0x0002,0x000c,0xffe3,0xffde,
0xfff0,0xffe8,0xfff6,0xfffa,0x0000,0xfff4,0xfff8,0x0004,
0xfff8,0xfff3,0x0000,0xfffa,0x0010,0xfff4,0x0005,0x000d,
0x0003,0x0007,0x000d,0x0003,0xfff8,0xfffe,0x000e,0x0000,
0x0003,0xfff9,0x0005,0x0005,0xfff8,0x0002,0xffef,0x0009,
0xffee,0x0018,0x0002,0x0013,0x000a,0x0004,0xffe4,0xffef,
0xfffb,0xffe4,0x0002,0xfff9,0x0004,0xfff1,0xfff9,0xfff8,
0xfffa,0xffe9,0xfff3,0xffeb,0x000e,0xffec,0x0011,0x0012,
0x000b,0x0021,0x001e,0x000b,0xffe9,0x000d,0x0005,0x0009,
0x003c,0x000a,0x0007,0xffff,0x0009,0xfff8,0x0006,0xfff3,
0x0002,0xfff1,0xffff,0xfff6,0xfff3,0xfff5,0x000f,0x0000,
0x0006,0x0009,0xffff,0x0000,0xfff3,0x0001,0xfff5,0xfffd,
0xfff3,0x0015,0x000d,0x001a,0xfff9,0x001f,0xfff6,0xfff9,
0xfff0,0xffdf,0xffe1,0xfff6,0x0016,0xfff8,0x0001,0xfffe,
0x0052,0xffff,0xfffc,0xffed,0x0006,0xffe5,0xfffa,0xffe3,
0xfff4,0xffe6,0x0001,0xffe8,0xfffb,0xffee,0x0011,0x0011,
0x0011,0x0006,0x000a,0x0000,0xfff9,0xfffe,0xfff7,0xfff0,
0xfff4,0x000b,0x0000,0x000b,0xfff7,0x0017,0x0000,0xfffd,
0xfff8,0xfff8,0xfff3,0xffff,0x0008,0x0007,0xfff9,0x0006,
0x0031,0x0002,0x0015,0x0000,0x0001,0xfffe,0x0009,0x0008,
0xfffa,0xfffa,0xfff8,0xfff6,0xfff8,0x0009,0xfffe,0x0000,
0xfffc,0xfffe,0xfff3,0xfff4,0xffe9,0xfff1,0xfff4,0xfff0,
0xffe6,0x0015,0x0002,0x0015,0xfff5,0x0017,0xfffc,0xffdf,
0xfff9,0xffdf,0xfffa,0x000d,0x0022,0x0005,0x001b,0x000a,
0x0047,0xfff6,0x0009,0xffef,0xffff,0xffec,0xfffd,0xfff8,
0xffeb,0xffee,0xfffa,0xffe8,0x0000,0x0001,0x0000,0x0010,
0x0006,0xfffb,0x0000,0xfff3,0xffef,0xffed,0xfff5,0xffe3,
0xffe7,0x000b,0xfff5,0x0006,0xfff3,0x000f,0x0007,0xffe3,
0x0000,0xfff8,0x000b,0x0016,0x0014,0x0015,0x0011,0x0012,
0x0043,0x0008,0x000e,0x000b,0xfff9,0xfff5,0xfff5,0xfff7,
0xfff9,0xfffd,0x000d,0x0010,0x0008,0x0009,0x0018,0xfff4,
0x000a,0xfff3,0xfffb,0xffef,0xfffe,0xfffc,0x0003,0xfff6,
0x0006,0x0011,0x0004,0x0013,0x0000,0x000b,0xfffa,0x000d,
0xfff7,0xffdf,0xfff2,0xfff6,0x0010,0xffef,0xfff6,0xfffc,
0x005a,0xfffd,0x0002,0xfffa,0xfff6,0xffe3,0xffe8,0xffe6,
0xffeb,0xfff1,0x000f,0x0002,0x0010,0x0001,0x0019,0x0004,
0x0015,0xfff0,0x0006,0xffee,0x0003,0xfff8,0x0005,0xffe8,
0x0008,0x0007,0xfff7,0x0004,0xffff,0x0003,0x0005,0x0012,
0xffff,0xfff9,0x0002,0xffff,0x0002,0xffff,0xffed,0x0003,
0x0039,0x0000,0x001b,0x000d,0xfff2,0xfffb,0xfff9,0x000b,
0xfff1,0x0004,0x0005,0x0010,0x000d,0x001d,0x0006,0xfff3,
0x0000,0xffe7,0xfff0,0xffe1,0xfff4,0xffea,0x0002,0xffe9,
0xfffa,0x0010,0xfff9,0x000e,0xfffe,0x0003,0x0000,0xfff4,
0x0000,0xffdf,0x0009,0x000d,0x001c,0xfffd,0x000e,0x0007,
0x004f,0xfff5,0x000f,0xfffc,0xffee,0xffe9,0xffec,0xfffb,
0xffe2,0xfff9,0x0007,0x0002,0x0015,0x0015,0x0008,0x0003,
0x000a,0xffe4,0xfffc,0xffe1,0xfffa,0xffe7,0x0003,0xffdb,
0xfffc,0x0007,0xffec,0x0000,0xfffc,0xfffc,0x000b,0xfff9,
0x0006,0xfff8,0x001b,0x0016,0x000e,0x000c,0x0005,0x0010,
0x002f,0x001e,0x000f,0x000e,0x000e,0x0009,0x0009,0xffe9,
0x000d,0xfff6,0xfff4,0xfff9,0xfff0,0xfff1,0xfffd,0xfffd,
0xffff,0x000e,0x0009,0x000c,0x0009,0x0008,0x0000,0x000a,
0xfff2,0x0004,0xfff7,0x0002,0xfffb,0x0008,0xfff3,0xfffd,
0xffee,0xfff6,0xffd3,0xfffd,0x0010,0xfffc,0x0004,0x0000,
0x0045,0x0011,0x0003,0xfffd,0x000a,0xfff8,0xfffd,0xffd8,
0xffff,0xffeb,0xfff6,0xffeb,0xfff8,0xffe9,0xffff,0x000d,
0x0008,0x000b,0x0015,0x000b,0x000f,0x0004,0x0000,0xfffe,
0xfff3,0xfffb,0xffe9,0xfff4,0xfff9,0x0000,0xffff,0x0000,
0xfff6,0x000e,0xffe4,0x0005,0x0001,0x000b,0xfffb,0x0007,
0x0024,0x0015,0x001c,0x0010,0x0006,0x0010,0x000c,0xfffe,
0x0004,0xfffe,0xffec,0xfff9,0xfff5,0x0004,0xffec,0xfffc,
0xfff4,0x0002,0xffff,0x0000,0x0000,0xfff8,0xfffe,0xfffe,
0xffe5,0x0004,0xffeb,0xfffe,0xfff7,0x0000,0xfffa,0xffe3,
0xfff7,0xfff6,0xffeb,0x0015,0x001c,0x000a,0x001d,0x000b,
0x003a,0x0009,0x0010,0xffff,0x0002,0xfffe,0x0000,0xffed,
0xfff6,0xfff3,0xffef,0xffeb,0xfffd,0xfffd,0xffed,0x000c,
0xfffe,0x0000,0x000a,0xffff,0x0005,0xfff4,0x0000,0xfff1,
0xffe6,0xfffb,0xffde,0xfff0,0xfff5,0xfff9,0x0004,0xffe7,
0xfffe,0x000e,0xfffd,0x001d,0x000d,0x0019,0x0014,0x0014,
0x0037,0x001c,0x0015,0x001b,0xfffe,0x0007,0xfff8,0xffec,
0x0004,0x0001,0x0001,0x0012,0x0005,0x0004,0x0005,0xfff0,
0x0002,0xfff8,0x0005,0xfffb,0x0013,0x0002,0x000e,0x0003,
0x0006,0x0000,0xffee,0xfffc,0x0002,0xfff5,0xfff8,0x0012,
0xfff5,0xfff6,0xffe3,0xfffd,0x000a,0xfff3,0xfff8,0xfffd,
0x004d,0x0010,0x0009,0x0009,0xfffa,0xfff5,0xffeb,0xffdb,
0xfff6,0xfff6,0x0004,0x0005,0x000d,0xfffd,0x0007,0x0000,
0x000d,0xfff5,0x0011,0xfffa,0x0019,0xffff,0x000f,0xfff7,
0x0007,0xfff7,0xffe0,0xffed,0x0000,0xffee,0x0002,0x0016,
0xfffd,0x000f,0xfff4,0x0005,0xfffc,0x0002,0xffef,0x0005,
0x002c,0x0014,0x0022,0x001d,0xfff6,0x000d,0xfffc,0x0000,
0xfffc,0x0009,0xfffb,0x0013,0x000a,0x0018,0xfff5,0xffef,
0xfff8,0xffec,0xfffb,0xffed,0x0009,0xfff2,0x000c,0xfff7,
0xfffa,0x0000,0xffe2,0xfff7,0x0000,0xffed,0xfffe,0xfff9,
0xfffe,0xfff6,0xfffb,0x0014,0x0015,0x0001,0x0011,0x0009,
0x0042,0x0008,0x0017,0x000b,0xfff2,0xfffb,0xffef,0xfff0,
0xffed,0xfffe,0xfffd,0x0005,0x0012,0x0011,0xfff6,0x0000,
0x0001,0xffe9,0x0006,0xffec,0x000f,0xffee,0x000e,0xffea,
0xfffb,0xfff6,0xffd4,0xffe9,0xfffe,0xffe6,0x0009,0xfffd,
0x0004,0x000e,0x000c,0x001d,0x0007,0x0010,0x0007,0x0012,
0x0012,0x0009,0xffef,0xfffc,0x000b,0x0003,0x0000,0x000b,
0x0007,0x0004,0x000a,0x0003,0x000a,0xffee,0x0018,0xfffd,
0x000e,0x0007,0x0004,0x000a,0xfff0,0x0001,0xffe5,0xfffc,
0xffe5,0x0011,0x000c,0x001e,0x0000,0x0023,0xfff7,0xfffd,
0xfff4,0xffdc,0xffdd,0xffe2,0xfffe,0xfff3,0x0002,0xfff5,
0x0028,0xfffe,0xffe3,0xffea,0x0007,0xfff2,0xfff4,0xfffb,
0xfff9,0xfff9,0x000c,0xfff7,0x0012,0xffe6,0x001a,0x000e,
0x0018,0x0004,0x0010,0x0009,0xfff6,0xfffe,0xffe6,0xffee,
0xffe6,0x0007,0xffff,0x000f,0xffff,0x001b,0x0002,0x0000,
0xfffc,0xfff5,0xffef,0xffeb,0xfff0,0x0001,0xfff9,0xfffd,
0x0008,0x0001,0xfffd,0xfffe,0x0003,0x000a,0x0003,0x0020,
0xffff,0x000c,0x0002,0x0004,0x000f,0x0001,0x0007,0xfffd,
0x0002,0xfffc,0xfffa,0xfffd,0xffe6,0xfff1,0xffe3,0xffef,
0xffd8,0x0011,0x0000,0x001a,0xfffe,0x001b,0xfffe,0xffe3,
0xfffc,0xffdc,0xfff6,0xfffa,0x0009,0x0000,0x001b,0x0000,
0x001e,0xfff5,0xfff1,0xffec,0x0000,0xfff8,0xfff7,0x000f,
0xfff1,0x0000,0x0005,0xfff7,0x0017,0xfffa,0x0008,0x000d,
0x000d,0xfff9,0x0005,0xfffd,0xffec,0xffed,0xffe5,0xffe1,
0xffd9,0x0007,0xfff3,0x000b,0xfffc,0x0013,0x0008,0xffe7,
0x0003,0xfff5,0x0007,0x0002,0xfffc,0x0010,0x0012,0x0009,
0x001a,0x0007,0xfff5,0x0008,0xfffb,0x0001,0xffef,0x000e,
0xffff,0x000f,0x0018,0x001e,0x0020,0x0001,0x0021,0xfff0,
0x0012,0xfff2,0x0000,0xfff8,0xfffa,0xfffc,0xfff4,0xfff4,
0xfffa,0x000d,0x0002,0x0017,0x0008,0x000f,0xfffc,0x0011,
0xfffb,0xffdc,0xffee,0xffe2,0xfff8,0xffea,0xfff6,0xfff2,
0x0030,0xfffc,0xffe9,0xfff7,0xfff7,0xffef,0xffe2,0xfffe,
0xfff0,0x0003,0x001a,0x0010,0x0028,0xfffa,0x0023,0x0001,
0x001c,0xffef,0x000c,0xfff7,0x0000,0xfff8,0xfff5,0xffe7,
0xfffb,0x0003,0xfff6,0x0008,0x0006,0x0007,0x0006,0x0016,
0x0001,0xfff5,0xffff,0xffeb,0xffea,0xfff9,0xffed,0xfffb,
0x000f,0x0000,0x0002,0x000a,0xfff3,0x0007,0xfff2,0x0023,
0xfff6,0x0017,0x0010,0x001f,0x0025,0x0015,0x0010,0xffef,
0x0006,0xffe6,0xfff6,0xffeb,0xfff0,0xffeb,0xfff3,0xffe7,
0xffed,0x000d,0xfff8,0x0013,0x0005,0x0007,0x0001,0xfff8,
0x0002,0xffdc,0x0005,0xfffa,0x0003,0xfff8,0x000f,0xffff,
0x0025,0xfff4,0xfff7,0xfff9,0xffef,0xfff5,0xffe6,0x0012,
0xffe7,0x000c,0x0013,0x0011,0x002d,0x000e,0x0011,0x0000,
0x0011,0xffe2,0x0001,0xffea,0xfff6,0xffe7,0xfff4,0xffda,
0xffee,0x0003,0xffea,0x0004,0x0003,0x0000,0x000d,0xfffd,
0x000a,0xfff5,0x0017,0x0002,0xfff6,0x0007,0x0005,0x0007,
0x0005,0x001d,0xfff7,0x000b,0x000f,0x0016,0x0003,0x0000,
0x0012,0x0008,0xffff,0x0006,0x0007,0xffe9,0x0006,0xfffa,
0x0005,0x000c,0x000f,0x0015,0x0005,0x0008,0xffef,0x0009,
0xffe4,0x0000,0xfff5,0x0006,0x0002,0x000c,0xfff5,0x0000,
0xfff2,0xfff3,0xffcf,0xffea,0xfff8,0xfff7,0x0004,0xfff7,
0x001b,0x0010,0xffeb,0xfffa,0x000c,0x0003,0xfff7,0xfff0,
0x0003,0xfffe,0x0001,0xfff9,0x000f,0xffe1,0x0007,0x000a,
0x0010,0x0009,0x001b,0x0015,0x000b,0x0005,0xfff0,0xfffd,
0xffe6,0xfff7,0xffe8,0xfff9,0x0000,0x0004,0x0000,0x0004,
0xfffa,0x000b,0xffe0,0xfff2,0xffe9,0x0006,0xfffb,0xffff,
0xfffc,0x0014,0x0003,0x000d,0x0008,0x001c,0x0006,0x0015,
0x000a,0x0010,0xfff8,0x0007,0x000c,0xfffd,0xfff5,0xfff9,
0xfffb,0x0000,0x0004,0x0008,0xfffc,0xfff8,0xffee,0xfffd,
0xffd7,0x0000,0xffea,0x0002,0x0000,0x0004,0xfffb,0xffe7,
0xfffa,0xfff2,0xffe7,0x0001,0x0002,0x0004,0x001d,0x0002,
0x0011,0x0008,0xfff8,0xfffc,0x0004,0x000a,0xfffa,0x0005,
0xfffc,0x0005,0xfffa,0xfffa,0x0014,0xfff6,0xfff7,0x0009,
0x0004,0xfffe,0x0010,0x0007,0x0001,0xfff4,0xffef,0xfff0,
0xffd9,0xfff7,0xffdc,0xfff4,0xfffe,0xfffd,0x0006,0xffeb,
0x0001,0x000b,0xfff9,0x000a,0xfff5,0x0014,0x0014,0x000b,
0x000d,0x001b,0xfffd,0x0018,0xffff,0x0013,0xfff2,0x0003,
0x0009,0x0014,0x000c,0x0021,0x001d,0xfffd,0x000f,0xffec,
0x0009,0xfff7,0x000b,0x0003,0x0010,0x0002,0xfffe,0x0002,
0xfff9,0xfffd,0xffec,0x0000,0x000a,0xfff9,0xfff9,0x0016,
0xfff9,0xfff3,0xffdf,0xffe9,0xfff2,0xffee,0xfff9,0xfff4,
0x0023,0x000f,0xfff1,0x0006,0xfffc,0x0001,0xffe5,0xfff4,
0xfffb,0x0008,0x000f,0x0013,0x0025,0xfff5,0x0010,0xfffe,
0x0014,0xfff4,0x0017,0x0002,0x0016,0xffff,0xffff,0xfff5,
0xfffb,0xfff3,0xffde,0xfff2,0x0008,0xfff2,0x0004,0x001a,
0x0000,0x000b,0xfff0,0xfff2,0xffe3,0xfffe,0xffef,0xfffd,
0x0003,0x0013,0x0009,0x001a,0xfff8,0x001a,0xfff6,0x0018,
0x0000,0x001c,0x0005,0x0021,0x0022,0x0011,0xfffe,0xffec,
0xffff,0xffea,0x0000,0xfff6,0x0006,0xfff2,0xfffd,0xfff6,
0xffec,0xfffc,0xffe0,0xfffc,0x0007,0xfff1,0x0000,0xfffd,
0x0000,0xfff3,0xfff7,0x0000,0xfffd,0xfffc,0x0011,0x0000,
0x0019,0x0007,0xfffe,0x0008,0xfff4,0x0007,0xffe9,0x0008,
0xfff3,0x0010,0x0007,0x0014,0x002a,0x0009,0x0000,0xfffd,
0x0009,0xffe7,0x000c,0xfff6,0x000c,0xffee,0xfffe,0xffe8,
0xffed,0xfff3,0xffd2,0xffed,0x0005,0xffea,0x000a,0x0000,
0x0008,0x000b,0x0008,0x0009,0xffef,0x000b,0x0007,0x0008,
0xffe7,0xfff9,0x0002,0xfff8,0x000c,0xfff9,0x0017,0xfff8,
0x000d,0xfff0,0xfff9,0xffec,0xffd6,0xfff7,0x0000,0x0003,
0xfff7,0x0019,0xfff4,0x000a,0xfff4,0x0012,0x0002,0x0018,
0x0013,0x000d,0x002e,0x0013,0xfffb,0x0016,0xfff6,0x0000,
0xfff8,0xfff5,0xfff8,0xfff7,0x0011,0xfff5,0xfff9,0xfff8,
0xfffd,0xffed,0xfff7,0xffe6,0x0008,0xffe6,0x000a,0xffe8,
0x0000,0xffe4,0xfffb,0xffdf,0xffde,0xffef,0x0002,0x0014,
0x0001,0x0016,0x0000,0x000a,0xfffa,0x000e,0x0003,0x000a,
0x0014,0x0004,0x0020,0x0004,0xfff9,0x000f,0x0000,0x0003,
0x0000,0x000d,0x0009,0x0000,0x0003,0x0004,0xffef,0x0000,
0xffdd,0xfff1,0x000f,0xfffa,0x0004,0xffff,0x001b,0x000c,
0x0005,0xfff8,0xfff1,0xffed,0xffdb,0x000b,0xfff0,0x0002,
0xffec,0x000c,0xffe9,0xfffe,0xffea,0x0001,0x0001,0x000b,
0x0005,0x000d,0x0022,0x000e,0xfff8,0x000e,0xfffc,0xffe6,
0x0000,0xfff5,0x0010,0x000e,0x001d,0x0002,0x0011,0x0003,
0xfff3,0xffe5,0x0003,0xffe8,0x0001,0xffed,0x000e,0xfffd,
0xfff7,0xffec,0xfff4,0xffdf,0xffe3,0x0003,0xfff1,0x0014,
0xfff7,0x0009,0xfff5,0xfffd,0xfff0,0xfffe,0x0002,0xfffe,
0x0007,0x0003,0x0014,0x0000,0xfff6,0x0007,0x0007,0xffea,
0x0007,0x000d,0x0021,0x0017,0x000e,0x0012,0x0007,0x000c,
0xffef,0xfff8,0x0008,0x0004,0xfffc,0xfff6,0x0006,0xfffb,
0x0004,0xfffb,0x0006,0x0006,0xffec,0x000a,0x0009,0xfff7,
0xfffc,0x0002,0xfff0,0xfff9,0xffff,0x000c,0x0011,0x0010,
0x0027,0x0009,0x0024,0x000c,0x0002,0x0003,0xfffa,0x0015,
0xffff,0xfff5,0x0007,0xfff6,0x000b,0xffec,0xffec,0xfff5,
0x0004,0xffec,0xfffd,0xfff3,0xfff8,0xffe4,0xfffa,0xffeb,
0xfff6,0xfff0,0x0008,0xfff9,0xfff4,0x0003,0x000b,0x0007,
0x0005,0x0000,0xfffc,0xfff8,0x0004,0x0008,0x0012,0x0003,
0x0029,0x0000,0x0016,0xfffe,0x0000,0xfffc,0x0005,0x0019,
0x0006,0x000e,0x0019,0xffff,0xfffe,0xfffc,0xffe3,0xfffe,
0xffe5,0xfff0,0x0015,0x0006,0xfff4,0xfffd,0x0009,0x0010,
0xfffd,0x0002,0xffff,0x0007,0xfff1,0x001f,0xfff9,0xfff6,
0xfff0,0xfff7,0xffe5,0xffeb,0xfff5,0xfffb,0x0010,0x0003,
0x001a,0x0009,0x0018,0x0007,0x0000,0xfffc,0x0000,0xfffc,
0x0006,0xfff5,0x0020,0x000e,0x0017,0xfffa,0x0005,0x0001,
0xfffb,0xffe3,0x0009,0xfff5,0xfff1,0xffea,0xfffd,0x0000,
0xffee,0xfff8,0x0001,0xfffa,0xfff9,0x0017,0xfffa,0x0006,
0xfffb,0xfff4,0xfff1,0xffeb,0xfffb,0xfff8,0x0011,0xfff7,
0x001c,0x0000,0x000b,0xfffa,0xfffe,0xfff4,0x000b,0x0000,
0x000e,0x000d,0x0031,0x0016,0x0008,0x0009,0xfffc,0x0009,
0xffdb,0x000c,0x0009,0x0007,0x0011,0x000b,0x001a,0xffee,
0x0019,0xfff4,0xffed,0xffef,0xffd3,0xfff2,0xffef,0x0000,
0xffef,0x001e,0xffff,0x0016,0x000a,0x0019,0x000c,0x0026,
0x0012,0xfffd,0x0016,0xfffc,0xfffd,0x0000,0xfff3,0x0003,
0xfff6,0x000b,0xffe9,0xfffe,0x000a,0xfff9,0xfffb,0xfff9,
0xfff1,0x0000,0xfffe,0xfff6,0x000d,0xfff9,0x000e,0xffdd,
0x000a,0xffe9,0xfff0,0xffe1,0xffdb,0xffeb,0xfff0,0x0011,
0xfffa,0x001a,0x000a,0x0015,0x0010,0x0015,0x000d,0x0019,
0x0013,0xfff3,0x0008,0xffed,0xfffb,0xfff9,0xffff,0x0008,
0xfffe,0x0024,0xfffb,0x0006,0xfffd,0x0008,0xfff1,0x0001,
0xffd0,0x0004,0x0017,0x0009,0x0009,0x0011,0x001e,0x0002,
0x0010,0xfffd,0xffe6,0xfff0,0xffd8,0x0006,0xffdd,0xffff,
0xffe4,0x0011,0xfff4,0x0009,0x0000,0x0008,0x000b,0x0019,
0x0005,0xfffd,0x000a,0xfff8,0xfffa,0xfff9,0xfffa,0xffea,
0xffff,0x000b,0x0001,0x0015,0x0016,0x0007,0x0013,0x0005,
0xffe6,0xfff9,0x000b,0xfff8,0x0005,0xffff,0x0011,0xfff2,
0x0001,0xfff1,0xffe8,0xffe2,0xffe0,0xffff,0xffdf,0x0010,
0xffee,0x000e,0x0000,0x0008,0x0006,0x0004,0x000c,0x000c,
0x0006,0xfff3,0xfffe,0xffe9,0xfff8,0xfff1,0x0004,0xffef,
0x0005,0x0024,0x0012,0x001e,0x0008,0x0016,0x000a,0x000e,
0xffe2,0x000b,0x000f,0x0014,0x0000,0x0008,0x0009,0xfff1,
0x000f,0x0000,0xfffb,0x0009,0xffe9,0x0006,0xfff8,0xfff3,
0xfff3,0x0007,0xfffb,0x0003,0x0014,0x0013,0x001b,0x001f,
0x0027,0xfff9,0x000d,0xfff5,0x0004,0xffed,0xfff8,0x0019,
0xfffd,0x000b,0xfff9,0xfffe,0x0004,0xfff0,0xffee,0xfff7,
0xfff8,0xffff,0x0003,0x0002,0xfffd,0xfff6,0xfffd,0xffe0,
0x0001,0xfff4,0xfffe,0xfffc,0xfff1,0xffff,0xfff9,0x0003,
0xfffe,0x0004,0x0006,0x0003,0x001a,0x000f,0x001d,0x0011,
0x0028,0xffef,0x0000,0xffe6,0x0002,0xffe5,0x0002,0x001d,
0x0004,0x0024,0x000a,0x0006,0xfff7,0x0000,0xffe5,0x0000,
0xffd8,0x0002,0x001d,0x0016,0xfff9,0x000e,0x000c,0x0005,
0x0007,0x0007,0xfff4,0x0009,0xffee,0x001a,0xffe6,0xfff2,
0xffe8,0xfffc,0xfff0,0xfff7,0x000a,0x0002,0x001a,0x0012,
0x001a,0xfff9,0x0001,0xfff1,0x0001,0xffe5,0xfffe,0x0000,
0x0004,0x000b,0x0011,0x0015,0x0010,0xffff,0x0007,0x0003,
0xffee,0xfff7,0x0011,0x0004,0xfff5,0xfffd,0x0000,0xfff5,
0xfff9,0xfffc,0xfff6,0xfffd,0xfff6,0x0012,0xffe8,0x0003,
0xfff2,0xfff9,0xfffc,0xfff6,0x0010,0xffff,0x001b,0x0004,
0x001b,0xffef,0xfff4,0xffe2,0x0000,0xffdd,0x0009,0x0003,
0x000c,0x0024,0x0023,0x001e,0x0002,0x000d,0xfffe,0x000b,
0xffbe,0xfff8,0xffe9,0xfff5,0x000e,0x0005,0x0011,0x0010,
0x0013,0x0002,0x0003,0xfffb,0xffee,0xffef,0x000a,0x0000,
0xffff,0x0017,0xfffa,0x0014,0xfff1,0x0012,0xfff2,0x0016,
0x0005,0x000a,0x002c,0x0017,0x0002,0x001a,0xfff7,0x0003,
0xfffc,0xfff2,0xfff4,0xffe3,0xfff9,0xfff0,0xfff9,0xffee,
0xffd4,0xffec,0xffde,0xffe3,0x000a,0xfff3,0x0004,0x0000,
0x0004,0xfff7,0x0005,0xffed,0xfff6,0xffe8,0x000b,0x0011,
0x0008,0x0014,0x0005,0x0013,0xfff7,0x000e,0xfff4,0x0009,
0x0006,0x0000,0x001e,0x0009,0x0000,0x0013,0x0002,0x0007,
0x0002,0x000a,0x0005,0xffec,0xffeb,0xffff,0xffef,0xfff7,
0xffb3,0xfff0,0xfff7,0xfff7,0x0006,0x000b,0x0015,0x0025,
0x000a,0x000a,0xfffc,0xfffb,0xfff3,0x0003,0xfff9,0x0000,
0xfff3,0x000b,0xffef,0x0006,0xffe7,0x0001,0xfff1,0x0009,
0xfff9,0x0009,0x0020,0x0013,0x0000,0x0012,0xfffe,0xffea,
0x0003,0xfff1,0x000c,0xfffb,0x0004,0xfffe,0x0011,0xfffb,
0xffc9,0xffe4,0xffeb,0xffe5,0x0002,0xfff9,0x0008,0x0014,
0xfffc,0xffff,0xffff,0xffee,0xfffb,0xfffc,0xfffb,0x0010,
0xfffe,0x0008,0xfffb,0x0005,0xffed,0xfffe,0xfff2,0xfffd,
0xfffa,0x0000,0x0012,0x0004,0xfffe,0x000b,0x0008,0xffee,
0x000b,0x000a,0x001d,0x0003,0xfff6,0x000d,0x0008,0x0003,
0xffc6,0xfff7,0xfff0,0x0001,0xfffe,0x0002,0x0000,0x0013,
0x000a,0x000d,0x0011,0x0015,0x0003,0x0003,0x0013,0xfff4,
0x0002,0x0000,0xfff6,0x0001,0xfffb,0x000c,0x0000,0x000f,
0x001a,0x0005,0x0022,0x0010,0x000b,0x0007,0xfffc,0x0019,
0x0002,0xfff2,0x0003,0xffe3,0xfff3,0xffe7,0xffec,0xffec,
0xffdc,0xffeb,0xffe4,0xfff0,0xfffa,0xfff0,0xfff4,0x0002,
0xfffc,0x0002,0x0014,0x0007,0x000b,0xfffc,0x0014,0x0004,
0x000c,0xfffe,0x0001,0x0000,0x0000,0x0008,0x0002,0x0002,
0x001b,0xfffc,0x0015,0x0002,0x0009,0x0000,0x0006,0x001d,
0x0009,0x000a,0x0015,0xffeb,0xffe4,0xfff6,0xffe3,0xfff5,
0xffbb,0xffef,0xfffd,0x0003,0xfff6,0x0008,0x0003,0x0028,
0x0001,0x0015,0x000a,0x0015,0x0008,0x0017,0x0001,0xfff3,
0xfff8,0xfff5,0xffeb,0xfff5,0xfff1,0xfffc,0x0000,0x0002,
0x000d,0x0005,0x0017,0x000c,0x0007,0x0000,0x0001,0x0000,
0x000a,0xfff2,0x001c,0xfffb,0xffff,0xfff5,0x0005,0xfff9,
0xffd1,0xffe2,0xfff1,0xfff2,0xfff2,0xfff7,0xfff7,0x0017,
0xfff3,0x000a,0x000c,0x0007,0x0010,0x000f,0x0003,0x0003,
0x0001,0xfff2,0xfff7,0xfff4,0xfff7,0xfff8,0x0000,0xfff6,
0x000e,0xfffc,0x0009,0xfffe,0x0005,0xfff8,0x000d,0x0003,
0x0012,0x000a,0x002d,0x0003,0xfff0,0x0004,0xfffc,0x0000,
0xffb1,0x000b,0xfff1,0x0004,0x0012,0x0017,0x0014,0x0005,
0x001e,0x0007,0xfff9,0xfffe,0xffeb,0xffeb,0xfff8,0xfffd,
0xfff6,0x001c,0x0004,0x001f,0x0006,0x0019,0xfffd,0x0025,
0x0004,0xfff9,0x0014,0x0000,0x0004,0x0004,0xfff5,0x0007,
0xfffa,0x0008,0xffe5,0xffea,0xfff2,0xfff4,0xfffb,0xfff0,
0xffc7,0x0000,0xffe5,0xfff3,0x000e,0x0005,0x0007,0xfff5,
0x000f,0xfffc,0xfffb,0xfff0,0xfff3,0xffe3,0xfffa,0x000d,
0x0000,0x0019,0x0010,0x001f,0x000c,0x0016,0xfffe,0x0017,
0x0006,0xfff0,0x0007,0xfff2,0x0002,0xfffd,0x0000,0x000c,
0x0000,0x0021,0xfff7,0xfff3,0xffe4,0x0003,0xfff2,0xfff9,
0xffa6,0x0003,0xfffe,0x0006,0x000a,0x001d,0x0018,0x001a,
0x0015,0x000f,0xfff1,0xfffe,0xfff0,0xffff,0xffe7,0xfffc,
0xffeb,0x0010,0xfffa,0x0012,0xfffd,0x0008,0xfffb,0x0018,
0xfff8,0xfff9,0x0009,0xfffc,0x0001,0xfffd,0xfffb,0xffee,
0x0001,0x0007,0xfffe,0x0001,0xfffe,0x0001,0x0013,0xfffd,
0xffbd,0xfff8,0xfff2,0xfff5,0x0007,0x000b,0x000b,0x0009,
0x0007,0x0003,0xfff3,0xfff0,0xfff8,0xfff7,0xffe8,0x000c,
0xfff6,0x000d,0x0005,0x0011,0x0002,0x0004,0xfffd,0x000a,
0xfffa,0xffef,0xfffc,0xffed,0x0000,0xfff5,0x0006,0xfff3,
0x0009,0x0021,0x000e,0x000a,0xfff0,0x0011,0x000a,0x0004,
0xffb9,0x000a,0xfff7,0x0011,0x0001,0x0014,0x0003,0x0008,
0x0015,0x0012,0x0006,0x0018,0x0000,0xffff,0x0000,0xfff0,
0xfffa,0x0005,0x0000,0x000d,0x0011,0x0013,0x000b,0x001d,
0x0019,0xfff5,0x000b,0xfffa,0x000d,0xfff1,0xfff9,0x001d,
0x0000,0x0008,0xfff5,0xffea,0xffec,0xffeb,0xffef,0xffee,
0xffcf,0xfffe,0xffeb,0x0000,0xffff,0x0002,0xfff7,0xfff8,
0x0006,0x0006,0x0008,0x000a,0x0008,0xfff7,0x0002,0x0000,
0x0004,0x0002,0x000d,0x000c,0x0017,0x000f,0x000c,0x0010,
0x001a,0xffeb,0xfffe,0xffeb,0x000b,0xffe9,0x0004,0x0021,
0x0007,0x0021,0x0006,0xfff3,0xffde,0xfffb,0xffe5,0xfff6,
0xffae,0x0001,0x0004,0x0013,0xfffa,0x001b,0x0006,0x001d,
0x000c,0x001a,0xffff,0x0018,0x0005,0x0012,0xffef,0xffef,
0xffef,0xfffa,0xfff6,0x0000,0x0007,0x0002,0x0009,0x0010,
0x000c,0xfff5,0x0000,0xfff5,0x0009,0xffe9,0x0000,0x0003,
0x0008,0x0008,0x000d,0x0001,0xfff8,0xfff9,0x0007,0xfffa,
0xffc4,0xfff6,0xfff9,0x0001,0xfff7,0x0008,0xfffa,0x000d,
0xfffe,0x000f,0x0001,0x000a,0x000d,0x000b,0xfff1,0x0000,
0xfffa,0xfff7,0x0001,0x0000,0x000d,0xffff,0x000b,0x0003,
0x000d,0xffeb,0xfff3,0xffe6,0x0007,0xffe1,0x000a,0x0007,
0x0010,0x0021,0x001f,0x000a,0xffea,0x0008,0xffff,0x0002,
0xfffd,0x0007,0xfffb,0xfffb,0x0008,0xfffe,0x0011,0xfff7,
0x0012,0xffe8,0xfffe,0xffed,0xfff6,0xfffc,0x001c,0x0011,
0x0005,0x001c,0xfffe,0x0007,0xfffc,0x000f,0x0007,0x0008,
0x0006,0x0017,0x000d,0x0015,0xfff2,0x0014,0xffef,0xffee,
0xfff5,0xffdf,0xffe2,0xfff5,0x0017,0xfff3,0xfffb,0xfff7,
0x0012,0xfffc,0xffef,0xffe9,0x0004,0xffec,0x0004,0xffe6,
0x0003,0xffdc,0x0000,0xffe0,0xfffe,0xfff4,0x001d,0x0022,
0x0010,0x0018,0x000a,0x0006,0x0000,0x000c,0x0008,0xfffc,
0x0008,0x000d,0x0000,0x0006,0xfff0,0x000c,0xfffb,0xfff3,
0xfffd,0xfff9,0xfff3,0xfffd,0x0008,0x0002,0xfff2,0x0000,
0xfff3,0x0000,0x0008,0xfffd,0x0000,0x0004,0x0015,0x000b,
0x0009,0xfff0,0xfff6,0xffee,0xfffb,0x0010,0x000a,0x0010,
0xfffb,0x000f,0xfff3,0xfffb,0xfff1,0xffff,0x0006,0xfffc,
0xfffa,0x0017,0x0002,0x0010,0xffef,0x000c,0xfff6,0xffd4,
0xfffd,0xffdf,0xfffa,0x000c,0x0022,0x0001,0x0014,0x0003,
0x0008,0xfff4,0xfffd,0xffeb,0xfffd,0xfff2,0x0008,0xfffb,
0xfffc,0xffe4,0xfff9,0xffe0,0x0002,0x0008,0x000c,0x0022,
0x0004,0x000c,0xffff,0xfffa,0xfff7,0xfffc,0x0007,0xffef,
0xfffc,0x000d,0xfff5,0x0001,0xffed,0x0004,0x0000,0xffd9,
0x0004,0xfff9,0x000b,0x0015,0x0014,0x0010,0x000a,0x000b,
0x0004,0x0006,0x0000,0x0007,0xfff8,0xfffc,0x0000,0xfffa,
0x0009,0xfff3,0x000b,0x0007,0x000b,0x000f,0x0025,0x0004,
0x0009,0x0005,0xfffb,0xfff5,0x0005,0x0009,0x0016,0x0001,
0x001b,0x0012,0x0004,0x000e,0xfffb,0x0000,0xfff4,0x0003,
0xfffc,0xffe0,0xfff2,0xfff4,0x0011,0xffea,0xffef,0xfff5,
0x001a,0xfffa,0xfff5,0xfff6,0xfff4,0xffe9,0xfff4,0xffe9,
0xfffb,0xffe8,0x000d,0xfffb,0x0013,0x0008,0x0026,0x0015,
0x0014,0x0002,0x0006,0xfff4,0x000b,0x0005,0x0017,0xfff5,
0x001d,0x0009,0xfff7,0x0000,0xfff9,0xfffa,0xffff,0x0007,
0x0002,0xfff9,0x0003,0xfffd,0x0002,0xfffa,0xffe5,0xfffd,
0xfffa,0xfffe,0x000e,0x0009,0xfff0,0x0001,0x0003,0x000e,
0x0000,0xfffb,0x0003,0x0008,0x0010,0x0024,0x0013,0x0003,
0xffff,0xfffa,0xffef,0xffe8,0xfffc,0xfff9,0x0015,0xfff5,
0x000e,0x0012,0xfff9,0x0009,0xfff7,0xfff9,0xfffa,0xffea,
0x0003,0xffdf,0x000a,0x000b,0x001c,0xfff9,0x0007,0x0000,
0x0010,0xfff2,0x0002,0xfff8,0xffec,0xffef,0xfff7,0xfffe,
0xfff2,0xfff0,0x0006,0xfffb,0x0018,0x001c,0x0015,0x0014,
0x0008,0xfff7,0xfffc,0xffe7,0x0001,0xfff5,0x0016,0xffe8,
0x000f,0x0008,0xffeb,0xfffb,0xfff5,0xfff2,0x0005,0xffee,
0x000b,0xfff9,0x001b,0x0014,0x000e,0x0007,0xffff,0x0009,
0xfff0,0x001b,0x0002,0x000a,0x000d,0x0010,0x0014,0xffec,
0x001d,0xffec,0xfff2,0xfff0,0xfff3,0xfff8,0x0009,0x000d,
0xfffe,0x0021,0x0009,0x0013,0x0011,0x0017,0x0011,0x0016,
0x0006,0x0006,0xfff7,0xfffe,0xfff4,0xfffe,0xffec,0xfff3,
0xfff3,0xfff6,0xffd3,0xfffc,0x0010,0xfff8,0xfffe,0xfff9,
0x0005,0x000f,0xfff7,0xfff9,0x0009,0xfffe,0x0008,0xffdb,
0x000e,0xffe1,0xfff5,0xffe3,0xfffb,0xfff0,0x000b,0x001e,
0x0007,0x001d,0x0015,0x0012,0x0017,0x0013,0x0012,0x0009,
0x0007,0xfffd,0xffe9,0xffef,0xfff2,0xfff7,0xfff8,0xfff7,
0xfffa,0x000f,0xffe5,0x0004,0x0002,0x0006,0xfff4,0x0001,
0xffe6,0x0013,0x000f,0x000c,0x0005,0x0016,0x0018,0x0000,
0x0015,0xfff4,0xffeb,0xfff1,0xfff8,0x000b,0xfff9,0x000c,
0xfff2,0x0014,0xfffe,0x0006,0x0007,0x0006,0x0010,0x0009,
0xfffa,0x0005,0xffeb,0xfff9,0xfff1,0xfff6,0xfff3,0xffd9,
0xfffb,0xfff6,0xffec,0x0013,0x001c,0x0005,0x0016,0x0005,
0xfffc,0x0006,0x0003,0xfffb,0x0001,0x0004,0x000b,0xfff0,
0x0006,0xffe9,0xffed,0xffe3,0x0000,0x0003,0xfffa,0x001e,
0xfffd,0x0011,0x000a,0x0005,0x000d,0x0002,0x0011,0xfffd,
0xfffb,0xfffd,0xffdd,0xffeb,0xffef,0xffef,0xfffe,0xffdd,
0x0002,0x000f,0xfffd,0x001c,0x000d,0x0015,0x000d,0x000d,
0xfff8,0x0019,0x0008,0x0017,0xfffd,0x000d,0x0003,0xffef,
0x0014,0xfff8,0x0000,0x000a,0x0008,0x000b,0x0012,0x0000,
0x0001,0x000a,0x0005,0x0000,0x001c,0x0011,0x0020,0x000f,
0x001a,0x0001,0xffed,0xfff7,0xfffd,0xffeb,0xfff1,0x0007,
0xfffa,0xfff7,0xffe3,0xfffb,0x000a,0xffef,0xfff1,0xfff7,
0x000d,0x000d,0xfffd,0x0005,0xfff9,0xfffc,0xfff7,0xffde,
0x0005,0xffec,0x0002,0xfffd,0x0010,0x0003,0x0014,0x0011,
0x000b,0x0007,0x0011,0x0000,0x0022,0x000d,0x0021,0x0002,
0x001c,0xfff8,0xffe0,0xffe8,0xfffb,0xffe3,0xfffd,0x000c,
0x0000,0x000f,0xfff5,0x0003,0xfffd,0xfffe,0xffe8,0xffff,
0xffee,0x0011,0x0015,0x0019,0xfff5,0x0013,0x0006,0x0003,
0x000b,0x0000,0xfff9,0x000b,0x000d,0x001f,0x0001,0x0000,
0xfff7,0xffff,0xfffb,0xfff4,0x0012,0x0000,0x001f,0x0002,
0x000d,0x0001,0xffe2,0xfff2,0xfff9,0xffe3,0xfff7,0xffee,
0x0001,0xfff6,0xfffc,0x0012,0x0016,0xfffd,0x000a,0x0002,
0x0003,0x0005,0x0009,0x0007,0xfff1,0x0001,0xfffb,0xfff3,
0xfffe,0xfff4,0xfffb,0xfffe,0x0015,0x0017,0x0002,0x0010,
0x0000,0xfffb,0x0006,0xfff3,0x0017,0xfffd,0x0020,0xfff6,
0x000f,0xfff8,0xffd4,0xffe4,0xfff7,0xffdb,0x0002,0xfff3,
0x0009,0x000f,0x000c,0x001b,0x0007,0x000c,0x0000,0x000b,
0xffd4,0x0006,0xffe2,0xfff8,0x0009,0x000a,0x000b,0x000e,
0x0017,0xfffb,0x0008,0xfffc,0x000e,0xfff4,0x0025,0x000e,
0x000c,0x001a,0x0004,0x0010,0xfff8,0x0010,0xfff7,0x0007,
0xfffa,0x0013,0x000c,0x0019,0xfffb,0x0018,0xfff1,0xfff3,
0xfff8,0xffdc,0xffde,0xffe1,0xffff,0xffee,0xfffc,0xffee,
0xffea,0xfffb,0xffd6,0xffe6,0x0006,0xfff8,0xffff,0xfffe,
0x0009,0xffef,0x000a,0xffee,0x0015,0xffed,0x0027,0x001f,
0x0017,0x0017,0x0010,0x000f,0xfffe,0x000c,0xfff9,0xfffa,
0xfffb,0x0009,0xffff,0x000a,0xfff9,0x0010,0xfffc,0xfff7,
0x0000,0xfff6,0xffef,0xffea,0xfff0,0xfffe,0xfff2,0xfff7,
0xffc9,0xffff,0xffef,0xfffa,0x0001,0x0010,0x000f,0x0023,
0x000f,0x0002,0x0000,0xfffc,0x0013,0x0008,0x0014,0x000d,
0x0001,0x000e,0xfff9,0x0003,0xffee,0x0000,0xfff6,0xfffb,
0xffed,0x0013,0x0000,0x0015,0xfff8,0x0010,0xfff7,0xffd9,
0x0000,0xffdc,0xfff6,0xfff9,0x0009,0xfffc,0x0014,0xfffb,
0xffdf,0xfff3,0xffe3,0xffe8,0xffff,0xffff,0x0002,0x0012,
0x0000,0xfff7,0x0003,0xffef,0x001b,0x0000,0x0015,0x001e,
0x000c,0x000b,0x0005,0x0002,0xfff4,0xfffc,0xfff7,0xffed,
0xffee,0x0009,0xfff3,0x0006,0xfff5,0x0008,0x0002,0xffdd,
0x0008,0xfff6,0x0007,0x0001,0xfffc,0x000b,0x000a,0x0002,
0xffdc,0x0005,0xffe8,0x0004,0xfff9,0x0007,0xfffa,0x0011,
0x000e,0x0005,0x0016,0x0016,0x0023,0x0008,0x002e,0x0001,
0x0011,0x0003,0x0000,0xfffe,0x0002,0x000a,0x0005,0x0000,
0x000e,0x000f,0x0002,0x0012,0x0002,0x0004,0xfff5,0x0007,
0xffff,0xffdc,0xffee,0xffe0,0xfff9,0xffe5,0xffef,0xffec,
0xfff2,0xfff9,0xffdc,0xfff3,0xfff6,0xfff6,0xffee,0x0000,
0x0000,0xfffb,0x0019,0x0008,0x002b,0x0000,0x0030,0x0012,
0x001b,0x0000,0x000c,0xfffd,0x0007,0x0006,0x0007,0xfff3,
0x000f,0x0005,0xfff5,0x0003,0x0000,0xfffe,0x0000,0x000c,
0x0006,0xfff6,0x0000,0xffe9,0xffea,0xfff5,0xffe6,0xfff4,
0xffd1,0xfffd,0xfff5,0x0006,0xfff1,0x000d,0xfffe,0x0026,
0x0006,0x000d,0x000f,0x0016,0x0028,0x001c,0x001c,0x0000,
0x0005,0xfff8,0xfff6,0xfff1,0xfff9,0xfff9,0x0004,0xfff3,
0x0001,0x000e,0xfff7,0x000e,0x0000,0xfffe,0xfffc,0xffee,
0x0007,0xffdc,0x0006,0xfff8,0x0003,0xfff3,0x0007,0xfff8,
0xffe7,0xfff1,0xffea,0xfff5,0xffee,0xfffc,0xfff1,0x0016,
0xfff8,0x0002,0x0011,0x0009,0x0030,0x0014,0x001e,0x0011,
0x0010,0xfff5,0x0001,0xfff0,0xfffe,0xfff6,0x0005,0xffe6,
0x0002,0x0004,0xffea,0x0000,0xfffe,0xfff6,0x0006,0xfff3,
0x000e,0xfff6,0x0017,0x0000,0xfff6,0x0002,0xffff,0x0000,
0xffc7,0x001a,0xffea,0x0007,0x000e,0x001c,0x000e,0x0003,
0x0023,0x0000,0xfffd,0xffff,0x000b,0xfff0,0x0012,0x000a,
0x0004,0x001f,0x000f,0x001c,0x000e,0x0017,0x0001,0x0015,
0xfff9,0x0002,0xfff5,0x0001,0xfffd,0x0001,0xffee,0xfff7,
0xfff6,0xfff3,0xffcf,0xffe8,0xfff8,0xfff2,0xfffe,0xfff0,
0xffdd,0x000e,0xffde,0xfff6,0x000a,0x000a,0x0001,0xfff4,
0x0014,0xfff4,0x0000,0xfff1,0x0012,0xffe8,0x0014,0x001b,
0x000e,0x001c,0x001b,0x001b,0x0014,0x0013,0x0002,0x0008,
0xfffb,0xfff9,0xffe7,0xfff3,0xfffb,0xfffb,0xfffa,0xfffb,
0xfffe,0x000c,0xffe1,0xfff1,0xffe9,0x0001,0xfff4,0xfff8,
0xffbc,0x0012,0xfff7,0x0009,0x0006,0x0023,0x0012,0x0019,
0x001a,0x0007,0xfff6,0xffff,0x0010,0x0003,0x0001,0x0009,
0xfffa,0x0013,0x0004,0x000f,0x0004,0x0006,0x0000,0x0008,
0xffec,0x0002,0xffe9,0xfffe,0xfff9,0xfffb,0xfff4,0xffdd,
0xffff,0xfff3,0xffe8,0x0000,0x0003,0x0000,0x0016,0xfffc,
0xffd2,0x0006,0xffeb,0xfff8,0x0002,0x0010,0x0005,0x0008,
0x000b,0xfffc,0xfff8,0xfff1,0x0018,0xfffc,0x0002,0x001a,
0x0003,0x0010,0x0010,0x000e,0x0009,0x0002,0x0001,0xfffc,
0xffed,0xfff9,0xffdc,0xffef,0xfff7,0xfff3,0x0000,0xffe1,
0x0005,0x000c,0xfff9,0x0008,0xfff5,0x000f,0x000d,0x0004,
0xffcf,0x0018,0xfff0,0x0014,0xfffe,0x001a,0xfffe,0x0007,
0x0019,0x000a,0x000b,0x0019,0x0020,0x0003,0x001b,0xfffe,
0x0008,0x0008,0x000b,0x0009,0x0018,0x0011,0x0010,0x000e,
0x000d,0xfffe,0xffec,0xfffb,0x0004,0xffef,0xfff2,0x000c,
0xfffd,0xfff3,0xffdf,0xffe7,0xfff2,0xffe9,0xfff1,0xffed,
0xffe5,0x000c,0xffe4,0x0002,0xfffa,0x0007,0xfff1,0xfff7,
0x000b,0xffff,0x000d,0x000b,0x0028,0xfffc,0x001d,0x000e,
0x0013,0x0005,0x0017,0x0008,0x001e,0x000d,0x0011,0x0000,
0x000e,0xfff4,0xffde,0xffec,0x0002,0xffe7,0xfffe,0x0010,
0x0004,0x000c,0xfff1,0xfff0,0xffe3,0xfff9,0xffe8,0xfff6,
0xffc4,0x0010,0xfffd,0x0016,0xfff6,0x0020,0x0000,0x001c,
0x0011,0x0012,0x0003,0x0019,0x0025,0x0017,0x000a,0xfffd,
0xfffe,0xfffd,0x0000,0xfffd,0x000e,0x0000,0x000e,0x0001,
0x0000,0xfffe,0xffe0,0xfff7,0x0001,0xffe7,0xfff9,0xfff3,
0x0005,0xfff3,0xfff8,0xffff,0xfffe,0xfff8,0x000a,0xfffa,
0xffda,0x0004,0xfff1,0x0004,0xfff2,0x000d,0xfff4,0x000b,
0x0002,0x0006,0x0006,0x000b,0x002d,0x0010,0x000b,0x000d,
0x0007,0xfffa,0x000c,0xfffc,0x0014,0xfffd,0x0010,0xfff4,
0x0001,0xfff4,0xffd2,0xffe8,0x0000,0xffdf,0x0003,0xfff7,
0x000c,0x000c,0x0008,0x0007,0xffef,0x0006,0x0000,0x0002};

const signed short etable2[5120]={
0x0049,0xffe0,0xffc4,0xfff1,0xffe6,0x003b,0x0002,0xffdf,
0x001e,0xfff6,0xfffd,0xffef,0x0008,0x001e,0xffff,0xffe6,
0xfffc,0xffea,0x000a,0x0010,0xffdc,0xfffb,0xfff5,0x0038,
0x0025,0x0006,0xfff6,0xfffb,0xfff3,0xfffd,0x0006,0xfffb,
0x000b,0x0004,0xffed,0xfffb,0xfff0,0x0029,0x0018,0x000d,
0x0004,0xfff5,0xffdb,0x0017,0xfffb,0x002e,0xfffe,0xffe3,
0xfffb,0xffd9,0xffeb,0xfff7,0x0000,0x0031,0x000c,0xfff7,
0xfff0,0xffe6,0x0016,0x000f,0xffd3,0xffec,0xfffb,0x0028,
0x0016,0x0011,0xffe6,0x001f,0xfff2,0x0002,0xfff2,0x000a,
0x001e,0x0014,0xffe5,0xfff7,0xffd9,0x0027,0x0012,0x0005,
0x0022,0xffe7,0xffd0,0xffe4,0xfff5,0x0022,0xfffe,0xffd7,
0x0009,0xfff9,0xffef,0x0015,0x0014,0x0018,0xffef,0xffdf,
0x0000,0xffe8,0x000a,0x002a,0x0003,0xfffb,0x000a,0x002a,
0x000b,0x0008,0xfffd,0x0003,0x0010,0x0009,0x0016,0xfffe,
0x0000,0xffdf,0xfff6,0x0012,0x0007,0x003a,0x000a,0x001c,
0xffde,0xfffc,0xffe7,0x000a,0x0009,0x0015,0xfff9,0xffdc,
0xffe6,0xffdc,0xffdd,0x001c,0x000c,0x002a,0xfffd,0xfff0,
0xfff4,0xffe4,0x0015,0x002a,0xfffb,0xffeb,0x0010,0x001a,
0xfffc,0x0013,0xffed,0x0027,0x000f,0x000f,0x0001,0x000d,
0x0013,0xffef,0xffef,0x000e,0xfff1,0x0037,0x0004,0x0013,
0x001c,0xffec,0xffcd,0xfff2,0xfffa,0x0007,0x0000,0xffe6,
0x001b,0xfffc,0x0012,0xffd8,0xfffa,0x0010,0xffff,0xfff1,
0x0000,0xffc9,0xfffb,0xfff0,0xffed,0x000e,0xfffd,0x0031,
0x000e,0x0001,0xffea,0xffe2,0xfff4,0x0000,0x0018,0x000f,
0x0009,0xffef,0xffd3,0xffe3,0x0004,0x001c,0x0033,0x0023,
0xffd8,0x0000,0xffe4,0x0018,0x000e,0xfffb,0xfffc,0xffeb,
0xfff9,0xffdf,0x0000,0xffe0,0xfff1,0x0023,0x000c,0x0001,
0xfff5,0xffc6,0x0005,0xfff0,0xffe4,0x0000,0x0001,0x0021,
0x0000,0x000b,0xffd9,0x0005,0xfff2,0x0006,0x0003,0x001f,
0x001c,0xffff,0xffcb,0xffdf,0xffed,0x0019,0x002e,0x001a,
0xfff5,0xfff2,0xffd9,0xffe5,0x0009,0xffef,0xfffc,0xffdf,
0x0006,0x0000,0x0004,0xffff,0x0005,0x000a,0xffef,0xffea,
0x0005,0xffc7,0xfffb,0x0009,0x0014,0x000d,0x0012,0x0023,
0xfff5,0x0003,0xfff0,0xffea,0x0011,0x000d,0x0028,0x0013,
0xffff,0xffc9,0xffdd,0xfffb,0x001b,0x002c,0x0025,0x0031,
0xffb0,0x0006,0xfff0,0x000b,0x001e,0xffe2,0xfff7,0xffe4,
0xffe4,0xffe3,0xfff3,0x0006,0xfffe,0x001c,0xfffd,0xfffb,
0xfff9,0xffc4,0x0005,0x0009,0x000b,0xffff,0x0018,0x0013,
0xffe5,0x000d,0xffe0,0x000d,0x000f,0x0013,0x0013,0x0023,
0x0011,0xffd9,0xffd5,0xfff7,0x0004,0x002a,0x0020,0x0029,
0x004e,0xffeb,0xffd5,0x0004,0xffda,0x0011,0x0011,0xfffb,
0x0037,0x0018,0xfff1,0xffdc,0x000e,0x0004,0x0018,0xffe8,
0x000c,0x0005,0x0011,0x001f,0xffca,0xfffb,0xfffe,0x001b,
0x002b,0xfff4,0x0002,0x0009,0xfff7,0xfff1,0x0016,0xfffd,
0x001c,0x0015,0xffec,0x0003,0x0014,0x001c,0x0009,0xfffb,
0x0009,0xffff,0xffec,0x002b,0xffef,0x0003,0x000c,0x0000,
0x0014,0xfffc,0xffdf,0xffe3,0x0006,0x0016,0x0026,0xfff9,
0x0000,0x0001,0x001d,0x001e,0xffc1,0xffeb,0x0003,0x000b,
0x001b,0xffff,0xfff2,0x002d,0xfff6,0xfff7,0x0001,0x000c,
0x002f,0x0025,0xffe4,0x0000,0xfffe,0x001a,0x0004,0xfff3,
0x0027,0xfff2,0xffe2,0xfff8,0xffea,0xfff8,0x000c,0xfff4,
0x0022,0x001b,0xffe3,0x0002,0x001a,0xfffe,0x0008,0xffe1,
0x0010,0x0003,0x0011,0x0039,0xfff2,0xfffa,0x0013,0x000d,
0x0010,0xfff6,0x0008,0x0011,0x0014,0xfffe,0x0026,0x0000,
0x0011,0xfff0,0xfff5,0x001b,0x002c,0x002d,0xfffc,0x0008,
0xffe3,0x0005,0xfff9,0x001e,0xffff,0xffeb,0x0007,0xfff9,
0x0000,0x0000,0xffd1,0x0009,0x0012,0x000f,0x0016,0xfff2,
0x0004,0x0000,0x001c,0x0039,0xffe9,0xffeb,0x0019,0xfffe,
0x0001,0x0000,0xfff9,0x0035,0x0013,0x0003,0x0011,0x000f,
0x0024,0x0000,0xffed,0x0018,0x0015,0x002b,0xfff7,0x0000,
0x0021,0xfff6,0xffde,0x0005,0xffef,0xffdd,0x000f,0x0001,
0x0035,0x001e,0x0006,0xffc5,0x0000,0xfff6,0x0018,0xfff3,
0x0011,0xffe5,0x0001,0xffff,0xffdb,0x000d,0x0004,0x0014,
0x0014,0xffee,0xfff6,0xfff0,0xfff8,0xfff5,0x0027,0x0012,
0x001a,0x0000,0xffd2,0xffec,0x0029,0x000f,0x0025,0x000f,
0xffdd,0x000a,0xfff5,0x002c,0x0003,0xffd0,0x000a,0x0006,
0x0011,0x0002,0xfff5,0xffcd,0xfff8,0x0008,0x0026,0x0003,
0x0004,0xffe1,0x000c,0xfffe,0xffd2,0xffff,0x000a,0x0004,
0x0005,0xfff9,0xffe6,0x0013,0xfff6,0xfffb,0x0012,0x0022,
0x002d,0x000f,0xffca,0xffe8,0x0012,0x000d,0x001f,0x0007,
0xfffb,0xfffd,0xffeb,0xfff9,0xfffe,0xffc4,0x000a,0xfffb,
0x0020,0x0022,0xfff9,0xffec,0x000b,0xfff0,0x0008,0xffec,
0x0015,0xffe3,0x0001,0x0018,0x0002,0x000d,0x001b,0x0006,
0xfffb,0xfff1,0xfffd,0xfff8,0x0015,0x0001,0x0037,0x0015,
0x000f,0xffda,0xffdb,0x0003,0x0041,0x0020,0x0017,0x001e,
0xffb6,0x0011,0x0000,0x001f,0x0012,0xffb7,0x0005,0x0000,
0xfffd,0x0005,0xffe7,0xfff4,0x0003,0x0001,0x0016,0xfffd,
0x0009,0xffdf,0x000c,0x0018,0xfffa,0xfffe,0x0021,0xfff7,
0xffeb,0xfffb,0xffec,0x001b,0x0013,0x0007,0x0022,0x0025,
0x0022,0xffea,0xffd4,0x0000,0x0029,0x001d,0x0011,0x0015,
0x004c,0xffdd,0xffe1,0xffe4,0xffcf,0x002b,0xffd8,0x0000,
0x001d,0xfff2,0x0008,0x0005,0x000a,0x0012,0xffe6,0xffd2,
0x0000,0x0007,0x0006,0x0003,0xffe7,0xfff9,0xfffe,0x0028,
0x001c,0x000e,0x0012,0xfffd,0xffe5,0xffe4,0xfff8,0xffd3,
0xfff3,0x0022,0xfff3,0xffe5,0xfff1,0x001f,0x000c,0x0003,
0x0007,0xfff1,0xfff7,0x0009,0xffe4,0x001d,0xffd3,0x0005,
0xfffa,0xffd5,0xfff7,0x000c,0x0002,0x0024,0xfff4,0xffe2,
0xfff5,0x0003,0x0011,0x0003,0xffde,0xffea,0x0003,0x0018,
0x000c,0x0018,0x0002,0x0020,0xffe4,0xffea,0xffe3,0xffe3,
0x0005,0x0032,0xffeb,0xffe1,0xffda,0x001d,0x0007,0xfffb,
0x0024,0xffe3,0xffed,0xffd7,0xffde,0x0012,0xffd3,0xfffa,
0x0008,0xfff6,0xfffb,0x002b,0x0017,0x000b,0xffd6,0xffcb,
0x0005,0x0005,0x0006,0x001e,0x000e,0xfff8,0x0014,0x001a,
0x0001,0x0010,0x0019,0x0004,0x0003,0xfff1,0x0007,0xffd7,
0xffe9,0xfffd,0xfffc,0xfffd,0x0008,0x0030,0xffff,0x0011,
0xffe0,0xfff8,0x0003,0xfffe,0xfff3,0x0004,0xffce,0xffff,
0xffe5,0xffd9,0xffe9,0x0033,0x000f,0x001e,0xffe5,0xffdb,
0xfff9,0x0001,0x0011,0x001d,0x0005,0xffe9,0x0019,0x000a,
0xfff2,0x001a,0x0008,0x0029,0x0001,0xfff7,0xfff3,0xffe6,
0xfffb,0x000c,0xfff4,0xfff9,0xfff2,0x002d,0xfffa,0x0009,
0x001f,0xffe8,0xffe9,0xffe5,0xffe3,0xfff7,0xffd5,0x0008,
0x001a,0xfff9,0x001e,0xffef,0xfffc,0x0003,0xffe6,0xffdd,
0x0005,0xffe8,0xfff6,0xffe4,0xfff7,0x000c,0x0005,0x0021,
0x0005,0x0008,0x0005,0xffe3,0xffe6,0xffe8,0x0009,0xffe9,
0xfff2,0x000c,0xffd9,0xffcc,0x0005,0x0012,0x0027,0x0018,
0xffdb,0xfffd,0x0000,0x000a,0xfff9,0xffea,0xffd0,0x000c,
0xfff8,0xffdc,0x000c,0xfff7,0xfff4,0x0016,0xfff4,0xffed,
0xfffa,0xffe4,0x0000,0xffe3,0xffee,0xfffd,0x000b,0x0011,
0xfff6,0x0012,0xfff6,0x0007,0xffe5,0xffee,0xfff5,0xfff9,
0x0003,0x001c,0xffd1,0xffc9,0xffee,0x000f,0x0022,0x0010,
0xfff8,0xffef,0xfff6,0xffd8,0xfff3,0xffde,0xffd1,0x0000,
0x0005,0xfffc,0x0010,0x0015,0x0008,0xfffe,0xffd6,0xffd5,
0x000a,0xffe6,0xfff6,0xfffe,0x001f,0x000b,0x001b,0x0013,
0xffeb,0x000a,0x000c,0xffec,0x0003,0xfff5,0x0019,0xffec,
0xffe7,0xffe7,0xffe3,0xffe4,0x001c,0x0022,0x0019,0x0026,
0xffb3,0x0002,0x000b,0xffff,0x0007,0xffd1,0xffcc,0x0005,
0xffe3,0xffdf,0xffff,0x001c,0x0000,0x000f,0xffe4,0xffe6,
0xfffe,0xffe2,0x0000,0xfffe,0x0016,0xfffc,0x0021,0x0003,
0xffdc,0x0015,0xfffd,0x000f,0x0002,0xfffb,0x0004,0xfffc,
0xfffa,0xfff7,0xffdb,0xffe1,0x0005,0x0020,0x0014,0x001e,
0x0051,0xffe7,0xfff2,0xfff8,0xffc3,0x0000,0xffe7,0x001c,
0x0036,0x0014,0xfffd,0xfff2,0x0011,0xfff8,0x0000,0xffd4,
0x0010,0x0023,0x000d,0x0012,0xffd5,0xfff9,0x0006,0x000b,
0x0021,0xfffc,0x001e,0x000b,0xffea,0xffd8,0x0006,0xffd5,
0x0003,0x0032,0xfff2,0xffee,0x0016,0x0012,0xffff,0xfff0,
0x000c,0xfffc,0x0008,0x001d,0xffd9,0xfff4,0xffe2,0x0021,
0x0013,0xfff8,0xffeb,0xfffa,0x0008,0x0009,0x000d,0xffe4,
0x0004,0x001f,0x0018,0x0012,0xffcc,0xffe9,0x000c,0xfffc,
0x0012,0x0005,0x000e,0x002f,0xffe8,0xffde,0xfff2,0xffe5,
0x0016,0x0042,0xffea,0xffea,0xffff,0x0010,0xfffa,0xffe8,
0x0029,0xffee,0xfffe,0xffeb,0xffd3,0xffe8,0xffe2,0x0015,
0x0021,0x0018,0xffef,0x0018,0x001d,0xfff1,0xfff0,0xffcd,
0x0015,0x0021,0x000d,0x002d,0xfffd,0xfff8,0x001c,0xfffe,
0x0007,0xfffe,0x0025,0x0013,0x0007,0xffe5,0x0016,0xffd9,
0xfff9,0x000c,0xfffb,0x0005,0x002d,0x0023,0xfff1,0xffff,
0xffe5,0x0001,0x0014,0x0011,0xffe8,0xffda,0xffdd,0x001a,
0xffff,0xfffc,0xffdd,0x0020,0x0015,0x0003,0xfffe,0xffdd,
0x0008,0x001d,0x0018,0x002c,0xfff4,0xffe8,0x0022,0xffee,
0xfff8,0x0007,0x0015,0x0037,0x0005,0xffeb,0x0002,0xffe9,
0x000b,0x001c,0xfff3,0x0001,0x0016,0x0021,0xffeb,0xfff6,
0x0024,0xfff3,0xfffb,0xfff9,0xffd8,0xffcd,0xffe4,0x0024,
0x0034,0x001b,0x0012,0xffdc,0x0002,0xffea,0x0000,0xffdf,
0x0015,0x0002,0xfffd,0xfff3,0xffe6,0x000b,0x000e,0x0004,
0x000a,0xfff6,0x0012,0xfff2,0xffea,0xffdc,0x0018,0xffeb,
0x0001,0x001c,0xffd8,0xffd6,0x002a,0x0005,0x0019,0x0005,
0xffe0,0x0006,0x0011,0x001f,0xffed,0xffbf,0xffdf,0x0029,
0x0010,0xffff,0x0000,0xffe3,0xfffa,0xfffc,0x000d,0xffef,
0x0009,0xffff,0x0008,0xfff2,0xffdd,0xfffd,0x0013,0xfff5,
0xfffc,0x0000,0x0001,0x0015,0xffe9,0xffe2,0x0003,0xfffb,
0x0014,0x002c,0xffd0,0xffd2,0x0013,0x0003,0x0014,0xfffd,
0xfffd,0xfff9,0x0006,0xffec,0xffe7,0xffb3,0xffe0,0x001d,
0x001f,0x001e,0x0004,0x0002,0x000e,0xffe3,0xfff0,0xffd8,
0x001a,0x0000,0xfffd,0x000c,0x000d,0x000a,0x0024,0xfff7,
0xfff1,0xfff8,0x0018,0xfffa,0x0007,0xffea,0x0028,0xffef,
0xfff8,0xfff7,0xffe1,0xffee,0x0042,0x0016,0x000b,0x0013,
0xffb8,0x000d,0x001d,0x0012,0xfffc,0xffa6,0xffdb,0x0022,
0xfffc,0x0001,0xfff3,0x0009,0x0006,0xfff5,0xfffe,0xffe8,
0x000d,0xfffd,0x0007,0x000b,0x0004,0xfffc,0x002a,0xffe7,
0xffe1,0x0001,0x0008,0x001d,0x0006,0xffef,0x0013,0xfffe,
0x000a,0x0006,0xffda,0xffea,0x002a,0x0013,0x0006,0x000b,
0x0074,0xffec,0xffbc,0xffe2,0xffe4,0x0053,0x001c,0xffee,
0x0020,0xffea,0xfff3,0xffeb,0x0005,0x001c,0x0005,0xfff9,
0xffe8,0xfff8,0xffea,0x0011,0xffe9,0x001e,0xffe7,0x002d,
0x000f,0xfff7,0xfff5,0xffee,0x0016,0xfff6,0x0004,0xfffe,
0x0013,0xfff4,0x0017,0x0003,0xffd5,0x0002,0x000c,0xfffc,
0x002f,0x0000,0xffd3,0x0007,0xfff9,0x0045,0x0017,0xfff3,
0xfffe,0xffcd,0xffe0,0xfff2,0xfffd,0x002f,0x0013,0x0008,
0xffdb,0xfff5,0xfff6,0x0010,0xffe0,0x000f,0xffed,0x001d,
0x0000,0x0001,0xffe4,0x0012,0x0014,0xfffc,0xfff0,0x000d,
0x0026,0x0003,0x000f,0x0000,0xffbe,0x0000,0x0007,0xfff3,
0x004d,0xfff3,0xffc8,0xffd5,0xfff3,0x0039,0x0017,0xffe6,
0x000b,0xffed,0xffe5,0x0010,0x0011,0x0016,0xfff6,0xfff1,
0xffed,0xfff6,0xffea,0x002b,0x0010,0x001e,0xfffe,0x001f,
0xfff5,0xfffa,0xfffb,0xfff7,0x0034,0x0002,0x0014,0x0000,
0x0008,0xffce,0x0021,0x001b,0xffed,0x0013,0xffff,0x0009,
0x0008,0x0006,0xffdf,0xfffc,0x0007,0x002c,0x0012,0xffeb,
0xffe9,0xffd0,0xffd2,0x0018,0x0009,0x0028,0x0003,0x0001,
0xffe0,0xfff3,0xfff5,0x002b,0x0007,0x000e,0x0003,0x000f,
0xffe6,0x0003,0xffeb,0x001a,0x0032,0x0008,0x0000,0x0010,
0x001b,0xffde,0x0019,0x0017,0xffd5,0x0011,0xfffa,0x0001,
0x0047,0xfff7,0xffc5,0xffe3,0xfff8,0x001e,0x001a,0xfff5,
0x001e,0xfff0,0x0008,0xffd4,0xfff7,0x000e,0x0005,0x0002,
0xffed,0xffd8,0xffda,0xfff1,0xfff9,0x0032,0xffef,0x0026,
0xfff9,0xfff2,0xffe8,0xffd5,0x0016,0xfffa,0x0016,0x0013,
0x0011,0xffde,0xfffe,0xffec,0xffe9,0xfff6,0x0027,0x0010,
0x0002,0x000b,0xffdc,0x0009,0x000d,0x0011,0x0015,0xfffa,
0xfffb,0xffd3,0xfff6,0xffdc,0xffee,0x0021,0x0013,0x0013,
0xffe1,0xffd4,0xffe5,0xfff1,0xfff0,0x0022,0xfff5,0x0016,
0xffea,0xfffc,0xffd8,0xfff9,0x0015,0x0000,0x0001,0x0023,
0x0024,0xffee,0xfff6,0xffe8,0xffd2,0xfff4,0x0022,0x0008,
0x0020,0xfffe,0xffd1,0xffd6,0x0007,0x0005,0x0015,0xffee,
0x0009,0xfff4,0xfffb,0xfffb,0x0002,0x0008,0xfff6,0xfffc,
0xfff2,0xffd6,0xffda,0x000a,0x0021,0x0031,0x0005,0x0018,
0xffdf,0xfff4,0xffef,0xffdd,0x0034,0x0006,0x0026,0x0016,
0x0007,0xffb8,0x0007,0x0003,0x0000,0x0006,0x0019,0x001e,
0xffdc,0x0012,0xffe8,0xfffd,0x001c,0xfff9,0x0010,0xfff3,
0xffe6,0xffd7,0xffe8,0x0001,0xfffb,0x001a,0x0003,0x000c,
0xffe5,0xffd2,0xffe5,0x000a,0x0018,0x0022,0x000a,0x0008,
0xffcf,0xfffe,0xffde,0x0000,0x0033,0x000c,0x0011,0x0026,
0x0019,0xffc8,0x0000,0x0000,0xffea,0x0003,0x0014,0x0016,
0x0079,0xfff7,0xffce,0xfff6,0xffd8,0x0028,0x002b,0x0009,
0x003a,0x000c,0xffe7,0xffd7,0x000b,0x0002,0x001f,0xfffb,
0xfff8,0x0013,0xfff1,0x0020,0xffd7,0x001e,0xfff0,0x0010,
0x0014,0xffe4,0x0000,0xfffd,0x001a,0xffea,0x0013,0x0000,
0x0024,0x0004,0x0016,0x000c,0xfffa,0xfff7,0xffff,0xffe8,
0x0034,0x000a,0xffe5,0x001b,0xffee,0x001a,0x0026,0x000e,
0x0017,0xfff0,0xffd4,0xffdf,0x0003,0x0014,0x002d,0x000a,
0xffec,0x000f,0xfffd,0x001f,0xffce,0x000e,0xfff6,0x0000,
0x0005,0xffef,0xfff1,0x0020,0x0018,0xfff0,0xffff,0x000f,
0x0037,0x0014,0x000e,0x0008,0xffe3,0xfff4,0xfff9,0xffe0,
0x0052,0xfffd,0xffda,0xffe9,0xffe8,0x000f,0x0026,0x0002,
0x0025,0x000f,0xffd9,0xfffe,0x0017,0xfffc,0x000f,0xfff4,
0xfffd,0x0011,0xfff1,0x003a,0xffff,0x001d,0x0006,0x0002,
0xfffb,0xffe6,0x0007,0x0004,0x0038,0xfff7,0x0023,0x0003,
0x0019,0xffdf,0x0020,0x0024,0x0011,0x0007,0xfff1,0xfff7,
0x000d,0x0011,0xfff1,0x000f,0xfffd,0x0001,0x0021,0x0007,
0x0001,0xfff4,0xffc6,0x0005,0x000f,0x000d,0x001d,0x0003,
0xfff0,0x000d,0xfffc,0x0039,0xfff6,0x000d,0x000b,0xfff3,
0xffeb,0xfff1,0xfff7,0x0028,0x0037,0xfffd,0x000e,0x0013,
0x002c,0xffef,0x0018,0x0020,0xfffb,0x0004,0xffeb,0xffee,
0x004c,0x0001,0xffd7,0xfff7,0xffed,0xfff4,0x0029,0x0011,
0x0037,0x0012,0xfffd,0xffc1,0xfffd,0xfff4,0x001e,0x0005,
0xfffd,0xfff4,0xffe1,0x0000,0xffe8,0x0031,0xfff8,0x0009,
0xffff,0xffdf,0xfff4,0xffe3,0x001b,0xffee,0x0025,0x0015,
0x0022,0xffef,0xfffd,0xfff5,0x000e,0xffe9,0x0019,0xfffe,
0x0007,0x0016,0xffee,0x001d,0x0001,0xffe7,0x0024,0x0015,
0x0014,0xfff7,0xffea,0xffc8,0xfff5,0x0006,0x002d,0x0015,
0xfff1,0xfff0,0xffec,0xffff,0xffdf,0x0022,0xfffe,0xfffa,
0xffef,0xffe9,0xffe4,0x0006,0x0019,0xfff4,0x0010,0x0025,
0x0035,0xffff,0xfff5,0xfff1,0xfff8,0xffe7,0x0014,0xfff5,
0x0025,0x0008,0xffe3,0xffea,0xfffc,0xffdb,0x0024,0x0009,
0x0022,0x0016,0xffef,0xffe8,0x0008,0xffee,0x000f,0xfffe,
0x0001,0xfff2,0xffe1,0x0019,0x000f,0x0030,0x000d,0xfffc,
0xffe4,0xffe1,0xfffb,0xffeb,0x0039,0xfffc,0x0035,0x0018,
0x0017,0xffc9,0x0006,0x000c,0x0025,0xfffa,0x000b,0x000b,
0xffe1,0x001c,0xfffa,0x0010,0x0010,0xffce,0x001f,0x000e,
0x0000,0xfffa,0xffdc,0xffef,0x0000,0x0000,0x001d,0x000e,
0xfff5,0xffee,0xffec,0x0019,0x0006,0x0021,0x0013,0xffec,
0xffd5,0xffeb,0xffeb,0x000e,0x0037,0x0000,0x0020,0x0028,
0x002a,0xffd9,0xffff,0x0008,0x000e,0xfff8,0x0006,0x0003,
0x0077,0xffe8,0xffd9,0xffd4,0xffcd,0x0042,0xfff2,0x000f,
0x001f,0xffe6,0xffff,0x0000,0x0007,0x0010,0xffed,0xffe4,
0xffed,0x0016,0xffe6,0x0004,0xfff3,0x001c,0xfff0,0x001d,
0x0005,0xffff,0x0010,0xfff0,0x0008,0xffdd,0xfff6,0xffd6,
0xfffc,0x0011,0x001d,0xffed,0xffd6,0xfff9,0x0000,0xfff1,
0x0032,0xfffd,0xfff0,0xfffb,0xffe2,0x0035,0xffed,0x0014,
0xfffd,0xffc9,0xffed,0x0008,0x0000,0x0022,0xfffb,0xfff5,
0xffe0,0x0012,0xfff1,0x0004,0xffea,0x000d,0xfff6,0x000d,
0xfff7,0x0008,0x0000,0x0013,0x0007,0xffe3,0xffe1,0xffe6,
0x000d,0x0021,0x0015,0xffea,0xffbf,0xfff7,0xfffc,0xffe9,
0x004f,0xffef,0xffe5,0xffc8,0xffdc,0x0029,0xffed,0x0008,
0x000a,0xffea,0xfff1,0x0027,0x0014,0x0009,0xffdd,0xffdd,
0xfff1,0x0014,0xffe6,0x001f,0x001a,0x001b,0x0006,0x000f,
0xffec,0x0000,0x0017,0xfff8,0x0026,0xffea,0x0005,0xffda,
0xfff1,0xffec,0x0027,0x0004,0xffee,0x0009,0xfff3,0xffff,
0x000a,0x0003,0xfffc,0xffee,0xfff1,0x001b,0xffe8,0x000d,
0xffe8,0xffcd,0xffde,0x002f,0x000c,0x001c,0xffeb,0xffed,
0xffe5,0x0010,0xfff1,0x001e,0x0011,0x000c,0x000c,0x0000,
0xffdc,0x000a,0x0007,0x001b,0x0025,0xfff0,0xfff1,0xffea,
0x0003,0xfffc,0x001f,0x0001,0xffd6,0x0007,0xffee,0xfff7,
0x004a,0xfff4,0xffe2,0xffd6,0xffe2,0x000e,0xfff0,0x0017,
0x001d,0xffed,0x0014,0xffeb,0xfff9,0x0001,0xffed,0xffef,
0xfff2,0xfff6,0xffd5,0xffe5,0x0003,0x0030,0xfff8,0x0016,
0xfff0,0xfff9,0x0004,0xffd6,0x0009,0xffe1,0x0006,0xffec,
0xfffa,0xfffc,0x0003,0xffd5,0xffea,0xffec,0x001c,0x0005,
0x0005,0x0007,0xfff9,0xfffc,0xfff7,0x0000,0xffeb,0x001c,
0xfffa,0xffd0,0x0002,0xfff2,0xfff1,0x0014,0xfffb,0x0000,
0xffe5,0xfff2,0xffe0,0xffe4,0xfffb,0x0020,0xfffe,0x0006,
0xffe0,0x0003,0xfff4,0xfffb,0x0008,0xffe7,0xfff2,0xfffc,
0x000c,0x000b,0xfffc,0xffd1,0xffd3,0xffea,0x0016,0xfffe,
0x0022,0xfffa,0xffee,0xffc9,0xfff1,0xfff5,0xffeb,0x0010,
0x0008,0xfff0,0x0006,0x0010,0x0005,0xfffc,0xffdd,0xffe8,
0xfff6,0xfff4,0xffd5,0xffff,0x002b,0x002f,0x000e,0x0008,
0xffd5,0xfffb,0x000a,0xffde,0x0027,0xffee,0x0016,0xfff0,
0xffef,0xffd6,0x000d,0xffed,0x0001,0xfffd,0x000e,0x0014,
0xffde,0x000e,0x0004,0xffef,0x0005,0xffe8,0xffe6,0x0014,
0xffe5,0xffd3,0xfff4,0x0018,0xfffe,0x000d,0xffeb,0xfff8,
0xffea,0xfff0,0xffe0,0xfffe,0x0022,0x001f,0x0014,0xfff9,
0xffc6,0x0005,0xfffb,0x0002,0x0026,0xfff4,0x0002,0xffff,
0x0001,0xffe6,0x0005,0xffe9,0xffeb,0xfffa,0x0008,0x000b,
0x007c,0xfff3,0xffeb,0xffe9,0xffc2,0x0017,0x0000,0x002b,
0x0039,0x0008,0xfff3,0xffee,0x000e,0xfff6,0x0006,0xffe6,
0xfffd,0x0031,0xffed,0x0013,0xffe1,0x001b,0xfff9,0x0000,
0x000b,0xffec,0x001d,0xffff,0x000c,0xffd1,0x0004,0xffd9,
0x000b,0x0022,0x001c,0xfff7,0xfffb,0xffed,0xfff3,0xffde,
0x0037,0x0006,0x0001,0x000e,0xffd7,0x000a,0xfffc,0x0030,
0x0016,0xffec,0xffe1,0xfff6,0x0005,0x0007,0x0014,0xfff7,
0xfff0,0x002d,0xfff8,0x0013,0xffd8,0x000c,0xffff,0xfff1,
0xfffc,0xfff6,0x000c,0x0022,0x000b,0xffd7,0xfff0,0xffe8,
0x001e,0x0031,0x0014,0xfff3,0xffe4,0xffea,0xffee,0xffd5,
0x0054,0xfffa,0xfff7,0xffdc,0xffd1,0xffff,0xfffc,0x0024,
0x0024,0x000c,0xffe5,0x0014,0x001a,0xffef,0xfff7,0xffdf,
0x0001,0x002f,0xffed,0x002e,0x0009,0x001b,0x000f,0xfff3,
0xfff1,0xffee,0x0023,0x0006,0x002a,0xffdf,0x0014,0xffdc,
0x0001,0xfffc,0x0026,0x000e,0x0012,0xfffe,0xffe5,0xffec,
0x000f,0x000d,0x000d,0x0001,0xffe6,0xfff2,0xfff7,0x0029,
0x0001,0xfff0,0xffd2,0x001b,0x0012,0x0001,0x0004,0xfff0,
0xfff5,0x002b,0xfff8,0x002d,0x0000,0x000b,0x0015,0xffe3,
0xffe2,0xfff8,0x0013,0x002a,0x0029,0xffe4,0x0000,0xffec,
0x0014,0x000b,0x001e,0x000a,0xfffc,0xfffb,0xffe0,0xffe4,
0x004f,0xfffe,0xfff4,0xffea,0xffd6,0xffe4,0xffff,0x0033,
0x0036,0x000f,0x0008,0xffd7,0x0000,0xffe8,0x0006,0xfff1,
0x0001,0x0011,0xffdc,0xfff4,0xfff2,0x002f,0x0000,0xfffa,
0xfff5,0xffe6,0x0010,0xffe5,0x000d,0xffd5,0x0016,0xffee,
0x000a,0x000c,0x0002,0xffde,0x000f,0xffdf,0x000d,0xfff3,
0x000a,0x0012,0x000a,0x000f,0xffeb,0xffd7,0xfffa,0x0038,
0x0013,0xfff3,0xfff7,0xffdf,0xfff7,0xfffa,0x0014,0x0001,
0xfff5,0x000d,0xffe8,0xfff3,0xffe9,0x0020,0x0006,0xffea,
0xffe6,0xfff1,0x0000,0x0008,0x000c,0xffdb,0x0001,0xfffe,
0x001c,0x001b,0xfffb,0xffdb,0xfff9,0xffdd,0x0008,0xffeb,
0x0027,0x0004,0x0000,0xffdd,0xffe5,0xffcb,0xfffa,0x002c,
0x0021,0x0012,0xfffb,0xfffe,0x000b,0xffe1,0xfff7,0xffea,
0x0006,0x000f,0xffdc,0x000d,0x0019,0x002e,0x0017,0xffec,
0xffdb,0xffe8,0x0017,0xffed,0x002b,0xffe3,0x0026,0xfff2,
0x0000,0xffe6,0x000c,0xfff6,0x0026,0xfff0,0x0000,0x0000,
0xffe3,0x0019,0x0016,0x0002,0xfffa,0xffbd,0xfff5,0x0031,
0xffff,0xfff6,0xffe8,0x0005,0x0003,0xfff3,0x0004,0xfffb,
0xfffa,0x000b,0xffe7,0x000c,0x0010,0x001f,0x001c,0xffdc,
0xffcb,0xfff3,0x0006,0x0010,0x002a,0xffe8,0x0011,0x0001,
0x0012,0xfff6,0x0004,0xfff3,0x000f,0xffee,0xfffb,0xfff9,
0x001d,0xffe7,0xffea,0xfffe,0x0006,0x0043,0x000b,0xffcf,
0x0001,0x000a,0x0018,0xfffb,0xfffd,0x000d,0xfffc,0x0005,
0x0006,0xfff5,0x0019,0xfff4,0xfff0,0xffe1,0xffe4,0x0024,
0x0035,0x000d,0xfffa,0xfff0,0xffd6,0x0018,0xffef,0xffff,
0xffee,0x000a,0xfffc,0x000d,0xfff1,0x0012,0x0005,0x0007,
0xffd9,0xfffc,0x0000,0x0023,0x001b,0x0035,0x0006,0xffd4,
0xffdf,0xffee,0x0005,0x0002,0xfff5,0x001f,0x0009,0x0016,
0xfffa,0xfff1,0x0024,0xfff3,0xffe7,0xffd2,0xffe9,0x0014,
0x0025,0x0018,0xffe9,0x0013,0xffd5,0x001d,0xffda,0x000e,
0x0000,0x001a,0xfff4,0x000a,0xffda,0x0010,0x0000,0x0000,
0xfff6,0xffee,0xfff6,0xfff1,0x0015,0x0029,0x0006,0xffc8,
0xffed,0x000d,0x0009,0x0021,0x0009,0x0006,0xffec,0xffff,
0x000b,0xfff3,0x0018,0x000d,0x0017,0xffe0,0xfffa,0x0016,
0x001a,0x000f,0x0000,0xfff8,0xfff4,0x0025,0xffff,0x0002,
0xffe4,0xffe5,0x0005,0x0025,0x0007,0x0023,0xfff8,0x0015,
0xffb1,0x0002,0x000c,0x0016,0x002a,0x001c,0x0001,0xffcd,
0xffca,0xfff1,0xfff8,0x0029,0x0000,0x0018,0xfffa,0x000f,
0xffff,0xffef,0x0024,0x000c,0x000e,0xffd1,0x0000,0x0006,
0x000b,0x001a,0xfff0,0x001b,0xfff3,0x002b,0xffea,0x0012,
0xfff6,0xfff4,0xfffe,0x0022,0xfff1,0x0021,0xfff3,0x000d,
0xfff1,0xfff3,0xfff3,0xffff,0x001a,0x000e,0x0009,0xffd7,
0xffff,0x0010,0x002e,0xffe5,0xffee,0xffff,0xfffc,0x0010,
0x000b,0xffd5,0x0008,0xffd3,0x0000,0xfff5,0xffeb,0x001d,
0x001e,0x0008,0xffed,0xffd6,0xffd7,0x001c,0x0000,0x0014,
0xffec,0xfff5,0xffe2,0xfff6,0x0004,0x0005,0x0020,0x001c,
0xffac,0x0006,0x0009,0x0024,0x002f,0x0001,0x0004,0xffdc,
0xffdc,0xfff4,0x001b,0xffec,0xffe6,0x0011,0x0009,0x0021,
0xffff,0xffd1,0x0013,0xffd2,0xfff7,0xffe5,0xfff1,0x000d,
0x000f,0x0012,0xffdd,0xfffa,0xffd6,0x0021,0xffec,0x0024,
0xffff,0x0004,0xffda,0xfff2,0xffee,0x0002,0x001b,0x0014,
0xffc9,0xfffa,0xffff,0xfff2,0x0029,0xfff6,0x0004,0xffd0,
0xffea,0x0014,0x001f,0x000a,0xfffb,0xfff9,0xffec,0x0009,
0x0010,0xffd3,0x0008,0xffed,0x0028,0xfff4,0x0001,0x000f,
0x0004,0x000a,0xfff4,0xffde,0xfff5,0x0029,0x0010,0x0018,
0xffe2,0xffcf,0xffec,0x000d,0x001c,0x0016,0x0012,0x002b,
0xff84,0x000d,0x0015,0x0017,0x003e,0xffe9,0x0000,0xffd5,
0xffc7,0xfff8,0x000d,0x0012,0xfff2,0x000a,0xfffa,0x001a,
0x0003,0xffcf,0x0013,0xffed,0x001f,0xffe5,0x0007,0x0000,
0xfff5,0x0014,0xffe3,0x0001,0xfff4,0x002f,0xfffc,0x0027,
0xfff5,0xffde,0xffe4,0x0009,0x0005,0x0013,0x000d,0x0022,
0x0022,0xfff2,0xfffc,0x0011,0xfffb,0x0018,0x001a,0xffec,
0x001b,0x002d,0x000c,0xffe8,0x0002,0xfff3,0x0015,0x0008,
0x0016,0x0010,0x0020,0x0002,0xffde,0xffe1,0xffec,0x0007,
0x003a,0xfffb,0x0005,0xfffe,0xffda,0x000c,0xfffe,0x0001,
0xffff,0x001a,0xfffb,0x0017,0x0015,0x0006,0xfff8,0xfff5,
0xffde,0x0006,0x0012,0x0037,0x000f,0x000b,0x0015,0xfff0,
0xfff8,0x0010,0xfffa,0xfff0,0xfffb,0x0004,0x0023,0x0018,
0x000a,0x000c,0x002b,0x0001,0xffd5,0xffd1,0xfff2,0xfff8,
0x002b,0x0005,0xfff6,0x0022,0xffd9,0x0012,0xffea,0x0010,
0x0011,0x002a,0xfff3,0x0013,0xffff,0x0003,0xfff2,0xffec,
0xfffb,0xfff9,0x0007,0x0004,0x0009,0x0000,0x0015,0xffe4,
0x0006,0x0030,0xfffe,0x000e,0x000f,0xffec,0x0005,0x0000,
0x001b,0x000e,0x0020,0x001c,0x0005,0xffe0,0x0002,0xfffa,
0x0020,0xfffd,0x000c,0x0005,0xfff8,0x0019,0x000e,0x0004,
0xfff4,0xfff5,0x0004,0x002f,0x002d,0x0016,0xffea,0x0002,
0xffb6,0x000c,0x001e,0x002a,0x001e,0xfff2,0x0010,0xffe9,
0xffe3,0x0013,0xffec,0x0015,0x0007,0xffff,0x0013,0x0011,
0x000e,0x000a,0x002b,0x001b,0xfffd,0xffd0,0x0008,0xffea,
0x0010,0x0007,0xfffc,0x002a,0xfff7,0x001f,0xfffa,0x0014,
0x0006,0x0004,0xfffd,0x002b,0x0016,0x0014,0xffe4,0xfffb,
0xfff6,0xfffd,0x0004,0x0012,0x000f,0xffe5,0x0018,0xfff3,
0x0018,0x0033,0x0022,0xffd1,0xfff4,0xffe4,0x0015,0x0013,
0x001b,0xfff0,0x000f,0xffe2,0xffef,0xfff4,0xfff4,0x0000,
0x0024,0xfff6,0xfff9,0xffe5,0xffdb,0x0010,0x000f,0x0016,
0xfffd,0x0004,0xffe1,0xffff,0x002a,0xfff9,0x0012,0x0009,
0xffb1,0x0011,0x001b,0x0038,0x0024,0xffd7,0x0013,0xfff8,
0xfff6,0x0016,0x000f,0xffd9,0xffec,0xfff7,0x0023,0x0023,
0x000f,0xffec,0x001a,0xffe1,0xffe6,0xffe5,0xfffa,0xfff1,
0x0014,0x0000,0xffe9,0x0008,0xffda,0x0016,0xfffb,0x0026,
0x000f,0x0014,0xffd9,0xfffc,0x0012,0xfff7,0x000d,0x0001,
0xffce,0x0003,0x0010,0x0005,0x001e,0xffcb,0x0013,0xffec,
0x0003,0x0037,0x0013,0xfff8,0x0000,0xffde,0x0005,0x000b,
0x0020,0xffee,0x000f,0xfffc,0x0016,0xfff3,0x000a,0xfff3,
0x0009,0xfff8,0x0000,0xffed,0xfff9,0x001d,0x001f,0x001a,
0xfff3,0xffdf,0xffeb,0x0016,0x0041,0x0009,0x0004,0x0017,
0xff89,0x0018,0x0027,0x002c,0x0033,0xffbe,0x000e,0xfff1,
0xffe1,0x001a,0x0001,0x0000,0xfff9,0xfff0,0x0013,0x001c,
0x0013,0xffea,0x001a,0xfffc,0x000d,0xffe4,0x0010,0xffe3,
0xfffb,0x0001,0xfff0,0x0010,0xfff8,0x0023,0x000a,0x002a,
0x0004,0xffef,0xffe3,0x0013,0x002a,0x0007,0x0000,0x000f,
0x001f,0xffe4,0x0006,0xfff0,0xfff0,0x0032,0xffe1,0xfff2,
0x0000,0x0006,0x0024,0x0011,0x0000,0x0000,0xffe3,0xfff2,
0x000b,0x0012,0x0014,0xffe7,0xfffa,0xffdf,0xffed,0x0014,
0x002b,0x0015,0x0015,0xfff2,0xffc9,0x0000,0xffe0,0xffd8,
0xffd6,0x0027,0x0001,0xfff8,0xfff2,0x0008,0xfffa,0xfffd,
0xffdb,0xfff8,0x001d,0x0016,0x0004,0x0025,0xffdc,0xfff7,
0xffde,0xffea,0x0011,0x0018,0xfff8,0x0012,0xfff1,0x0002,
0xffff,0x000e,0x001f,0xffe7,0xfff1,0xffd0,0xfff3,0x0004,
0x001c,0x001f,0x0005,0x0015,0xffc7,0x0004,0xffcb,0xffe8,
0xffe9,0x0037,0xfffa,0xfff4,0xffdb,0x0006,0xfff5,0xfff5,
0xfff9,0xffea,0x0012,0xffe3,0xffff,0x0019,0xffdc,0xffeb,
0xffec,0x0009,0x0016,0x0038,0x000b,0xfffa,0xffd3,0xffeb,
0x000f,0x0010,0x0014,0x0001,0x0021,0xffde,0x0002,0x0006,
0x0011,0x0017,0x001c,0xfffa,0xffe7,0x000c,0xfff0,0xffdb,
0xffcb,0x0001,0x000b,0x000f,0x0008,0x0019,0xffec,0x000b,
0xffb4,0xffff,0x0029,0x0009,0x0013,0x000c,0xffd7,0xffef,
0xffc9,0xffee,0x0003,0x003f,0x0003,0x000c,0xffe2,0xfffb,
0x0003,0x000c,0x001f,0x0000,0x0018,0xffcf,0x0008,0xfff7,
0x0001,0x0021,0x000c,0x001d,0xffe5,0x0012,0xffdb,0xffeb,
0xffde,0x0011,0x0003,0x000b,0xfff2,0x0017,0xffe7,0x0002,
0xfff3,0xffef,0x000f,0xfff1,0x0003,0xffff,0xffdf,0xfff9,
0xffff,0x000c,0x003a,0xfffb,0xfff1,0xfff3,0xffe3,0xfffd,
0x0010,0xfff3,0x0004,0xffc7,0x000a,0xfff3,0xfff5,0x000d,
0x0015,0x000f,0x0009,0xffd8,0xffc9,0x0003,0xfff2,0xffed,
0xffd4,0x0011,0xffe8,0xffe0,0x0005,0xfffc,0x0015,0x0012,
0xffae,0x0003,0x0026,0x0017,0x0018,0xfff1,0xffda,0xfffe,
0xffdb,0xfff1,0x0027,0x0002,0xffe9,0x0004,0xfff1,0x000c,
0x0003,0xffef,0x000f,0xffc6,0x0001,0xffe3,0xfffa,0xfffe,
0x0005,0x001a,0xfff9,0xfffc,0xffc8,0x0009,0xffdd,0xfffd,
0xffe7,0x0021,0xffe0,0xffdc,0xffef,0xfff9,0x000f,0x0009,
0xffcc,0xfff6,0x001b,0xffe5,0x0012,0xffe6,0xffda,0xfff2,
0xffe9,0x0010,0x002c,0x0021,0xfffd,0xffec,0xffd3,0xfff6,
0x0014,0xfff1,0x0003,0xffe1,0x0032,0xfff2,0x000a,0x0000,
0xfffb,0x0011,0x000f,0xffe0,0xffe8,0x0010,0x0001,0xfff1,
0xffc9,0xffec,0xfff2,0xfff8,0x001d,0x000c,0x0007,0x0020,
0xff87,0x0009,0x0032,0x000a,0x0028,0xffd8,0xffd5,0xfff7,
0xffc6,0xfff4,0x0019,0x0029,0xfff5,0xfffe,0xffe1,0x0005,
0x0008,0xffed,0x000f,0xffe0,0x0029,0xffe2,0x0010,0xfff0,
0xffec,0x001c,0x0000,0x0003,0xffe6,0x0016,0xffed,0x0000,
0xffdc,0xfffc,0xffea,0xfff4,0x0006,0x0009,0x0001,0x0018,
0x0024,0xffee,0x0018,0x0003,0xffe4,0x0007,0xfff0,0x000d,
0x001a,0x0029,0x0018,0xffff,0x0005,0xffe6,0xfffd,0xfff4,
0x001b,0x002e,0x001b,0xfff6,0xffe8,0xffde,0xfff6,0xfff8,
0x0031,0x0002,0x0022,0x0000,0xffcd,0xfff4,0xffef,0xffda,
0xffe7,0x0038,0x0000,0x0000,0x0016,0xfffd,0xffec,0xffea,
0xffe0,0x0002,0x002f,0x002a,0xfff9,0xfffb,0xffeb,0x0012,
0xfff7,0x000c,0x0005,0x0005,0xfffe,0xfff8,0x000a,0x0004,
0x000e,0x002a,0x0026,0xfff6,0xffdf,0xffcf,0xfffb,0xffe8,
0x0021,0x000c,0x0011,0x0023,0xffcc,0xfffa,0xffda,0xffea,
0xfff9,0x0048,0xfff9,0xfffd,0x0000,0xfffa,0xffe7,0xffe2,
0xfffe,0xfff5,0x0024,0xfff7,0xfff3,0xffef,0xffeb,0x0006,
0x0005,0x002d,0x000a,0x0024,0x0012,0xffdf,0xffed,0xffed,
0x001f,0x002c,0x001b,0x000f,0x0010,0xffde,0x000b,0xffea,
0x0016,0x0004,0x0028,0x0007,0xffeb,0x0000,0xffff,0xffdd,
0xffdc,0x0012,0x000a,0x0018,0x002e,0x000c,0xffde,0xfff8,
0xffb9,0x0009,0x003b,0x001d,0x0008,0xffe2,0xffe6,0x000b,
0xffe2,0x0010,0xfff8,0x002c,0x0009,0xfff2,0xfffb,0xfffe,
0x0013,0x0028,0x0026,0x000f,0x0007,0xffce,0x0011,0xffda,
0x0007,0x000e,0x0018,0x002b,0xffea,0x0006,0xffea,0xffed,
0xffef,0x0022,0x0002,0x0014,0x0017,0x000a,0xffd9,0xfff0,
0xfff8,0xfffa,0x0021,0x0004,0xfff9,0xffd4,0xffee,0x0015,
0x0017,0x0030,0x002e,0xffe8,0xfff7,0xffd8,0xfffd,0xffff,
0x0020,0x000d,0x000b,0xffd5,0xfff9,0xfff2,0xfffd,0xfff1,
0x001a,0xfffd,0x0015,0xffe6,0xffce,0xfff8,0x0000,0xfff0,
0xffe5,0x0022,0xffe7,0xffe9,0x002b,0xffef,0x0006,0xffff,
0xffb3,0x000d,0x0038,0x002b,0x000d,0xffc7,0xffe9,0x001a,
0xfff5,0x0013,0x001b,0xfff0,0xffef,0xffea,0x000a,0x000f,
0x0013,0x000a,0x0016,0xffd5,0xfff0,0xffe2,0x0002,0xffe1,
0x000b,0x0006,0x0005,0x0009,0xffcc,0xfffe,0xffec,0x0000,
0xfff8,0x0032,0xffdf,0xffe5,0x0013,0xffed,0x0001,0xfff7,
0xffd1,0x0000,0x002d,0xfff9,0x0007,0xffbb,0xffe9,0x000d,
0x0002,0x0033,0x0020,0x000e,0x0003,0xffd1,0xffed,0xfff8,
0x0025,0x000b,0x000a,0xfff0,0x0020,0xfff1,0x0013,0xffe3,
0x0000,0xffff,0x001c,0xffee,0xffec,0x0004,0x0010,0xfff3,
0xffda,0xfffd,0xfff1,0x0000,0x0042,0x0000,0xfff9,0x000d,
0xff8c,0x0014,0x0044,0x001e,0x001c,0xffad,0xffe4,0x0012,
0xffe0,0x0016,0x000d,0x0015,0xfffb,0xffe4,0xfffb,0x0007,
0x0018,0x0008,0x0016,0xffef,0x0017,0xffe2,0x0019,0xffd3,
0xfff1,0x0009,0x000b,0x0012,0xffea,0x000a,0xfffc,0x0002,
0xffed,0x000c,0xffe9,0xfffd,0x002b,0xfffe,0xfff4,0x0004,
0x0048,0xfff3,0xffe3,0xffee,0x0004,0x005a,0x0025,0xffde,
0x0004,0xffff,0x000d,0xfff7,0xfffa,0x000b,0x0002,0x0018,
0xfff3,0x0003,0xfff9,0xfff5,0xfffc,0x0004,0xffd6,0x0019,
0x001f,0xffff,0xfff8,0xffe3,0xfffa,0x0011,0xffed,0x0002,
0xfff6,0xfffa,0x0026,0x0016,0xffd6,0xffed,0xfffa,0xfff5,
0x0003,0x0007,0xfffa,0x0014,0x0019,0x004d,0x0020,0xffe3,
0xffe1,0xffe2,0xfffc,0xfffe,0xfff2,0x001d,0x0010,0x0028,
0xffe6,0x0000,0x0003,0xfff4,0xfff3,0xfff6,0xffdc,0x0009,
0x000f,0x0008,0xffe8,0x0006,0xfff9,0x0016,0xffd8,0x0011,
0x0008,0x0009,0x001f,0x0012,0xffbe,0xffea,0xfff5,0xffed,
0x0020,0xfffa,0xffef,0xffe1,0x0013,0x0041,0x0021,0xffd7,
0xfff0,0x0001,0x0000,0x001d,0x0006,0x0004,0xfff3,0x0011,
0xfff7,0x0001,0xfff8,0x000e,0x0023,0x0003,0xffed,0x000b,
0x0004,0x0000,0xffff,0xffeb,0x0017,0x001e,0xfffd,0x0005,
0xffec,0xffd4,0x0030,0x002e,0xffed,0xfffd,0xffec,0x0003,
0xffdc,0x000d,0x0005,0x0007,0x0028,0x0033,0x001c,0xffdc,
0xffcc,0xffe5,0xffee,0x0024,0xfffe,0x0016,0x0000,0x0021,
0xffeb,0xfffe,0x0003,0x000d,0x001a,0xfff5,0xfff2,0xfffc,
0xfff6,0x000a,0xffee,0x000e,0x0016,0x0024,0xffe8,0x0015,
0xffff,0xffe4,0x0028,0x002a,0xffd6,0xfffb,0xffe7,0xfffb,
0x001b,0xffff,0xffec,0xffef,0x0018,0x0026,0x0023,0xffe6,
0x0001,0x0004,0x0023,0xffe0,0xffeb,0xfffd,0x0002,0x0023,
0xfff8,0xffe3,0xffe8,0xffd4,0x000c,0x0018,0xffde,0x0012,
0x0008,0xfff9,0xffeb,0xffc9,0xfffb,0x0015,0xfffe,0x0017,
0xfff5,0xffe4,0x000d,0xffff,0xffea,0xffdf,0x0015,0x000a,
0xffd7,0x0012,0x0002,0x0015,0x002d,0x0018,0x001e,0xffeb,
0xffdf,0xffe8,0x0011,0xffe8,0xffe3,0x000f,0x0010,0x0033,
0xffeb,0xffdf,0xfff3,0xffd3,0x0003,0x0008,0xffe4,0x0002,
0xfff9,0x0002,0xffdb,0xffed,0xfff9,0x001b,0xffea,0x0027,
0x0007,0xfff4,0x0005,0xfffb,0xffd3,0xffdd,0x000f,0x0001,
0xfff4,0x0004,0xfff8,0xffe3,0x0027,0x000c,0x001e,0xffdf,
0xffed,0x0008,0x0015,0x0006,0xfff8,0xfff7,0xfff3,0x001c,
0xfffc,0xffe1,0xffe8,0xffee,0x0034,0x0017,0xfff4,0x0004,
0xffee,0xfffb,0xfff2,0xffd1,0x0018,0x0022,0x000e,0x001b,
0xffea,0xffbe,0x0016,0x0016,0x0001,0xfff0,0x0006,0x0018,
0xffaf,0x0019,0x000e,0x0008,0x003d,0x0000,0x0019,0xffe4,
0xffca,0xffec,0x0003,0x000e,0xffef,0x0008,0x0000,0x002c,
0xfff0,0xffdd,0xfff3,0xffee,0x002b,0x0007,0xfffa,0xfff5,
0xffdf,0x0004,0xffe2,0xfff5,0x0016,0x0028,0xfffa,0x002b,
0xfffd,0xffce,0x000e,0x0012,0xffea,0xffee,0x0001,0x0010,
0x004d,0xfffe,0xfff5,0x0001,0xfff9,0x002f,0x0034,0xfffb,
0x001d,0x0021,0x0001,0xffe4,0x0000,0xfff1,0x001c,0x001a,
0x0002,0x001e,0x0000,0x0002,0xffea,0x0004,0xffdf,0xfffd,
0x0024,0xffeb,0x0003,0xfff1,0xfffe,0x0005,0xfffc,0x0004,
0x0006,0x0009,0x0025,0x001f,0xfffb,0xffe0,0xffec,0xffe2,
0x0008,0x0011,0x000a,0x0028,0x000d,0x0022,0x002f,0x0000,
0xfffb,0x0004,0xfff0,0xffeb,0xfff8,0x0002,0x002a,0x002b,
0xfff6,0x001a,0x000a,0x0002,0xffe1,0xfff5,0xffe5,0xffed,
0x0015,0xfff6,0xfff4,0x0014,0xfffd,0x000b,0xffe7,0x0014,
0x0019,0x0019,0x001d,0x001c,0xffe4,0xffde,0xffe7,0xffda,
0x0025,0x0003,0x0000,0xfff6,0x0007,0x0016,0x0030,0xfff4,
0x0008,0x0024,0xfff4,0x0009,0x000c,0xffea,0x000c,0x0013,
0x0006,0x001c,0x0000,0x001d,0x0012,0x0003,0xfff5,0xffef,
0x000a,0xffee,0x000a,0xfff9,0x001b,0x0012,0x000b,0x0007,
0xfffd,0xffe4,0x002f,0x0037,0x0012,0xfff1,0xffde,0xfff0,
0xffe1,0x0018,0x0017,0x001b,0x001d,0x0009,0x002b,0xfff8,
0xffe6,0x0007,0xffe2,0x0011,0x0004,0xfffd,0x001a,0x0023,
0xfffb,0x0018,0x000a,0x001c,0x0009,0xfff4,0xfffb,0xffdf,
0xfffb,0xfff8,0xfffb,0x001d,0x001a,0x0018,0xfff7,0x0017,
0x000e,0xfff4,0x0027,0x0034,0xfffb,0xffee,0xffd9,0xffe8,
0x0020,0x0008,0xfffd,0x0002,0x000d,0xfffc,0x0032,0x0001,
0x001b,0x0027,0x0017,0xffcd,0xfff1,0xffe2,0x001b,0x0025,
0x0007,0xffff,0xffef,0xffe3,0xfffb,0x0017,0xffe7,0xfff6,
0x000e,0xffe6,0xfff8,0xffd7,0xffff,0x0009,0x000d,0x001a,
0x0005,0xfff4,0x000c,0x0007,0x000e,0xffd3,0x0006,0xfff7,
0xffdc,0x001d,0x0013,0x0029,0x0022,0xffee,0x002d,0x0006,
0xfff8,0x000a,0x0005,0xffd5,0xffe9,0xfff5,0x002a,0x0035,
0xfffb,0xfffb,0xfffa,0xffe2,0xfff2,0x0008,0xffec,0xffe6,
0xffff,0xfff0,0xffe7,0xfffc,0xfffd,0x000f,0xfff9,0x0029,
0x0017,0x0003,0x0004,0x0003,0xfff8,0xffd0,0x0001,0xffef,
0xfff9,0x000f,0x0009,0xfff7,0x001c,0xffe3,0x002d,0xfffb,
0x0006,0x002b,0x0009,0xfff4,0xfffe,0xffdc,0x000c,0x001e,
0x000b,0xfffd,0xffef,0xfffd,0x0022,0x0016,0xfffd,0xffe8,
0xfff4,0xffe8,0xfffe,0xffe0,0x001c,0x0016,0x001d,0x001d,
0xfffb,0xffce,0x0015,0x001f,0x0026,0xffe3,0xfff9,0x0005,
0xffb4,0x0023,0x001f,0x001c,0x0031,0xffd5,0x0028,0x0000,
0xffe3,0x000e,0xfff8,0xfffb,0xfff6,0xffee,0x001a,0x002e,
0x0000,0xfff9,0xfffa,0xfffd,0x0019,0x0007,0x0002,0xffd8,
0xffe4,0xfff2,0xffee,0x0003,0x001b,0x001c,0x0008,0x002d,
0x000d,0xffde,0x000d,0x001b,0x000f,0xffe1,0xfff4,0xfffd,
0x004a,0xffef,0x0000,0xffe1,0xffee,0x0049,0xfffb,0x0000,
0x0003,0xfffb,0x0019,0x000c,0xfffd,0xffff,0xffea,0x0003,
0xfff7,0x0021,0xfff4,0xffe8,0x0006,0x0002,0xffdf,0x0009,
0x0015,0x0005,0x0014,0xffe5,0xffed,0xfff9,0xffde,0xffdb,
0xffde,0x0016,0x002c,0x0000,0xffd7,0xffe3,0xffef,0xffeb,
0x0005,0x0003,0x0015,0x0007,0x0002,0x003c,0xfff6,0x0005,
0xffe0,0xffde,0x0007,0x0014,0xfff5,0x0010,0xfff8,0x0014,
0xffeb,0x001d,0xffff,0xffe8,0xfffe,0xfff3,0xffe5,0xfffa,
0x0005,0x000f,0x0003,0x0008,0xffeb,0xffff,0xffc9,0xffeb,
0xfff1,0x0026,0x0025,0xfffd,0xffbf,0xffe0,0xffe9,0xffe2,
0x0023,0xfff6,0x000b,0xffd4,0xfffd,0x0030,0xfff6,0xfffa,
0xffef,0xfffe,0x000b,0x0033,0x0008,0xfff8,0xffda,0xfffd,
0xfffc,0x001f,0xfff4,0x0002,0x002e,0x0001,0xfff6,0xfffc,
0xfffb,0x0007,0x001a,0xffed,0x000a,0x0005,0xffee,0xffde,
0xffd3,0xfff1,0x0036,0x0018,0xffee,0xfff3,0xffe1,0xfff9,
0xffdf,0x000a,0x0022,0xfffb,0x0011,0x0023,0xfff1,0xffff,
0xffcb,0xffe2,0xfffa,0x003b,0x0000,0x000a,0xffe8,0x000d,
0xffef,0x001b,0xffff,0x0001,0x0025,0xfff3,0xfffc,0xffec,
0xffec,0x0012,0x000a,0x0010,0x0008,0x000b,0xffd9,0xffee,
0xffe6,0x0000,0x002e,0x0014,0xffd7,0xfff1,0xffdb,0xfff1,
0x001d,0xfffb,0x0007,0xffe2,0x0001,0x0015,0xfff9,0x0007,
0x0000,0x0000,0x002f,0xfff7,0xffee,0xfff1,0xffea,0x000e,
0xfffc,0x0000,0xffe4,0xffc7,0x0017,0x0015,0xffe7,0x0002,
0xffff,0x0000,0x0007,0xffcb,0xffed,0xfffd,0xffef,0xfff1,
0xffdc,0x0000,0x0013,0xffe8,0xffeb,0xffd5,0x0009,0x0000,
0xffd9,0x000e,0x001e,0x0008,0x0016,0x0008,0xfff4,0x000c,
0xffde,0xffe5,0x001d,0xfffe,0xffe6,0x0002,0xfff8,0x001f,
0xfff0,0xfffd,0xffef,0xffc7,0x000e,0x0006,0xffed,0xfff3,
0xfff0,0x000a,0xfff8,0xffef,0xffec,0x0002,0xffda,0x0000,
0xffef,0x0010,0x000b,0xffe5,0xffd4,0xffd3,0x0004,0xfff8,
0xfff7,0x0001,0x0014,0xffd5,0x0011,0xfffd,0xfff4,0x0000,
0xffec,0x0004,0x0021,0x001d,0xfffa,0xffea,0xffda,0x0007,
0x0000,0xffff,0xffe3,0xffe2,0x003f,0x0015,0xfffd,0xfff5,
0xffe5,0x0001,0x000e,0xffd3,0x000a,0x0009,0xffff,0xfff4,
0xffd1,0xffdb,0x001c,0x0000,0x0002,0xffe6,0xfffc,0x000d,
0xffb2,0x0015,0x002b,0xfffc,0x0026,0xffef,0xffef,0x0005,
0xffc9,0xffe8,0x000f,0x0024,0xfff2,0xfffc,0xffe8,0x0018,
0xfff4,0xfffb,0xffef,0xffe1,0x0036,0x0005,0x0002,0xffe5,
0xffd5,0x000c,0xfffe,0xfff7,0x0009,0x000f,0xffea,0x0003,
0xffe4,0xffeb,0x0014,0xfffd,0xffec,0xffe4,0xfff7,0x0005,
0x0050,0xfffa,0x0010,0xfff5,0xffe2,0x001e,0x0009,0x001c,
0x001c,0x001d,0x000d,0xfffa,0x0002,0xffe4,0x0003,0x0005,
0x0007,0x003c,0xfffb,0xfff7,0xfff5,0x0001,0xffe8,0xffed,
0x001b,0xfff3,0x0020,0xfff3,0xfff1,0xffed,0xffed,0xffdd,
0xffef,0x0027,0x002b,0x0009,0xfffc,0xffd6,0xffe0,0xffd7,
0x000b,0x000e,0x0027,0x001b,0xfff7,0x0011,0x0004,0x0021,
0xfffa,0x0000,0xfffc,0x0001,0xfffb,0xfff6,0x0011,0x0016,
0xfffb,0x0039,0x0005,0xfff7,0xffec,0xfff3,0xffee,0xffdd,
0x000b,0xfffd,0x0010,0x0016,0xffef,0xfff3,0xffd8,0xffed,
0x0001,0x0037,0x0023,0x0005,0xffe5,0xffd4,0xffdb,0xffcf,
0x0028,0x0000,0x001c,0xffe8,0xfff2,0x0005,0x0004,0x0015,
0x0007,0x0021,0x0000,0x0020,0x000f,0xffdd,0xfff4,0xffff,
0x000b,0x003a,0xfffb,0x0010,0x001c,0x0000,0xffff,0xffdf,
0x0000,0xfff5,0x0027,0xfffb,0x000e,0xfffa,0xfffd,0xffe1,
0xffe4,0x0001,0x0035,0x0021,0x0013,0xffe7,0xffd2,0xffe6,
0xffe4,0x0014,0x0033,0x000e,0x0006,0xfff9,0x0000,0x001a,
0xffe5,0x0004,0xffee,0x0028,0x0006,0xfff0,0x0001,0x000f,
0x0000,0x0037,0x0005,0x0010,0x0013,0xfff2,0x0003,0xffcf,
0xfff2,0xffff,0x0016,0x001e,0x000c,0x0000,0xffe8,0xfff1,
0xfff7,0x0011,0x002d,0x001d,0xfffc,0xffe4,0xffcd,0xffdd,
0x0022,0x0004,0x0019,0xfff6,0xfff7,0xffeb,0x0007,0x0024,
0x001a,0x0024,0x0023,0xffe4,0xfff4,0xffd6,0x0003,0x0010,
0x000c,0x001c,0xffeb,0xffd6,0x0005,0x0015,0xfff0,0xffe6,
0x0004,0xffed,0x0013,0xffd9,0xfff1,0xfff1,0xffff,0xfff3,
0xffed,0x0011,0x0011,0xfff2,0x000f,0xffc9,0xfffc,0xffed,
0xffde,0x0019,0x0030,0x001c,0x000b,0xffde,0x0002,0x0029,
0xfff7,0x0007,0x0011,0xffeb,0xffec,0xffe8,0x0011,0x0021,
0x0000,0x0018,0xfff6,0xffd6,0xfffd,0x0005,0xfff6,0xffd6,
0xfff5,0xfff8,0x0003,0xfffd,0xfff0,0xfff7,0xffea,0x0002,
0x0000,0x0021,0x000a,0xffee,0xfff9,0xffc6,0xfff6,0xffe4,
0xfffc,0x000b,0x0025,0xffe9,0x0005,0xffd2,0x0002,0x001d,
0x0005,0x0027,0x0015,0x0009,0x0000,0xffcf,0xfff4,0x0009,
0x0010,0x001a,0xffea,0xfff1,0x002d,0x0014,0x0005,0xffd8,
0xffea,0xffef,0x001a,0xffe1,0x000e,0xfffe,0x000e,0xfff6,
0xffe2,0xffec,0x001b,0x0009,0x0027,0xffd9,0xffee,0xfffb,
0xffb7,0x0020,0x003c,0x000f,0x001a,0xffc5,0xfffe,0x0021,
0xffe2,0x000a,0x0003,0x0011,0xfff8,0xffe2,0x0001,0x001a,
0x0004,0x0016,0xfff6,0xfff0,0x0024,0x0005,0x000b,0xffc8,
0xffdb,0xfffa,0x000a,0x0005,0x000d,0x0003,0xfffa,0x0005,
0xfff5,0xfffc,0x0013,0x0005,0x0010,0xffd7,0xffe8,0xfff3};
 
const unsigned long ftable1[128]={
0x4cc9f,0x482af,0x47bd8,0x44700,0x5238b,0x47377,0x4898a,0x411fd,
0x4f8b7,0x4a7d5,0x4bd1b,0x47feb,0x5554b,0x49414,0x4c9d4,0x4403c,
0x4fa57,0x550c5,0x4ea1c,0x54c6e,0x51f27,0x4ff8f,0x4cab5,0x4bbb6,
0x53e58,0x5a5e8,0x5551f,0x5d6ff,0x56499,0x540f7,0x528e8,0x51740,
0x4cdba,0x459db,0x4a644,0x4445b,0x4e123,0x423bc,0x480ed,0x3ed60,
0x5292b,0x49d33,0x51d8c,0x49f1d,0x53cc4,0x45a9d,0x4e88c,0x43073,
0x4d3a1,0x4e583,0x4f702,0x5182e,0x4b81f,0x47291,0x49dc4,0x46541,
0x5434b,0x55bc1,0x5a27e,0x5d510,0x51ba0,0x4c587,0x51f83,0x4d45f,
0x4d45f,0x51f83,0x4c587,0x51ba0,0x5d510,0x5a27e,0x55bc1,0x5434b,
0x46541,0x49dc4,0x47291,0x4b81f,0x5182e,0x4f702,0x4e583,0x4d3a1,
0x43073,0x4e88c,0x45a9d,0x53cc4,0x49f1d,0x51d8c,0x49d33,0x5292b,
0x3ed60,0x480ed,0x423bc,0x4e123,0x4445b,0x4a644,0x459db,0x4cdba,
0x51740,0x528e8,0x540f7,0x56499,0x5d6ff,0x5551f,0x5a5e8,0x53e58,
0x4bbb6,0x4cab5,0x4ff8f,0x51f27,0x54c6e,0x4ea1c,0x550c5,0x4fa57,
0x4403c,0x4c9d4,0x49414,0x5554b,0x47feb,0x4bd1b,0x4a7d5,0x4f8b7,
0x411fd,0x4898a,0x47377,0x5238b,0x44700,0x47bd8,0x482af,0x4cc9f};

const unsigned long ftable2[128]={
0x2f8e9,0x3444d,0x3637b,0x3608d,0x3372e,0x33ab9,0x33946,0x2f157,
0x307a1,0x36a4d,0x380c9,0x39279,0x332c0,0x34673,0x33a8a,0x2fec4,
0x2ecea,0x36011,0x34bb0,0x37829,0x36353,0x39c4a,0x35f32,0x33352,
0x2cb99,0x33db5,0x3221f,0x3595c,0x31b84,0x35804,0x31d79,0x3075f,
0x27f6f,0x2f99d,0x2d6c9,0x3369b,0x2df25,0x34928,0x3018c,0x32129,
0x28cb2,0x31e5c,0x2eebd,0x36c4e,0x2e2a3,0x3601f,0x30a58,0x33aa8,
0x28cee,0x336a2,0x2e69d,0x37dcd,0x323b6,0x3fa08,0x34b2d,0x3acd3,
0x27abc,0x3214b,0x2cff6,0x3695f,0x2f09d,0x3ae92,0x315ba,0x37761,
0x37761,0x315ba,0x3ae92,0x2f09d,0x3695f,0x2cff6,0x3214b,0x27abc,
0x3acd3,0x34b2d,0x3fa08,0x323b6,0x37dcd,0x2e69d,0x336a2,0x28cee,
0x33aa8,0x30a58,0x3601f,0x2e2a3,0x36c4e,0x2eebd,0x31e5c,0x28cb2,
0x32129,0x3018c,0x34928,0x2df25,0x3369b,0x2d6c9,0x2f99d,0x27f6f,
0x3075f,0x31d79,0x35804,0x31b84,0x3595c,0x3221f,0x33db5,0x2cb99,
0x33352,0x35f32,0x39c4a,0x36353,0x37829,0x34bb0,0x36011,0x2ecea,
0x2fec4,0x33a8a,0x34673,0x332c0,0x39279,0x380c9,0x36a4d,0x307a1,
0x2f157,0x33946,0x33ab9,0x3372e,0x3608d,0x3637b,0x3444d,0x2f8e9};

static const short decodetable1[63]={
0x0000,0x0006,0x0010,0x0012,0x0014,0x0017,0x0019,0x001d,
0x0020,0x0024,0x0029,0x002e,0x0033,0x0039,0x0041,0x0049,
0x0051,0x005b,0x0067,0x0073,0x0081,0x0091,0x00a3,0x00b7,
0x00cd,0x00e6,0x0103,0x0122,0x0146,0x016d,0x019a,0x01cc,
0x0204,0x0243,0x028a,0x02da,0x0333,0x0397,0x0407,0x0485,
0x0512,0x05b0,0x0662,0x0729,0x0809,0x0904,0x0a1e,0x0b5a,
0x0cbd,0x0e4b,0x1009,0x11fe,0x1430,0x16a7,0x196b,0x1c85,
0x2000,0x23e7,0x2849,0x2d33,0x32b7,0x38e7,0x3fd9};

static const short decodetable2[127]={
0xf037,0xf043,0xf04e,0xf058,0xf062,0xf06c,0xf077,0xf082,
0xf08e,0xf09a,0xf0a6,0xf0b2,0xf0be,0xf0cc,0xf0d9,0xf0e6,
0xf0f4,0xf101,0xf10f,0xf11e,0xf12d,0xf13d,0xf14c,0xf15c,
0xf16d,0xf17d,0xf18d,0xf19d,0xf1ae,0xf1bf,0xf1d1,0xf1e3,
0xf1f6,0xf20a,0xf21d,0xf232,0xf247,0xf25d,0xf274,0xf28c,
0xf2a4,0xf2bc,0xf2d4,0xf2ee,0xf307,0xf321,0xf33c,0xf358,
0xf374,0xf391,0xf3af,0xf3ce,0xf3ee,0xf410,0xf433,0xf459,
0xf480,0xf4a9,0xf4d1,0xf4ff,0xf52c,0xf55c,0xf58c,0xf5c4,
0xf5fb,0xf637,0xf673,0xf6ad,0xf6e8,0xf727,0xf766,0xf7a7,
0xf7e8,0xf82a,0xf86b,0xf8ae,0xf8f0,0xf93a,0xf984,0xf9d0,
0xfa1c,0xfa6c,0xfabc,0xfb0d,0xfb5f,0xfbbe,0xfc1e,0xfc80,
0xfce2,0xfd45,0xfda8,0xfe19,0xfe8a,0xff0e,0xff92,0x0015,
0x0098,0x012c,0x01bf,0x0248,0x02d0,0x0353,0x03d6,0x0451,
0x04cd,0x053e,0x05b0,0x0621,0x0692,0x0707,0x077c,0x07e7,
0x0852,0x08c2,0x0931,0x09aa,0x0a23,0x0aa4,0x0b25,0x0baa,
0x0c2e,0x0ca8,0x0d23,0x0d93,0x0e04,0x0e75,0x0ee6};

static const short decodetable3[63]={
0xf3ed,0xf54d,0xf6ae,0xf7af,0xf8b1,0xf990,0xfa6f,0xfb39,
0xfc03,0xfcbd,0xfd77,0xfe1d,0xfec4,0xff58,0xffec,0x007b,
0x010b,0x0196,0x0220,0x02a5,0x032a,0x03a9,0x0429,0x04a1,
0x0519,0x058c,0x05fe,0x066d,0x06dc,0x0747,0x07b2,0x0817,
0x087b,0x08d9,0x0937,0x0990,0x09e8,0x0a3a,0x0a8c,0x0ad9,
0x0b26,0x0b6d,0x0bb4,0x0bf8,0x0c3d,0x0c7e,0x0cbf,0x0cfc,
0x0d3a,0x0d72,0x0dab,0x0ddf,0x0e13,0x0e44,0x0e75,0x0ea1,
0x0ecd,0x0ef5,0x0f1e,0x0f44,0x0f6b,0x0f8f,0x0fb4};

static const short decodetable4[63]={
0xf23b,0xf2ae,0xf321,0xf38c,0xf3f7,0xf457,0xf4b6,0xf517,
0xf578,0xf5d5,0xf631,0xf68d,0xf6e8,0xf742,0xf79b,0xf7f0,
0xf845,0xf896,0xf8e7,0xf937,0xf986,0xf9d6,0xfa26,0xfa74,
0xfac3,0xfb0f,0xfb5c,0xfbaa,0xfbf8,0xfc46,0xfc94,0xfce2,
0xfd2f,0xfd7f,0xfdcf,0xfe22,0xfe76,0xfec9,0xff1c,0xff73,
0xffca,0x0020,0x0077,0x00d0,0x0128,0x0186,0x01e4,0x0248,
0x02ab,0x0315,0x037f,0x03f1,0x0463,0x04e0,0x055d,0x05e8,
0x0673,0x0710,0x07ad,0x0872,0x0938,0x0a2f,0x0b26};

static const short decodetable5[31]={
0xf8cb,0xfa55,0xfbdf,0xfcea,0xfdf6,0xfed4,0xffb3,0x006f,
0x012d,0x01da,0x0287,0x032b,0x03cf,0x046a,0x0505,0x059a,
0x062e,0x06bf,0x0751,0x07e2,0x0873,0x0904,0x0994,0x0a22,
0x0aaf,0x0b3c,0x0bc9,0x0c56,0x0ce3,0x0d6a,0x0df1};

static const short decodetable6[31]={
0xf57d,0xf679,0xf775,0xf83d,0xf904,0xf9b5,0xfa65,0xfb04,
0xfba2,0xfc2f,0xfcbb,0xfd40,0xfdc5,0xfe44,0xfec4,0xff44,
0xffc5,0x0047,0x00c9,0x0150,0x01d6,0x0266,0x02f7,0x0396,
0x0435,0x04f3,0x05b1,0x0692,0x0774,0x0899,0x09bf};

static const short decodetable7[15]={
0xfaa4,0xfc65,0xfe26,0xff56,0x0085,0x017f,0x0278,0x0362,
0x044c,0x0537,0x0623,0x071f,0x081b,0x0946,0x0a70};

static const short decodetable8[15]={
0xf6ab,0xf7d8,0xf905,0xfa1b,0xfb31,0xfc32,0xfd33,0xfe22,
0xff11,0xfffe,0x00ea,0x01f6,0x0302,0x0462,0x05c2};

static const short decodetable9[15]={
0xf9df,0xfb3f,0xfca0,0xfdbc,0xfed8,0xffd1,0x00c8,0x01b3,
0x029e,0x038f,0x047f,0x0596,0x06ad,0x07ff,0x0951};

static const short decodetable10[15]={
0xf768,0xf890,0xf9b8,0xfac9,0xfbda,0xfcd0,0xfdc7,0xfea8,
0xff88,0x006c,0x0152,0x0258,0x035f,0x04da,0x0655};

static const short decodetable11[7]={
0xfd97,0xff2b,0x00be,0x01f0,0x0322,0x0476,0x05cb};

const short *decodetable[11]={
decodetable1,decodetable2,decodetable3,decodetable4,decodetable5,
decodetable6,decodetable7,decodetable8,decodetable9,decodetable10,
decodetable11};


static int ra144_decode_init(AVCodecContext * avctx)
{
	Real144_internal *glob=avctx->priv_data;

	memset(glob,0,sizeof(Real144_internal));
	glob->resetflag=1;
	glob->swapbuf1=glob->swapb1a;
	glob->swapbuf2=glob->swapb2a;
	glob->swapbuf1alt=glob->swapb1b;
	glob->swapbuf2alt=glob->swapb2b;

	memcpy(glob->wavtable1,wavtable1,sizeof(wavtable1));
	memcpy(glob->wavtable2,wavtable2,sizeof(wavtable2));

	return 0;
}

static void final(Real144_internal *glob, short *i1, short *i2, void *out, int *statbuf, int len);
static void add_wav(Real144_internal *glob, int n, int f, int m1, int m2, int m3, short *s1, short *s2, short *s3, short *dest);
static int irms(short *data, int factor);
static void rotate_block(short *source, short *target, int offset);
/* lookup square roots in table */
static int t_sqrt(unsigned int x)
{
  int s=0;
  while (x>0xfff) { s++; x=x>>2; }
  return (sqrt_table[x]<<s)<<2;
}

/* do 'voice' */
static void do_voice(int *a1, int *a2)
{
  int buffer[10];
  int *b1,*b2;
  int x,y;
  int *ptr,*tmp;
  
  b1=buffer;
  b2=a2;
  
  for (x=0;x<10;x++) {
    b1[x]=(*a1)<<4;

    if(x>0) {
      ptr=b2+x;
      for (y=0;y<=x-1;y++)
        b1[y]=(((*a1)*(*(--ptr)))>>12)+b2[y];
    }
    tmp=b1;
    b1=b2;
    b2=tmp;
    a1++;
  }  
  ptr=a2+10;
  while (ptr>a2) (*a2++)>>=4;
}


/* do quarter-block output */
static void do_output_subblock(Real144_internal *glob, int x)
{
  int a,b,c,d,e,f,g;

  if (x==1) memset(glob->buffer,0,20);
  if ((*glob->iptr)==0) a=0;
  else a=(*glob->iptr)+HALFBLOCK-1;
  glob->iptr++;
  b=*(glob->iptr++);
  c=*(glob->iptr++);
  d=*(glob->iptr++);
  if (a) rotate_block(glob->buffer_2,glob->buffer_a,a);
  memcpy(glob->buffer_b,etable1+b*BLOCKSIZE,BLOCKSIZE*2);
  e=((ftable1[b]>>4)*glob->gval)>>8;
  memcpy(glob->buffer_c,etable2+c*BLOCKSIZE,BLOCKSIZE*2);
  f=((ftable2[c]>>4)*glob->gval)>>8;
  if (a) g=irms(glob->buffer_a,glob->gval)>>12;
  else g=0;
  add_wav(glob,d,a,g,e,f,glob->buffer_a,glob->buffer_b,glob->buffer_c,glob->buffer_d);
  memmove(glob->buffer_2,glob->buffer_2+BLOCKSIZE,(BUFFERSIZE-BLOCKSIZE)*2);
  memcpy(glob->buffer_2+BUFFERSIZE-BLOCKSIZE,glob->buffer_d,BLOCKSIZE*2);
  final(glob,glob->gsp,glob->buffer_d,glob->output_buffer,glob->buffer,BLOCKSIZE);
}

/* rotate block */
static void rotate_block(short *source, short *target, int offset)
{
  short *end;
  short *ptr1;
  short *ptr2;
  short *ptr3;
  ptr2=source+BUFFERSIZE;
  ptr3=ptr1=ptr2-offset;
  end=target+BLOCKSIZE;
  while (target<end) {
    *(target++)=*(ptr3++);
    if (ptr3==ptr2) ptr3=ptr1;
  }
}

/* inverse root mean square */
static int irms(short *data, int factor)
{
  short *p1,*p2;
  unsigned int sum;
  p2=(p1=data)+BLOCKSIZE;
  for (sum=0;p2>p1;p1++) sum+=(*p1)*(*p1);
  if (sum==0) return 0; /* OOPS - division by zero */
  return (0x20000000/(t_sqrt(sum)>>8))*factor;
}

/* multiply/add wavetable */
static void add_wav(Real144_internal *glob, int n, int f, int m1, int m2, int m3, short *s1, short *s2, short *s3, short *dest)
{
  int a,b,c;
  int x;
  short *ptr,*ptr2;

  ptr=glob->wavtable1+n*9;
  ptr2=glob->wavtable2+n*9;
  if (f!=0) {
    a=((*ptr)*m1)>>((*ptr2)+1); 
  } else {
    a=0;
  }
  ptr++;ptr2++;
  b=((*ptr)*m2)>>((*ptr2)+1);
  ptr++;ptr2++;
  c=((*ptr)*m3)>>((*ptr2)+1);
  ptr2=(ptr=dest)+BLOCKSIZE;
  if (f!=0)
    while (ptr<ptr2)
      *(ptr++)=((*(s1++))*a+(*(s2++))*b+(*(s3++))*c)>>12;
  else
    while (ptr<ptr2)
      *(ptr++)=((*(s2++))*b+(*(s3++))*c)>>12;
}


static void final(Real144_internal *glob, short *i1, short *i2, void *out, int *statbuf, int len)
{
  int x,sum;
  int buffer[10];
  short *ptr;
  short *ptr2;

  memcpy(glob->work,statbuf,20);
  memcpy(glob->work+10,i2,len*2);

  buffer[9]=i1[0];
  buffer[8]=i1[1];
  buffer[7]=i1[2];
  buffer[6]=i1[3];
  buffer[5]=i1[4];
  buffer[4]=i1[5];
  buffer[3]=i1[6];
  buffer[2]=i1[7];
  buffer[1]=i1[8];
  buffer[0]=i1[9];

  ptr2=(ptr=glob->work)+len;
  while (ptr<ptr2) {
    for(sum=0,x=0;x<=9;x++)
      sum+=buffer[x]*(ptr[x]);
    sum=sum>>12;
    x=ptr[10]-sum;
    if (x<-32768 || x>32767)
    {
      memset(out,0,len*2);
      memset(statbuf,0,20);
      return;
    }
    ptr[10]=x;
    ptr++;
  }
  memcpy(out,ptr+10-len,len*2);
  memcpy(statbuf,ptr,20);
}

/* Decode 20-byte input */
static void unpack_input(unsigned char *input, unsigned int *output)
{
  unsigned int outbuffer[28];
  unsigned short inbuffer[10];
  unsigned int x;
  unsigned int *ptr;

  /* fix endianness */
  for (x=0;x<20;x+=2)
    inbuffer[x/2]=(input[x]<<8)+input[x+1];

  /* unpack */
  ptr=outbuffer;
  *(ptr++)=27;
  *(ptr++)=(inbuffer[0]>>10)&0x3f;
  *(ptr++)=(inbuffer[0]>>5)&0x1f;
  *(ptr++)=inbuffer[0]&0x1f;
  *(ptr++)=(inbuffer[1]>>12)&0xf;
  *(ptr++)=(inbuffer[1]>>8)&0xf;
  *(ptr++)=(inbuffer[1]>>5)&7;
  *(ptr++)=(inbuffer[1]>>2)&7;
  *(ptr++)=((inbuffer[1]<<1)&6)|((inbuffer[2]>>15)&1);
  *(ptr++)=(inbuffer[2]>>12)&7;
  *(ptr++)=(inbuffer[2]>>10)&3;
  *(ptr++)=(inbuffer[2]>>5)&0x1f;
  *(ptr++)=((inbuffer[2]<<2)&0x7c)|((inbuffer[3]>>14)&3);
  *(ptr++)=(inbuffer[3]>>6)&0xff;
  *(ptr++)=((inbuffer[3]<<1)&0x7e)|((inbuffer[4]>>15)&1);
  *(ptr++)=(inbuffer[4]>>8)&0x7f;
  *(ptr++)=(inbuffer[4]>>1)&0x7f;
  *(ptr++)=((inbuffer[4]<<7)&0x80)|((inbuffer[5]>>9)&0x7f);
  *(ptr++)=(inbuffer[5]>>2)&0x7f;
  *(ptr++)=((inbuffer[5]<<5)&0x60)|((inbuffer[6]>>11)&0x1f);
  *(ptr++)=(inbuffer[6]>>4)&0x7f;
  *(ptr++)=((inbuffer[6]<<4)&0xf0)|((inbuffer[7]>>12)&0xf);
  *(ptr++)=(inbuffer[7]>>5)&0x7f;
  *(ptr++)=((inbuffer[7]<<2)&0x7c)|((inbuffer[8]>>14)&3);
  *(ptr++)=(inbuffer[8]>>7)&0x7f;
  *(ptr++)=((inbuffer[8]<<1)&0xfe)|((inbuffer[9]>>15)&1);
  *(ptr++)=(inbuffer[9]>>8)&0x7f;
  *(ptr++)=(inbuffer[9]>>1)&0x7f;

  *(output++)=outbuffer[11];
  for (x=1;x<11;*(output++)=outbuffer[x++]);
  ptr=outbuffer+12;
  for (x=0;x<16;x+=4)
  {
    *(output++)=ptr[x];
    *(output++)=ptr[x+2];
    *(output++)=ptr[x+3];
    *(output++)=ptr[x+1];    
  }
}

static unsigned int rms(int *data, int f)
{
  int *c;
  int x;
  int d;
  unsigned int res;
  int b;

  c=data;
  b=0;
  res=0x10000;
  for (x=0;x<10;x++)
  {
    res=(((0x1000000-(*c)*(*c))>>12)*res)>>12;
    if (res==0) return 0;
    if (res<=0x3fff)
    {
      while (res<=0x3fff)
      {
        b++;
        res<<=2;
      }
    } else {
      if (res>0x10000)
        return 0; /* We're screwed, might as well go out with a bang. :P */
    }
    c++;
  }
  if (res>0) res=t_sqrt(res);

  res>>=(b+10);
  res=(res*f)>>10;
  return res;
}

static void dec1(Real144_internal *glob, int *data, int *inp, int n, int f)
{
  short *ptr,*end;

  *(glob->decptr++)=rms(data,f);
  glob->decptr++;
  end=(ptr=glob->decsp)+(n*10);
  while (ptr<end) *(ptr++)=*(inp++);
}

static int eq(Real144_internal *glob, short *in, int *target)
{
  int retval;
  int a;
  int b;
  int c;
  unsigned int u;
  short *sptr;
  int *ptr1,*ptr2,*ptr3;
  int *bp1,*bp2,*temp;

  retval=0;
  bp1=glob->buffer1;
  bp2=glob->buffer2;
  ptr2=(ptr3=glob->buffer2)+9;
  sptr=in;
  while (ptr2>=ptr3)
    *(ptr3++)=*(sptr++);

  target+=9;
  a=bp2[9];
  *target=a;
  if (a+0x1000>0x1fff)
    return 0; /* We're screwed, might as well go out with a bang. :P */
  c=8;u=a;
  while (c>=0)
  {
    if (u==0x1000) u++;
    if (u==0xfffff000) u--;
    b=0x1000-((u*u)>>12);
    if (b==0) b++;
    ptr2=bp1;
    ptr1=(ptr3=bp2)+c;
    for (u=0;u<=c;u++)
      *(ptr2++)=((*(ptr3++)-(((*target)*(*(ptr1--)))>>12))*(0x1000000/b))>>12;
    *(--target)=u=bp1[(c--)];
    if ((u+0x1000)>0x1fff) retval=1;
    temp=bp2;
    bp2=bp1;
    bp1=temp;
  }
  return retval;
}

static void dec2(Real144_internal *glob, int *data, int *inp, int n, int f, int *inp2, int l)
{
  unsigned int *ptr1,*ptr2;
  int work[10];
  int a,b;
  int x;
  int result;

  if(l+1<NBLOCKS/2) a=NBLOCKS-(l+1);
  else a=l+1;
  b=NBLOCKS-a;
  if (l==0)
  {
    glob->decsp=glob->sptr=glob->gbuf2;
    glob->decptr=glob->gbuf1;
  }
  ptr1=inp;
  ptr2=inp2;
  for (x=0;x<10*n;x++)
    *(glob->sptr++)=(a*(*ptr1++)+b*(*ptr2++))>>2;
  result=eq(glob,glob->decsp,work);
  if (result==1)
  {
    dec1(glob,data,inp,n,f);
  } else {
    *(glob->decptr++)=rms(work,f);
    glob->decptr++;
  }
  glob->decsp+=n*10;
}

/* Uncompress one block (20 bytes -> 160*2 bytes) */
static int ra144_decode_frame(AVCodecContext * avctx,
            void *data, int *data_size,
            uint8_t * buf, int buf_size)
{
  unsigned int a,b,c;
  long s;
  signed short *shptr;
  unsigned int *lptr,*temp;
  const short **dptr;
  void *datao;
  Real144_internal *glob=avctx->priv_data;

  datao = data;
  unpack_input(buf,glob->unpacked);
  
  glob->iptr=glob->unpacked;
  glob->val=decodetable[0][(*(glob->iptr++))<<1];

  dptr=decodetable+1;
  lptr=glob->swapbuf1;
  while (lptr<glob->swapbuf1+10)
    *(lptr++)=(*(dptr++))[(*(glob->iptr++))<<1];

  do_voice(glob->swapbuf1,glob->swapbuf2);

  a=t_sqrt(glob->val*glob->oldval)>>12;

  for (c=0;c<NBLOCKS;c++) {
    if (c==(NBLOCKS-1)) {
      dec1(glob,glob->swapbuf1,glob->swapbuf2,3,glob->val);
    } else {
      if (c*2==(NBLOCKS-2)) {
        if (glob->oldval<glob->val) {
          dec2(glob,glob->swapbuf1,glob->swapbuf2,3,a,glob->swapbuf2alt,c);
        } else {
          dec2(glob,glob->swapbuf1alt,glob->swapbuf2alt,3,a,glob->swapbuf2,c);
        }
      } else {
        if (c*2<(NBLOCKS-2)) {
          dec2(glob,glob->swapbuf1alt,glob->swapbuf2alt,3,glob->oldval,glob->swapbuf2,c);
        } else {
          dec2(glob,glob->swapbuf1,glob->swapbuf2,3,glob->val,glob->swapbuf2alt,c);
        }
      }
    }
  }

  /* do output */
  for (b=0,c=0;c<4;c++) {
    glob->gval=glob->gbuf1[c*2];
    glob->gsp=glob->gbuf2+b;
    do_output_subblock(glob,glob->resetflag);
    glob->resetflag=0;

    shptr=glob->output_buffer;
    while (shptr<glob->output_buffer+BLOCKSIZE) {
      s=*(shptr++)<<2;
      *((int16_t *)data)=s;
      if (s>32767) *((int16_t *)data)=32767;
      if (s<-32767) *((int16_t *)data)=-32768;
      ((int16_t *)data)++;
    }
    b+=30;
  }

  glob->oldval=glob->val;
  temp=glob->swapbuf1alt;
  glob->swapbuf1alt=glob->swapbuf1;
  glob->swapbuf1=temp;
  temp=glob->swapbuf2alt;
  glob->swapbuf2alt=glob->swapbuf2;
  glob->swapbuf2=temp;
  *data_size=data-datao;
  return 20;
}


AVCodec ra_144_decoder =
{
    "real_144",
    CODEC_TYPE_AUDIO,
    CODEC_ID_RA_144,
    sizeof(Real144_internal),
    ra144_decode_init,
    NULL,
    NULL,
    ra144_decode_frame,
};
