/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import java.io.PrintWriter;

public class RegMultiStringValue
extends RegistryValue {
    String[] data;
    int dataLen;

    public RegMultiStringValue(RegistryKey registryKey, String string) {
        super(registryKey, string, 7);
        this.data = null;
        this.dataLen = 0;
    }

    public RegMultiStringValue(RegistryKey registryKey, String string, int n) {
        super(registryKey, string, n);
        this.data = null;
        this.dataLen = 0;
    }

    public RegMultiStringValue(RegistryKey registryKey, String string, String[] stringArray) {
        super(registryKey, string, 7);
        this.setData(stringArray);
    }

    public String[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.dataLen;
    }

    public void setData(String[] stringArray) {
        this.data = stringArray;
        this.dataLen = stringArray.length;
    }

    @Override
    public byte[] getByteData() {
        int n = this.getByteLength();
        int n2 = 0;
        byte[] byArray = new byte[n];
        for (int i = 0; i < this.dataLen; ++i) {
            byte[] byArray2 = this.data[i].getBytes();
            for (int j = 0; j < byArray2.length; ++j) {
                byArray[n2++] = byArray2[j];
            }
            byArray[n2++] = 0;
        }
        return byArray;
    }

    @Override
    public int getByteLength() {
        int n = 0;
        for (int i = 0; i < this.dataLen; ++i) {
            n += this.data[i].length() + 1;
        }
        return n;
    }

    @Override
    public void setByteData(byte[] byArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] != 0) continue;
            ++n2;
        }
        n = 0;
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            stringArray[n] = new String(byArray, n3, i - n3);
            n3 = n;
        }
        this.setData(stringArray);
    }

    @Override
    public void export(PrintWriter printWriter) {
        int n;
        int n2 = 0;
        printWriter.println("\"" + this.getName() + "\"=hex(7):\\");
        for (n = 0; n < this.data.length; ++n) {
            n2 += this.data[n].length() + 1;
        }
        n = 0;
        byte[] byArray = new byte[++n2];
        for (int i = 0; i < this.data.length; ++i) {
            int n3 = this.data[i].length();
            byte[] byArray2 = this.data[i].getBytes();
            System.arraycopy(byArray2, 0, byArray, n, n3);
            n += n3;
            byArray[n++] = 0;
        }
        byArray[n++] = 0;
        RegistryValue.exportHexData(printWriter, byArray);
    }
}

