/*****************************************************************************
 * dvdplay.h: DVD Video Manager library, exported functions.
 *****************************************************************************
 * Copyright (C) 2002 VideoLAN
 * $Id: dvdplay.h,v 1.3 2003/01/29 20:55:26 sam Exp $
 *
 * Authors: Stphane Borel <stef@via.ecp.fr>
 *
 * Adapted from Ogle - A video player
 * Copyright (C) 2000, 2001 Hkan Hjort
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#ifndef _DVDPLAY_DVDPLAY_H
#define _DVDPLAY_DVDPLAY_H  1

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 * The libdvdplay basic structure
 *****************************************************************************/
typedef struct dvdplay_s* dvdplay_ptr;

/*****************************************************************************
 * Defines and flags
 *****************************************************************************/

/* events for caller application */
typedef enum
{
    NEW_DOMAIN      = 2,
    NEW_VTS         = 3,
    NEW_FILE        = 4,
    NEW_PGC         = 5,
    NEW_PG          = 6,
    NEW_CELL        = 7,
    END_OF_CELL     = 8,
    JUMP            = 9,
    STILL_TIME      = 10,
    COMPLETE_VIDEO  = 11,
    NEW_HIGHLIGHT   = 12
} dvdplay_event_t;

/* menu ids */
typedef enum
{
    TITLE_MENU      = 2,
    ROOT_MENU       = 3,
    SUBPICTURE_MENU = 4,
    AUDIO_MENU      = 5,
    ANGLE_MENU      = 6,
    PART_MENU       = 7,
} dvdplay_menu_t;

/*****************************************************************************
 * Exported prototypes
 *****************************************************************************/
extern dvdplay_ptr   dvdplay_open      ( char *,
                                  void(*pf_callback)( void*, dvdplay_event_t ),
                                        void * );
extern int           dvdplay_close     ( dvdplay_ptr );
extern char *        dvdplay_error     ( dvdplay_ptr );

/* Video Manager */
extern int           dvdplay_start     ( dvdplay_ptr, int );
extern int           dvdplay_reset     ( dvdplay_ptr );


#ifdef __cplusplus
}
#endif

#endif /* <dvdplay/dvdplay.h> */
