/* SPDX-License-Identifier: GPL-2.0+ */
/*
 *  Copyright (C) 2011 Samsung Electronics
 *  Lukasz Majewski <l.majewski@samsung.com>
 */

#ifndef __MAX8997_PMIC_H_
#define __MAX8997_PMIC_H_

/* MAX 8997 registers */
enum {
	MAX8997_REG_PMIC_ID0	= 0x00,
	MAX8997_REG_PMIC_ID1	= 0x01,
	MAX8997_REG_INTSRC	= 0x02,
	MAX8997_REG_INT1	= 0x03,
	MAX8997_REG_INT2	= 0x04,
	MAX8997_REG_INT3	= 0x05,
	MAX8997_REG_INT4	= 0x06,

	MAX8997_REG_INT1MSK	= 0x08,
	MAX8997_REG_INT2MSK	= 0x09,
	MAX8997_REG_INT3MSK	= 0x0a,
	MAX8997_REG_INT4MSK	= 0x0b,

	MAX8997_REG_STATUS1	= 0x0d,
	MAX8997_REG_STATUS2	= 0x0e,
	MAX8997_REG_STATUS3	= 0x0f,
	MAX8997_REG_STATUS4	= 0x10,

	MAX8997_REG_MAINCON1	= 0x13,
	MAX8997_REG_MAINCON2	= 0x14,
	MAX8997_REG_BUCKRAMP	= 0x15,

	MAX8997_REG_BUCK1CTRL	= 0x18,
	MAX8997_REG_BUCK1DVS1	= 0x19,
	MAX8997_REG_BUCK1DVS2	= 0x1a,
	MAX8997_REG_BUCK1DVS3	= 0x1b,
	MAX8997_REG_BUCK1DVS4	= 0x1c,
	MAX8997_REG_BUCK1DVS5	= 0x1d,
	MAX8997_REG_BUCK1DVS6	= 0x1e,
	MAX8997_REG_BUCK1DVS7	= 0x1f,
	MAX8997_REG_BUCK1DVS8	= 0x20,
	MAX8997_REG_BUCK2CTRL	= 0x21,
	MAX8997_REG_BUCK2DVS1	= 0x22,
	MAX8997_REG_BUCK2DVS2	= 0x23,
	MAX8997_REG_BUCK2DVS3	= 0x24,
	MAX8997_REG_BUCK2DVS4	= 0x25,
	MAX8997_REG_BUCK2DVS5	= 0x26,
	MAX8997_REG_BUCK2DVS6	= 0x27,
	MAX8997_REG_BUCK2DVS7	= 0x28,
	MAX8997_REG_BUCK2DVS8	= 0x29,
	MAX8997_REG_BUCK3CTRL	= 0x2a,
	MAX8997_REG_BUCK3DVS	= 0x2b,
	MAX8997_REG_BUCK4CTRL	= 0x2c,
	MAX8997_REG_BUCK4DVS	= 0x2d,
	MAX8997_REG_BUCK5CTRL	= 0x2e,
	MAX8997_REG_BUCK5DVS1	= 0x2f,
	MAX8997_REG_BUCK5DVS2	= 0x30,
	MAX8997_REG_BUCK5DVS3	= 0x31,
	MAX8997_REG_BUCK5DVS4	= 0x32,
	MAX8997_REG_BUCK5DVS5	= 0x33,
	MAX8997_REG_BUCK5DVS6	= 0x34,
	MAX8997_REG_BUCK5DVS7	= 0x35,
	MAX8997_REG_BUCK5DVS8	= 0x36,
	MAX8997_REG_BUCK6CTRL	= 0x37,
	MAX8997_REG_BUCK6BPSKIPCTRL	= 0x38,
	MAX8997_REG_BUCK7CTRL	= 0x39,
	MAX8997_REG_BUCK7DVS	= 0x3a,
	MAX8997_REG_LDO1CTRL	= 0x3b,
	MAX8997_REG_LDO2CTRL	= 0x3c,
	MAX8997_REG_LDO3CTRL	= 0x3d,
	MAX8997_REG_LDO4CTRL	= 0x3e,
	MAX8997_REG_LDO5CTRL	= 0x3f,
	MAX8997_REG_LDO6CTRL	= 0x40,
	MAX8997_REG_LDO7CTRL	= 0x41,
	MAX8997_REG_LDO8CTRL	= 0x42,
	MAX8997_REG_LDO9CTRL	= 0x43,
	MAX8997_REG_LDO10CTRL	= 0x44,
	MAX8997_REG_LDO11CTRL	= 0x45,
	MAX8997_REG_LDO12CTRL	= 0x46,
	MAX8997_REG_LDO13CTRL	= 0x47,
	MAX8997_REG_LDO14CTRL	= 0x48,
	MAX8997_REG_LDO15CTRL	= 0x49,
	MAX8997_REG_LDO16CTRL	= 0x4a,
	MAX8997_REG_LDO17CTRL	= 0x4b,
	MAX8997_REG_LDO18CTRL	= 0x4c,
	MAX8997_REG_LDO21CTRL	= 0x4d,

	MAX8997_REG_MBCCTRL1	= 0x50,
	MAX8997_REG_MBCCTRL2	= 0x51,
	MAX8997_REG_MBCCTRL3	= 0x52,
	MAX8997_REG_MBCCTRL4	= 0x53,
	MAX8997_REG_MBCCTRL5	= 0x54,
	MAX8997_REG_MBCCTRL6	= 0x55,
	MAX8997_REG_OTPCGHCVS	= 0x56,

	MAX8997_REG_SAFEOUTCTRL = 0x5a,

	MAX8997_REG_LBCNFG1	= 0x5e,
	MAX8997_REG_LBCNFG2	= 0x5f,
	MAX8997_REG_BBCCTRL	= 0x60,

	MAX8997_REG_FLASH1_CUR	= 0x63, /* 0x63 ~ 0x6e for FLASH */
	MAX8997_REG_FLASH2_CUR	= 0x64,
	MAX8997_REG_MOVIE_CUR	= 0x65,
	MAX8997_REG_GSMB_CUR	= 0x66,
	MAX8997_REG_BOOST_CNTL	= 0x67,
	MAX8997_REG_LEN_CNTL	= 0x68,
	MAX8997_REG_FLASH_CNTL	= 0x69,
	MAX8997_REG_WDT_CNTL	= 0x6a,
	MAX8997_REG_MAXFLASH1	= 0x6b,
	MAX8997_REG_MAXFLASH2	= 0x6c,
	MAX8997_REG_FLASHSTATUS	= 0x6d,
	MAX8997_REG_FLASHSTATUSMASK	= 0x6e,

	MAX8997_REG_GPIOCNTL1	= 0x70,
	MAX8997_REG_GPIOCNTL2	= 0x71,
	MAX8997_REG_GPIOCNTL3	= 0x72,
	MAX8997_REG_GPIOCNTL4	= 0x73,
	MAX8997_REG_GPIOCNTL5	= 0x74,
	MAX8997_REG_GPIOCNTL6	= 0x75,
	MAX8997_REG_GPIOCNTL7	= 0x76,
	MAX8997_REG_GPIOCNTL8	= 0x77,
	MAX8997_REG_GPIOCNTL9	= 0x78,
	MAX8997_REG_GPIOCNTL10	= 0x79,
	MAX8997_REG_GPIOCNTL11	= 0x7a,
	MAX8997_REG_GPIOCNTL12	= 0x7b,

	MAX8997_REG_LDO1CONFIG	= 0x80,
	MAX8997_REG_LDO2CONFIG	= 0x81,
	MAX8997_REG_LDO3CONFIG	= 0x82,
	MAX8997_REG_LDO4CONFIG	= 0x83,
	MAX8997_REG_LDO5CONFIG	= 0x84,
	MAX8997_REG_LDO6CONFIG	= 0x85,
	MAX8997_REG_LDO7CONFIG	= 0x86,
	MAX8997_REG_LDO8CONFIG	= 0x87,
	MAX8997_REG_LDO9CONFIG	= 0x88,
	MAX8997_REG_LDO10CONFIG	= 0x89,
	MAX8997_REG_LDO11CONFIG	= 0x8a,
	MAX8997_REG_LDO12CONFIG	= 0x8b,
	MAX8997_REG_LDO13CONFIG	= 0x8c,
	MAX8997_REG_LDO14CONFIG	= 0x8d,
	MAX8997_REG_LDO15CONFIG	= 0x8e,
	MAX8997_REG_LDO16CONFIG	= 0x8f,
	MAX8997_REG_LDO17CONFIG	= 0x90,
	MAX8997_REG_LDO18CONFIG	= 0x91,
	MAX8997_REG_LDO21CONFIG	= 0x92,

	MAX8997_REG_DVSOKTIMER1	= 0x97,
	MAX8997_REG_DVSOKTIMER2	= 0x98,
	MAX8997_REG_DVSOKTIMER4	= 0x99,
	MAX8997_REG_DVSOKTIMER5	= 0x9a,

	PMIC_NUM_OF_REGS = 0x9b,
};

#define ACTDISSAFEO1 (1 << 4)
#define ACTDISSAFEO2 (1 << 5)
#define ENSAFEOUT1 (1 << 6)
#define ENSAFEOUT2 (1 << 7)

#define ENBUCK (1 << 0)
#define ACTIVE_DISCHARGE (1 << 3)
#define GNSLCT (1 << 2)
#define LDO_ADE (1 << 1)
#define SAFEOUT_4_85V 0x00
#define SAFEOUT_4_90V 0x01
#define SAFEOUT_4_95V 0x02
#define SAFEOUT_3_30V 0x03

/* Charger */
#define DETBAT                  (1 << 2)
#define MBCICHFCSET             (1 << 4)
#define MBCHOSTEN               (1 << 6)
#define VCHGR_FC                (1 << 7)

#define CHARGER_MIN_CURRENT 200
#define CHARGER_MAX_CURRENT 950
#define CHARGER_CURRENT_RESOLUTION 50

#define MAX8997_I2C_ADDR        (0xCC >> 1)
#define MAX8997_RTC_ADDR	(0x0C >> 1)
#define MAX8997_MUIC_ADDR	(0x4A >> 1)
#define MAX8997_FG_ADDR	(0x6C >> 1)

enum {
	LDO_OFF = 0,
	LDO_ON = 1,

	DIS_LDO = (0x00 << 6),
	EN_LDO = (0x3 << 6),
};

#define MAX8997_LDO_MAX_VAL 0x3F
unsigned char max8997_reg_ldo(int uV);
#endif /* __MAX8997_PMIC_H_ */
