/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) 2020
 * Author(s): Giulio Benetti <giulio.benetti@benettiengineering.com>
 */

#ifndef _DT_BINDINGS_PINCTRL_IMXRT1020_PINFUNC_H
#define _DT_BINDINGS_PINCTRL_IMXRT1020_PINFUNC_H

/* TODO: continue from LPI2C4_SDA_SELECT_INPUT */

#define IMX_PAD_SION	0x40000000

/*
 * The pin function ID is a tuple of
 * <mux_reg conf_reg input_reg mux_mode input_val>
 */

#define MXRT1020_IOMUXC_GPIO_EMC_00_SEMC_DA00				0x014 0x188 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_00_QTIMER2_TIMER0			0x014 0x188 0x420 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_00_LPUART4_CTS_B			0x014 0x188 0x3E0 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_00_SPDIF_SR_CLK			0x014 0x188 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_00_LPSPI2_SCK				0x014 0x188 0x3B0 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_00_GPIO2_IO00				0x014 0x188 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_00_FLEXCAN1_TX				0x014 0x188 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_00_PIT_TRIGGER02			0x014 0x188 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_01_SEMC_DA01				0x018 0x18C 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_01_QTIMER2_TIMER1			0x018 0x18C 0x424 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_01_LPUART4_RTS_B			0x018 0x18C 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_01_SPDIF_OUT				0x018 0x18C 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_01_LPSPI2_PCS0				0x018 0x18C 0x3AC 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_01_GPIO2_IO01				0x018 0x18C 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_01_FLEXCAN1_RX				0x018 0x18C 0x320 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_01_PIT_TRIGGER03			0x018 0x18C 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_02_SEMC_DA02				0x01C 0x190 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_02_QTIMER2_TIMER2			0x01C 0x190 0x428 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_02_LPUART4_TX				0x01C 0x190 0x3E8 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_02_SPDIF_LOCK				0x01C 0x190 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_02_LPSPI2_SDO				0x01C 0x190 0x3B8 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_02_GPIO2_IO02				0x01C 0x190 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_02_LPI2C1_SCL				0x01C 0x190 0x37C 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_03_SEMC_DA03				0x020 0x194 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_03_QTIMER2_TIMER3			0x020 0x194 0x42C 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_03_LPUART4_RX				0x020 0x194 0x3E4 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_03_SPDIF_EXT_CLK			0x020 0x194 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_03_LPSPI2_SDI				0x020 0x194 0x3B4 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_03_GPIO2_IO03				0x020 0x194 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_03_LPI2C1_SDA				0x020 0x194 0x380 0x6 0x1

#define MXRT1020_IOMUXC_GPIO_EMC_04_SEMC_DA04				0x024 0x198 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_04_XBAR1_INOUT04			0x024 0x198 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_04_SPDIF_OUT				0x024 0x198 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_04_SAI2_TX_BCLK			0x024 0x198 0x464 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_04_FLEXIO1_FLEXIO16			0x024 0x198 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_04_GPIO2_IO04				0x024 0x198 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_05_SEMC_DA05				0x028 0x19C 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_05_XBAR1_INOUT05			0x028 0x19C 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_05_SPDIF_IN				0x028 0x19C 0x488 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_05_SAI2_TX_SYNC			0x028 0x19C 0x468 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_05_FLEXIO1_FLEXIO17			0x028 0x19C 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_05_GPIO2_IO05				0x028 0x19C 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_06_SEMC_DA06				0x02C 0x1A0 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_06_XBAR1_INOUT06			0x02C 0x1A0 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_06_LPUART3_TX				0x02C 0x1A0 0x3DC 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_06_SAI2_TX_DATA			0x02C 0x1A0 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_06_FLEXIO1_FLEXIO18			0x02C 0x1A0 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_06_GPIO2_IO06				0x02C 0x1A0 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_07_SEMC_DA07				0x030 0x1A4 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_07_XBAR1_INOUT07			0x030 0x1A4 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_07_LPUART3_RX				0x030 0x1A4 0x3D8 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_07_SAI2_RX_SYNC			0x030 0x1A4 0x460 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_07_FLEXIO1_FLEXIO19			0x030 0x1A4 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_07_GPIO2_IO07				0x030 0x1A4 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_08_SEMC_DM00				0x034 0x1A8 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_08_XBAR1_INOUT08			0x034 0x1A8 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_08_FLEXCAN2_TX				0x034 0x1A8 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_08_SAI2_RX_DATA			0x034 0x1A8 0x45C 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_08_FLEXIO1_FLEXIO20			0x034 0x1A8 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_08_GPIO2_IO08				0x034 0x1A8 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_09_SEMC_ADDR00				0x038 0x1AC 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_09_XBAR1_INOUT09			0x038 0x1AC 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_09_FLEXCAN2_RX				0x038 0x1AC 0x324 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_09_SAI2_RX_BCLK			0x038 0x1AC 0x458 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_09_FLEXIO1_FLEXIO21			0x038 0x1AC 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_09_GPIO2_IO09				0x038 0x1AC 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_10_SEMC_CAS				0x03C 0x1B0 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_10_XBAR1_INOUT10			0x03C 0x1B0 0x4B0 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_10_LPI2C4_SDA				0x03C 0x1B0 0x398 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_10_SAI1_TX_SYNC			0x03C 0x1B0 0x450 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_10_LPSPI2_SCK				0x03C 0x1B0 0x3B0 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_10_GPIO2_IO10				0x03C 0x1B0 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_10_FLEXPWM2_PWMX00			0x03C 0x1B0 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_11_SEMC_RAS				0x040 0x1B4 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_11_XBAR1_INOUT11			0x040 0x1B4 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_11_LPI2C4_SCL				0x040 0x1B4 0x394 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_11_SAI1_TX_BCLK			0x040 0x1B4 0x44C 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_11_LPSPI2_PCS0				0x040 0x1B4 0x3AC 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_11_GPIO2_IO11				0x040 0x1B4 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_11_FLEXPWM2_PWMX01			0x040 0x1B4 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_12_SEMC_CS0				0x044 0x1B8 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_12_XBAR1_INOUT12			0x044 0x1B8 0x4B4 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_12_LPUART6_TX				0x044 0x1B8 0x3F8 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_12_SAI1_TX_DATA00			0x044 0x1B8 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_12_LPSPI2_SDO				0x044 0x1B8 0x3B8 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_12_GPIO2_IO12				0x044 0x1B8 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_12_FLEXPWM2_PWMX02			0x044 0x1B8 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_13_SEMC_BA0				0x048 0x1BC 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_13_XBAR1_INOUT13			0x048 0x1BC 0x4B8 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_13_LPUART6_RX				0x048 0x1BC 0x3F4 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_13_SAI1_RX_DATA00			0x048 0x1BC 0x438 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_13_LPSPI2_SDI				0x048 0x1BC 0x3B4 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_13_GPIO2_IO13				0x048 0x1BC 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_13_FLEXPWM2_PWMX03			0x048 0x1BC 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_13_CCM_PMIC_RDY			0x048 0x1BC 0x300 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_14_SEMC_BA1				0x04C 0x1C0 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_14_XBAR1_INOUT14			0x04C 0x1C0 0x4A0 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_14_LPUART6_CTS_B			0x04C 0x1C0 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_14_SAI1_RX_BCLK			0x04C 0x1C0 0x434 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_14_LPSPI2_PCS1				0x04C 0x1C0 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_14_GPIO2_IO14				0x04C 0x1C0 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_14_FLEXCAN1_TX				0x04C 0x1C0 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_15_SEMC_ADDR10				0x050 0x1C4 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_15_XBAR1_INOUT15			0x050 0x1C4 0x4A4 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_15_LPUART6_RTS_B			0x050 0x1C4 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_15_SAI1_RX_SYNC			0x050 0x1C4 0x448 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_15_WDOG1_B				0x050 0x1C4 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_15_GPIO2_IO15				0x050 0x1C4 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_15_FLEXCAN1_RX				0x050 0x1C4 0x320 0x6 0x3

#define MXRT1020_IOMUXC_GPIO_EMC_16_SEMC_ADDR00				0x054 0x1C8 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_16_MQS_RIGHT				0x054 0x1C8 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_16_SAI2_MCLK				0x054 0x1C8 0x454 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_16_GPIO2_IO16				0x054 0x1C8 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_16_SRC_BOOT_MODE00			0x054 0x1C8 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_17_SEMC_ADDR01				0x058 0x1CC 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_17_MQS_LEFT				0x058 0x1CC 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_17_SAI3_MCLK				0x058 0x1CC 0x46C 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_17_GPIO2_IO17				0x058 0x1CC 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_17_SRC_BOOT_MODE01			0x058 0x1CC 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_18_SEMC_ADDR02				0x05C 0x1D0 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_18_XBAR1_INOUT16			0x05C 0x1D0 0x4A8 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_18_LPI2C2_SDA				0x05C 0x1D0 0x388 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_18_SAI1_RX_SYNC			0x05C 0x1D0 0x448 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_EMC_18_FLEXIO1_FLEXIO22			0x05C 0x1D0 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_18_GPIO2_IO18				0x05C 0x1D0 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_18_SRC_BT_CFG00			0x05C 0x1D0 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_19_SEMC_ADDR03				0x060 0x1D4 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_19_XBAR1_INOUT17			0x060 0x1D4 0x4AC 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_19_LPI2C2_SCL				0x060 0x1D4 0x384 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_19_SAI1_RX_BCLK			0x060 0x1D4 0x434 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_EMC_19_FLEXIO1_FLEXIO23			0x060 0x1D4 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_19_GPIO2_IO19				0x060 0x1D4 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_19_SRC_BT_CFG01			0x060 0x1D4 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_20_SEMC_ADDR04				0x064 0x1D8 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_20_FLEXPWM1_PWMA03			0x064 0x1D8 0x334 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_20_LPUART2_CTS_B			0x064 0x1D8 0x3CC 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_20_SAI1_MCLK				0x064 0x1D8 0x430 0x3 0x3
#define MXRT1020_IOMUXC_GPIO_EMC_20_FLEXIO1_FLEXIO24			0x064 0x1D8 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_20_GPIO2_IO20				0x064 0x1D8 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_20_SRC_BT_CFG02			0x064 0x1D8 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_21_SEMC_ADDR05				0x068 0x1DC 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_21_FLEXPWM1_PWMB03			0x068 0x1DC 0x344 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_21_LPUART2_RTS_B			0x068 0x1DC 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_21_SAI1_RX_DATA00			0x068 0x1DC 0x438 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_EMC_21_FLEXIO1_FLEXIO25			0x068 0x1DC 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_21_GPIO2_IO21				0x068 0x1DC 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_21_SRC_BT_CFG03			0x068 0x1DC 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_22_SEMC_ADDR06				0x06C 0x1E0 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_22_FLEXPWM1_PWMA02			0x06C 0x1E0 0x330 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_22_LPUART2_TX				0x06C 0x1E0 0x3D4 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_22_SAI1_TX_DATA03			0x06C 0x1E0 0x43C 0x3 0x1

#define MXRT1020_IOMUXC_GPIO_EMC_22_FLEXIO1_FLEXIO26			0x06C 0x1E0 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_22_GPIO2_IO22				0x06C 0x1E0 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_22_SRC_BT_CFG04			0x06C 0x1E0 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_23_SEMC_ADDR07				0x070 0x1E4 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_23_FLEXPWM1_PWMB02			0x070 0x1E4 0x340 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_23_LPUART2_RX				0x070 0x1E4 0x3D0 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_23_SAI1_TX_DATA02			0x070 0x1E4 0x440 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_23_FLEXIO1_FLEXIO27			0x070 0x1E4 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_23_GPIO2_IO23				0x070 0x1E4 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_23_SRC_BT_CFG05			0x070 0x1E4 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_24_SEMC_ADDR08				0x074 0x1E8 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_24_FLEXPWM1_PWMA01			0x074 0x1E8 0x32C 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_24_LPUART8_CTS_B			0x074 0x1E8 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_24_SAI1_TX_DATA01			0x074 0x1E8 0x444 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_24_FLEXIO1_FLEXIO28			0x074 0x1E8 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_24_GPIO2_IO24				0x074 0x1E8 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_24_SRC_BT_CFG06			0x074 0x1E8 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_25_SEMC_ADDR09				0x078 0x1EC 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_25_FLEXPWM1_PWMB01			0x078 0x1EC 0x33C 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_25_LPUART8_RTS_B			0x078 0x1EC 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_25_SAI1_TX_DATA00			0x078 0x1EC 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_25_FLEXIO1_FLEXIO29			0x078 0x1EC 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_25_GPIO2_IO25				0x078 0x1EC 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_25_SRC_BT_CFG07			0x078 0x1EC 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_26_SEMC_ADDR11				0x07C 0x1F0 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_26_FLEXPWM1_PWMA00			0x07C 0x1F0 0x328 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_26_LPUART8_TX				0x07C 0x1F0 0x408 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_26_SAI1_TX_BCLK			0x07C 0x1F0 0x44C 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_EMC_26_FLEXIO1_FLEXIO30			0x07C 0x1F0 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_26_GPIO2_IO26				0x07C 0x1F0 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_26_SRC_BT_CFG08			0x07C 0x1F0 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_27_SEMC_ADDR12				0x080 0x1F4 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_27_FLEXPWM1_PWMB00			0x080 0x1F4 0x338 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_27_LPUART8_RX				0x080 0x1F4 0x404 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_27_SAI1_TX_SYNC			0x080 0x1F4 0x450 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_EMC_27_FLEXIO1_FLEXIO31			0x080 0x1F4 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_27_GPIO2_IO27				0x080 0x1F4 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_27_SRC_BT_CFG09			0x080 0x1F4 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_28_SEMC_DQS				0x084 0x1F8 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_28_FLEXPWM2_PWMA03			0x084 0x1F8 0x354 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_28_XBAR1_INOUT18			0x084 0x1F8 0x4BC 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_28_SAI3_MCLK				0x084 0x1F8 0x46C 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_EMC_28_EWM_OUT_B				0x084 0x1F8 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_28_GPIO2_IO28				0x084 0x1F8 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_28_GPT2_CAPTURE2			0x084 0x1F8 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_28_FLEXPWM1_PWMX00			0x084 0x1F8 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_29_SEMC_CKE				0x088 0x1FC 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_29_FLEXPWM2_PWMB03			0x088 0x1FC 0x364 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_29_XBAR1_INOUT19			0x088 0x1FC 0x4C0 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_29_SAI3_RX_BCLK			0x088 0x1FC 0x470 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_29_WDOG2_RST_B_DEB			0x088 0x1FC 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_29_GPIO2_IO29				0x088 0x1FC 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_29_GPT2_COMPARE2			0x088 0x1FC 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_29_FLEXPWM1_PWMX01			0x088 0x1FC 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_30_SEMC_CLK				0x08C 0x200 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_30_FLEXPWM2_PWMA02			0x08C 0x200 0x350 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_30_LPUART4_CTS_B			0x08C 0x200 0x3E0 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_30_SAI3_RX_SYNC			0x08C 0x200 0x478 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_30_WDOG1_RST_B_DEB			0x08C 0x200 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_30_GPIO2_IO30				0x08C 0x200 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_30_GPT2_COMPARE3			0x08C 0x200 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_30_FLEXPWM1_PWMX02			0x08C 0x200 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_31_SEMC_DM01				0x090 0x204 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_31_FLEXPWM2_PWMB02			0x090 0x204 0x360 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_31_LPUART4_RTS_B			0x090 0x204 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_31_SAI3_RX_DATA			0x090 0x204 0x474 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_31_WDOG2_B				0x090 0x204 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_31_GPIO2_IO31				0x090 0x204 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_31_GPT2_CLK				0x090 0x204 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_31_FLEXPWM1_PWMX03			0x090 0x204 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_32_SEMC_DATA08				0x094 0x208 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_32_QTIMER1_TIMER0			0x094 0x208 0x410 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_32_LPUART4_TX				0x094 0x208 0x3E8 0x2 0x2
#define MXRT1020_IOMUXC_GPIO_EMC_32_SAI3_TX_DATA			0x094 0x208 0x000 0x3 0x4
#define MXRT1020_IOMUXC_GPIO_EMC_32_LPSPI4_SCK				0x094 0x208 0x3C0 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_32_GPIO3_IO00				0x094 0x208 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_32_REF_24M_OUT				0x094 0x208 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_33_SEMC_DATA09				0x098 0x20C 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_33_QTIMER1_TIMER1			0x098 0x20C 0x414 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_33_LPUART4_RX				0x098 0x20C 0x3E4 0x2 0x2
#define MXRT1020_IOMUXC_GPIO_EMC_33_SAI3_TX_BCLK			0x098 0x20C 0x47C 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_33_LPSPI4_PCS0				0x098 0x20C 0x3BC 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_33_GPIO3_IO01				0x098 0x20C 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_34_SEMC_DATA10				0x09C 0x210 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_34_QTIMER1_TIMER2			0x09C 0x210 0x418 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_34_LPUART7_TX				0x09C 0x210 0x400 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_34_SAI3_TX_SYNC			0x09C 0x210 0x480 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_34_LPSPI4_SDO				0x09C 0x210 0x3C8 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_34_GPIO3_IO02				0x09C 0x210 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_34_ENET_CRS				0x09C 0x210 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_35_SEMC_DATA11				0x0A0 0x214 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_35_QTIMER1_TIMER3			0x0A0 0x214 0x41C 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_35_LPUART7_RX				0x0A0 0x214 0x3FC 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_35_USDHC2_WP				0x0A0 0x214 0x49C 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_35_LPSPI4_SDI				0x0A0 0x214 0x3C4 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_35_GPIO3_IO03				0x0A0 0x214 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_35_ENET_COL				0x0A0 0x214 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_36_SEMC_DATA12				0x0A4 0x218 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_36_FLEXPWM2_PWMA01			0x0A4 0x218 0x34C 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_36_LPUART5_CTS_B			0x0A4 0x218 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_36_CCM_PMIC_RDY			0x0A4 0x218 0x300 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_36_LPSPI4_PCS1				0x0A4 0x218 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_36_GPIO3_IO04				0x0A4 0x218 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_36_ENET_RX_CLK				0x0A4 0x218 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_36_USDHC1_WP				0x0A4 0x218 0x494 0x7 0x4

#define MXRT1020_IOMUXC_GPIO_EMC_37_SEMC_DATA13				0x0A8 0x21C 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_37_FLEXPWM2_PWMB01			0x0A8 0x21C 0x35C 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_37_LPUART5_RTS_B			0x0A8 0x21C 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_37_MQS_RIGHT				0x0A8 0x21C 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_37_LPSPI4_PCS2				0x0A8 0x21C 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_37_GPIO3_IO05				0x0A8 0x21C 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_37_ENET_RDATA03			0x0A8 0x21C 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_37_USDHC1_VSELECT			0x0A8 0x21C 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_38_SEMC_DATA14				0x0AC 0x220 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_38_FLEXPWM2_PWMA00			0x0AC 0x220 0x348 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_38_LPUART5_TX				0x0AC 0x220 0x3F0 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_38_MQS_LEFT				0x0AC 0x220 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_38_LPSPI4_PCS3				0x0AC 0x220 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_38_GPIO3_IO06				0x0AC 0x220 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_38_ENET_RDATA02			0x0AC 0x220 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_38_USDHC1_CD_B				0x0AC 0x220 0x490 0x7 0x3

#define MXRT1020_IOMUXC_GPIO_EMC_39_SEMC_DATA15				0x0B0 0x224 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_39_FLEXPWM2_PWMB00			0x0B0 0x224 0x358 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_39_LPUART5_RX				0x0B0 0x224 0x3EC 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_39_USB_OTG1_OC				0x0B0 0x224 0x48C 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_EMC_39_WDOG1_B				0x0B0 0x224 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_39_GPIO3_IO07				0x0B0 0x224 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_39_ENET_TX_ER				0x0B0 0x224 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_39_GPT1_CLK				0x0B0 0x224 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_40_SEMC_CSX00				0x0B4 0x228 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_40_XBAR1_INOUT18			0x0B4 0x228 0x4BC 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_40_SPDIF_OUT				0x0B4 0x228 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_40_USB_OTG1_ID				0x0B4 0x228 0x2FC 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_EMC_40_ENET_MDIO				0x0B4 0x228 0x308 0x4 0x2
#define MXRT1020_IOMUXC_GPIO_EMC_40_GPIO3_IO08				0x0B4 0x228 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_40_ENET_TDATA03			0x0B4 0x228 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_40_GPT1_COMPARE3			0x0B4 0x228 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_EMC_41_SEMC_READY				0x0B8 0x22C 0x484 0x0 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_41_XBAR1_INOUT19			0x0B8 0x22C 0x4C0 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_41_SPDIF_IN				0x0B8 0x22C 0x488 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_41_USB_OTG1_PWR			0x0B8 0x22C 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_41_ENET_MDC				0x0B8 0x22C 0x000 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_EMC_41_GPIO3_IO09				0x0B8 0x22C 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_41_ENET_TDATA02			0x0B8 0x22C 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_EMC_41_GPT1_COMPARE2			0x0B8 0x22C 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_00_JTAG_TMS				0x0BC 0x230 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_00_GPIO1_IO00			0x0BC 0x230 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_00_GPT1_COMPARE1			0x0BC 0x230 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_01_JTAG_TCK				0x0C0 0x234 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_01_GPIO1_IO01			0x0C0 0x234 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_01_GPT1_CAPTURE2			0x0C0 0x234 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_02_JTAG_MOD				0x0C4 0x238 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_02_GPIO1_IO02			0x0C4 0x238 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_02_GPT1_CAPTURE1			0x0C4 0x238 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_03_JTAG_TDI				0x0C8 0x23C 0x000 0x0 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_03_USDHC2_CD_B			0x0C8 0x23C 0x498 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_03_WDOG1_B				0x0C8 0x23C 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_03_SAI1_MCLK				0x0C8 0x23C 0x430 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_03_USDHC1_WP				0x0C8 0x23C 0x494 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_03_GPIO1_IO03			0x0C8 0x23C 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_03_USB_OTG1_OC			0x0C8 0x23C 0x48C 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_03_CCM_PMIC_RDY			0x0C8 0x23C 0x300 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_04_JTAG_TDO				0x0CC 0x240 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_04_FLEXCAN1_TX			0x0CC 0x240 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_04_USDHC1_WP				0x0CC 0x240 0x494 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_04_QTIMER2_TIMER0			0x0CC 0x240 0x420 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_04_ENET_MDIO				0x0CC 0x240 0x308 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_04_GPIO1_IO04			0x0CC 0x240 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_04_USB_OTG1_PWR			0x0CC 0x240 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_04_EWM_OUT_B				0x0CC 0x240 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_05_JTAG_TRSTB			0x0D0 0x244 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_05_FLEXCAN1_RX			0x0D0 0x244 0x320 0x1 0x2
#define MXRT1020_IOMUXC_GPIO_AD_B0_05_USDHC1_CD_B			0x0D0 0x244 0x490 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_05_QTIMER2_TIMER1			0x0D0 0x244 0x424 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_05_ENET_MDC				0x0D0 0x244 0x000 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_05_GPIO1_IO05			0x0D0 0x244 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_05_USB_OTG1_ID			0x0D0 0x244 0x2FC 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_05_NMI_GLUE_NMI			0x0D0 0x244 0x40C 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_06_PIT_TRIGGER00			0x0D4 0x248 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_06_MQS_RIGHT				0x0D4 0x248 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_06_LPUART1_TX			0x0D4 0x248 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_06_QTIMER2_TIMER2			0x0D4 0x248 0x428 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_06_FLEXPWM2_PWMA03			0x0D4 0x248 0x354 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_06_GPIO1_IO06			0x0D4 0x248 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_06_REF_32K_OUT			0x0D4 0x248 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_07_PIT_TRIGGER01			0x0D8 0x24C 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_07_MQS_LEFT				0x0D8 0x24C 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_07_LPUART1_RX			0x0D8 0x24C 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_07_QTIMER2_TIMER3			0x0D8 0x24C 0x42C 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_07_FLEXPWM2_PWMB03			0x0D8 0x24C 0x364 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_07_GPIO1_IO07			0x0D8 0x24C 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_07_REF_24M_OUT			0x0D8 0x24C 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_08_ENET_TX_CLK			0x0DC 0x250 0x31C 0x0 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_08_LPI2C3_SCL			0x0DC 0x250 0x38C 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_08_LPUART1_CTS_B			0x0DC 0x250 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_08_KPP_COL00				0x0DC 0x250 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_08_ENET_REF_CLK1			0x0DC 0x250 0x304 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_08_GPIO1_IO08			0x0DC 0x250 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_08_ARM_CM7_TXEV			0x0DC 0x250 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_09_ENET_RDATA01			0x0E0 0x254 0x310 0x0 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_09_LPI2C3_SDA			0x0E0 0x254 0x390 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_09_LPUART1_RTS_B			0x0E0 0x254 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_09_KPP_ROW00				0x0E0 0x254 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_09_GPIO1_IO09			0x0E0 0x254 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_09_ARM_CM7_RXEV			0x0E0 0x254 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_10_ENET_RDATA00			0x0E4 0x258 0x30C 0x0 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_10_LPSPI1_SCK			0x0E4 0x258 0x3A0 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_10_LPUART5_TX			0x0E4 0x258 0x3F0 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_10_KPP_COL01				0x0E4 0x258 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_10_FLEXPWM2_PWMA02			0x0E4 0x258 0x350 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_10_GPIO1_IO10			0x0E4 0x258 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_10_ARM_CM7_TRACE_CLK			0x0E4 0x258 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_11_ENET_RX_EN			0x0E8 0x25C 0x314 0x0 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_11_LPSPI1_PCS0			0x0E8 0x25C 0x39C 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_11_LPUART5_RX			0x0E8 0x25C 0x3EC 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_11_KPP_ROW01				0x0E8 0x25C 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_11_FLEXPWM2_PWMB02			0x0E8 0x25C 0x360 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_11_GPIO1_IO11			0x0E8 0x25C 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_11_ARM_CM7_TRACE_SWO			0x0E8 0x25C 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_12_ENET_RX_ER			0x0EC 0x260 0x318 0x0 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_12_LPSPI1_SDO			0x0EC 0x260 0x3A8 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_12_LPUART3_CTS_B			0x0EC 0x260 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_12_KPP_COL02				0x0EC 0x260 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_12_FLEXPWM2_PWMA01			0x0EC 0x260 0x34C 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_12_GPIO1_IO12			0x0EC 0x260 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_12_ARM_CM7_TRACE00			0x0EC 0x260 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_12_SNVS_HP_VIO_5_CTL			0x0EC 0x260 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_13_ENET_TX_EN			0x0F0 0x264 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_13_LPSPI1_SDI			0x0F0 0x264 0x3A4 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_13_LPUART3_RTS_B			0x0F0 0x264 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_13_KPP_ROW02				0x0F0 0x264 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_13_FLEXPWM2_PWMB01			0x0F0 0x264 0x35C 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_13_GPIO1_IO13			0x0F0 0x264 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_13_ARM_CM7_TRACE01			0x0F0 0x264 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_13_SNVS_HP_VIO_5_B			0x0F0 0x264 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_14_ENET_TDATA00			0x0F4 0x268 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_14_FLEXCAN2_TX			0x0F4 0x268 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_14_LPUART3_TX			0x0F4 0x268 0x3DC 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_14_KPP_COL03				0x0F4 0x268 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_14_FLEXPWM2_PWMA00			0x0F4 0x268 0x348 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_14_GPIO1_IO14			0x0F4 0x268 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_14_ARM_CM7_TRACE02			0x0F4 0x268 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_14_WDOG1_ANY				0x0F4 0x268 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B0_15_ENET_TDATA01			0x0F8 0x26C 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_15_FLEXCAN2_RX			0x0F8 0x26C 0x324 0x1 0x2
#define MXRT1020_IOMUXC_GPIO_AD_B0_15_LPUART3_RX			0x0F8 0x26C 0x3D8 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B0_15_KPP_ROW03				0x0F8 0x26C 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_15_FLEXPWM2_PWMB00			0x0F8 0x26C 0x358 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_15_GPIO1_IO15			0x0F8 0x26C 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B0_15_ARM_CM7_TRACE03			0x0F8 0x26C 0x000 0x6 0x2

#define MXRT1020_IOMUXC_GPIO_AD_B1_00_SEMC_READY			0x0FC 0x270 0x484 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_00_FLEXSPI_A_DATA03			0x0FC 0x270 0x374 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_00_FLEXCAN2_TX			0x0FC 0x270 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_00_SAI1_MCLK				0x0FC 0x270 0x430 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_AD_B1_00_FLEXIO1_FLEXIO15			0x0FC 0x270 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_00_GPIO1_IO16			0x0FC 0x270 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_00_ENET_1588_EVENT2_OUT		0x0FC 0x270 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_00_KPP_COL04				0x0FC 0x270 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_01_SEMC_CSX00			0x100 0x274 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_01_FLEXSPI_A_SCLK			0x100 0x274 0x378 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_01_FLEXCAN2_RX			0x100 0x274 0x324 0x2 0x3
#define MXRT1020_IOMUXC_GPIO_AD_B1_01_SAI1_TX_BCLK			0x100 0x274 0x44C 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_AD_B1_01_FLEXIO1_FLEXIO14			0x100 0x274 0x000 0x4 0x2
#define MXRT1020_IOMUXC_GPIO_AD_B1_01_GPIO1_IO17			0x100 0x274 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_01_ENET_1588_EVENT2_IN		0x100 0x274 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_01_KPP_ROW04				0x100 0x274 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_02_SEMC_CSX01			0x104 0x278 0x000 0x0 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_02_FLEXSPI_A_DATA00			0x104 0x278 0x368 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_02_LPSPI4_SCK			0x104 0x278 0x3C0 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_02_SAI1_TX_SYNC			0x104 0x278 0x450 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_AD_B1_02_FLEXIO1_FLEXIO13			0x104 0x278 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_02_GPIO1_IO18			0x104 0x278 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_02_ENET_1588_EVENT3_OUT		0x104 0x278 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_02_KPP_COL05				0x104 0x278 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_03_SEMC_CSX02			0x108 0x27C 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_03_FLEXSPI_A_DATA02			0x108 0x27C 0x370 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_03_LPSPI4_PCS0			0x108 0x27C 0x3BC 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_03_SAI1_TX_DATA00			0x108 0x27C 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_03_FLEXIO1_FLEXIO12			0x108 0x27C 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_03_GPIO1_IO19			0x108 0x27C 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_03_ENET_1588_EVENT3_IN		0x108 0x27C 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_03_KPP_ROW05				0x108 0x27C 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_04_SEMC_CSX03			0x10C 0x280 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_04_FLEXSPI_A_DATA01			0x10C 0x280 0x36C 0x1 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_04_LPSPI4_SDO			0x10C 0x280 0x3C8 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_04_SAI1_RX_SYNC			0x10C 0x280 0x448 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_04_FLEXIO1_FLEXIO11			0x10C 0x280 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_04_GPIO1_IO20			0x10C 0x280 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_04_LPSPI1_PCS1			0x10C 0x280 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_04_KPP_COL06				0x10C 0x280 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_05_USDHC1_WP				0x110 0x284 0x494 0x0 0x2
#define MXRT1020_IOMUXC_GPIO_AD_B1_05_FLEXSPI_A_SS0_B			0x110 0x284 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_05_LPSPI4_SDI			0x110 0x284 0x3C4 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_05_SAI1_RX_DATA00			0x110 0x284 0x438 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_05_FLEXIO1_FLEXIO10			0x110 0x284 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_05_GPIO1_IO21			0x110 0x284 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_05_LPSPI1_PCS2			0x110 0x284 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_05_KPP_ROW06				0x110 0x284 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_06_USDHC1_RESET_B			0x114 0x288 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_06_FLEXPWM1_PWMA00			0x114 0x288 0x328 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_06_LPUART2_CTS_B			0x114 0x288 0x3CC 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_06_SAI1_RX_BCLK			0x114 0x288 0x434 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_06_FLEXIO1_FLEXIO09			0x114 0x288 0x000 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_06_GPIO1_IO22			0x114 0x288 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_06_LPSPI1_PCS3			0x114 0x288 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_06_KPP_COL07				0x114 0x288 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_07_USDHC1_VSELECT			0x118 0x28C 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_07_FLEXPWM1_PWMB00			0x118 0x28C 0x338 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_07_LPUART2_RTS_B			0x118 0x28C 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_07_SAI1_TX_DATA01			0x118 0x28C 0x444 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_07_FLEXIO1_FLEXIO08			0x118 0x28C 0x000 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_07_GPIO1_IO23			0x118 0x28C 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_07_LPSPI3_PCS3			0x118 0x28C 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_07_KPP_ROW07				0x118 0x28C 0x000 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_08_LPI2C2_SCL			0x11C 0x290 0x384 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_08_FLEXPWM1_PWMA01			0x11C 0x290 0x32C 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_08_LPUART2_TX			0x11C 0x290 0x3D4 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_08_SAI1_TX_DATA02			0x11C 0x290 0x440 0x3 0x3
#define MXRT1020_IOMUXC_GPIO_AD_B1_08_FLEXIO1_FLEXIO07			0x11C 0x290 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_08_GPIO1_IO24			0x11C 0x290 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_08_LPSPI3_PCS2			0x11C 0x290 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_08_XBAR1_INOUT12			0x11C 0x290 0x4B4 0x7 0x1

#define MXRT1020_IOMUXC_GPIO_AD_B1_09_LPI2C2_SDA			0x120 0x294 0x388 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_09_FLEXPWM1_PWMB01			0x120 0x294 0x33C 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_09_LPUART2_RX			0x120 0x294 0x3D0 0x2 0x2
#define MXRT1020_IOMUXC_GPIO_AD_B1_09_SAI1_TX_DATA03			0x120 0x294 0x43C 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_09_FLEXIO1_FLEXIO26			0x120 0x294 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_09_GPIO1_IO25			0x120 0x294 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_09_LPSPI3_PCS1			0x120 0x294 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_09_XBAR1_INOUT13			0x120 0x294 0x4B8 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_10_USB_OTG1_PWR			0x124 0x298 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_10_FLEXPWM1_PWMA02			0x124 0x298 0x330 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_10_LPUART4_TX			0x124 0x298 0x3E8 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_10_USDHC1_CD_B			0x124 0x298 0x490 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_AD_B1_10_FLEXIO1_FLEXIO05			0x124 0x298 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_10_GPIO1_IO26			0x124 0x298 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_10_GPT2_CAPTURE1			0x124 0x298 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_11_USB_OTG1_ID			0x128 0x29C 0x2FC 0x0 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_11_FLEXPWM1_PWMB02			0x128 0x29C 0x340 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_11_LPUART4_RX			0x128 0x29C 0x3E4 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_11_USDHC1_WP				0x128 0x29C 0x494 0x3 0x3
#define MXRT1020_IOMUXC_GPIO_AD_B1_11_FLEXIO1_FLEXIO04			0x128 0x29C 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_11_GPIO1_IO27			0x128 0x29C 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_11_GPT2_COMPARE1			0x128 0x29C 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_12_USB_OTG1_OC			0x12C 0x2A0 0x48C 0x0 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_12_ACMP1_OUT				0x12C 0x2A0 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_12_LPSPI3_SCK			0x12C 0x2A0 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_12_USDHC2_CD_B			0x12C 0x2A0 0x498 0x3 0x2
#define MXRT1020_IOMUXC_GPIO_AD_B1_12_FLEXIO1_FLEXIO03			0x12C 0x2A0 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_12_GPIO1_IO28			0x12C 0x2A0 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_12_FLEXPWM1_PWMA03			0x12C 0x2A0 0x334 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_13_LPI2C1_HREQ			0x130 0x2A4 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_13_ACMP2_OUT				0x130 0x2A4 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_13_LPSPI3_PCS0			0x130 0x2A4 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_13_USDHC2_WP				0x130 0x2A4 0x49C 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_13_FLEXIO1_FLEXIO02			0x130 0x2A4 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_13_GPIO1_IO29			0x130 0x2A4 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_13_FLEXPWM1_PWMB03			0x130 0x2A4 0x344 0x6 0x1

#define MXRT1020_IOMUXC_GPIO_AD_B1_14_LPI2C1_SCL			0x134 0x2A8 0x37C 0x0 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_14_ACMP3_OUT				0x134 0x2A8 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_14_LPSPI3_SDO			0x134 0x2A8 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_14_ENET_1588_EVENT0_OUT		0x134 0x2A8 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_14_FLEXIO1_FLEXIO01			0x134 0x2A8 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_14_GPIO1_IO30			0x134 0x2A8 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_AD_B1_15_LPI2C1_SDA			0x138 0x2AC 0x380 0x0 0x1
#define MXRT1020_IOMUXC_GPIO_AD_B1_15_ACMP4_OUT				0x138 0x2AC 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_15_LPSPI3_SDI			0x138 0x2AC 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_15_ENET_1588_EVENT0_IN		0x138 0x2AC 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_15_FLEXIO1_FLEXIO00			0x138 0x2AC 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_AD_B1_15_GPIO1_IO31			0x138 0x2AC 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B0_00_USDHC1_DATA2			0x13C 0x2B0 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_00_QTIMER1_TIMER0			0x13C 0x2B0 0x410 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_00_SAI1_MCLK				0x13C 0x2B0 0x430 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_00_SAI2_MCLK				0x13C 0x2B0 0x454 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_00_LPI2C3_SCL			0x13C 0x2B0 0x38C 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_00_GPIO3_IO13			0x13C 0x2B0 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_00_FLEXSPI_A_SS1_B			0x13C 0x2B0 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_00_XBAR1_INOUT14			0x13C 0x2B0 0x4A0 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B0_01_USDHC1_DATA3			0x140 0x2B4 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_01_QTIMER1_TIMER1			0x140 0x2B4 0x414 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_01_REF_24M_OUT			0x140 0x2B4 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_01_SAI2_RX_SYNC			0x140 0x2B4 0x460 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_01_LPI2C3_SDA			0x140 0x2B4 0x390 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_01_GPIO3_IO14			0x140 0x2B4 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_01_FLEXSPI_B_SS1_B			0x140 0x2B4 0x000 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_01_XBAR1_INOUT15			0x140 0x2B4 0x4A4 0x7 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B0_02_USDHC1_CMD			0x144 0x2B8 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_02_QTIMER1_TIMER2			0x144 0x2B8 0x418 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_02_LPUART7_CTS_B			0x144 0x2B8 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_02_SAI2_RX_BCLK			0x144 0x2B8 0x458 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_02_LPSPI1_SCK			0x144 0x2B8 0x3A0 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_02_GPIO3_IO15			0x144 0x2B8 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_02_ENET_MDIO				0x144 0x2B8 0x308 0x6 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_02_XBAR1_INOUT16			0x144 0x2B8 0x4A8 0x7 0x1

#define MXRT1020_IOMUXC_GPIO_SD_B0_03_USDHC1_CLK			0x148 0x2BC 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_03_QTIMER1_TIMER3			0x148 0x2BC 0x41C 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_03_LPUART7_RTS_B			0x148 0x2BC 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_03_SAI2_RX_DATA			0x148 0x2BC 0x45C 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_03_LPSPI1_PCS0			0x148 0x2BC 0x39C 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_03_GPIO3_IO16			0x148 0x2BC 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_03_ENET_MDC				0x148 0x2BC 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B0_04_USDHC1_DATA0			0x14C 0x2C0 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_04_FLEXCAN2_TX			0x14C 0x2C0 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_04_LPUART7_TX			0x14C 0x2C0 0x400 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_04_SAI2_TX_DATA			0x14C 0x2C0 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_04_LPSPI1_SDO			0x14C 0x2C0 0x3A8 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_04_GPIO3_IO17			0x14C 0x2C0 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_04_FLEXSPI_B_SS0_B			0x14C 0x2C0 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B0_05_USDHC1_DATA1			0x150 0x2C4 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_05_FLEXCAN2_RX			0x150 0x2C4 0x324 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_05_LPUART7_RX			0x150 0x2C4 0x3FC 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_05_SAI2_TX_BCLK			0x150 0x2C4 0x464 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_05_LPSPI1_SDI			0x150 0x2C4 0x3A4 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_05_GPIO3_IO18			0x150 0x2C4 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_05_FLEXSPI_B_DQS			0x150 0x2C4 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B0_06_USDHC1_CD_B			0x154 0x2C8 0x490 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_06_USDHC1_RESET_B			0x154 0x2C8 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_06_REF_32K_OUT			0x154 0x2C8 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_06_SAI2_TX_SYNC			0x154 0x2C8 0x468 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_06_WDOG1_B				0x154 0x2C8 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_06_GPIO3_IO19			0x154 0x2C8 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B0_06_XBAR1_INOUT17			0x154 0x2C8 0x4AC 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B1_00_USDHC2_DATA2			0x158 0x2CC 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_00_FLEXSPI_B_DATA03			0x158 0x2CC 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_00_LPUART6_TX			0x158 0x2CC 0x3F8 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_SD_B1_00_XBAR1_INOUT10			0x158 0x2CC 0x4B0 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_SD_B1_00_FLEXCAN1_TX			0x158 0x2CC 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_00_GPIO3_IO20			0x158 0x2CC 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B1_01_USDHC2_DATA3			0x15C 0x2D0 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_01_FLEXSPI_B_SCLK			0x15C 0x2D0 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_01_LPUART6_RX			0x15C 0x2D0 0x3F4 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_SD_B1_01_FLEXSPI_A_SS1_B			0x15C 0x2D0 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_01_FLEXCAN1_RX			0x15C 0x2D0 0x320 0x4 0x1
#define MXRT1020_IOMUXC_GPIO_SD_B1_01_GPIO3_IO21			0x15C 0x2D0 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B1_02_USDHC2_CMD			0x160 0x2D4 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_02_FLEXSPI_B_DATA00			0x160 0x2D4 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_02_LPUART8_TX			0x160 0x2D4 0x408 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_02_LPI2C4_SCL			0x160 0x2D4 0x394 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_02_ENET_1588_EVENT1_OUT		0x160 0x2D4 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_02_GPIO3_IO22			0x160 0x2D4 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_02_CCM_CLKO1				0x160 0x2D4 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B1_03_USDHC2_CLK			0x164 0x2D8 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_03_FLEXSPI_B_DATA02			0x164 0x2D8 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_03_LPUART8_RX			0x164 0x2D8 0x404 0x2 0x1
#define MXRT1020_IOMUXC_GPIO_SD_B1_03_LPI2C4_SDA			0x164 0x2D8 0x398 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_SD_B1_03_ENET_1588_EVENT1_IN		0x164 0x2D8 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_03_GPIO3_IO23			0x164 0x2D8 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_03_CCM_CLKO2				0x164 0x2D8 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B1_04_USDHC2_DATA0			0x168 0x2DC 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_04_FLEXSPI_B_DATA01			0x168 0x2DC 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_04_ENET_TX_CLK			0x168 0x2DC 0x31C 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_04_ENET_REF_CLK1			0x168 0x2DC 0x304 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_04_EWM_OUT_B				0x168 0x2DC 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_04_GPIO3_IO24			0x168 0x2DC 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_04_CCM_WAIT				0x168 0x2DC 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B1_05_USDHC2_DATA1			0x16C 0x2E0 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_05_FLEXSPI_A_DQS			0x16C 0x2E0 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_05_ENET_RDATA01			0x16C 0x2E0 0x310 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_05_SAI3_MCLK				0x16C 0x2E0 0x46C 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_05_FLEXSPI_B_SS0_B			0x16C 0x2E0 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_05_GPIO3_IO25			0x16C 0x2E0 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_05_CCM_PMIC_RDY			0x16C 0x2E0 0x300 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B1_06_USDHC2_CD_B			0x170 0x2E4 0x498 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_06_FLEXSPI_A_DATA03			0x170 0x2E4 0x374 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_06_ENET_RDATA00			0x170 0x2E4 0x30C 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_06_SAI3_TX_BCLK			0x170 0x2E4 0x47C 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_06_LPSPI2_PCS0			0x170 0x2E4 0x3AC 0x4 0x2
#define MXRT1020_IOMUXC_GPIO_SD_B1_06_GPIO3_IO26			0x170 0x2E4 0x000 0x5 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_06_CCM_STOP				0x170 0x2E4 0x000 0x6 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B1_07_USDHC2_RESET_B			0x174 0x2E8 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_07_FLEXSPI_A_SCLK			0x174 0x2E8 0x378 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_07_ENET_RX_EN			0x174 0x2E8 0x314 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_07_SAI3_TX_SYNC			0x174 0x2E8 0x480 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_07_LPSPI2_SCK			0x174 0x2E8 0x3B0 0x4 0x2
#define MXRT1020_IOMUXC_GPIO_SD_B1_07_GPIO3_IO27			0x174 0x2E8 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B1_08_USDHC2_DATA4			0x178 0x2EC 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_08_FLEXSPI_A_DATA00			0x178 0x2EC 0x368 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_08_ENET_RX_ER			0x178 0x2EC 0x318 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_08_SAI3_TX_DATA			0x178 0x2EC 0x000 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_08_LPSPI2_SDO			0x178 0x2EC 0x3B8 0x4 0x2
#define MXRT1020_IOMUXC_GPIO_SD_B1_08_GPIO3_IO28			0x178 0x2EC 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B1_09_USDHC2_DATA5			0x17C 0x2F0 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_09_FLEXSPI_A_DATA02			0x17C 0x2F0 0x370 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_09_ENET_TX_EN			0x17C 0x2F0 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_09_SAI3_RX_BCLK			0x17C 0x2F0 0x470 0x3 0x1
#define MXRT1020_IOMUXC_GPIO_SD_B1_09_LPSPI2_SDI			0x17C 0x2F0 0x3B4 0x4 0x2
#define MXRT1020_IOMUXC_GPIO_SD_B1_09_GPIO3_IO29			0x17C 0x2F0 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B1_10_USDHC2_DATA6			0x180 0x2F4 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_10_FLEXSPI_A_DATA01			0x180 0x2F4 0x36C 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_10_ENET_TDATA00			0x180 0x2F4 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_10_SAI3_RX_SYNC			0x180 0x2F4 0x478 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_10_LPSPI2_PCS2			0x180 0x2F4 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_10_GPIO3_IO30			0x180 0x2F4 0x000 0x5 0x0

#define MXRT1020_IOMUXC_GPIO_SD_B1_11_USDHC2_DATA7			0x184 0x2F8 0x000 0x0 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_11_FLEXSPI_A_SS0_B			0x184 0x2F8 0x000 0x1 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_11_ENET_TDATA01			0x184 0x2F8 0x000 0x2 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_11_SAI3_RX_DATA			0x184 0x2F8 0x474 0x3 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_11_LPSPI2_PCS3			0x184 0x2F8 0x000 0x4 0x0
#define MXRT1020_IOMUXC_GPIO_SD_B1_11_GPIO3_IO31			0x184 0x2F8 0x000 0x5 0x0

#endif /* _DT_BINDINGS_PINCTRL_IMXRT1020_PINFUNC_H */
