/*
 * Memory Setup stuff - taken from blob memsetup.S
 *
 * Copyright (C) 1999 2000 2001 Erik Mouw (J.A.K.Mouw@its.tudelft.nl) and
 *		       Jan-Derk Bakker (J.D.Bakker@its.tudelft.nl)
 *
 * Modified for the at91rm9200dk board by
 * (C) Copyright 2004
 * Gary Jennejohn, DENX Software Engineering, <garyj@denx.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <version.h>

#ifdef CONFIG_BOOTBINFUNC
/*
 * some parameters for the board
 *
 * This is based on rm9200dk.cfg for the BDI2000 from ABATRON which in
 * turn is based on the boot.bin code from ATMEL
 *
 */

/* flash */
#define MC_PUIA 0xFFFFFF10
#define MC_PUIA_VAL 0x00000000
#define MC_PUP 0xFFFFFF50
#define MC_PUP_VAL 0x00000000
#define MC_PUER 0xFFFFFF54
#define MC_PUER_VAL 0x00000000
#define MC_ASR 0xFFFFFF04
#define MC_ASR_VAL 0x00000000
#define MC_AASR 0xFFFFFF08
#define MC_AASR_VAL 0x00000000
#define EBI_CFGR 0xFFFFFF64
#define EBI_CFGR_VAL 0x00000000
#define SMC2_CSR 0xFFFFFF70
#define SMC2_CSR_VAL 0x00003284 /* 16bit, 2 TDF, 4 WS */

/* clocks */
#define PLLAR 0xFFFFFC28
#define PLLAR_VAL 0x20263E04 /* 179.712000 MHz for PCK */
#define PLLBR 0xFFFFFC2C
#define PLLBR_VAL 0x10483E0E /* 48.054857 MHz (divider by 2 for USB) */
#define MCKR 0xFFFFFC30
#define MCKR_VAL 0x00000202 /* PCK/3 = MCK Master Clock = 59.904000MHz from PLLA */

/* sdram */
#define PIOC_ASR 0xFFFFF870
#define PIOC_ASR_VAL 0xFFFF0000 /* Configure PIOC as peripheral (D16/D31) */
#define PIOC_BSR 0xFFFFF874
#define PIOC_BSR_VAL 0x00000000
#define PIOC_PDR 0xFFFFF804
#define PIOC_PDR_VAL 0xFFFF0000
#define EBI_CSA 0xFFFFFF60
#define EBI_CSA_VAL 0x00000002 /* CS1=SDRAM */
#define SDRC_CR 0xFFFFFF98
#define SDRC_CR_VAL 0x2188c155 /* set up the SDRAM */
#define SDRAM 0x20000000 /* address of the SDRAM */
#define SDRAM1 0x20000080 /* address of the SDRAM */
#define SDRAM_VAL 0x00000000 /* value written to SDRAM */
#define SDRC_MR 0xFFFFFF90
#define SDRC_MR_VAL 0x00000002 /* Precharge All */
#define SDRC_MR_VAL1 0x00000004 /* refresh */
#define SDRC_MR_VAL2 0x00000003 /* Load Mode Register */
#define SDRC_MR_VAL3 0x00000000 /* Normal Mode */
#define SDRC_TR 0xFFFFFF94
#define SDRC_TR_VAL 0x000002E0 /* Write refresh rate */


_TEXT_BASE:
	.word	TEXT_BASE

.globl lowlevelinit
lowlevelinit:
	/* memory control configuration */
	/* this isn't very elegant, but	 what the heck */
	ldr	r0, =SMRDATA
	ldr	r1, _TEXT_BASE
	sub	r0, r0, r1
	add	r2, r0, #80
0:
	/* the address */
	ldr	r1, [r0], #4
	/* the value */
	ldr	r3, [r0], #4
	str	r3, [r1]
	cmp	r2, r0
	bne	0b
	/* delay - this is all done by guess */
	ldr	r0, =0x00010000
1:
	subs	r0, r0, #1
	bhi	1b
	ldr	r0, =SMRDATA1
	ldr	r1, _TEXT_BASE
	sub	r0, r0, r1
	add	r2, r0, #176
2:
	/* the address */
	ldr	r1, [r0], #4
	/* the value */
	ldr	r3, [r0], #4
	str	r3, [r1]
	cmp	r2, r0
	bne	2b

	/* everything is fine now */
	mov	pc, lr

	.ltorg

SMRDATA:
	.word MC_PUIA
	.word MC_PUIA_VAL
	.word MC_PUP
	.word MC_PUP_VAL
	.word MC_PUER
	.word MC_PUER_VAL
	.word MC_ASR
	.word MC_ASR_VAL
	.word MC_AASR
	.word MC_AASR_VAL
	.word EBI_CFGR
	.word EBI_CFGR_VAL
	.word SMC2_CSR
	.word SMC2_CSR_VAL
	.word PLLAR
	.word PLLAR_VAL
	.word PLLBR
	.word PLLBR_VAL
	.word MCKR
	.word MCKR_VAL
	/* SMRDATA is 80 bytes long */
	/* here there's a delay of 100 */
SMRDATA1:
	.word PIOC_ASR
	.word PIOC_ASR_VAL
	.word PIOC_BSR
	.word PIOC_BSR_VAL
	.word PIOC_PDR
	.word PIOC_PDR_VAL
	.word EBI_CSA
	.word EBI_CSA_VAL
	.word SDRC_CR
	.word SDRC_CR_VAL
	.word SDRC_MR
	.word SDRC_MR_VAL
	.word SDRAM
	.word SDRAM_VAL
	.word SDRC_MR
	.word SDRC_MR_VAL1
	.word SDRAM
	.word SDRAM_VAL
	.word SDRAM
	.word SDRAM_VAL
	.word SDRAM
	.word SDRAM_VAL
	.word SDRAM
	.word SDRAM_VAL
	.word SDRAM
	.word SDRAM_VAL
	.word SDRAM
	.word SDRAM_VAL
	.word SDRAM
	.word SDRAM_VAL
	.word SDRAM
	.word SDRAM_VAL
	.word SDRC_MR
	.word SDRC_MR_VAL2
	.word SDRAM1
	.word SDRAM_VAL
	.word SDRC_TR
	.word SDRC_TR_VAL
	.word SDRAM
	.word SDRAM_VAL
	.word SDRC_MR
	.word SDRC_MR_VAL3
	.word SDRAM
	.word SDRAM_VAL
	/* SMRDATA1 is 176 bytes long */
#endif /* CONFIG_BOOTBINFUNC */
