/*--------------------------------------------------------------------------*/
/*                                                                          */
/*               The Opus Computer-Based Conversation System                */
/*    (c) Copyright 1986-1991, Wynn Wagner III, All Rights Reserved         */
/*                                                                          */
/*                                                                          */
/*                   YOOHOO is a trademark of Wynn Wagner III               */
/*                                                                          */
/*                        YOOHOO-YOOHOO/2U2 & WaZOO are                     */
/*           Copyright 1987, Wynn Wagner III, All Rights Reserved           */
/*                                                                          */
/*                                                                          */
/* This material is available for use by anybody with no strings and        */
/* no guarantees.                                                           */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* OPUS 1.20 Message/File area database structures.                         */
/* Copyright 1991 Wynn Wagner III, Doug Boone and John Valentyn.            */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* LEGIBLE SECTION.  Definitions to make "C" look like a real language.     */
/*--------------------------------------------------------------------------*/

#ifndef begin
# define begin        {
# define end          }
# define true         (-1)
# define false        0
# define Procedure    void
# define shl          <<
# define shr          >>
# define xor          ^
# define and          &&
# define or           ||
# define not          !
# define mod          %
  typedef unsigned      bit;
  typedef unsigned int  word;
  typedef unsigned char byte;
  typedef unsigned char const * const  STRING;
# define fallthrough        /* ... for use in switch statements for clarity. */
#endif


#ifndef max
#define max(a,b)     ((a)>(b)?(a):(b))
#endif

#ifndef min
#define min(a,b)     ((a)<=(b)?(a):(b))
#endif


/*--------------------------------------------------------------------------*/
/* Structure for SYSMSG.DAT                                                 */
/* A single-file message area database                                      */
/*--------------------------------------------------------------------------*/

struct  _filesys {

    char    Area_Name[32]; 		/* Area's primary name */

    word    Area_Number;		/* area number */
    word    Area_Menu;		/* which menu? */
    word    Total_Size;

    byte    Area_Priv;		/* Area Privilege */
    byte    Down_Priv;		/* Download Privilege */

    byte    Up_Priv;
    byte    Priv_Up;		/* Uploads from users with Priv>= Priv_Up */
    byte    Ratio_Priv;		/* Privilege where u/d ratios start */
    byte    New_Priv;
    
    byte    fill_byte1[2];
/* 48 */
    word    Attrib;		/* Area Attribute */
    word    Status;		/* Area Status, extended Attribute? */

	long    Start_Pos;		/* start of Area in sysfile.dat */
/* 56 */
    long    Area_Lock;		/* Area Lock */

    long    Up_Lock;

    long    Down_Lock;		/* edit Lock */

    long    Priv_Key;		/* Private Key path */

/* 72 */
    long    Section;		/* edit Lock */

    long    fill_long[2];

	byte	Title_Len;		/* length of Title */
    byte    Prefiles_Len;	/* files shown at Area access like Areainfo */

	byte    Downpath_Len;		/* length of path */
	byte    Uppath_Len;		/* length of path */
/* 88 */
    byte    Barricade_Len;		/* Barricade length if used */
    byte    Rules_Len;

    byte    Privkey_Len;		/* Uploads from users with "key" go here */
    byte    PrivUp_Len;		/* Private Upload path */
    byte    Menu_Len;		/* file name for this area's ascii menu */
    byte    Vol_Len;		/* Length of volume name */
    byte    Help_Len;		/* Length of help name for this area */

    byte    fill_byte2[5];		/* more filler */
/* 100 */
    word    Other_Len;		/* external programs use this number bytes */

    word    Def_Upload;		/* Area number for default uploads */
    word    Priv_Upload;		/* Area number for Priv uploads */
    word    Key_Upload;		/* Area number for Lock uploads */

    word    fill_word[10];		/* more filler to 128 bytes*/
};

/*  Title */
/*  Prefiles */
/*  Downpath */
/*  Barricade */
/*  Rules */
/*  Menu */
/*  Help */
/*  Upload */
/*  Priv Upload */
/*  Key Upload */
/* File area help file */
/*  Volume */
/*  "Other" field. Reserved for external programs */

/*--------------------------------------------------------------------------*/
/* Structure for SYSMSG.DAT                                                 */
/* A single-file message Area database                                      */
/*--------------------------------------------------------------------------*/

struct  _msgsys {

    char    Area_Name[32]; 		/* Area's primary name */
    char    Echo_Name[32];		/* Area's echo name */
    word    Area_Number;		/* Area number */
    word    Area_Menu;		/* which menu? */
    word    Total_Size;		/* Total size of this Area in SYSMSG.DAT */

    byte    Area_Priv;		/* Area Privilege */
    byte    Edit_Priv;		/* Edit Privilege */
    byte    Private_Priv;		/* Privilege to read Private messages*/
    byte    Upload_Priv;
    byte    fill_0[3];
    byte    Translate;		/* Which character set to use 1, 2.... */
/* 80 */
    long    Area_Lock;		/* Area Lock */
    long    Edit_Lock;		/* Edit Lock */

    long    Private_Lock;		/* Lock to read Private messages*/
    long    Upload_Lock;

    word    Attrib;		/* Area Attribute */
    word    Status;		/* Area Status, extended Attribute? */

	long    Start_Pos;		/* start of Area in sysmsg.dat */
    long    Section;
    byte    Max_Lines;		/* Maximum number of lines in messages */
    byte    fill_1[3];
/* 112 */

    word    Zone;
    word    Net;
    word    Node;
    word    Point;

	byte    Path_Len;		/* length of Path */
	byte	Title_Len;		/* length of Title */

    byte    Barricade_Len;		/* Barricade length if used */
    byte    Origin_Len;		/* non-default Origin line */

    byte    Domain_Len;		/* Domain (if used) length */
    byte    Menu_Len;		/* file name for this area's ascii menu */
    byte    Vol_Len;		/* Length of volume name */
    byte    Help_Len;		/* Length of help name for this area */
/* 144 */

	byte    Scan_Len;		/* number of boards that Area is Scanned to */
    byte    Scan_Pos;		/* where Opus is in the Scan right now */
    word    Other_Len;		/* external programs use this number bytes */
    word    Extern_Flags;
    word    word_fill[5];
/* 160 */
};

/*--------------------------------------------------------------------------*/
/* Then some strings/structures follow as needed                            */
/*--------------------------------------------------------------------------*/
	 /* Path string  */
    /* Title string */
    /* Barricade string */
    /* Origin string */
    /* Domain string */
    /* Menu string */
    /* Message area help file */
    /* Volume ID */
    /* aScan[Scan_Len] echoScan addresses */
    /*  "Other" field. Reserved for external programs */

/*--------------------------------------------------------------------------*/
/* end of strings                                                           */
/*--------------------------------------------------------------------------*/


struct  _ascan {		/* structure of address for echoScanning */
    word    Net;
    word    Node;
};

/*--------------------------------------------------------------------------*/
/* LMR is used in LREAD.DAT to store the user's last message read counter   */
/*--------------------------------------------------------------------------*/
struct  _lmr {
    unsigned long    user_id;
    word    high_msg;
    word    last_msg;
};

/*--------------------------------------------------------------------------*/
/* LF is used to store the last time a user has accessed each area          */
/*--------------------------------------------------------------------------*/
struct  _lf {
    unsigned long    user_id;
    unsigned long    last_timestamp;
}; 

/*--------------------------------------------------------------------------*/
/* File Area attributes (limit or describe the behavior of an area)         */
/*--------------------------------------------------------------------------*/

#define    F_DUPE  0x0001		/* Allow duplicate uploads in this area      */
#define    F_FREE  0x0002		/* Downloads from this area area all 0K      */


/*--------------------------------------------------------------------------*/
/* Area attributes (limit or describe the behavior of an area)              */
/*--------------------------------------------------------------------------*/
#define  SYSMAIL   0x01    /* is a mail area                                */
#define  P_REP     0x02    /* Net mail private echomail back                */
#define  NOPUBLIC  0x04    /* OPUS: Disallow public messages                */
#define  NOPRIVATE 0x08    /* OPUS: Disallow private messages               */
#define  ANON_OK   0x10    /* OPUS: Enable anonymous messages               */
#define  ECHOMAIL  0x20    /* OPUS: Set=Echomail Clear=Not Echomail         */
#define  USEALIAS  0x40	   /* OPUS: Use user's alias in this area if.....   */
#define  PASSTHROUGH   0x80	/* OPUS: Allow high-bit characters in echo area  */
#define  INBOUND   0x0100		/* Inbound Only area */


/*--------------------------------------------------------------------------*/
/* msgsys.Extern_Flags                                                      */
/* Opus will not use these flags, set them or anything. The ones that are   */
/* marked as RESERVED will be defined in the future for "standard" uses.    */
/* The ones marked as EXTERN will have no "standard" meaning so conflicting */
/* programs MAY have conflicting uses.                                      */
/*--------------------------------------------------------------------------*/

#define RENUMBER   0x0001 		/* This area gets renumbered                 */
#define MAILCHECK	0x0002		/* The mail check program will do this area  */
#define RESERVED2	0x0004   	/* Reserved for Opus-defined flags           */
#define RESERVED3	0x0008   	/* Reserved for Opus-defined flags           */
#define RESERVED4	0x0010   	/* Reserved for Opus-defined flags           */
#define RESERVED5	0x0020   	/* Reserved for Opus-defined flags           */
#define RESERVED6	0x0040   	/* Reserved for Opus-defined flags           */
#define RESERVED7	0x0080   	/* Reserved for Opus-defined flags           */
#define EXTERN1	0x0100   	/* Undefined! Meaning varies for each program*/
#define EXTERN2	0x0200   	/* Undefined! Meaning varies for each program*/
#define EXTERN3	0x0400   	/* Undefined! Meaning varies for each program*/
#define EXTERN4	0x0800   	/* Undefined! Meaning varies for each program*/
#define EXTERN5	0x1000   	/* Undefined! Meaning varies for each program*/
#define EXTERN6	0x2000   	/* Undefined! Meaning varies for each program*/
#define EXTERN7	0x4000   	/* Undefined! Meaning varies for each program*/
#define EXTERN8	0x8000   	/* Undefined! Meaning varies for each program*/
