
/* Global ZMODEM behaviour control. Settable externally. */

extern unsigned zmttype;	/* number of blocks to allow ahead */
				/* 0 == full streaming */
				/* 1 - 64 == blocks (preferred) */
				/* 1024 - 65536 == Ks */

extern unsigned zmrtype;	/* 0 == accepts full streaming (ZCRCG/ZCRCQ) */
				/* 1 == fully ACKed (ZCRCW) */

extern unsigned zmblkmax;	/* the size of the send/receive buffer */

extern unsigned zmblkst;	/* initial maximum size of Tx blocks */

extern char *zmbuff;		/* Rx/Tx buffer, must be BLKSIZE or larger */

/* Status returned to the caller */

extern unsigned totl_files;	/* how many files sent/received */
extern unsigned totl_errors;	/* how many failures */
extern long totl_bytes;		/* 128 bytes blocks */
extern unsigned totl_process;	/* 1 == file in process */
extern unsigned totl_recoveries;/* how many error recoveries (ZRPOS) */

/* Zmodem globals (declared in ZBASE.C) */

extern char *namelist;		/* list of received filenames */
extern unsigned listlen;	/* its max. length */

extern int rxtimeout;		/* Hundredths of seconds to wait for something */
extern int rxframeind;		/* ZBIN ZBIN32, or ZHEX type of frame received */
extern int rxtype;		/* Type of header received */
extern int rxcount;		/* Count of data bytes received */
extern char rxhdr[4];		/* Received header */
extern char txhdr[4];		/* Transmitted header */
extern long rxbytes;		/* total received/acked bytes */
extern long rxpos;		/* Received file position */
extern long txpos;		/* Transmitted file position */
extern int txfcs32;		/* TRUE means send binary frames with 32 bit FCS */
extern int crc32t;		/* Display flag indicating 32 bit CRC being sent */
extern int znulls;		/* Number of nulls to send at beginning of ZDATA hdr */
extern char attn[ZATTNLEN+1];	/* Attention string Rx sends to Tx on err */

extern int tryzhdrtype;		/* Header type to send corresponding to Last rx close */

extern FLAG txwindow;		/* 1 == I do windows */
extern unsigned txwsize;	/* size of the transmitted window */
extern unsigned txwspace;	/* how often to send ZCRCQ */

extern long lrxpos;		/* Receiver's last reported offset */
extern int errors;

extern unsigned blklen;		/* length of transmitted records */
extern unsigned rxbuflen;	/* Receiver's max buffer length or 0 for accepts streaming */
extern FLAG eofseen;		/* EOF seen on input */
extern int rxflags;		/* receivers Rx flags (CANxxx bit masks) */
extern FLAG zctlesc;		/* escape control characters */
extern FLAG cantovio;		/* Rx can't overlap disk and serial IO */
extern long bytcnt;
extern char wantfcs32;		/* Tx want to send 32 bit FCS */

extern FLAG lzconv;		/* Tx ZMODEM file conversion request */
extern FLAG lzmanag;		/* Tx ZMODEM file management request */
extern FLAG lztrans;		/* Tx ZMODEM file transport request */

extern FLAG zconv;		/* Rx ZMODEM file conversion request */
extern FLAG zmanag;		/* Rx ZMODEM file management request */
extern FLAG ztrans;		/* Rx ZMODEM file transport request */

extern long lastsync;		/* Last offset to which we got a ZRPOS */
extern int beenhereb4;		/* How many times we've been ZRPOS'd same place */

extern FLAG lastsent;		/* Last char we sent */
extern FLAG Not8bit;		/* Seven bits seen on header */
extern FLAG zmabort;

extern char abortstr[];		/* transfer abort string */
extern char *Zendnames[];
extern char *framenames[];

extern long crc32tab[];		/* CRC polynomial 0xedb88320 */
extern unsigned crctab[];
