/*

meminit()	Allocates all available memory into one
		large free memory block. 

n= getbuf(min,max,p)
		Allocate memory, minimum and maximum values.
		Returns the number of bytes or 0 if the minimum
		is not available.

rlsbuf(buff,size)
		Deallcates previously allocated memory.

*/

static char *memptr;		/* pointer to our memory pool */
static unsigned memsize;	/* how big it is */

char *getmem();
long sizmem();

#define abs(x) ((x)<0?-(x):(x))
#define max(a,b) ((a)>(b)?(a):(b))
#define min(a,b) ((a)<=(b)?(a):(b))

/* Get all of memory. */

meminit() {

	memsize= sizmem();		/* how much there is, */
	memptr= getmem(memsize);	/* get it */
}

/* Allocate a buffer; return the amount allocated. */

getbuf(minimum,maximum,p)
unsigned minimum,maximum;
char **p;
{
unsigned s;

	s= min(maximum,memsize);	/* smaller of the two, */
	if (s < minimum) s= 0;		/* check for not enough */

	*p= memptr;			/* ptr to free memory, */

	memptr += s;			/* remove from the pool */
	memsize -= s;

	return(s);			/* return count or 0 */
}

/* Deallocate a previous request; error is we cant. */

rlsbuf(buff,n)
char *buff;
unsigned n;
{
	if (memptr != (buff + n)) {
		error("Non-Contiguous rlsbuf(%04lx,%04lx)\r\n",0L+(int)buff,0L + n);
		n= 0;
	}
	memptr -= n;			/* increase pool, */
	memsize += n;			/* account for size */
	return(1);
}
