     title     Fido/FidoNet Runtime Overlay Loader User Module
     .sfcond

comment ~

	Overlay Loader for Fido/FidoNet version 12
	This was originally "SAMPLE.ASM" from the PLINK86
	diskette.

	T. Jennings 8 Nov 89

~
name OVUSER
public	$OVLYIU		;entry point to initialize user module
public	$OVLYMU		;entry point for MSDOS user routine
public	$OVLYFN		;overlay file name string for overlay loader to use
public	$OVEXIT
public	$OVLEND

			;fatal messages
public	$roverflow	;overlay loader reload stack overflow
public	$runderflow	;overlay loader reload stack undeflow
public	$rnomemory	;not enough memory for overlay reload stack
public	$needdos2	;need dos 2.0 i/o capability
;
;This is a macro for doing operating system calls.
;
LodOff    macro     Reg,Var	;;macro to load variable offset into reg
     mov  Reg,offset Var	;;MSDOS, offsets are from segment
     endm
;
Sys  macro     Fun,Arg		;;macro for invoking Operating system functions
     mov  AH,Fun
     ifnb <Arg>
     LodOff    DX, Arg
     endif
     int  21H
     endm
;
;The data area must be set up as shown here so that it will combine properly
;with the overlay loader's data area.  DS and ES always point to this segment
;when the overlay loader calls this module.
;
extrn	$OVCLOSE:far	;close open overlay file, if any

extrn	$OVOM$:byte	;open mode for overlay files - 
			;network may be running => shared files
extrn	$OVDOS2:byte	;-1 => MSDOS >= 2.0 running

OVdata    segment   word public 'OVLOADER'
;
CR   equ  0DH
LF   equ  0AH
;
DosVer	db 0			;MSDOS version number.
FNlen	equ 80			;maximum length of overlay file name
$OVLYFN db FNlen dup (?)	;overlay file name work area
				;my error message

Err	db CR,LF
	db 'The Fido/FidoNet program file *must* be named "FIDO.EXE"',CR,LF
	db 'and *must* reside in the same subdirectory you run Fido from.',CR,LF
	db '$'

$runderflow	db "Fido/FidoNet Overlay Loader: stack underflow $"
$roverflow	db "Fido/FidoNet Overlay Loader: stack overflow $"
$rnomemory	db "Fido/FidoNet Overlay Loader: not enough memory for stack $"
$needdos2	db "Fido/FidoNet Overlay Loader: dos 2.0 required $"

OVdata    ends

;
;The code segment must be set up as shown here so it will combine properly
;with the overlay loader's code segment.  All calls to this module are near
;calls.
;
OVcode    segment  public 'OVLOADER'
assume cs:OVcode, ds:OVdata, es:OVdata
;
;Initialization routine: $OVDOS2 & $OVOM$ MUST BE INITIALIZED HERE!!
;
$OVLYIU   proc near
     Sys  30H            ;AL := DOS version #
     mov  DosVer, AL     ;Save for later.
     cmp  AL,2           ;go away if earlier than 2.0
     jnc  IU2
     jmp  short IUend
IU2:                     ;DOS 2.x or later
     mov  $OVDOS2, -1    ;   -1 => use dos 2.0 file handles
     xor  AL, AL         ;   default to standard file open mode
     mov  $OVOM$, AL     ;   set my open mode
IUend:
     ret
$OVLYIU   endp
;
;If this is the first attempt to load an overlay, do nothing, otherwise, 
;print an error message and terminate the program.
;
$OVLYMU   proc near
     or   AL, AL         ;error on last attempt?
     jnz  Error
     mov  AL, 0          ;Tell loader to try this file name.
     ret
;
Error:
     mov  AH, 9          ;print our error message.
     mov  DX, offset Err
     int  21H
     mov  AL, 1          ;Stop the program.
     ret  

$OVLYMU   endp

;
;End of overlay load; not used.
;
$OVLEND proc near
    ret
$OVLEND endp

;
;Fata error cleanup; not used.
;
$OVEXIT proc near
        call  $OVCLOSE
        mov al, 0ffh
        mov ah, 4ch
        int 21h
    ret
$OVEXIT endp

OVcode    ends
     end
