title	Runtime Overlay Loader User Module for Plink86
subttl	Written by Dave Hirschman, Phoenix Software Associates, Ltd.
;
;This is the overlay loader for Fido. It is a stripped
;version of the one in SAMPLE.ASM on the 1.45 release disk.
;
name	OVLYM	;name of this module
;
;********
;* Data *
;********
;The data area must be set up as shown here so that it will combine properly
;with the overlay loader's data area.  DS and ES always point to this segment
;when the overlay loader calls this module.
;
OVdata	segment	word public 'OVERLAYLOADER'

public	$OVLYFN	;overlay file name string for overlay loader to use
;
CR	equ	0DH
LF	equ	0AH
;
$ovlyfn db 80 dup (0)	;filename set by overlay loader

err1 db 'The file ',0
err2 db ' must reside in the default directory',13,10,0

OVdata	ends
;
;********
;* Code *
;********
;The code segment must be set up as shown here so it will combine properly
;with the overlay loader's code segment.  All calls to this module are near
;calls.
;
OVcode	segment  public 'OVERLAYLOADER'
	assume cs:OVcode, ds:OVdata, es:OVdata

public	$OVLYIU	;entry point to initialize user module
public	$OVLYMU ;entry point for MSDOS user routine
;
;***********
;* $OVLYIU *
;***********
;Initialization routine (nothing to do).
;
$OVLYIU	proc	near
	ret
$OVLYIU	endp
;
;***********
;* $OVLYxU *
;***********
;If this is the first attempt to load an overlay, append our path name to the
;front.  Otherwise, print an error message and terminate the program.
;
$OVLYMU	proc	near
	or	al,al		;if no error,
	jnz	error		;just return 00.
	ret

error:	mov	si,offset err1
	call	error2
	mov	si,offset $ovlyfn
	call	error2
	mov	si,offset err2
error2:	cld
	lodsb
	cmp	al,0
	je	error3
	mov	dl,al
	mov	ah,2
	int	21h
	jmp	error2
error3:	mov	al,1
	ret

$OVLYMU	endp
OVcode	ends
	end
