#include "fido.h"
#include <ascii.h>
#include "fidomem.h"
#include "proto.h"

/* Routines used by main() and the fidonet main() routine; stored in the
out-of-space overlay since they are not frequently used (and we are 
desparate.) 


mail_pending()	Displays what packets are available and their status.

execute(s)	Exec a program.

*/

/* Display outgoing packets' status. */

void mail_pending() {
int i;
char buff[SS],*cp;

	if (node_files() || (fido.event == -1)) {
		cprintf(SM+102);				/* no packets */
		return;
	}
	dsp_event(buff,fido.event);			/* display it, */
	cputs("   "); cputs(buff);
	cprintf(SM+103);
	for (i= 0; get_ntc(i) != -1; i++) {
		if (ntc.bits & NTC_PD) cp= string(SM+158); /* "PU." */
		else cp= (ntc.bits & NTC_SUCCESS) ? 
		    string(CM+4) /* yes */ : string(CM+6); /* no */

		cprintf(0,"%12s      %3d     %3d     %3d     %3d     %3s     %3s %s\377",
		    str_node(&ntc.node),
		    ntc.tries,ntc.connects,ntc.msgs,ntc.files,cp,

		    ((ntc.connects < connect_tries) 
		      && (ntc.tries < dial_tries) 
		      && ((ntc.bits & NTC_SUCCESS) == 0)
		    ? string(CM+4) : string(CM+6)),
		    (ntc.bits & NTC_HOLD ? string(SM+153) : "")
		);
	}
	if (!i) cprintf(SM+102);			/* no packets */
	cprintf(FM+1);
}

/* Execute a program. */

void execute(pgmname)
char *pgmname;		/* program name, list of arguments */
{
#define NUMARGS 12	/* max. args fork() will pass */
char argv[NUMARGS + 1][SS];
char *cp;
int i;

	cp= pgmname;
	for (i= 0; i < NUMARGS; i++) {
		cpyatm(argv[i],cp);		/* copy the args */
		cp= next_arg(cp);		/* into the usual array */
	}
	*argv[i]= NUL;				/* null last arg to terminate */
	reset_hw();				/* unlink serial driver */
	reset_clk();				/* unlink clock */
	i= forkvp(argv[0],argv);		/* go execute it */
/*	wait();				*/	/* who knows, maybe DOS 4 ... */
	set_clk();				/* and back on again */
	iodev= -1; set_hw();			/* reenable hardware */

	if (i) cprintf(SM+105,pgmname);		/* error */
/**/	if (i) clprintf(0,"forkvp error code %d\r\n",i);
}
