/*
	Fido's memory usage declarations.
*/

extern char *texttbl[4];	/* pointers to text tables (see TEXT.H) */

/* NOTE: At runtime these tables are converted from char *'s to table-of-
offsets by FIDO.INI, to be compatible with the loaded tables. */

extern char *fmtable[];		/* Fixed Messages */
extern char *lmtable[];		/* Log Messages */

extern char dayname[8][4];	/* names of the days of the week */

extern struct _node id;		/* our node ID */
extern struct _node altid;	/* our alternate node ID */
extern struct _fido fido;	/* our main system file */

extern struct _area msgarea;	/* current area */
extern struct _area filearea;
extern char ovpath[];		/* file area override pathname */

extern struct _nmap nmap;	/* node routing controls */
extern struct _ntc ntc;		/* Node To Call index structure */
extern struct _ndat ndat;	/* node physical info */
extern struct _clr caller;	/* caller record */
extern struct _msg msg;		/* message header */
extern struct _node msg_orig;	/* KLUDGE for backwards compatibility */
extern struct _node msg_dest;	/* KLUDGE for backwards compatibility */

extern int *highmsg;		/* table of highest msg # in system, */
extern int *totlmsg;		/* table of total number of messages, */
extern int msgfile;		/* global handle for opened message, */

extern int msgfile;		/* global handle for opened message, (.MSG) */
extern int cmtfile;		/* logon and comment file, (.LOG) */
extern int idxfile;		/* nodelist index file (NODELIST.IDX) */
extern int ndxfile;		/* nodelist net index file (NODELIST.NDX) */
extern int zdxfile;		/* nodelist zone index file (NODELIST.ZDX) */
extern int nodefile;		/* nodemap file (NODELIST.NMP) */
extern int ndatfile;		/* nodelist file (NODELIST.BBS) */
extern int ntcfile;		/* node to call file (NODELIST.NTC) */

extern char doscode;		/* DOS error code */
extern char mailcode;		/* errorlevel to use when msgs received */
extern char filecode;		/* errorlevel to use when files received */
extern char crashcode;		/* errorlevel to use when YOOHOO/TSYNC recv'd */
extern FLAG crashmail;		/* 1 == process TSYNC/YOOHOO specially */

extern FLAG kblock;		/* 1 == disable Control-C and -K */
extern FLAG abort;		/* 1 == Control-C typed during output */
extern int column;		/* column number, */
extern int line;

extern FLAG send_only;		/* 1 == send mail only set by ROUTER */
extern FLAG recv_only;		/* 1 == receive mail only set by ROUTER */
extern FLAG cm_only;		/* 1 == send only to #CM nodes set by ROUTER */
extern FLAG ext_mail;		/* 1 == export packets */
extern char dial_tries;		/* max. attempts to dial out */
extern char connect_tries;	/* ditto, with connects */
extern char rings;		/* number of rings to answer the phone */
extern char mdmstr[40];		/* modem initialization string */
extern char dial_interval;	/* how often to dial */
extern char cont_interval;	/* how often to reenable CONT events */
extern char dial_pref[30];	/* FidoNet dial string prefix */

extern unsigned mdmtype;	/* type of modem */
extern unsigned maxbaud;	/* maximum baud rate */
extern unsigned linkrate;	/* modem fixed link rate else 0 */

extern int pktnum;		/* incoming packet number */

extern FLAG terminate;		/* 1 == terminate after this caller */
extern FLAG echo;		/* 1 == echo on line input, */
extern FLAG test;		/* 1 == test mode, (no modem) */
extern FLAG localout;		/* 1 == echo caller IO to local console */
extern FLAG localin;		/* 1 == simultaneous keyboards */

extern char lmtstate;		/* 0 - 2, caller time limit warning state */
extern char taskid;		/* current Fido taskID (MLINK, etc) */

extern unsigned limit;		/* time limit in force, */
extern unsigned user_limit;	/* current user time limit */
extern unsigned klimit;		/* download limit in force */
extern unsigned dlimit;		/* daily time limit in force */
extern FLAG hlimit;		/* 1 == hard time limit */

extern char date[];		/* caller signon date */
extern char langpath[];		/* current language-file path or NUL */

extern FLAG cd_flag;		/* true == ignore CD line */
extern unsigned datarate;	/* baud rate to/from caller */
extern unsigned online_baud;	/* force-connect at this baud */

extern unsigned totl_files;	/* total files sent/rec'd */
extern unsigned totl_errors;	/* error count, soft errors incl */
extern unsigned totl_process;	/* 1 == transfer aborted while in process */
extern unsigned totl_recoveries;/* number of error recoveries */
extern long totl_bytes;		/* number of bytes sent */

extern unsigned filemode;	/* XMODEM, TELINK, ZMODEM, etc */
extern unsigned zmttype;	/* Zmodem Tx behaviour */
extern unsigned zmrtype;	/* Zmodem Rx behaviour */

extern unsigned ioport;		/* I/O port, set in FIDO.INI */

/* Modem variables, from driver.h */

extern char driver_id[];	/* driver ID string */
extern unsigned cd_bit;		/* bit to test for Carrier Detect, */
extern unsigned iodev;		/* serial channel number */	

/* Local text buffer */

extern char *mem;		/* our memory buffer */
extern unsigned memsize;	/* and its size */

extern char *text;		/* text work buffer */
extern unsigned textsize;	/* and its size */

/* Time stuff, from driver.h */

extern long millisec;		/* G.P. milliseconds */
extern long millis2;
extern int seconds,minutes,hours;

/* Globals required by ZMODEM */

extern unsigned zmttype;			/* Zmodem Tx behaviour */
extern unsigned zmrtype;			/* Zmodem Rx behaviour */
extern unsigned zmblkmax;			/* Zmodem maximum block size */
extern unsigned zmblkst;			/* Zmodem start with this block size */
extern char *zmbuff;				/* Zmodem Rx/Tx buffer */
