#include "fido.h"
#include "fidomem.h"
#include <xfbuf.h>
#include <filexfer.h>
#include "proto.h"

/*
	Various file transfer support routines

NOTE: The args to xferstat are really: xferstat(n,z,0,s); 
the 0 is always present so that we can point to it to force
Fido's _fspr() to assume an inline format string. 


xferstat(n,z,s)	Controls error reporting and status logging for
int n;		file transfers. N is the function call number;
long z;
char *s;	0 == Initialize: clears the file status counters
		totl_???? to zero, and readies the display.

		1 == start new file: Displays the passed filename (s)
		and overall file size (z).

		2 == status display: current block number, etc. Z
		is current byte offset. s is a runtime message.

		3 == error message: similar to above but can be
		handled differently if necessary.

badname(s)	Returns true if the passed ASCII name is a device
		name.

baudrate()	Returns the current baud rate.

fexist(fn)	Returns true if this file cannot be overwritten;
char *fn;	ie. if it exists and overwriting is not allowed by
		the program.

chkabort()	Checks the local keyboard and returns true if the
		file transfer should be aborted.
*/

/* Display a file transfer status message. N is how to handle it:

	0	Initialize display
	1	new filename (do CR/LF before and after)
	2	runtime status (do CR only)
	3	runtime error (do CR/LF)
 */

void xferstat(n,z,s)
int n;		/* status message type */
long z;		/* block/offset/etc */
char *s;	/* string or format */
{
char *cp,buff[SS],f[SS];

	if (!fbit(FBIT_XFERDISP) && !fbit(FBIT_LOGXFER)) return;

	switch (filemode) {
		case XMODEM:	cp= "XMODEM"; break;
		case XMODEMC:	cp= "XMODEM/CRC"; break;
		case TELINK:	cp= "TELINK"; break;
		case TELINKC:	cp= "TELINK/CRC"; break;
		case MODEM7:	cp= "MODEM7"; break;
		case MODEM7C:	cp= "MODEM7/CRC"; break;
		case KERMIT:	cp= "KERMIT"; break;
		case DIETIFNA:	cp= "DIETIFNA"; break;
		case ZMODEM:	cp= "ZMODEM"; break;
		case FSC001X:	cp= "FSC-0001 XMODEM"; break;
		case FSC001T:	cp= "FSC-0001 TELINK"; break;
		default: 	cp= "?UNKNOWN?"; break;
	}
	_fspr(f,&s);				/* format protocol message */
	sprintf(buff,0,"%s: %s %,lu",cp,f,z);	/* format report string */

	if ((n == 1) || (n == 3)) {		/* if error or new file */
		if (fbit(FBIT_XFERDISP))	/* to local console */
			cprintf(0," * %s           \r\n",buff);

		if (fbit(FBIT_LOGXFER))		/* and 'xferlog yes' */
			lprintf(0," * %s\r\n",buff); /* output to log */

	} else if (n != 0) {			/* normal status */
		if (fbit(FBIT_XFERDISP))	/* if enabled, */
			cprintf(0," * %s          \r",buff); /* print to screen only */
	}
}

/* Check for illegal filenames. Mostly just device names. */

char *strip_path();

badname(s)
char *s;
{
int f,i;
char name[SS];
struct _xfbuf xfbuf;

	cpyarg(name,s);			/* clean copy, */
	stolower(name);			/* easy testing */
	xfbuf.s_attrib= 0xff;		/* all types */
	if (! _find(name,0,&xfbuf)) 	/* if it doesnt exist, */
		return(0);		/* no prob */

/* NOTE: This uses the direct INT 21 open() and close(), since ioctl() needs
the DOS handle, not our internal one. */

	f= _open(name,0);		/* if we can't open it */
	if (f == -1) return(0);		/* it aint there */

	i= _ioctl(0,f,0,0);		/* see if device */
	_close(f);			/* close handle */
	return(i & 0x80);		/* 0x80 is the 'device' bit */
}

/* Return true if we cannot overwrite this file. */

fexist(fn)
char *fn;
{
int file;

	if (! (filearea.flags & AREA_OVW)) {
		file= open(fn,0);
		if (file != -1) {
			close(file);
			return(-1);
		}
	}
	return(0);
}

/* We dont use chkabort() in Fido. */

chkabort() {

	return(0);
}

/* Return the current baud rate. */

baudrate() {

	return(datarate);
}
