; $Header$
;
; $Source$
;
;	This is the timer routines for MSC 4.0
;
; $Log$
;

	TITLE	Low-Level Timer routines

;
; These routines are written to interface to Microsoft C
; running under small data and small program model.
;

CEnter	Macro
	PUSH	BP
	MOV	BP,SP
	PUSH	DI
	PUSH	SI
	EndM

CLeave	Macro
	POP	SI
	POP	DI
	MOV	SP,BP
	POP	BP
	RET
	EndM

Save    Macro   R1,R2,R3,R4,R5,R6,R7,R8,R9,R10
        Irp     Rx,<R1,R2,R3,R4,R5,R6,R7,R8,R9,R10> ;Repeat for each parm
        Ifnb    <Rx>                            ;If this parm not blank
        Push    Rx                              ;Save the register
        Endif                                   ;End Ifnb
        Endm                                    ;End Irp


;;      The Restore macro makes use of the fact that R1-R10 are still defined,
;;      but, being a different macro, this will not expand when the Save macro
;;      is used.  Note that the Restore macro will restore whatever registers
;;      were last Save'd in the assembly listing, not during execution.
;;      Therefore, its use is restricted to restoring the previous sequential
;;      Save macro's registers.

Restore Macro
        Irp     Rx,<R10,R9,R8,R7,R6,R5,R4,R3,R2,R1> ;Repeat for each parm
        Ifnb    <Rx>                      ;If this parm not blank
        Pop     Rx                        ;Pop the register
        Endif                             ;End Ifnb
        Endm                              ;End Irp
        Endm                              ;End of Restore macro
        Endm                              ;End of Save Macro

DGROUP	GROUP	_DATA
	ASSUME	CS:_TEXT, DS:DGROUP, SS:DGROUP

_DATA	SEGMENT WORD PUBLIC 'DATA'
_DATA	ENDS

_TEXT	SEGMENT	BYTE PUBLIC 'CODE'

;
; long DOS_time();
;
;	Returns the DOS time from a Get Time command as a long integer
;
	PUBLIC _DOS_time
_DOS_time PROC NEAR

	CEnter				; Enter routine C style

	MOV	AH,2CH			; DOS Get Time command
	INT	21H			; Do DOS interrupt
	MOV	AX,DX			; Put low order in AX
	MOV	DX,CX			; Put high order in DX

	CLeave				; Leave routine C style

_DOS_time ENDP

;
; long DOS_date();
;
;	Returns the DOS date from a Get Date command as a long integer
;
	PUBLIC _DOS_date
_DOS_date PROC NEAR

	CEnter				; Enter routine C style

	MOV	AH,2AH			; DOS Get Date command
	INT	21H			; Do DOS interrupt
	MOV	AX,DX			; Put low order in AX
	MOV	DX,CX			; Put high order in DX

	CLeave				; Leave routine C style

_DOS_date ENDP

;
; int week_day ();
;
;	Returns the day of the week from DOS
;
	PUBLIC _week_day
_week_day PROC NEAR

	CEnter				; Enter routine C style

	MOV	AH,2AH			; DOS Get Date command
	INT	21H			; Do DOS interrupt
	XOR	AH,AH

	CLeave				; Leave routine C style

_week_day ENDP

_TEXT	ENDS
	END				; end of file com-int.asm
