.xlist
        page    64,132
        title   Mid-level FOSSIL Communications routines
        subttl  by Wynn Wagner III
        name    Com_Asm
        .sall
.list
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                       ;;
;; OPUS FOSSIL INTERFACE ;;
;;                       ;;  
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
; OPUS_ASM:  Node list compiler for Opus-Cbcs, v0.00
;
; ASSEMBLER: MicroSoft MASM, v4.00
;
; MACROS:    MicroSoft cMacros, v1.06 (included with MicroSoft C compiler)
;
;
;
;
; FOSSIL:    OPUS-Cbcs uses a standard interface to modems (data layer)
;            contained in a resident program which follows the FOSSIL
;            protocol.  This file contains routines used by OPUS-Cbcs
;            to communicate with the FOSSIL program.  For more information
;            about the specifications for a FOSSIL sub-system, contact
;            Vince Perriello (FidoNet 141/491).
;
;
;
;
; General notices/warnings/threats:
;
;    This source code is NOT public domain.  It has a copyright.  
;
;
; Specific notices/warnings/threats on USING this source code:
;
;    You are hereby given a limited license (permission) to use this source 
;    code in any manner you see fit as long as you do so in a lawful and
;    friendly manner and do not get any consideration other than goodwill 
;    from your efforts.  In other words, this material is not available for 
;    use in any product that is sold (including so-called ShareWare).  If 
;    you use this source code in any manner, then your end result must be 
;    freely available.
;
;
; Specific notices/warnings/threats on DISTRIBUTING this source code:
;
;    This source code may not be distributed if it is modified.
;
;    Also, you may not make money from the transfer of this source code.
;    In other words, you may not charge others for access to the material.
;    This includes transfer by diskette.  It also means that BBS's and other
;    systems which charge a fee are not allowed to keep this material 
;    on-line for download.
;
;    OPUS software is always free.  Period.  No exceptions.
;
;    If you purchased this source code, please contact OPUSinfo,
;    FidoNet<tm> 1/113, 1-214-991-3381.
;
;
; Notice about warranty:
;
;    Nothing in this file is warranted or guaranteed to do anything except
;    take up disk space.  If you cannot live without some warranty and/or
;    guarantee, them please don't use this material.
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
        if1
        %out    FOSSIL routines for OPUS-Cbcs
        %out    Copyright 1987. Wynn Wagner III. All Rights Reserved
        endif
        include version.inc
        include msdos.inc
        include cmacros.inc
        if2
        if memS ne 1
        error   <You have to use SMALL memory for this module.>
        endif
        endif
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; LOG:
;        WW3...18-Feb-87......Added ctrl-break logic to `Cominit()'
;
;
;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                       ;;  
;;     DEFINITIONS       ;;
;;                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
MODEM    equ      14H      ; interrupt taken over by FOSSIL programs
FROMOPUS equ    4f50H      ; see `Cominit()' for usage
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                       ;;  
;;       EXTERNAL        ;;
;;     DECLARATIONS      ;;
;;                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
; EXTRN   _kbdbreak:word 	commented out by vince
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                       ;;  
;;     DATA SEGMENT      ;;
;;                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
sBegin   data

staticW  Port,0

sEnd
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                       ;;  
;;     CODE SEGMENT      ;;
;;                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
sBegin   code

         assumes  cs,code
         assumes  ds,data
                                
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         page
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
         ;;                                          ;;
         ;; ROUTINE: _Com_                           ;;
         ;;                                          ;;
         ;; PURPOSE: General calls to FOSSIL         ;;
         ;;                                          ;;
         ;; USAGE:   int Com_(request,parm1);        ;;
         ;;          byte request, parm1;            ;;
         ;;                                          ;;
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cProc    Com_,<PUBLIC>,<si,di>

         parmB    request
         parmB    parm1

cBegin

         mov      ah, request
         mov      al, parm1
         mov      dx, Port
         int      MODEM

         cld
                
cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         page
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
         ;;                                          ;;
         ;; ROUTINE: _Cominit                        ;;
         ;;                                          ;;
         ;; PURPOSE: Initialize the FOSSIL system    ;;
         ;;                                          ;;
         ;; USAGE:   int Cominit(WhichPort);         ;;
         ;;          byte WhichPort                  ;;
         ;;                                          ;;
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cProc    Cominit,<PUBLIC>,<si,di>

         parmB    WhichPort

cBegin

         mov      ah,  4            ; initialization service request
         xor      dh,  dh
         mov      dl,  WhichPort
         mov      Port,dx
                                    ;-----------------------------------------
                                    ; ADDED: WW3 18-Feb-87
                                    ;
                                    ; On an initialization call, iff bx
                                    ; contains 0x4f50 and the FOSSIL program
                                    ; supports it, then when a control-break
                                    ; is detected from the keyboard, FOSSIL
                                    ; will set the value at DS:DX to 
                                    ; non-zero.
                                    ;
                                    ; This is an OPUS-only extension to
                                    ; FOSSIL primarily intended for non-IBM
                                    ; computers such as the DEC Rainbow.
                                    ;
                                    ; The example here assumes SMALL memory
                                    ; model.  For other models, you should
                                    ; add code to set DS to the correct
                                    ; segment.
                                    ;
;        mov      bx,  FROMOPUS     ; <--- Let FOSSIL know it's OPUS calling
;        lea      cx,  _kbdbreak    ; <--- Offset of control-break variable
                                    ;
                                    ; END ADDITION
                                    ;-----------------------------------------
         int      MODEM

         push     ax

         mov      ax, 0f01H         ; Use XON/XOFF
         mov      dx, Port
         int      MODEM

;        mov      ax, 1001H         ; Enable ^C/^K checking from remote
;        mov      dx, Port
;        int      MODEM

         cld
         pop      ax

cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


         page
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
         ;;                                          ;;
         ;; ROUTINE: _seconds                        ;;
         ;;                                          ;;
         ;; PURPOSE: Return the current seconds from ;;
         ;;          DOSs system clock.              ;;
         ;;                                          ;;
         ;; USAGE:   int seconds(void);              ;;
         ;;                                          ;;
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cProc    seconds,<PUBLIC>,<si,di>

cBegin

         callos   gettime
         mov      al, dh
         xor      ah, ah

cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         page
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
         ;;                                          ;;
         ;; ROUTINE: _computr                        ;;
         ;;                                          ;;
         ;; PURPOSE: Return the BIOS identification  ;;
         ;;          byte.                           ;;
         ;;                                          ;;
         ;; USAGE:   int computr(void);              ;;
         ;;                                          ;;
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cProc    computr,<PUBLIC>,<es>

cBegin

         mov      ax,0f000H
         mov      es,ax
         mov      al,es:0fffeH
         xor      ah,ah

cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         page
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
         ;;                                          ;;
         ;; ROUTINE: _fossil_gotoxy                  ;;
         ;;                                          ;;
         ;; PURPOSE: Send the local cursor to a      ;;
         ;;          screen location.  Column and    ;;
         ;;          row are both 0-based values.    ;;
         ;;                                          ;;
         ;; USAGE:   void fossil_gotoxy(column,row); ;;
         ;;          unsigned char column, row;      ;;
         ;;                                          ;;
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cProc    fossil_gotoxy,<PUBLIC>

         parmB    column
         parmB    row

cBegin

         mov      ah, 11h
         mov      dh, row
         mov      dl, column
         int      MODEM

         cld
                
cEnd


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         page
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
         ;;                                          ;;
         ;; ROUTINE: _fossil_whereami                ;;
         ;;                                          ;;
         ;; PURPOSE: Return the current screen       ;;
         ;;          location as two nybbles.        ;;
         ;;                                          ;;
         ;; USAGE:   int fossil_whereami(void);      ;;
         ;;                                          ;;
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cProc    fossil_whereami,<PUBLIC>

cBegin

         mov      ah, 12h
         int      MODEM
         mov      ax, dx

         cld
                
cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         page
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
         ;;                                          ;;
         ;; ROUTINE: _fossil_wherey                  ;;
         ;;                                          ;;
         ;; PURPOSE: Return the current column on    ;;
         ;;          the local monitor.              ;;
         ;;                                          ;;
         ;; USAGE:   int wherey(void);               ;;
         ;;                                          ;;
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cProc    fossil_wherey,<PUBLIC>

cBegin

         mov      ah, 12h
         int      MODEM
         mov      al, dh
         xor      ah, ah

         cld
                
cEnd


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         page
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
         ;;                                          ;;
         ;; ROUTINE: _fossil_wherex                  ;;
         ;;                                          ;;
         ;; PURPOSE: Return the current row on the   ;;
         ;;          local monitor.                  ;;
         ;;                                          ;;
         ;; USAGE:   int wherex(void);               ;;
         ;;                                          ;;
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cProc    fossil_wherex,<PUBLIC>

cBegin

         mov      ah, 12h
         int      MODEM
         mov      al, dl
         xor      ah, ah

         cld
                
cEnd


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


cProc    bios_gotoxy,<PUBLIC>
         parmB    x
         parmB    y

cBegin
         mov      dh, y
         mov      dl, x
         xor      bx, bx
         mov      ah, 2
         int      10H
cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cProc    bios_wherey,<PUBLIC>

cBegin
         xor      bx, bx
         mov      ah, 03H
         int      10H

         xor      ah, ah
         mov      al, dh
 
cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cProc    bios_wherex,<PUBLIC>

cBegin
         xor      bx, bx
         mov      ah, 03H
         int      10H

         xor      ah, ah
         mov      al, dl
 
cEnd


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                   
sEnd
         end

;; END OF FILE: Com_Asm.Asm ;;

