/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_CONNECTIVITY_SOURCE_DRIVERS_EVOAB2_NRESULTSETMETADATA_HXX
#define INCLUDED_CONNECTIVITY_SOURCE_DRIVERS_EVOAB2_NRESULTSETMETADATA_HXX

#include <com/sun/star/sdbc/XResultSetMetaData.hpp>
#include <cppuhelper/implbase.hxx>
#include "NConnection.hxx"
#include <rtl/ref.hxx>
#include <com/sun/star/connection/XConnection.hpp>
namespace connectivity
{
    namespace evoab
    {

        //************ Class: ResultSetMetaData

        typedef ::cppu::WeakImplHelper< css::sdbc::XResultSetMetaData>   OResultSetMetaData_BASE;

        class OEvoabResultSetMetaData : public  OResultSetMetaData_BASE
        {
          OUString       m_aTableName;
                  ::std::vector<sal_Int32>        m_aEvoabFields;

        protected:
            virtual ~OEvoabResultSetMetaData() override;
        public:
          explicit OEvoabResultSetMetaData(const OUString& _aTableName);
          void setEvoabFields(const ::rtl::Reference<connectivity::OSQLColumns> &xColumns) throw(css::sdbc::SQLException);
          inline sal_uInt32 fieldAtColumn(sal_Int32 columnIndex) const
                        { return m_aEvoabFields[columnIndex - 1]; }
          inline sal_Int32 getFieldSize() const
            {return m_aEvoabFields.size();}
          /// Avoid ambigous cast error from the compiler.
          inline operator css::uno::Reference< css::sdbc::XResultSetMetaData > () throw()
          { return this; }

          virtual sal_Int32 SAL_CALL getColumnCount(  ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Bool SAL_CALL isAutoIncrement( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Bool SAL_CALL isCaseSensitive( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Bool SAL_CALL isSearchable( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Bool SAL_CALL isCurrency( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Int32 SAL_CALL isNullable( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Bool SAL_CALL isSigned( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Int32 SAL_CALL getColumnDisplaySize( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual OUString SAL_CALL getColumnLabel( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual OUString SAL_CALL getColumnName( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual OUString SAL_CALL getSchemaName( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Int32 SAL_CALL getPrecision( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Int32 SAL_CALL getScale( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual OUString SAL_CALL getTableName( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual OUString SAL_CALL getCatalogName( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Int32 SAL_CALL getColumnType( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual OUString SAL_CALL getColumnTypeName( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Bool SAL_CALL isReadOnly( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Bool SAL_CALL isWritable( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual sal_Bool SAL_CALL isDefinitelyWritable( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
          virtual OUString SAL_CALL getColumnServiceName( sal_Int32 column ) throw(css::sdbc::SQLException, css::uno::RuntimeException, std::exception) override;
        };
    }
}

#endif // INCLUDED_CONNECTIVITY_SOURCE_DRIVERS_EVOAB2_NRESULTSETMETADATA_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
