/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.CallInstruction;
import sun.jvm.hotspot.asm.PCRelativeAddress;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;

public class SPARCCallInstruction
extends SPARCInstruction
implements CallInstruction {
    private final PCRelativeAddress addr;

    public SPARCCallInstruction(PCRelativeAddress addr) {
        super("call");
        this.addr = addr;
    }

    @Override
    public String asString(long currentPc, SymbolFinder symFinder) {
        long address = this.addr.getDisplacement() + currentPc;
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(symFinder.getSymbolFor(address));
        return buf.toString();
    }

    @Override
    public Address getBranchDestination() {
        return this.addr;
    }

    @Override
    public boolean isCall() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }
}

