/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.stats;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandles;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String VALUE = "value";
    static final String MS = "_ms";
    static final String MIN = "min";
    static final String MIN_MS = "min_ms";
    static final String MAX = "max";
    static final String MAX_MS = "max_ms";
    static final String MEAN = "mean";
    static final String MEAN_MS = "mean_ms";
    static final String MEDIAN = "median";
    static final String MEDIAN_MS = "median_ms";
    static final String STDDEV = "stddev";
    static final String STDDEV_MS = "stddev_ms";
    static final String P75 = "p75";
    static final String P75_MS = "p75_ms";
    static final String P95 = "p95";
    static final String P95_MS = "p95_ms";
    static final String P99 = "p99";
    static final String P99_MS = "p99_ms";
    static final String P999 = "p999";
    static final String P999_MS = "p999_ms";
    public static String[] OS_MXBEAN_CLASSES = new String[]{OperatingSystemMXBean.class.getName(), "com.sun.management.OperatingSystemMXBean", "com.sun.management.UnixOperatingSystemMXBean", "com.ibm.lang.management.OperatingSystemMXBean"};

    public static void addMetrics(NamedList<Object> lst, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        lst.add("avgRequestsPerSecond", (Object)timer.getMeanRate());
        lst.add("5minRateRequestsPerSecond", (Object)timer.getFiveMinuteRate());
        lst.add("15minRateRequestsPerSecond", (Object)timer.getFifteenMinuteRate());
        lst.add("avgTimePerRequest", (Object)MetricUtils.nsToMs(snapshot.getMean()));
        lst.add("medianRequestTime", (Object)MetricUtils.nsToMs(snapshot.getMedian()));
        lst.add("75thPcRequestTime", (Object)MetricUtils.nsToMs(snapshot.get75thPercentile()));
        lst.add("95thPcRequestTime", (Object)MetricUtils.nsToMs(snapshot.get95thPercentile()));
        lst.add("99thPcRequestTime", (Object)MetricUtils.nsToMs(snapshot.get99thPercentile()));
        lst.add("999thPcRequestTime", (Object)MetricUtils.nsToMs(snapshot.get999thPercentile()));
    }

    public static double nsToMs(double ns) {
        return ns / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    }

    public static NamedList toNamedList(MetricRegistry registry, List<MetricFilter> shouldMatchFilters, MetricFilter mustMatchFilter, boolean skipHistograms, boolean skipAggregateValues, boolean compact, Map<String, Object> metadata) {
        SimpleOrderedMap result = new SimpleOrderedMap();
        MetricUtils.toMaps(registry, shouldMatchFilters, mustMatchFilter, skipHistograms, skipAggregateValues, compact, (arg_0, arg_1) -> MetricUtils.lambda$toNamedList$0((NamedList)result, arg_0, arg_1));
        if (metadata != null && !metadata.isEmpty()) {
            result.add("_metadata_", metadata);
        }
        return result;
    }

    public static void toMaps(MetricRegistry registry, List<MetricFilter> shouldMatchFilters, MetricFilter mustMatchFilter, boolean skipHistograms, boolean skipAggregateValues, boolean compact, BiConsumer<String, Object> consumer) {
        Map metrics = registry.getMetrics();
        SortedSet names = registry.getNames();
        names.stream().filter(s -> shouldMatchFilters.stream().anyMatch(metricFilter -> metricFilter.matches(s, (Metric)metrics.get(s)))).filter(s -> mustMatchFilter.matches(s, (Metric)metrics.get(s))).forEach(n -> {
            Metric metric = (Metric)metrics.get(n);
            if (metric instanceof Counter) {
                Counter counter = (Counter)metric;
                consumer.accept((String)n, MetricUtils.convertCounter(counter, compact));
            } else if (metric instanceof Gauge) {
                Gauge gauge = (Gauge)metric;
                try {
                    consumer.accept((String)n, MetricUtils.convertGauge(gauge, compact));
                }
                catch (InternalError ie) {
                    if (n.startsWith("memory.") && ie.getMessage().contains("Memory Pool not found")) {
                        LOG.warn("Error converting gauge '" + n + "', possible JDK bug: SOLR-10362", (Throwable)ie);
                        consumer.accept((String)n, null);
                    }
                    throw ie;
                }
            } else if (metric instanceof Meter) {
                Meter meter = (Meter)metric;
                consumer.accept((String)n, MetricUtils.convertMeter(meter));
            } else if (metric instanceof Timer) {
                Timer timer = (Timer)metric;
                consumer.accept((String)n, MetricUtils.convertTimer(timer, skipHistograms));
            } else if (metric instanceof Histogram && !skipHistograms) {
                Histogram histogram = (Histogram)metric;
                consumer.accept((String)n, MetricUtils.convertHistogram(histogram));
            }
        });
    }

    static Map<String, Object> convertHistogram(Histogram histogram) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        Snapshot snapshot = histogram.getSnapshot();
        response.put("count", histogram.getCount());
        MetricUtils.addSnapshot(response, snapshot, false);
        return response;
    }

    static double nsToMs(boolean convert, double value) {
        if (convert) {
            return MetricUtils.nsToMs(value);
        }
        return value;
    }

    static void addSnapshot(Map<String, Object> response, Snapshot snapshot, boolean ms) {
        response.put(ms ? MIN_MS : MIN, MetricUtils.nsToMs(ms, snapshot.getMin()));
        response.put(ms ? MAX_MS : MAX, MetricUtils.nsToMs(ms, snapshot.getMax()));
        response.put(ms ? MEAN_MS : MEAN, MetricUtils.nsToMs(ms, snapshot.getMean()));
        response.put(ms ? MEDIAN_MS : MEDIAN, MetricUtils.nsToMs(ms, snapshot.getMedian()));
        response.put(ms ? STDDEV_MS : STDDEV, MetricUtils.nsToMs(ms, snapshot.getStdDev()));
        response.put(ms ? P75_MS : P75, MetricUtils.nsToMs(ms, snapshot.get75thPercentile()));
        response.put(ms ? P95_MS : P95, MetricUtils.nsToMs(ms, snapshot.get95thPercentile()));
        response.put(ms ? P99_MS : P99, MetricUtils.nsToMs(ms, snapshot.get99thPercentile()));
        response.put(ms ? P999_MS : P999, MetricUtils.nsToMs(ms, snapshot.get999thPercentile()));
    }

    static Map<String, Object> convertTimer(Timer timer, boolean skipHistograms) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("count", timer.getCount());
        response.put("meanRate", timer.getMeanRate());
        response.put("1minRate", timer.getOneMinuteRate());
        response.put("5minRate", timer.getFiveMinuteRate());
        response.put("15minRate", timer.getFifteenMinuteRate());
        if (!skipHistograms) {
            MetricUtils.addSnapshot(response, timer.getSnapshot(), true);
        }
        return response;
    }

    static Map<String, Object> convertMeter(Meter meter) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("count", meter.getCount());
        response.put("meanRate", meter.getMeanRate());
        response.put("1minRate", meter.getOneMinuteRate());
        response.put("5minRate", meter.getFiveMinuteRate());
        response.put("15minRate", meter.getFifteenMinuteRate());
        return response;
    }

    static Object convertGauge(Gauge gauge, boolean compact) {
        if (compact) {
            return gauge.getValue();
        }
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put(VALUE, gauge.getValue());
        return response;
    }

    static Object convertCounter(Counter counter, boolean compact) {
        if (compact) {
            return counter.getCount();
        }
        LinkedHashMap<String, Long> response = new LinkedHashMap<String, Long>();
        response.put("count", counter.getCount());
        return response;
    }

    public static ExecutorService instrumentedExecutorService(ExecutorService delegate, MetricRegistry metricRegistry, String scope) {
        return new InstrumentedExecutorService(delegate, metricRegistry, scope);
    }

    public static <T extends PlatformManagedObject> void addMXBeanMetrics(T obj, Class<? extends T> intf, String prefix, BiConsumer<String, Metric> consumer) {
        if (intf.isInstance(obj)) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(intf, intf.getSuperclass(), 3);
            }
            catch (IntrospectionException e) {
                LOG.warn("Unable to fetch properties of MXBean " + obj.getClass().getName());
                return;
            }
            for (PropertyDescriptor desc : beanInfo.getPropertyDescriptors()) {
                String name = desc.getName();
                try {
                    desc.getReadMethod().invoke(obj, new Object[0]);
                    Gauge gauge = () -> {
                        try {
                            return desc.getReadMethod().invoke((Object)obj, new Object[0]);
                        }
                        catch (InvocationTargetException ite) {
                            return null;
                        }
                        catch (IllegalAccessException e) {
                            return null;
                        }
                    };
                    String metricName = MetricRegistry.name((String)prefix, (String[])new String[]{name});
                    consumer.accept(metricName, (Metric)gauge);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static <T extends PlatformManagedObject> void addMXBeanMetrics(T obj, String[] interfaces, String prefix, BiConsumer<String, Metric> consumer) {
        for (String clazz : interfaces) {
            try {
                Class<PlatformManagedObject> intf = Class.forName(clazz).asSubclass(PlatformManagedObject.class);
                MetricUtils.addMXBeanMetrics(obj, intf, null, consumer);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void lambda$toNamedList$0(NamedList result, String k, Object v) {
        result.add(k, v);
    }
}

