/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uninverting;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.GrowableWriter;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedLongValues;
import org.apache.solr.uninverting.DocTermOrds;
import org.apache.solr.uninverting.FieldCache;
import org.apache.solr.uninverting.FieldCacheSanityChecker;

class FieldCacheImpl
implements FieldCache {
    private Map<Class<?>, Cache> caches;
    final LeafReader.CoreClosedListener purgeCore = this::purgeByCacheKey;
    private volatile PrintStream infoStream;

    FieldCacheImpl() {
        this.init();
    }

    private synchronized void init() {
        this.caches = new HashMap(6);
        this.caches.put(Long.TYPE, new LongCache(this));
        this.caches.put(BinaryDocValues.class, new BinaryDocValuesCache(this));
        this.caches.put(SortedDocValues.class, new SortedDocValuesCache(this));
        this.caches.put(DocTermOrds.class, new DocTermOrdsCache(this));
        this.caches.put(DocsWithFieldCache.class, new DocsWithFieldCache(this));
    }

    @Override
    public synchronized void purgeAllCaches() {
        this.init();
    }

    @Override
    public synchronized void purgeByCacheKey(Object coreCacheKey) {
        for (Cache c : this.caches.values()) {
            c.purgeByCacheKey(coreCacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized FieldCache.CacheEntry[] getCacheEntries() {
        ArrayList<FieldCache.CacheEntry> result = new ArrayList<FieldCache.CacheEntry>(17);
        for (Map.Entry<Class<?>, Cache> cacheEntry : this.caches.entrySet()) {
            Cache cache = cacheEntry.getValue();
            Class<?> cacheType = cacheEntry.getKey();
            Map<Object, Map<CacheKey, Accountable>> map = cache.readerCache;
            synchronized (map) {
                for (Map.Entry<Object, Map<CacheKey, Accountable>> readerCacheEntry : cache.readerCache.entrySet()) {
                    Object readerKey = readerCacheEntry.getKey();
                    if (readerKey == null) continue;
                    Map<CacheKey, Accountable> innerCache = readerCacheEntry.getValue();
                    for (Map.Entry<CacheKey, Accountable> mapEntry : innerCache.entrySet()) {
                        CacheKey entry = mapEntry.getKey();
                        result.add(new FieldCache.CacheEntry(readerKey, entry.field, cacheType, entry.custom, mapEntry.getValue()));
                    }
                }
            }
        }
        return result.toArray(new FieldCache.CacheEntry[result.size()]);
    }

    private void initReader(LeafReader reader) {
        reader.addCoreClosedListener(this.purgeCore);
    }

    void setDocsWithField(LeafReader reader, String field, Bits docsWithField, FieldCache.Parser parser) {
        Bits.MatchNoBits bits;
        int maxDoc = reader.maxDoc();
        if (docsWithField == null) {
            bits = new Bits.MatchNoBits(maxDoc);
        } else if (docsWithField instanceof FixedBitSet) {
            int numSet = ((FixedBitSet)docsWithField).cardinality();
            if (numSet >= maxDoc) {
                assert (numSet == maxDoc);
                bits = new Bits.MatchAllBits(maxDoc);
            } else {
                bits = docsWithField;
            }
        } else {
            bits = docsWithField;
        }
        this.caches.get(DocsWithFieldCache.class).put(reader, new CacheKey(field, parser), new BitsEntry((Bits)bits));
    }

    @Override
    public Bits getDocsWithField(LeafReader reader, String field, FieldCache.Parser parser) throws IOException {
        FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
        if (fieldInfo == null) {
            return new Bits.MatchNoBits(reader.maxDoc());
        }
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE) {
            return reader.getDocsWithField(field);
        }
        if (!(parser instanceof FieldCache.PointParser) && fieldInfo.getIndexOptions() == IndexOptions.NONE) {
            return new Bits.MatchNoBits(reader.maxDoc());
        }
        BitsEntry bitsEntry = (BitsEntry)this.caches.get(DocsWithFieldCache.class).get(reader, new CacheKey(field, parser), false);
        return bitsEntry.bits;
    }

    @Override
    public NumericDocValues getNumerics(LeafReader reader, String field, FieldCache.Parser parser, boolean setDocsWithField) throws IOException {
        if (parser == null) {
            throw new NullPointerException();
        }
        NumericDocValues valuesIn = reader.getNumericDocValues(field);
        if (valuesIn != null) {
            return valuesIn;
        }
        FieldInfo info = reader.getFieldInfos().fieldInfo(field);
        if (info == null) {
            return DocValues.emptyNumeric();
        }
        if (info.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + field + " was indexed as " + info.getDocValuesType());
        }
        if (parser instanceof FieldCache.PointParser) {
            if (info.getPointDimensionCount() == 0) {
                return DocValues.emptyNumeric();
            }
            if (info.getPointDimensionCount() != 1) {
                throw new IllegalStateException("Type mismatch: " + field + " was indexed with dimensions=" + info.getPointDimensionCount());
            }
            PointValues values = reader.getPointValues();
            if (values == null || values.size(field) == 0L) {
                return DocValues.emptyNumeric();
            }
            if (values.size(field) != (long)values.getDocCount(field)) {
                throw new IllegalStateException("Type mismatch: " + field + " was indexed with multiple values, numValues=" + values.size(field) + ",numDocs=" + values.getDocCount(field));
            }
        } else if (info.getIndexOptions() == IndexOptions.NONE) {
            return DocValues.emptyNumeric();
        }
        return (NumericDocValues)this.caches.get(Long.TYPE).get(reader, new CacheKey(field, parser), setDocsWithField);
    }

    @Override
    public SortedDocValues getTermsIndex(LeafReader reader, String field) throws IOException {
        return this.getTermsIndex(reader, field, 0.5f);
    }

    @Override
    public SortedDocValues getTermsIndex(LeafReader reader, String field, float acceptableOverheadRatio) throws IOException {
        SortedDocValues valuesIn = reader.getSortedDocValues(field);
        if (valuesIn != null) {
            return valuesIn;
        }
        FieldInfo info = reader.getFieldInfos().fieldInfo(field);
        if (info == null) {
            return DocValues.emptySorted();
        }
        if (info.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + field + " was indexed as " + info.getDocValuesType());
        }
        if (info.getIndexOptions() == IndexOptions.NONE) {
            return DocValues.emptySorted();
        }
        SortedDocValuesImpl impl = (SortedDocValuesImpl)this.caches.get(SortedDocValues.class).get(reader, new CacheKey(field, Float.valueOf(acceptableOverheadRatio)), false);
        return impl.iterator();
    }

    @Override
    public BinaryDocValues getTerms(LeafReader reader, String field, boolean setDocsWithField) throws IOException {
        return this.getTerms(reader, field, setDocsWithField, 0.5f);
    }

    @Override
    public BinaryDocValues getTerms(LeafReader reader, String field, boolean setDocsWithField, float acceptableOverheadRatio) throws IOException {
        BinaryDocValues valuesIn = reader.getBinaryDocValues(field);
        if (valuesIn == null) {
            valuesIn = reader.getSortedDocValues(field);
        }
        if (valuesIn != null) {
            return valuesIn;
        }
        FieldInfo info = reader.getFieldInfos().fieldInfo(field);
        if (info == null) {
            return DocValues.emptyBinary();
        }
        if (info.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + field + " was indexed as " + info.getDocValuesType());
        }
        if (info.getIndexOptions() == IndexOptions.NONE) {
            return DocValues.emptyBinary();
        }
        BinaryDocValuesImpl impl = (BinaryDocValuesImpl)this.caches.get(BinaryDocValues.class).get(reader, new CacheKey(field, Float.valueOf(acceptableOverheadRatio)), setDocsWithField);
        return impl.iterator();
    }

    @Override
    public SortedSetDocValues getDocTermOrds(LeafReader reader, String field, BytesRef prefix) throws IOException {
        assert (prefix == null || prefix == INT32_TERM_PREFIX || prefix == INT64_TERM_PREFIX);
        SortedSetDocValues dv = reader.getSortedSetDocValues(field);
        if (dv != null) {
            return dv;
        }
        SortedDocValues sdv = reader.getSortedDocValues(field);
        if (sdv != null) {
            return DocValues.singleton((SortedDocValues)sdv);
        }
        FieldInfo info = reader.getFieldInfos().fieldInfo(field);
        if (info == null) {
            return DocValues.emptySortedSet();
        }
        if (info.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + field + " was indexed as " + info.getDocValuesType());
        }
        if (info.getIndexOptions() == IndexOptions.NONE) {
            return DocValues.emptySortedSet();
        }
        Terms terms = reader.terms(field);
        if (terms == null) {
            return DocValues.emptySortedSet();
        }
        long numPostings = terms.getSumDocFreq();
        if (numPostings != -1L && numPostings == (long)terms.getDocCount()) {
            return DocValues.singleton((SortedDocValues)this.getTermsIndex(reader, field));
        }
        DocTermOrds dto = (DocTermOrds)this.caches.get(DocTermOrds.class).get(reader, new CacheKey(field, prefix), false);
        return dto.iterator(reader);
    }

    @Override
    public void setInfoStream(PrintStream stream) {
        this.infoStream = stream;
    }

    @Override
    public PrintStream getInfoStream() {
        return this.infoStream;
    }

    static final class DocTermOrdsCache
    extends Cache {
        DocTermOrdsCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Accountable createValue(LeafReader reader, CacheKey key, boolean setDocsWithField) throws IOException {
            BytesRef prefix = (BytesRef)key.custom;
            return new DocTermOrds(reader, null, key.field, prefix);
        }
    }

    static final class BinaryDocValuesCache
    extends Cache {
        BinaryDocValuesCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Accountable createValue(LeafReader reader, CacheKey key, boolean setDocsWithField) throws IOException {
            int startBPV;
            int maxDoc = reader.maxDoc();
            Terms terms = reader.terms(key.field);
            float acceptableOverheadRatio = ((Float)key.custom).floatValue();
            int termCountHardLimit = maxDoc;
            PagedBytes bytes = new PagedBytes(15);
            if (terms != null) {
                long numUniqueTerms = terms.size();
                if (numUniqueTerms != -1L) {
                    if (numUniqueTerms > (long)termCountHardLimit) {
                        numUniqueTerms = termCountHardLimit;
                    }
                    startBPV = PackedInts.bitsRequired((long)(numUniqueTerms * 4L));
                } else {
                    startBPV = 1;
                }
            } else {
                startBPV = 1;
            }
            GrowableWriter docToOffset = new GrowableWriter(startBPV, maxDoc, acceptableOverheadRatio);
            bytes.copyUsingLengthPrefix(new BytesRef());
            if (terms != null) {
                BytesRef term;
                int termCount = 0;
                TermsEnum termsEnum = terms.iterator();
                PostingsEnum docs = null;
                while (termCount++ != termCountHardLimit && (term = termsEnum.next()) != null) {
                    int docID;
                    long pointer = bytes.copyUsingLengthPrefix(term);
                    docs = termsEnum.postings(docs, 0);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        docToOffset.set(docID, pointer);
                    }
                }
            }
            PackedInts.Mutable offsetReader = docToOffset.getMutable();
            if (setDocsWithField) {
                this.wrapper.setDocsWithField(reader, key.field, new Bits((PackedInts.Reader)offsetReader, maxDoc){
                    final /* synthetic */ PackedInts.Reader val$offsetReader;
                    final /* synthetic */ int val$maxDoc;
                    {
                        this.val$offsetReader = reader;
                        this.val$maxDoc = n;
                    }

                    public boolean get(int index) {
                        return this.val$offsetReader.get(index) != 0L;
                    }

                    public int length() {
                        return this.val$maxDoc;
                    }
                }, null);
            }
            return new BinaryDocValuesImpl(bytes.freeze(true), (PackedInts.Reader)offsetReader);
        }
    }

    private static class BinaryDocValuesImpl
    implements Accountable {
        private final PagedBytes.Reader bytes;
        private final PackedInts.Reader docToOffset;

        public BinaryDocValuesImpl(PagedBytes.Reader bytes, PackedInts.Reader docToOffset) {
            this.bytes = bytes;
            this.docToOffset = docToOffset;
        }

        public BinaryDocValues iterator() {
            final BytesRef term = new BytesRef();
            return new BinaryDocValues(){

                public BytesRef get(int docID) {
                    long pointer = docToOffset.get(docID);
                    if (pointer == 0L) {
                        term.length = 0;
                    } else {
                        bytes.fill(term, pointer);
                    }
                    return term;
                }
            };
        }

        public long ramBytesUsed() {
            return this.bytes.ramBytesUsed() + this.docToOffset.ramBytesUsed() + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>(2);
            resources.add(Accountables.namedAccountable((String)"term bytes", (Accountable)this.bytes));
            resources.add(Accountables.namedAccountable((String)"addresses", (Accountable)this.docToOffset));
            return Collections.unmodifiableList(resources);
        }
    }

    static class SortedDocValuesCache
    extends Cache {
        SortedDocValuesCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Accountable createValue(LeafReader reader, CacheKey key, boolean setDocsWithField) throws IOException {
            int startTermsBPV;
            int maxDoc = reader.maxDoc();
            Terms terms = reader.terms(key.field);
            float acceptableOverheadRatio = ((Float)key.custom).floatValue();
            PagedBytes bytes = new PagedBytes(15);
            if (terms != null) {
                long numUniqueTerms = terms.size();
                if (numUniqueTerms != -1L) {
                    if (numUniqueTerms > (long)maxDoc) {
                        throw new IllegalStateException("Type mismatch: " + key.field + " was indexed with multiple values per document, use SORTED_SET instead");
                    }
                    startTermsBPV = PackedInts.bitsRequired((long)numUniqueTerms);
                } else {
                    startTermsBPV = 1;
                }
            } else {
                startTermsBPV = 1;
            }
            PackedLongValues.Builder termOrdToBytesOffset = PackedLongValues.monotonicBuilder((float)0.0f);
            GrowableWriter docToTermOrd = new GrowableWriter(startTermsBPV, maxDoc, acceptableOverheadRatio);
            int termOrd = 0;
            if (terms != null) {
                BytesRef term;
                TermsEnum termsEnum = terms.iterator();
                PostingsEnum docs = null;
                while ((term = termsEnum.next()) != null) {
                    int docID;
                    if (termOrd >= maxDoc) {
                        throw new IllegalStateException("Type mismatch: " + key.field + " was indexed with multiple values per document, use SORTED_SET instead");
                    }
                    termOrdToBytesOffset.add(bytes.copyUsingLengthPrefix(term));
                    docs = termsEnum.postings(docs, 0);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        docToTermOrd.set(docID, (long)(1 + termOrd));
                    }
                    ++termOrd;
                }
            }
            return new SortedDocValuesImpl(bytes.freeze(true), termOrdToBytesOffset.build(), (PackedInts.Reader)docToTermOrd.getMutable(), termOrd);
        }
    }

    public static class SortedDocValuesImpl
    implements Accountable {
        private final PagedBytes.Reader bytes;
        private final PackedLongValues termOrdToBytesOffset;
        private final PackedInts.Reader docToTermOrd;
        private final int numOrd;

        public SortedDocValuesImpl(PagedBytes.Reader bytes, PackedLongValues termOrdToBytesOffset, PackedInts.Reader docToTermOrd, int numOrd) {
            this.bytes = bytes;
            this.docToTermOrd = docToTermOrd;
            this.termOrdToBytesOffset = termOrdToBytesOffset;
            this.numOrd = numOrd;
        }

        public SortedDocValues iterator() {
            final BytesRef term = new BytesRef();
            return new SortedDocValues(){

                public int getValueCount() {
                    return numOrd;
                }

                public int getOrd(int docID) {
                    return (int)docToTermOrd.get(docID) - 1;
                }

                public BytesRef lookupOrd(int ord) {
                    if (ord < 0) {
                        throw new IllegalArgumentException("ord must be >=0 (got ord=" + ord + ")");
                    }
                    bytes.fill(term, termOrdToBytesOffset.get(ord));
                    return term;
                }
            };
        }

        public long ramBytesUsed() {
            return this.bytes.ramBytesUsed() + this.termOrdToBytesOffset.ramBytesUsed() + this.docToTermOrd.ramBytesUsed() + (long)(3 * RamUsageEstimator.NUM_BYTES_OBJECT_REF) + 4L;
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>(3);
            resources.add(Accountables.namedAccountable((String)"term bytes", (Accountable)this.bytes));
            resources.add(Accountables.namedAccountable((String)"ord -> term", (Accountable)this.termOrdToBytesOffset));
            resources.add(Accountables.namedAccountable((String)"doc -> ord", (Accountable)this.docToTermOrd));
            return Collections.unmodifiableList(resources);
        }
    }

    static final class LongCache
    extends Cache {
        LongCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Accountable createValue(final LeafReader reader, CacheKey key, boolean setDocsWithField) throws IOException {
            GrowableWriterAndMinValue values;
            final FieldCache.Parser parser = (FieldCache.Parser)key.custom;
            final HoldsOneThing valuesRef = new HoldsOneThing();
            Uninvert u = new Uninvert(parser instanceof FieldCache.PointParser){
                private long minValue;
                private long currentValue;
                private GrowableWriter values;

                @Override
                public void visitTerm(BytesRef term) {
                    this.currentValue = parser.parseValue(term);
                    if (this.values == null) {
                        int startBitsPerValue;
                        if (this.currentValue < 0L) {
                            this.minValue = this.currentValue;
                            startBitsPerValue = this.minValue == Long.MIN_VALUE ? 64 : PackedInts.bitsRequired((long)(-this.minValue));
                        } else {
                            this.minValue = 0L;
                            startBitsPerValue = PackedInts.bitsRequired((long)this.currentValue);
                        }
                        this.values = new GrowableWriter(startBitsPerValue, reader.maxDoc(), 0.5f);
                        if (this.minValue != 0L) {
                            this.values.fill(0, this.values.size(), -this.minValue);
                        }
                        valuesRef.set(new GrowableWriterAndMinValue(this.values, this.minValue));
                    }
                }

                @Override
                public void visitDoc(int docID) {
                    this.values.set(docID, this.currentValue - this.minValue);
                }

                @Override
                protected TermsEnum termsEnum(Terms terms) throws IOException {
                    return parser.termsEnum(terms);
                }
            };
            u.uninvert(reader, key.field, setDocsWithField);
            if (setDocsWithField) {
                this.wrapper.setDocsWithField(reader, key.field, u.docsWithField, parser);
            }
            if ((values = (GrowableWriterAndMinValue)valuesRef.get()) == null) {
                return new LongsFromArray((PackedInts.Reader)new PackedInts.NullReader(reader.maxDoc()), 0L);
            }
            return new LongsFromArray((PackedInts.Reader)values.writer.getMutable(), values.minValue);
        }
    }

    static class LongsFromArray
    extends NumericDocValues
    implements Accountable {
        private final PackedInts.Reader values;
        private final long minValue;

        public LongsFromArray(PackedInts.Reader values, long minValue) {
            this.values = values;
            this.minValue = minValue;
        }

        public long get(int docID) {
            return this.minValue + this.values.get(docID);
        }

        public long ramBytesUsed() {
            return this.values.ramBytesUsed() + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + 8L;
        }
    }

    static final class DocsWithFieldCache
    extends Cache {
        DocsWithFieldCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected BitsEntry createValue(LeafReader reader, CacheKey key, boolean setDocsWithField) throws IOException {
            String field = key.field;
            FieldCache.Parser parser = (FieldCache.Parser)key.custom;
            if (parser instanceof FieldCache.PointParser) {
                return this.createValuePoints(reader, field);
            }
            return this.createValuePostings(reader, field);
        }

        private BitsEntry createValuePoints(LeafReader reader, String field) throws IOException {
            int maxDoc = reader.maxDoc();
            PointValues values = reader.getPointValues();
            assert (values != null);
            assert (values.size(field) > 0L);
            int docCount = values.getDocCount(field);
            assert (docCount <= maxDoc);
            if (docCount == maxDoc) {
                return new BitsEntry((Bits)new Bits.MatchAllBits(maxDoc));
            }
            Uninvert u = new Uninvert(true){

                @Override
                protected TermsEnum termsEnum(Terms terms) throws IOException {
                    throw new AssertionError();
                }

                @Override
                protected void visitTerm(BytesRef term) {
                }

                @Override
                protected void visitDoc(int docID) {
                }
            };
            u.uninvert(reader, field, true);
            return new BitsEntry(u.docsWithField);
        }

        private BitsEntry createValuePostings(LeafReader reader, String field) throws IOException {
            int maxDoc = reader.maxDoc();
            FixedBitSet res = null;
            Terms terms = reader.terms(field);
            if (terms != null) {
                BytesRef term;
                int termsDocCount = terms.getDocCount();
                assert (termsDocCount <= maxDoc);
                if (termsDocCount == maxDoc) {
                    return new BitsEntry((Bits)new Bits.MatchAllBits(maxDoc));
                }
                TermsEnum termsEnum = terms.iterator();
                PostingsEnum docs = null;
                while ((term = termsEnum.next()) != null) {
                    int docID;
                    if (res == null) {
                        res = new FixedBitSet(maxDoc);
                    }
                    docs = termsEnum.postings(docs, 0);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        res.set(docID);
                    }
                }
            }
            if (res == null) {
                return new BitsEntry((Bits)new Bits.MatchNoBits(maxDoc));
            }
            int numSet = res.cardinality();
            if (numSet >= maxDoc) {
                assert (numSet == maxDoc);
                return new BitsEntry((Bits)new Bits.MatchAllBits(maxDoc));
            }
            return new BitsEntry((Bits)res);
        }
    }

    static class BitsEntry
    implements Accountable {
        final Bits bits;

        BitsEntry(Bits bits) {
            this.bits = bits;
        }

        public long ramBytesUsed() {
            long base = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            if (this.bits instanceof Bits.MatchAllBits || this.bits instanceof Bits.MatchNoBits) {
                return base;
            }
            return base + (long)(this.bits.length() >>> 3);
        }
    }

    private static class GrowableWriterAndMinValue {
        public GrowableWriter writer;
        public long minValue;

        GrowableWriterAndMinValue(GrowableWriter array, long minValue) {
            this.writer = array;
            this.minValue = minValue;
        }
    }

    private static class HoldsOneThing<T> {
        private T it;

        private HoldsOneThing() {
        }

        public void set(T it) {
            this.it = it;
        }

        public T get() {
            return this.it;
        }
    }

    private static abstract class Uninvert {
        public Bits docsWithField;
        final boolean points;

        Uninvert(boolean points) {
            this.points = points;
        }

        final void uninvert(LeafReader reader, String field, boolean setDocsWithField) throws IOException {
            if (this.points) {
                this.uninvertPoints(reader, field, setDocsWithField);
            } else {
                this.uninvertPostings(reader, field, setDocsWithField);
            }
        }

        final void uninvertPoints(LeafReader reader, String field, boolean setDocsWithField) throws IOException {
            final int maxDoc = reader.maxDoc();
            PointValues values = reader.getPointValues();
            assert (values != null);
            assert (values.size(field) > 0L);
            if (setDocsWithField) {
                int docCount = values.getDocCount(field);
                assert (docCount <= maxDoc);
                if (docCount == maxDoc) {
                    this.docsWithField = new Bits.MatchAllBits(maxDoc);
                    setDocsWithField = false;
                }
            }
            final boolean doDocsWithField = setDocsWithField;
            final BytesRef scratch = new BytesRef();
            values.intersect(field, new PointValues.IntersectVisitor(){

                public void visit(int docID) throws IOException {
                    throw new AssertionError();
                }

                public void visit(int docID, byte[] packedValue) throws IOException {
                    scratch.bytes = packedValue;
                    scratch.length = packedValue.length;
                    this.visitTerm(scratch);
                    this.visitDoc(docID);
                    if (doDocsWithField) {
                        if (docsWithField == null) {
                            docsWithField = new FixedBitSet(maxDoc);
                        }
                        ((FixedBitSet)docsWithField).set(docID);
                    }
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
            });
        }

        final void uninvertPostings(LeafReader reader, String field, boolean setDocsWithField) throws IOException {
            int maxDoc = reader.maxDoc();
            Terms terms = reader.terms(field);
            if (terms != null) {
                BytesRef term;
                if (setDocsWithField) {
                    int termsDocCount = terms.getDocCount();
                    assert (termsDocCount <= maxDoc);
                    if (termsDocCount == maxDoc) {
                        this.docsWithField = new Bits.MatchAllBits(maxDoc);
                        setDocsWithField = false;
                    }
                }
                TermsEnum termsEnum = this.termsEnum(terms);
                PostingsEnum docs = null;
                FixedBitSet docsWithField = null;
                while ((term = termsEnum.next()) != null) {
                    int docID;
                    this.visitTerm(term);
                    docs = termsEnum.postings(docs, 0);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        this.visitDoc(docID);
                        if (!setDocsWithField) continue;
                        if (docsWithField == null) {
                            docsWithField = new FixedBitSet(maxDoc);
                            this.docsWithField = docsWithField;
                        }
                        docsWithField.set(docID);
                    }
                }
            }
        }

        @Deprecated
        protected abstract TermsEnum termsEnum(Terms var1) throws IOException;

        protected abstract void visitTerm(BytesRef var1);

        protected abstract void visitDoc(int var1);
    }

    static class CacheKey {
        final String field;
        final Object custom;

        CacheKey(String field, Object custom) {
            this.field = field;
            this.custom = custom;
        }

        public boolean equals(Object o) {
            if (o instanceof CacheKey) {
                CacheKey other = (CacheKey)o;
                if (other.field.equals(this.field) && (other.custom == null ? this.custom == null : other.custom.equals(this.custom))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ (this.custom == null ? 0 : this.custom.hashCode());
        }
    }

    static abstract class Cache {
        final FieldCacheImpl wrapper;
        final Map<Object, Map<CacheKey, Accountable>> readerCache = new WeakHashMap<Object, Map<CacheKey, Accountable>>();

        Cache(FieldCacheImpl wrapper) {
            this.wrapper = wrapper;
        }

        protected abstract Accountable createValue(LeafReader var1, CacheKey var2, boolean var3) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void purgeByCacheKey(Object coreCacheKey) {
            Map<Object, Map<CacheKey, Accountable>> map = this.readerCache;
            synchronized (map) {
                this.readerCache.remove(coreCacheKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(LeafReader reader, CacheKey key, Accountable value) {
            Object readerKey = reader.getCoreCacheKey();
            Map<Object, Map<CacheKey, Accountable>> map = this.readerCache;
            synchronized (map) {
                Map<CacheKey, Accountable> innerCache = this.readerCache.get(readerKey);
                if (innerCache == null) {
                    innerCache = new HashMap<CacheKey, Accountable>();
                    this.readerCache.put(readerKey, innerCache);
                    this.wrapper.initReader(reader);
                }
                if (innerCache.get(key) == null) {
                    innerCache.put(key, value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(LeafReader reader, CacheKey key, boolean setDocsWithField) throws IOException {
            Accountable value;
            Map<CacheKey, Accountable> innerCache;
            Object readerKey = reader.getCoreCacheKey();
            Accountable accountable = this.readerCache;
            synchronized (accountable) {
                innerCache = this.readerCache.get(readerKey);
                if (innerCache == null) {
                    innerCache = new HashMap<CacheKey, Accountable>();
                    this.readerCache.put(readerKey, innerCache);
                    this.wrapper.initReader(reader);
                    value = null;
                } else {
                    value = innerCache.get(key);
                }
                if (value == null) {
                    value = new FieldCache.CreationPlaceholder();
                    innerCache.put(key, value);
                }
            }
            if (value instanceof FieldCache.CreationPlaceholder) {
                accountable = value;
                synchronized (accountable) {
                    FieldCache.CreationPlaceholder progress = (FieldCache.CreationPlaceholder)value;
                    if (progress.value == null) {
                        PrintStream infoStream;
                        progress.value = this.createValue(reader, key, setDocsWithField);
                        Map<Object, Map<CacheKey, Accountable>> map = this.readerCache;
                        synchronized (map) {
                            innerCache.put(key, progress.value);
                        }
                        if (key.custom != null && this.wrapper != null && (infoStream = this.wrapper.getInfoStream()) != null) {
                            this.printNewInsanity(infoStream, progress.value);
                        }
                    }
                    return progress.value;
                }
            }
            return value;
        }

        private void printNewInsanity(PrintStream infoStream, Object value) {
            FieldCacheSanityChecker.Insanity[] insanities = FieldCacheSanityChecker.checkSanity(this.wrapper);
            block0: for (int i = 0; i < insanities.length; ++i) {
                FieldCacheSanityChecker.Insanity insanity = insanities[i];
                FieldCache.CacheEntry[] entries = insanity.getCacheEntries();
                for (int j = 0; j < entries.length; ++j) {
                    if (entries[j].getValue() != value) continue;
                    infoStream.println("WARNING: new FieldCache insanity created\nDetails: " + insanity.toString());
                    infoStream.println("\nStack:\n");
                    new Throwable().printStackTrace(infoStream);
                    continue block0;
                }
            }
        }
    }
}

