/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.util.Pair;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.FieldEqualitor;
import org.apache.solr.client.solrj.io.eq.MultipleFieldEqualitor;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.eval.AndEvaluator;
import org.apache.solr.client.solrj.io.eval.BooleanEvaluator;
import org.apache.solr.client.solrj.io.eval.EqualsEvaluator;
import org.apache.solr.client.solrj.io.eval.GreaterThanEqualToEvaluator;
import org.apache.solr.client.solrj.io.eval.GreaterThanEvaluator;
import org.apache.solr.client.solrj.io.eval.LessThanEqualToEvaluator;
import org.apache.solr.client.solrj.io.eval.LessThanEvaluator;
import org.apache.solr.client.solrj.io.eval.NotEvaluator;
import org.apache.solr.client.solrj.io.eval.OrEvaluator;
import org.apache.solr.client.solrj.io.eval.RawValueEvaluator;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.FacetStream;
import org.apache.solr.client.solrj.io.stream.HavingStream;
import org.apache.solr.client.solrj.io.stream.ParallelStream;
import org.apache.solr.client.solrj.io.stream.RankStream;
import org.apache.solr.client.solrj.io.stream.RollupStream;
import org.apache.solr.client.solrj.io.stream.StatsStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.UniqueStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParser;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Bucket;
import org.apache.solr.client.solrj.io.stream.metrics.CountMetric;
import org.apache.solr.client.solrj.io.stream.metrics.MaxMetric;
import org.apache.solr.client.solrj.io.stream.metrics.MeanMetric;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;
import org.apache.solr.client.solrj.io.stream.metrics.MinMetric;
import org.apache.solr.client.solrj.io.stream.metrics.SumMetric;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.StreamHandler;
import org.apache.solr.handler.sql.LimitStream;
import org.apache.solr.handler.sql.SolrEnumerator;
import org.apache.solr.handler.sql.SolrRel;
import org.apache.solr.handler.sql.SolrSchema;
import org.apache.solr.handler.sql.SolrTableScan;

class SolrTable
extends AbstractQueryableTable
implements TranslatableTable {
    private static final String DEFAULT_QUERY = "*:*";
    private final String collection;
    private final SolrSchema schema;
    private RelProtoDataType protoRowType;

    SolrTable(SolrSchema schema, String collection) {
        super(Object[].class);
        this.schema = schema;
        this.collection = collection;
    }

    public String toString() {
        return "SolrTable {" + this.collection + "}";
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType == null) {
            this.protoRowType = this.schema.getRelDataType(this.collection);
        }
        return (RelDataType)this.protoRowType.apply((Object)typeFactory);
    }

    private Enumerable<Object> query(Properties properties) {
        return this.query(properties, Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, null);
    }

    private Enumerable<Object> query(Properties properties, final List<Map.Entry<String, Class>> fields, String query, List<Pair<String, String>> orders, List<String> buckets, List<Pair<String, String>> metricPairs, String limit, String negativeQuery, String havingPredicate) {
        TupleStream tupleStream;
        boolean mapReduce = "map_reduce".equals(properties.getProperty("aggregationMode"));
        boolean negative = Boolean.parseBoolean(negativeQuery);
        String q = null;
        q = query == null ? DEFAULT_QUERY : (negative ? "*:* AND " + query : query);
        String zk = properties.getProperty("zk");
        try {
            tupleStream = metricPairs.isEmpty() && buckets.isEmpty() ? this.handleSelect(zk, this.collection, q, fields, orders, limit) : (buckets.isEmpty() ? this.handleStats(zk, this.collection, q, metricPairs, fields) : (mapReduce ? this.handleGroupByMapReduce(zk, this.collection, properties, fields, q, orders, buckets, metricPairs, limit, havingPredicate) : this.handleGroupByFacet(zk, this.collection, fields, q, orders, buckets, metricPairs, limit, havingPredicate)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StreamContext streamContext = new StreamContext();
        streamContext.setSolrClientCache(StreamHandler.getClientCache());
        tupleStream.setStreamContext(streamContext);
        final TupleStream finalStream = tupleStream;
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new SolrEnumerator(finalStream, fields);
            }
        };
    }

    private static StreamComparator bucketSortComp(List<Bucket> buckets, Map<String, String> dirs) {
        FieldComparator[] comps = new FieldComparator[buckets.size()];
        for (int i = 0; i < buckets.size(); ++i) {
            ComparatorOrder comparatorOrder = ComparatorOrder.fromString((String)dirs.get(buckets.get(i).toString()));
            String sortKey = buckets.get(i).toString();
            comps[i] = new FieldComparator(sortKey, comparatorOrder);
        }
        if (comps.length == 1) {
            return comps[0];
        }
        return new MultipleFieldComparator((StreamComparator[])comps);
    }

    private static StreamComparator bucketSortComp(Bucket[] buckets, String dir) {
        FieldComparator[] comps = new FieldComparator[buckets.length];
        for (int i = 0; i < buckets.length; ++i) {
            ComparatorOrder comparatorOrder = SolrTable.ascDescComp(dir);
            String sortKey = buckets[i].toString();
            comps[i] = new FieldComparator(sortKey, comparatorOrder);
        }
        if (comps.length == 1) {
            return comps[0];
        }
        return new MultipleFieldComparator((StreamComparator[])comps);
    }

    private String getSortDirection(Map.Entry<String, String> order) {
        String direction = order.getValue();
        return direction == null ? "asc" : direction;
    }

    private StreamComparator getComp(List<? extends Map.Entry<String, String>> orders) {
        FieldComparator[] comps = new FieldComparator[orders.size()];
        for (int i = 0; i < orders.size(); ++i) {
            Map.Entry<String, String> order = orders.get(i);
            String direction = this.getSortDirection(order);
            ComparatorOrder comparatorOrder = ComparatorOrder.fromString((String)direction);
            String sortKey = order.getKey();
            comps[i] = new FieldComparator(sortKey, comparatorOrder);
        }
        if (comps.length == 1) {
            return comps[0];
        }
        return new MultipleFieldComparator((StreamComparator[])comps);
    }

    private List<Metric> buildMetrics(List<Pair<String, String>> metricPairs, boolean ifEmptyCount) {
        ArrayList<Metric> metrics = new ArrayList<Metric>(metricPairs.size());
        metrics.addAll(metricPairs.stream().map(this::getMetric).collect(Collectors.toList()));
        if (metrics.size() == 0 && ifEmptyCount) {
            metrics.add((Metric)new CountMetric());
        }
        return metrics;
    }

    private Metric getMetric(Pair<String, String> metricPair) {
        switch ((String)metricPair.getKey()) {
            case "COUNT": {
                return new CountMetric((String)metricPair.getValue());
            }
            case "SUM": 
            case "$SUM0": {
                return new SumMetric((String)metricPair.getValue());
            }
            case "MIN": {
                return new MinMetric((String)metricPair.getValue());
            }
            case "MAX": {
                return new MaxMetric((String)metricPair.getValue());
            }
            case "AVG": {
                return new MeanMetric((String)metricPair.getValue());
            }
        }
        throw new IllegalArgumentException((String)metricPair.getKey());
    }

    private TupleStream handleSelect(String zk, String collection, String query, List<Map.Entry<String, Class>> fields, List<Pair<String, String>> orders, String limit) throws IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("q", new String[]{query});
        for (Map.Entry<String, Class> entry : fields) {
            String fname = entry.getKey();
            if (limit == null && "score".equals(fname)) {
                throw new IOException("score is not a valid field for unlimited queries.");
            }
            if (!fname.contains("*")) continue;
            throw new IOException("* is not supported for column selection.");
        }
        String fl = this.getFields(fields);
        if (orders.size() > 0) {
            params.add("sort", new String[]{this.getSort(orders)});
        } else if (limit == null) {
            params.add("sort", new String[]{"_version_ desc"});
            fl = fl + ",_version_";
        } else {
            params.add("sort", new String[]{"score desc"});
            if (fl.indexOf("score") == -1) {
                fl = fl + ",score";
            }
        }
        params.add("fl", new String[]{fl});
        if (limit != null) {
            params.add("rows", new String[]{limit});
            return new LimitStream((TupleStream)new CloudSolrStream(zk, collection, (SolrParams)params), Integer.parseInt(limit));
        }
        params.add("qt", new String[]{"/export"});
        return new CloudSolrStream(zk, collection, (SolrParams)params);
    }

    private String getSort(List<Pair<String, String>> orders) {
        StringBuilder buf = new StringBuilder();
        for (Pair<String, String> pair : orders) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append((String)pair.getKey()).append(" ").append((String)pair.getValue());
        }
        return buf.toString();
    }

    private String getSingleSort(Pair<String, String> order) {
        StringBuilder buf = new StringBuilder();
        buf.append((String)order.getKey()).append(" ").append((String)order.getValue());
        return buf.toString();
    }

    private String getFields(List<Map.Entry<String, Class>> fields) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, Class> field : fields) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(field.getKey());
        }
        return buf.toString();
    }

    private String getFields(Set<String> fieldSet) {
        StringBuilder buf = new StringBuilder();
        for (String field : fieldSet) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(field);
        }
        return buf.toString();
    }

    private Set<String> getFieldSet(Metric[] metrics, List<Map.Entry<String, Class>> fields) {
        HashSet<String> set = new HashSet<String>();
        for (Metric metric : metrics) {
            for (String column : metric.getColumns()) {
                set.add(column);
            }
        }
        for (Map.Entry entry : fields) {
            if (((String)entry.getKey()).indexOf(40) != -1) continue;
            set.add((String)entry.getKey());
        }
        return set;
    }

    private static String getSortDirection(List<Pair<String, String>> orders) {
        Iterator<Pair<String, String>> iterator;
        if (orders != null && orders.size() > 0 && (iterator = orders.iterator()).hasNext()) {
            Pair<String, String> item = iterator.next();
            return (String)item.getValue();
        }
        return "asc";
    }

    private static String bucketSort(Bucket[] buckets, String dir) {
        StringBuilder buf = new StringBuilder();
        boolean comma = false;
        for (Bucket bucket : buckets) {
            if (comma) {
                buf.append(",");
            }
            buf.append(bucket.toString()).append(" ").append(dir);
            comma = true;
        }
        return buf.toString();
    }

    private static String getPartitionKeys(Bucket[] buckets) {
        StringBuilder buf = new StringBuilder();
        boolean comma = false;
        for (Bucket bucket : buckets) {
            if (comma) {
                buf.append(",");
            }
            buf.append(bucket.toString());
            comma = true;
        }
        return buf.toString();
    }

    private static boolean sortsEqual(Bucket[] buckets, String direction, List<Pair<String, String>> orders) {
        if (buckets.length != orders.size()) {
            return false;
        }
        for (int i = 0; i < buckets.length; ++i) {
            Bucket bucket = buckets[i];
            Pair<String, String> order = orders.get(i);
            if (!bucket.toString().equals(order.getKey())) {
                return false;
            }
            if (((String)order.getValue()).toLowerCase(Locale.ROOT).contains(direction.toLowerCase(Locale.ROOT))) continue;
            return false;
        }
        return true;
    }

    private TupleStream handleGroupByMapReduce(String zk, String collection, Properties properties, List<Map.Entry<String, Class>> fields, String query, List<Pair<String, String>> orders, List<String> _buckets, List<Pair<String, String>> metricPairs, String limit, String havingPredicate) throws IOException {
        HashMap<String, Class> fmap = new HashMap<String, Class>();
        for (Map.Entry<String, Class> entry : fields) {
            fmap.put(entry.getKey(), entry.getValue());
        }
        int numWorkers = Integer.parseInt(properties.getProperty("numWorkers", "1"));
        Bucket[] buckets = this.buildBuckets(_buckets, fields);
        Metric[] metrics = this.buildMetrics(metricPairs, false).toArray(new Metric[0]);
        if (metrics.length == 0) {
            return this.handleSelectDistinctMapReduce(zk, collection, properties, fields, query, orders, buckets, limit);
        }
        for (Metric metric : metrics) {
            Class c = (Class)fmap.get(metric.getIdentifier());
            if (!Long.class.equals((Object)c)) continue;
            metric.outputLong = true;
        }
        Set<String> fieldSet = this.getFieldSet(metrics, fields);
        if (metrics.length == 0) {
            throw new IOException("Group by queries must include atleast one aggregate function.");
        }
        String fl = this.getFields(fieldSet);
        String sortDirection = SolrTable.getSortDirection(orders);
        String sort = SolrTable.bucketSort(buckets, sortDirection);
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("fl", new String[]{fl});
        params.set("q", new String[]{query});
        params.set("wt", new String[]{"javabin"});
        params.set("qt", new String[]{"/export"});
        if (numWorkers > 1) {
            params.set("partitionKeys", new String[]{SolrTable.getPartitionKeys(buckets)});
        }
        params.set("sort", new String[]{sort});
        Object tupleStream = null;
        CloudSolrStream cstream = new CloudSolrStream(zk, collection, (SolrParams)params);
        tupleStream = new RollupStream((TupleStream)cstream, buckets, metrics);
        StreamFactory factory = new StreamFactory().withFunctionName("search", CloudSolrStream.class).withFunctionName("parallel", ParallelStream.class).withFunctionName("rollup", RollupStream.class).withFunctionName("sum", SumMetric.class).withFunctionName("min", MinMetric.class).withFunctionName("max", MaxMetric.class).withFunctionName("avg", MeanMetric.class).withFunctionName("count", CountMetric.class).withFunctionName("and", AndEvaluator.class).withFunctionName("or", OrEvaluator.class).withFunctionName("not", NotEvaluator.class).withFunctionName("eq", EqualsEvaluator.class).withFunctionName("gt", GreaterThanEvaluator.class).withFunctionName("lt", LessThanEvaluator.class).withFunctionName("val", RawValueEvaluator.class).withFunctionName("lteq", LessThanEqualToEvaluator.class).withFunctionName("having", HavingStream.class).withFunctionName("gteq", GreaterThanEqualToEvaluator.class);
        if (havingPredicate != null) {
            BooleanEvaluator booleanOperation = (BooleanEvaluator)factory.constructEvaluator(StreamExpressionParser.parse((String)havingPredicate));
            tupleStream = new HavingStream((TupleStream)tupleStream, booleanOperation);
        }
        if (numWorkers > 1) {
            StreamComparator comp = SolrTable.bucketSortComp(buckets, sortDirection);
            ParallelStream parallelStream = new ParallelStream(zk, collection, (TupleStream)tupleStream, numWorkers, comp);
            parallelStream.setStreamFactory(factory);
            tupleStream = parallelStream;
        }
        if (orders != null && orders.size() > 0) {
            if (!SolrTable.sortsEqual(buckets, sortDirection, orders)) {
                int lim = limit == null ? 100 : Integer.parseInt(limit);
                StreamComparator comp = this.getComp(orders);
                tupleStream = new RankStream((TupleStream)tupleStream, lim, comp);
            } else if (limit != null) {
                tupleStream = new LimitStream((TupleStream)tupleStream, Integer.parseInt(limit));
            }
        } else if (limit != null) {
            tupleStream = new LimitStream((TupleStream)tupleStream, Integer.parseInt(limit));
        }
        return tupleStream;
    }

    private Bucket[] buildBuckets(List<String> buckets, List<Map.Entry<String, Class>> fields) {
        Bucket[] bucketsArray = new Bucket[buckets.size()];
        int i = 0;
        for (Map.Entry<String, Class> field : fields) {
            String fieldName = field.getKey();
            if (!buckets.contains(fieldName)) continue;
            bucketsArray[i++] = new Bucket(fieldName);
        }
        return bucketsArray;
    }

    private TupleStream handleGroupByFacet(String zkHost, String collection, List<Map.Entry<String, Class>> fields, String query, List<Pair<String, String>> orders, List<String> bucketFields, List<Pair<String, String>> metricPairs, String lim, String havingPredicate) throws IOException {
        HashMap<String, Class> fmap = new HashMap<String, Class>();
        for (Map.Entry<String, Class> f : fields) {
            fmap.put(f.getKey(), f.getValue());
        }
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.add("q", new String[]{query});
        Bucket[] buckets = this.buildBuckets(bucketFields, fields);
        Metric[] metrics = this.buildMetrics(metricPairs, true).toArray(new Metric[0]);
        if (metrics.length == 0) {
            metrics = new Metric[]{new CountMetric()};
        } else {
            for (Metric metric : metrics) {
                Class c = (Class)fmap.get(metric.getIdentifier());
                if (!Long.class.equals((Object)c)) continue;
                metric.outputLong = true;
            }
        }
        int limit = lim != null ? Integer.parseInt(lim) : 1000;
        FieldComparator[] sorts = null;
        if (orders == null || orders.size() == 0) {
            sorts = new FieldComparator[buckets.length];
            for (int i = 0; i < sorts.length; ++i) {
                sorts[i] = new FieldComparator("index", ComparatorOrder.ASCENDING);
            }
        } else {
            sorts = SolrTable.getComps(orders);
        }
        int overfetch = (int)((double)limit * 1.25);
        Object tupleStream = new FacetStream(zkHost, collection, (SolrParams)solrParams, buckets, metrics, sorts, overfetch);
        StreamFactory factory = new StreamFactory().withFunctionName("search", CloudSolrStream.class).withFunctionName("parallel", ParallelStream.class).withFunctionName("rollup", RollupStream.class).withFunctionName("sum", SumMetric.class).withFunctionName("min", MinMetric.class).withFunctionName("max", MaxMetric.class).withFunctionName("avg", MeanMetric.class).withFunctionName("count", CountMetric.class).withFunctionName("and", AndEvaluator.class).withFunctionName("or", OrEvaluator.class).withFunctionName("not", NotEvaluator.class).withFunctionName("eq", EqualsEvaluator.class).withFunctionName("val", RawValueEvaluator.class).withFunctionName("gt", GreaterThanEvaluator.class).withFunctionName("lt", LessThanEvaluator.class).withFunctionName("lteq", LessThanEqualToEvaluator.class).withFunctionName("gteq", GreaterThanEqualToEvaluator.class);
        if (havingPredicate != null) {
            BooleanEvaluator booleanOperation = (BooleanEvaluator)factory.constructEvaluator(StreamExpressionParser.parse((String)havingPredicate));
            tupleStream = new HavingStream((TupleStream)tupleStream, booleanOperation);
        }
        if (lim != null) {
            tupleStream = new LimitStream((TupleStream)tupleStream, limit);
        }
        return tupleStream;
    }

    private TupleStream handleSelectDistinctMapReduce(String zkHost, String collection, Properties properties, List<Map.Entry<String, Class>> fields, String query, List<Pair<String, String>> orders, Bucket[] buckets, String limit) throws IOException {
        int i;
        int numWorkers = Integer.parseInt(properties.getProperty("numWorkers", "1"));
        String fl = this.getFields(fields);
        String sort = null;
        FieldEqualitor ecomp = null;
        StreamComparator comp = null;
        if (orders != null && orders.size() > 0) {
            StreamComparator[] adjustedSorts = this.adjustSorts(orders, buckets);
            FieldEqualitor[] fieldEqualitors = new FieldEqualitor[adjustedSorts.length];
            StringBuilder buf = new StringBuilder();
            for (i = 0; i < adjustedSorts.length; ++i) {
                FieldComparator fieldComparator = (FieldComparator)adjustedSorts[i];
                fieldEqualitors[i] = new FieldEqualitor(fieldComparator.getLeftFieldName());
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(fieldComparator.getLeftFieldName()).append(" ").append(fieldComparator.getOrder().toString());
            }
            sort = buf.toString();
            if (adjustedSorts.length == 1) {
                ecomp = fieldEqualitors[0];
                comp = adjustedSorts[0];
            } else {
                ecomp = new MultipleFieldEqualitor((StreamEqualitor[])fieldEqualitors);
                comp = new MultipleFieldComparator(adjustedSorts);
            }
        } else {
            StringBuilder sortBuf = new StringBuilder();
            FieldEqualitor[] equalitors = new FieldEqualitor[buckets.length];
            StreamComparator[] streamComparators = new StreamComparator[buckets.length];
            for (i = 0; i < buckets.length; ++i) {
                equalitors[i] = new FieldEqualitor(buckets[i].toString());
                streamComparators[i] = new FieldComparator(buckets[i].toString(), ComparatorOrder.ASCENDING);
                if (i > 0) {
                    sortBuf.append(',');
                }
                sortBuf.append(buckets[i].toString()).append(" asc");
            }
            sort = sortBuf.toString();
            if (equalitors.length == 1) {
                ecomp = equalitors[0];
                comp = streamComparators[0];
            } else {
                ecomp = new MultipleFieldEqualitor((StreamEqualitor[])equalitors);
                comp = new MultipleFieldComparator(streamComparators);
            }
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("fl", new String[]{fl});
        params.set("q", new String[]{query});
        params.set("wt", new String[]{"javabin"});
        params.set("qt", new String[]{"/export"});
        if (numWorkers > 1) {
            params.set("partitionKeys", new String[]{SolrTable.getPartitionKeys(buckets)});
        }
        params.set("sort", new String[]{sort});
        Object tupleStream = null;
        CloudSolrStream cstream = new CloudSolrStream(zkHost, collection, (SolrParams)params);
        tupleStream = new UniqueStream((TupleStream)cstream, (StreamEqualitor)ecomp);
        if (numWorkers > 1) {
            ParallelStream parallelStream = new ParallelStream(zkHost, collection, (TupleStream)tupleStream, numWorkers, comp);
            StreamFactory factory = new StreamFactory().withFunctionName("search", CloudSolrStream.class).withFunctionName("parallel", ParallelStream.class).withFunctionName("unique", UniqueStream.class);
            parallelStream.setStreamFactory(factory);
            tupleStream = parallelStream;
        }
        if (limit != null) {
            tupleStream = new LimitStream((TupleStream)tupleStream, Integer.parseInt(limit));
        }
        return tupleStream;
    }

    private StreamComparator[] adjustSorts(List<Pair<String, String>> orders, Bucket[] buckets) throws IOException {
        ArrayList<FieldComparator> adjustedSorts = new ArrayList<FieldComparator>();
        HashSet<String> bucketFields = new HashSet<String>();
        HashSet<Object> sortFields = new HashSet<Object>();
        ComparatorOrder comparatorOrder = ComparatorOrder.ASCENDING;
        for (Pair<String, String> pair : orders) {
            sortFields.add(pair.getKey());
            adjustedSorts.add(new FieldComparator((String)pair.getKey(), SolrTable.ascDescComp((String)pair.getValue())));
            comparatorOrder = SolrTable.ascDescComp((String)pair.getValue());
        }
        for (Object bucket : buckets) {
            bucketFields.add(bucket.toString());
        }
        for (String string : sortFields) {
            if (bucketFields.contains(string)) continue;
            throw new IOException("All sort fields must be in the field list.");
        }
        if (sortFields.size() < buckets.length) {
            for (Object bucket : buckets) {
                String b = bucket.toString();
                if (sortFields.contains(b)) continue;
                adjustedSorts.add(new FieldComparator(bucket.toString(), comparatorOrder));
            }
        }
        return (StreamComparator[])adjustedSorts.toArray(new FieldComparator[adjustedSorts.size()]);
    }

    private TupleStream handleStats(String zk, String collection, String query, List<Pair<String, String>> metricPairs, List<Map.Entry<String, Class>> fields) {
        Metric[] metrics;
        HashMap<String, Class> fmap = new HashMap<String, Class>();
        for (Map.Entry<String, Class> entry : fields) {
            fmap.put(entry.getKey(), entry.getValue());
        }
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.add("q", new String[]{query});
        for (Metric metric : metrics = this.buildMetrics(metricPairs, false).toArray(new Metric[0])) {
            Class c = (Class)fmap.get(metric.getIdentifier());
            if (!Long.class.equals((Object)c)) continue;
            metric.outputLong = true;
        }
        return new StatsStream(zk, collection, (SolrParams)solrParams, metrics);
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new SolrQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new SolrTableScan(cluster, cluster.traitSetOf((RelTrait)SolrRel.CONVENTION), relOptTable, this, null);
    }

    private static FieldComparator[] getComps(List<Pair<String, String>> orders) {
        FieldComparator[] comps = new FieldComparator[orders.size()];
        for (int i = 0; i < orders.size(); ++i) {
            Pair<String, String> sortItem = orders.get(i);
            String ordering = (String)sortItem.getValue();
            ComparatorOrder comparatorOrder = SolrTable.ascDescComp(ordering);
            String sortKey = (String)sortItem.getKey();
            comps[i] = new FieldComparator(sortKey, comparatorOrder);
        }
        return comps;
    }

    private static ComparatorOrder ascDescComp(String s) {
        if (s.toLowerCase(Locale.ROOT).contains("desc")) {
            return ComparatorOrder.DESCENDING;
        }
        return ComparatorOrder.ASCENDING;
    }

    public static class SolrQueryable<T>
    extends AbstractTableQueryable<T> {
        SolrQueryable(QueryProvider queryProvider, SchemaPlus schema, SolrTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            Enumerable enumerable = this.getTable().query(this.getProperties());
            return enumerable.enumerator();
        }

        private SolrTable getTable() {
            return (SolrTable)this.table;
        }

        private Properties getProperties() {
            return ((SolrSchema)((Object)this.schema.unwrap(SolrSchema.class))).properties;
        }

        public Enumerable<Object> query(List<Map.Entry<String, Class>> fields, String query, List<Pair<String, String>> order, List<String> buckets, List<Pair<String, String>> metricPairs, String limit, String negativeQuery, String havingPredicate) {
            return this.getTable().query(this.getProperties(), fields, query, order, buckets, metricPairs, limit, negativeQuery, havingPredicate);
        }
    }
}

