/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.text.NumberFormat;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;

final class LongArrayFormatter
implements Formatter {
    public static final LongArrayFormatter INSTANCE = new LongArrayFormatter();

    LongArrayFormatter() {
    }

    @Override
    public boolean accept(Object o) {
        return o instanceof long[];
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public void format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        NumberFormat f = context.getNumberFormat();
        long[] array = (long[])o;
        out.append('[');
        for (int i = 0; i < array.length; ++i) {
            if (f != null) {
                StringFormatter.serialize(context, f.format(array[i]), out);
            } else {
                out.append(String.valueOf(array[i]));
            }
            if (i == array.length - 1) continue;
            out.append(',');
            if (!context.isPrettyPrint()) continue;
            out.append(' ');
        }
        out.append(']');
    }
}

