/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSharedWorkerGlobalScope.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAbortController.h"
#include "JSAbortSignal.h"
#include "JSByteLengthQueuingStrategy.h"
#include "JSCompressionStream.h"
#include "JSCompressionStreamEncoder.h"
#include "JSCountQueuingStrategy.h"
#include "JSCustomEvent.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMURL.h"
#include "JSDOMWrapperCache.h"
#include "JSDecompressionStream.h"
#include "JSDecompressionStreamDecoder.h"
#include "JSErrorEvent.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSEventTarget.h"
#include "JSFileReaderSync.h"
#include "JSPerformance.h"
#include "JSPerformanceEntry.h"
#include "JSPerformanceMark.h"
#include "JSPerformanceMeasure.h"
#include "JSPerformanceObserver.h"
#include "JSPerformanceObserverEntryList.h"
#include "JSPerformanceResourceTiming.h"
#include "JSPerformanceServerTiming.h"
#include "JSPromiseRejectionEvent.h"
#include "JSReadableByteStreamController.h"
#include "JSReadableStream.h"
#include "JSReadableStreamBYOBReader.h"
#include "JSReadableStreamBYOBRequest.h"
#include "JSReadableStreamDefaultController.h"
#include "JSReadableStreamDefaultReader.h"
#include "JSSharedWorkerGlobalScope.h"
#include "JSTextDecoder.h"
#include "JSTextDecoderStream.h"
#include "JSTextEncoder.h"
#include "JSTextEncoderStream.h"
#include "JSTransformStream.h"
#include "JSTransformStreamDefaultController.h"
#include "JSURLSearchParams.h"
#include "JSWritableStream.h"
#include "JSWritableStreamDefaultController.h"
#include "JSWritableStreamDefaultWriter.h"
#include "JSXMLHttpRequest.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSharedWorkerGlobalScopeInstanceFunction_close);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScopeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_name);
static JSC_DECLARE_CUSTOM_SETTER(setJSSharedWorkerGlobalScope_name);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_onconnect);
static JSC_DECLARE_CUSTOM_SETTER(setJSSharedWorkerGlobalScope_onconnect);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_CompressionStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_CompressionStreamEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_DecompressionStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_DecompressionStreamDecoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ByteLengthQueuingStrategyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_CountQueuingStrategyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ReadableByteStreamControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ReadableStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ReadableStreamBYOBReaderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ReadableStreamBYOBRequestConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ReadableStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ReadableStreamDefaultReaderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_TransformStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_TransformStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_WritableStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_WritableStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_WritableStreamDefaultWriterConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_AbortControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_AbortSignalConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_CustomEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ErrorEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_EventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_EventTargetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PromiseRejectionEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_TextDecoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_TextDecoderStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_TextEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_TextEncoderStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_FileReaderSyncConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_URLConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_URLSearchParamsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceEntryConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceMarkConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceMeasureConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceObserverConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceObserverEntryListConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceResourceTimingConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceServerTimingConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_SharedWorkerGlobalScopeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_XMLHttpRequestConstructor);

using JSSharedWorkerGlobalScopeDOMConstructor = JSDOMConstructorNotConstructable<JSSharedWorkerGlobalScope>;

/* Hash table */

static const struct CompactHashIndex JSSharedWorkerGlobalScopeTableIndex[131] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 25, -1 },
    { -1, -1 },
    { -1, -1 },
    { 28, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 21, -1 },
    { 18, -1 },
    { -1, -1 },
    { 5, -1 },
    { 0, -1 },
    { 8, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 33, -1 },
    { 22, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 4, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 20, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 2, -1 },
    { 15, 129 },
    { 6, -1 },
    { -1, -1 },
    { 29, -1 },
    { -1, -1 },
    { 10, 128 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 13, -1 },
    { -1, -1 },
    { -1, -1 },
    { 12, -1 },
    { 7, -1 },
    { -1, -1 },
    { 30, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 9, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 17, -1 },
    { 31, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 32, -1 },
    { -1, -1 },
    { 1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 19, -1 },
    { -1, -1 },
    { 26, -1 },
    { -1, -1 },
    { -1, -1 },
    { 11, -1 },
    { -1, -1 },
    { 14, -1 },
    { -1, -1 },
    { 16, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 24, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 3, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 23, -1 },
    { 27, 130 },
    { 34, -1 },
};


static const HashTableValue JSSharedWorkerGlobalScopeTableValues[] =
{
    { "name"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_name, setJSSharedWorkerGlobalScope_name } },
    { "onconnect"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_onconnect, setJSSharedWorkerGlobalScope_onconnect } },
    { "ByteLengthQueuingStrategy"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_ByteLengthQueuingStrategyConstructor, 0 } },
    { "CountQueuingStrategy"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_CountQueuingStrategyConstructor, 0 } },
    { "ReadableStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_ReadableStreamConstructor, 0 } },
    { "ReadableStreamDefaultController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_ReadableStreamDefaultControllerConstructor, 0 } },
    { "ReadableStreamDefaultReader"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_ReadableStreamDefaultReaderConstructor, 0 } },
    { "TransformStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_TransformStreamConstructor, 0 } },
    { "TransformStreamDefaultController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_TransformStreamDefaultControllerConstructor, 0 } },
    { "WritableStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_WritableStreamConstructor, 0 } },
    { "WritableStreamDefaultController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_WritableStreamDefaultControllerConstructor, 0 } },
    { "WritableStreamDefaultWriter"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_WritableStreamDefaultWriterConstructor, 0 } },
    { "AbortController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_AbortControllerConstructor, 0 } },
    { "AbortSignal"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_AbortSignalConstructor, 0 } },
    { "CustomEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_CustomEventConstructor, 0 } },
    { "ErrorEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_ErrorEventConstructor, 0 } },
    { "Event"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_EventConstructor, 0 } },
    { "EventTarget"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_EventTargetConstructor, 0 } },
    { "PromiseRejectionEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_PromiseRejectionEventConstructor, 0 } },
    { "TextDecoder"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_TextDecoderConstructor, 0 } },
    { "TextDecoderStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_TextDecoderStreamConstructor, 0 } },
    { "TextEncoder"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_TextEncoderConstructor, 0 } },
    { "TextEncoderStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_TextEncoderStreamConstructor, 0 } },
    { "URL"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_URLConstructor, 0 } },
    { "URLSearchParams"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_URLSearchParamsConstructor, 0 } },
    { "Performance"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_PerformanceConstructor, 0 } },
    { "PerformanceEntry"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_PerformanceEntryConstructor, 0 } },
    { "PerformanceMark"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_PerformanceMarkConstructor, 0 } },
    { "PerformanceMeasure"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_PerformanceMeasureConstructor, 0 } },
    { "PerformanceObserver"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_PerformanceObserverConstructor, 0 } },
    { "PerformanceObserverEntryList"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_PerformanceObserverEntryListConstructor, 0 } },
    { "PerformanceResourceTiming"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_PerformanceResourceTimingConstructor, 0 } },
    { "PerformanceServerTiming"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_PerformanceServerTimingConstructor, 0 } },
    { "XMLHttpRequest"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScope_XMLHttpRequestConstructor, 0 } },
    { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSharedWorkerGlobalScopeInstanceFunction_close, 0 } },
};

static const HashTable JSSharedWorkerGlobalScopeTable = { 35, 127, static_cast<uint8_t>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::Function), JSSharedWorkerGlobalScope::info(), JSSharedWorkerGlobalScopeTableValues, JSSharedWorkerGlobalScopeTableIndex };
template<> const ClassInfo JSSharedWorkerGlobalScopeDOMConstructor::s_info = { "SharedWorkerGlobalScope"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSharedWorkerGlobalScopeDOMConstructor) };

template<> JSValue JSSharedWorkerGlobalScopeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSWorkerGlobalScope::getConstructor(vm, &globalObject);
}

template<> void JSSharedWorkerGlobalScopeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SharedWorkerGlobalScope"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, globalObject.getPrototypeDirect(), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const struct CompactHashIndex JSSharedWorkerGlobalScopePrototypeTableIndex[2] = {
    { -1, -1 },
    { 0, -1 },
};


static const HashTableValue JSSharedWorkerGlobalScopePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSharedWorkerGlobalScopeConstructor, 0 } },
};

static const HashTable JSSharedWorkerGlobalScopePrototypeTable = { 1, 1, static_cast<uint8_t>(static_cast<unsigned>(PropertyAttribute::DontEnum)), JSSharedWorkerGlobalScope::info(), JSSharedWorkerGlobalScopePrototypeTableValues, JSSharedWorkerGlobalScopePrototypeTableIndex };
const ClassInfo JSSharedWorkerGlobalScopePrototype::s_info = { "SharedWorkerGlobalScope"_s, &Base::s_info, &JSSharedWorkerGlobalScopePrototypeTable, nullptr, CREATE_METHOD_TABLE(JSSharedWorkerGlobalScopePrototype) };

void JSSharedWorkerGlobalScopePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSharedWorkerGlobalScope::s_info = { "SharedWorkerGlobalScope"_s, &Base::s_info, &JSSharedWorkerGlobalScopeTable, nullptr, CREATE_METHOD_TABLE(JSSharedWorkerGlobalScope) };

JSSharedWorkerGlobalScope::JSSharedWorkerGlobalScope(VM& vm, Structure* structure, Ref<SharedWorkerGlobalScope>&& impl)
    : JSWorkerGlobalScope(vm, structure, WTFMove(impl))
{
}

Ref<SharedWorkerGlobalScope> JSSharedWorkerGlobalScope::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, SharedWorkerGlobalScope>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

void JSSharedWorkerGlobalScope::finishCreation(VM& vm, JSGlobalProxy* proxy)
{
    Base::finishCreation(vm, proxy);

    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CompressionStreamPublicName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_CompressionStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CompressionStreamEncoderPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_CompressionStreamEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).DecompressionStreamPublicName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_DecompressionStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).DecompressionStreamDecoderPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_DecompressionStreamDecoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().fileReaderAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).FileReaderSyncPublicName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_FileReaderSyncConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().sharedWorkerEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).SharedWorkerGlobalScopePublicName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_SharedWorkerGlobalScopeConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableByteStreamControllerPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_ReadableByteStreamControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_ReadableStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamBYOBReaderPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_ReadableStreamBYOBReaderConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamBYOBRequestPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_ReadableStreamBYOBRequestConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_ReadableStreamDefaultControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamDefaultReaderPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_ReadableStreamDefaultReaderConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_TransformStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_TransformStreamDefaultControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_WritableStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_WritableStreamDefaultControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamDefaultWriterPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_WritableStreamDefaultWriterConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).AbortSignalPrivateName(), CustomGetterSetter::create(vm, jsSharedWorkerGlobalScope_AbortSignalConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
}

JSValue JSSharedWorkerGlobalScope::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSharedWorkerGlobalScopeDOMConstructor, DOMConstructorID::SharedWorkerGlobalScope>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScopeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSharedWorkerGlobalScopePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSharedWorkerGlobalScope::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSharedWorkerGlobalScope_nameGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_nameGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSharedWorkerGlobalScope_nameSetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    bool shouldThrow = true;
    thisObject.createDataProperty(&lexicalGlobalObject, propertyName, value, shouldThrow);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSharedWorkerGlobalScope_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::setPassingPropertyName<setJSSharedWorkerGlobalScope_nameSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_onconnectGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().connectEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_onconnect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_onconnectGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSharedWorkerGlobalScope_onconnectSetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().connectEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSharedWorkerGlobalScope_onconnect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::set<setJSSharedWorkerGlobalScope_onconnectSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_CompressionStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCompressionStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_CompressionStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_CompressionStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_CompressionStreamEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCompressionStreamEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_CompressionStreamEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_CompressionStreamEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_DecompressionStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDecompressionStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_DecompressionStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_DecompressionStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_DecompressionStreamDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDecompressionStreamDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_DecompressionStreamDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_DecompressionStreamDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_ByteLengthQueuingStrategyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSByteLengthQueuingStrategy::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ByteLengthQueuingStrategyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_ByteLengthQueuingStrategyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_CountQueuingStrategyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCountQueuingStrategy::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_CountQueuingStrategyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_CountQueuingStrategyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_ReadableByteStreamControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableByteStreamController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ReadableByteStreamControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_ReadableByteStreamControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_ReadableStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ReadableStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_ReadableStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_ReadableStreamBYOBReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamBYOBReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ReadableStreamBYOBReaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_ReadableStreamBYOBReaderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_ReadableStreamBYOBRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamBYOBRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ReadableStreamBYOBRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_ReadableStreamBYOBRequestConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_ReadableStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ReadableStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_ReadableStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_ReadableStreamDefaultReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamDefaultReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ReadableStreamDefaultReaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_ReadableStreamDefaultReaderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_TransformStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTransformStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_TransformStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_TransformStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_TransformStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTransformStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_TransformStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_TransformStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_WritableStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_WritableStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_WritableStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_WritableStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_WritableStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_WritableStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_WritableStreamDefaultWriterConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStreamDefaultWriter::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_WritableStreamDefaultWriterConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_WritableStreamDefaultWriterConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_AbortControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSAbortController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_AbortControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_AbortControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_AbortSignalConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSAbortSignal::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_AbortSignalConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_AbortSignalConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_CustomEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCustomEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_CustomEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_CustomEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_ErrorEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSErrorEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_ErrorEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_ErrorEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_EventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_EventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_EventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_EventTargetConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSEventTarget::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_EventTargetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_EventTargetConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_PromiseRejectionEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPromiseRejectionEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PromiseRejectionEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_PromiseRejectionEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_TextDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_TextDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_TextDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_TextDecoderStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextDecoderStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_TextDecoderStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_TextDecoderStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_TextEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_TextEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_TextEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_TextEncoderStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextEncoderStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_TextEncoderStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_TextEncoderStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_FileReaderSyncConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFileReaderSync::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_FileReaderSyncConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_FileReaderSyncConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_URLConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMURL::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_URLConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_URLConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_URLSearchParamsConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSURLSearchParams::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_URLSearchParamsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_URLSearchParamsConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_PerformanceConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformance::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_PerformanceConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_PerformanceEntryConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceEntry::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceEntryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_PerformanceEntryConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_PerformanceMarkConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceMark::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceMarkConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_PerformanceMarkConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_PerformanceMeasureConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceMeasure::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceMeasureConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_PerformanceMeasureConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_PerformanceObserverConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceObserver::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceObserverConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_PerformanceObserverConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_PerformanceObserverEntryListConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceObserverEntryList::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceObserverEntryListConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_PerformanceObserverEntryListConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_PerformanceResourceTimingConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceResourceTiming::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceResourceTimingConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_PerformanceResourceTimingConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_PerformanceServerTimingConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceServerTiming::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_PerformanceServerTimingConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_PerformanceServerTimingConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_SharedWorkerGlobalScopeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSSharedWorkerGlobalScope::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_SharedWorkerGlobalScopeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_SharedWorkerGlobalScopeConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSharedWorkerGlobalScope_XMLHttpRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSSharedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSXMLHttpRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsSharedWorkerGlobalScope_XMLHttpRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSharedWorkerGlobalScope>::get<jsSharedWorkerGlobalScope_XMLHttpRequestConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsSharedWorkerGlobalScopeInstanceFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSharedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSharedWorkerGlobalScopeInstanceFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSharedWorkerGlobalScope>::call<jsSharedWorkerGlobalScopeInstanceFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

JSC::GCClient::IsoSubspace* JSSharedWorkerGlobalScope::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSharedWorkerGlobalScope, UseCustomHeapCellType::Yes>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSharedWorkerGlobalScope.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSharedWorkerGlobalScope = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSharedWorkerGlobalScope.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSharedWorkerGlobalScope = std::forward<decltype(space)>(space); },
        [] (auto& server) -> JSC::HeapCellType& { return server.m_heapCellTypeForJSSharedWorkerGlobalScope; }
    );
}

void JSSharedWorkerGlobalScope::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSharedWorkerGlobalScope*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

SharedWorkerGlobalScope* JSSharedWorkerGlobalScope::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSharedWorkerGlobalScope*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
