/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGSVGElement.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMMatrix2DInit.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSNodeList.h"
#include "JSSVGAngle.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGElement.h"
#include "JSSVGLength.h"
#include "JSSVGMatrix.h"
#include "JSSVGNumber.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "JSSVGTransform.h"
#include "JSSVGViewSpec.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_getIntersectionList);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_getEnclosureList);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_checkIntersection);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_checkEnclosure);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_deselectAll);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGNumber);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGLength);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGAngle);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGPoint);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGMatrix);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGRect);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGTransform);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGTransformFromMatrix);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_getElementById);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_pauseAnimations);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_unpauseAnimations);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_animationsPaused);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_getCurrentTime);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_setCurrentTime);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_suspendRedraw);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_unsuspendRedraw);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_unsuspendRedrawAll);
static JSC_DECLARE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_forceRedraw);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGSVGElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSVGElement_x);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSVGElement_y);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSVGElement_width);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSVGElement_height);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSVGElement_currentScale);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGSVGElement_currentScale);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSVGElement_currentTranslate);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSVGElement_useCurrentView);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSVGElement_currentView);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSVGElement_viewBox);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSVGElement_preserveAspectRatio);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSVGElement_zoomAndPan);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGSVGElement_zoomAndPan);

class JSSVGSVGElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGSVGElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGSVGElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGSVGElementPrototype>(vm)) JSSVGSVGElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGSVGElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGSVGElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGSVGElementPrototype, JSSVGSVGElementPrototype::Base);

using JSSVGSVGElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGSVGElement>;

/* Hash table for constructor */

static const HashTableValue JSSVGSVGElementConstructorTableValues[] =
{
    { "SVG_ZOOMANDPAN_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "SVG_ZOOMANDPAN_DISABLE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "SVG_ZOOMANDPAN_MAGNIFY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
};

static_assert(SVGSVGElement::SVG_ZOOMANDPAN_UNKNOWN == 0, "SVG_ZOOMANDPAN_UNKNOWN in SVGSVGElement does not match value from IDL");
static_assert(SVGSVGElement::SVG_ZOOMANDPAN_DISABLE == 1, "SVG_ZOOMANDPAN_DISABLE in SVGSVGElement does not match value from IDL");
static_assert(SVGSVGElement::SVG_ZOOMANDPAN_MAGNIFY == 2, "SVG_ZOOMANDPAN_MAGNIFY in SVGSVGElement does not match value from IDL");

template<> const ClassInfo JSSVGSVGElementDOMConstructor::s_info = { "SVGSVGElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGSVGElementDOMConstructor) };

template<> JSValue JSSVGSVGElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGGraphicsElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGSVGElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGSVGElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGSVGElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSSVGSVGElement::info(), JSSVGSVGElementConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSSVGSVGElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSVGElementConstructor, 0 } },
    { "x"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSVGElement_x, 0 } },
    { "y"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSVGElement_y, 0 } },
    { "width"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSVGElement_width, 0 } },
    { "height"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSVGElement_height, 0 } },
    { "currentScale"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSVGElement_currentScale, setJSSVGSVGElement_currentScale } },
    { "currentTranslate"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSVGElement_currentTranslate, 0 } },
    { "useCurrentView"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSVGElement_useCurrentView, 0 } },
    { "currentView"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSVGElement_currentView, 0 } },
    { "viewBox"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSVGElement_viewBox, 0 } },
    { "preserveAspectRatio"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSVGElement_preserveAspectRatio, 0 } },
    { "zoomAndPan"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSVGElement_zoomAndPan, setJSSVGSVGElement_zoomAndPan } },
    { "getIntersectionList"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_getIntersectionList, 2 } },
    { "getEnclosureList"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_getEnclosureList, 2 } },
    { "checkIntersection"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_checkIntersection, 2 } },
    { "checkEnclosure"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_checkEnclosure, 2 } },
    { "deselectAll"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_deselectAll, 0 } },
    { "createSVGNumber"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_createSVGNumber, 0 } },
    { "createSVGLength"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_createSVGLength, 0 } },
    { "createSVGAngle"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_createSVGAngle, 0 } },
    { "createSVGPoint"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_createSVGPoint, 0 } },
    { "createSVGMatrix"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_createSVGMatrix, 0 } },
    { "createSVGRect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_createSVGRect, 0 } },
    { "createSVGTransform"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_createSVGTransform, 0 } },
    { "createSVGTransformFromMatrix"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_createSVGTransformFromMatrix, 0 } },
    { "getElementById"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_getElementById, 1 } },
    { "pauseAnimations"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_pauseAnimations, 0 } },
    { "unpauseAnimations"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_unpauseAnimations, 0 } },
    { "animationsPaused"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_animationsPaused, 0 } },
    { "getCurrentTime"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_getCurrentTime, 0 } },
    { "setCurrentTime"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_setCurrentTime, 1 } },
    { "suspendRedraw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_suspendRedraw, 1 } },
    { "unsuspendRedraw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_unsuspendRedraw, 1 } },
    { "unsuspendRedrawAll"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_unsuspendRedrawAll, 0 } },
    { "forceRedraw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGSVGElementPrototypeFunction_forceRedraw, 0 } },
    { "SVG_ZOOMANDPAN_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "SVG_ZOOMANDPAN_DISABLE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "SVG_ZOOMANDPAN_MAGNIFY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
};

const ClassInfo JSSVGSVGElementPrototype::s_info = { "SVGSVGElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGSVGElementPrototype) };

void JSSVGSVGElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGSVGElement::info(), JSSVGSVGElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGSVGElement::s_info = { "SVGSVGElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGSVGElement) };

JSSVGSVGElement::JSSVGSVGElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGSVGElement>&& impl)
    : JSSVGGraphicsElement(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGSVGElement> JSSVGSVGElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSSVGSVGElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGSVGElementPrototype::createStructure(vm, &globalObject, JSSVGGraphicsElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGSVGElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGSVGElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGSVGElement>(vm, globalObject);
}

JSValue JSSVGSVGElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGSVGElementDOMConstructor, DOMConstructorID::SVGSVGElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSVGElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGSVGElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGSVGElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGSVGElement_xGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.xAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSVGElement_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::get<jsSVGSVGElement_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGSVGElement_yGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.yAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSVGElement_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::get<jsSVGSVGElement_yGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGSVGElement_widthGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.widthAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSVGElement_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::get<jsSVGSVGElement_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGSVGElement_heightGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.heightAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSVGElement_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::get<jsSVGSVGElement_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGSVGElement_currentScaleGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.currentScale())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSVGElement_currentScale, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::get<jsSVGSVGElement_currentScaleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGSVGElement_currentScaleSetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLFloat>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setCurrentScale(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGSVGElement_currentScale, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::set<setJSSVGSVGElement_currentScaleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGSVGElement_currentTranslateGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGPoint>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.currentTranslate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSVGElement_currentTranslate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::get<jsSVGSVGElement_currentTranslateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGSVGElement_useCurrentViewGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.useCurrentView())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSVGElement_useCurrentView, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::get<jsSVGSVGElement_useCurrentViewGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGSVGElement_currentViewGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGViewSpec>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.currentView())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSVGElement_currentView, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::get<jsSVGSVGElement_currentViewGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGSVGElement_viewBoxGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedRect>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.viewBoxAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSVGElement_viewBox, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::get<jsSVGSVGElement_viewBoxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGSVGElement_preserveAspectRatioGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedPreserveAspectRatio>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.preserveAspectRatioAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSVGElement_preserveAspectRatio, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::get<jsSVGSVGElement_preserveAspectRatioGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGSVGElement_zoomAndPanGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.zoomAndPan())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSVGElement_zoomAndPan, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::get<jsSVGSVGElement_zoomAndPanGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGSVGElement_zoomAndPanSetter(JSGlobalObject& lexicalGlobalObject, JSSVGSVGElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedShort>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setZoomAndPan(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGSVGElement_zoomAndPan, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSVGElement>::set<setJSSVGSVGElement_zoomAndPanSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_getIntersectionListBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto rectConversionResult = convert<IDLInterface<SVGRect>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "rect"_s, "SVGSVGElement"_s, "getIntersectionList"_s, "SVGRect"_s); });
    if (UNLIKELY(rectConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto referenceElementConversionResult = convert<IDLNullable<IDLInterface<SVGElement>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "referenceElement"_s, "SVGSVGElement"_s, "getIntersectionList"_s, "SVGElement"_s); });
    if (UNLIKELY(referenceElementConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<NodeList>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getIntersectionList(*rectConversionResult.releaseReturnValue(), referenceElementConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_getIntersectionList, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_getIntersectionListBody>(*lexicalGlobalObject, *callFrame, "getIntersectionList");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_getEnclosureListBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto rectConversionResult = convert<IDLInterface<SVGRect>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "rect"_s, "SVGSVGElement"_s, "getEnclosureList"_s, "SVGRect"_s); });
    if (UNLIKELY(rectConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto referenceElementConversionResult = convert<IDLNullable<IDLInterface<SVGElement>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "referenceElement"_s, "SVGSVGElement"_s, "getEnclosureList"_s, "SVGElement"_s); });
    if (UNLIKELY(referenceElementConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<NodeList>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getEnclosureList(*rectConversionResult.releaseReturnValue(), referenceElementConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_getEnclosureList, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_getEnclosureListBody>(*lexicalGlobalObject, *callFrame, "getEnclosureList");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_checkIntersectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto elementConversionResult = convert<IDLInterface<SVGElement>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element"_s, "SVGSVGElement"_s, "checkIntersection"_s, "SVGElement"_s); });
    if (UNLIKELY(elementConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto rectConversionResult = convert<IDLInterface<SVGRect>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "rect"_s, "SVGSVGElement"_s, "checkIntersection"_s, "SVGRect"_s); });
    if (UNLIKELY(rectConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.checkIntersection(*elementConversionResult.releaseReturnValue(), *rectConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_checkIntersection, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_checkIntersectionBody>(*lexicalGlobalObject, *callFrame, "checkIntersection");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_checkEnclosureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto elementConversionResult = convert<IDLInterface<SVGElement>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element"_s, "SVGSVGElement"_s, "checkEnclosure"_s, "SVGElement"_s); });
    if (UNLIKELY(elementConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto rectConversionResult = convert<IDLInterface<SVGRect>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "rect"_s, "SVGSVGElement"_s, "checkEnclosure"_s, "SVGRect"_s); });
    if (UNLIKELY(rectConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.checkEnclosure(*elementConversionResult.releaseReturnValue(), *rectConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_checkEnclosure, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_checkEnclosureBody>(*lexicalGlobalObject, *callFrame, "checkEnclosure");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_deselectAllBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deselectAll(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_deselectAll, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_deselectAllBody>(*lexicalGlobalObject, *callFrame, "deselectAll");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_createSVGNumberBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGNumber>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGNumber())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGNumber, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_createSVGNumberBody>(*lexicalGlobalObject, *callFrame, "createSVGNumber");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_createSVGLengthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGLength>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGLength())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGLength, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_createSVGLengthBody>(*lexicalGlobalObject, *callFrame, "createSVGLength");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_createSVGAngleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGAngle>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGAngle())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGAngle, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_createSVGAngleBody>(*lexicalGlobalObject, *callFrame, "createSVGAngle");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_createSVGPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPoint())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGPoint, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_createSVGPointBody>(*lexicalGlobalObject, *callFrame, "createSVGPoint");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_createSVGMatrixBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGMatrix())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGMatrix, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_createSVGMatrixBody>(*lexicalGlobalObject, *callFrame, "createSVGMatrix");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_createSVGRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGRect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGRect())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGRect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_createSVGRectBody>(*lexicalGlobalObject, *callFrame, "createSVGRect");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_createSVGTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGTransform>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGTransform())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGTransform, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_createSVGTransformBody>(*lexicalGlobalObject, *callFrame, "createSVGTransform");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_createSVGTransformFromMatrixBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto matrixConversionResult = convert<IDLDictionary<DOMMatrix2DInit>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(matrixConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGTransform>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGTransformFromMatrix(matrixConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_createSVGTransformFromMatrix, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_createSVGTransformFromMatrixBody>(*lexicalGlobalObject, *callFrame, "createSVGTransformFromMatrix");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_getElementByIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto elementIdConversionResult = convert<IDLRequiresExistingAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(elementIdConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<Element>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getElementById(elementIdConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_getElementById, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_getElementByIdBody>(*lexicalGlobalObject, *callFrame, "getElementById");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_pauseAnimationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.pauseAnimations(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_pauseAnimations, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_pauseAnimationsBody>(*lexicalGlobalObject, *callFrame, "pauseAnimations");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_unpauseAnimationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.unpauseAnimations(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_unpauseAnimations, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_unpauseAnimationsBody>(*lexicalGlobalObject, *callFrame, "unpauseAnimations");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_animationsPausedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.animationsPaused())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_animationsPaused, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_animationsPausedBody>(*lexicalGlobalObject, *callFrame, "animationsPaused");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_getCurrentTimeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLFloat>(*lexicalGlobalObject, throwScope, impl.getCurrentTime())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_getCurrentTime, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_getCurrentTimeBody>(*lexicalGlobalObject, *callFrame, "getCurrentTime");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_setCurrentTimeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto secondsConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(secondsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setCurrentTime(secondsConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_setCurrentTime, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_setCurrentTimeBody>(*lexicalGlobalObject, *callFrame, "setCurrentTime");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_suspendRedrawBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto maxWaitMillisecondsConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(maxWaitMillisecondsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.suspendRedraw(maxWaitMillisecondsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_suspendRedraw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_suspendRedrawBody>(*lexicalGlobalObject, *callFrame, "suspendRedraw");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_unsuspendRedrawBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto suspendHandleIdConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(suspendHandleIdConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.unsuspendRedraw(suspendHandleIdConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_unsuspendRedraw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_unsuspendRedrawBody>(*lexicalGlobalObject, *callFrame, "unsuspendRedraw");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_unsuspendRedrawAllBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.unsuspendRedrawAll(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_unsuspendRedrawAll, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_unsuspendRedrawAllBody>(*lexicalGlobalObject, *callFrame, "unsuspendRedrawAll");
}

static inline JSC::EncodedJSValue jsSVGSVGElementPrototypeFunction_forceRedrawBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGSVGElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.forceRedraw(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGSVGElementPrototypeFunction_forceRedraw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGSVGElement>::call<jsSVGSVGElementPrototypeFunction_forceRedrawBody>(*lexicalGlobalObject, *callFrame, "forceRedraw");
}

JSC::GCClient::IsoSubspace* JSSVGSVGElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGSVGElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGSVGElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGSVGElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGSVGElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGSVGElement = std::forward<decltype(space)>(space); }
    );
}

void JSSVGSVGElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGSVGElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

SVGSVGElement* JSSVGSVGElement::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGSVGElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
