/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPermissions.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSPermissionStatus.h"
#include "Navigator.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include "WorkerNavigator.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsPermissionsPrototypeFunction_query);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPermissionsConstructor);

class JSPermissionsPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPermissionsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPermissionsPrototype* ptr = new (NotNull, JSC::allocateCell<JSPermissionsPrototype>(vm)) JSPermissionsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPermissionsPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPermissionsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPermissionsPrototype, JSPermissionsPrototype::Base);

using JSPermissionsDOMConstructor = JSDOMConstructorNotConstructable<JSPermissions>;

template<> const ClassInfo JSPermissionsDOMConstructor::s_info = { "Permissions"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPermissionsDOMConstructor) };

template<> JSValue JSPermissionsDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPermissionsDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Permissions"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPermissions::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSPermissionsPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPermissionsConstructor, 0 } },
    { "query"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPermissionsPrototypeFunction_query, 1 } },
};

const ClassInfo JSPermissionsPrototype::s_info = { "Permissions"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPermissionsPrototype) };

void JSPermissionsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPermissions::info(), JSPermissionsPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPermissions::s_info = { "Permissions"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPermissions) };

JSPermissions::JSPermissions(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Permissions>&& impl)
    : JSDOMWrapper<Permissions>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, Permissions>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPermissions::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPermissionsPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSPermissionsPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPermissions::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPermissions>(vm, globalObject);
}

JSValue JSPermissions::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPermissionsDOMConstructor, DOMConstructorID::Permissions>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPermissions::destroy(JSC::JSCell* cell)
{
    JSPermissions* thisObject = static_cast<JSPermissions*>(cell);
    thisObject->JSPermissions::~JSPermissions();
}

JSC_DEFINE_CUSTOM_GETTER(jsPermissionsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPermissionsPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPermissions::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsPermissionsPrototypeFunction_queryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSPermissions>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto permissionDescConversionResult = convert<IDLObject>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(permissionDescConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<PermissionStatus>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.query(permissionDescConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPermissionsPrototypeFunction_query, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSPermissions>::call<jsPermissionsPrototypeFunction_queryBody>(*lexicalGlobalObject, *callFrame, "query");
}

JSC::GCClient::IsoSubspace* JSPermissions::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPermissions, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPermissions.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPermissions = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPermissions.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPermissions = std::forward<decltype(space)>(space); }
    );
}

void JSPermissions::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPermissions*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSPermissionsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsPermissions = jsCast<JSPermissions*>(handle.slot()->asCell());
    NavigatorBase* owner = WTF::getPtr(jsPermissions->wrapped().navigator());
    if (!owner)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Navigator"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSPermissionsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPermissions = static_cast<JSPermissions*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsPermissions->protectedWrapped().ptr(), jsPermissions);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Permissions@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11PermissionsE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, Permissions>, void>> static inline void verifyVTable(Permissions* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7Permissions@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore11PermissionsE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // Permissions has subclasses. If Permissions has subclasses that get passed
        // to toJS() we currently require Permissions you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Permissions>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<Permissions>(impl.ptr());
#endif
    return createWrapper<Permissions>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Permissions& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Permissions* JSPermissions::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPermissions*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
