/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSOpusEncoderConfig.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> ConversionResult<IDLDictionary<OpusEncoderConfig>> convertDictionary<OpusEncoderConfig>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    OpusEncoderConfig result;
    JSValue complexityValue;
    if (isNullOrUndefined)
        complexityValue = jsUndefined();
    else {
        complexityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "complexity"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!complexityValue.isUndefined()) {
        auto complexityConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, complexityValue);
        if (UNLIKELY(complexityConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.complexity = complexityConversionResult.releaseReturnValue();
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto formatConversionResult = convertOptionalWithDefault<IDLEnumeration<OpusEncoderConfig::BitstreamFormat>>(lexicalGlobalObject, formatValue, [&]() -> ConversionResult<IDLEnumeration<OpusEncoderConfig::BitstreamFormat>> { return Converter<IDLEnumeration<OpusEncoderConfig::BitstreamFormat>>::ReturnType { OpusEncoderConfig::BitstreamFormat::Opus }; });
    if (UNLIKELY(formatConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.format = formatConversionResult.releaseReturnValue();
    JSValue frameDurationValue;
    if (isNullOrUndefined)
        frameDurationValue = jsUndefined();
    else {
        frameDurationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameDuration"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto frameDurationConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, frameDurationValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType { 20000 }; });
    if (UNLIKELY(frameDurationConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.frameDuration = frameDurationConversionResult.releaseReturnValue();
    JSValue packetlosspercValue;
    if (isNullOrUndefined)
        packetlosspercValue = jsUndefined();
    else {
        packetlosspercValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "packetlossperc"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto packetlosspercConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, packetlosspercValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 0 }; });
    if (UNLIKELY(packetlosspercConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.packetlossperc = packetlosspercConversionResult.releaseReturnValue();
    JSValue usedtxValue;
    if (isNullOrUndefined)
        usedtxValue = jsUndefined();
    else {
        usedtxValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "usedtx"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto usedtxConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, usedtxValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(usedtxConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.usedtx = usedtxConversionResult.releaseReturnValue();
    JSValue useinbandfecValue;
    if (isNullOrUndefined)
        useinbandfecValue = jsUndefined();
    else {
        useinbandfecValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "useinbandfec"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto useinbandfecConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, useinbandfecValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(useinbandfecConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.useinbandfec = useinbandfecConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const OpusEncoderConfig& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLEnforceRangeAdaptor<IDLUnsignedLong>::isNullValue(dictionary.complexity)) {
        auto complexityValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLong>::extractValueFromNullable(dictionary.complexity));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "complexity"_s), complexityValue);
    }
    auto formatValue = toJS<IDLEnumeration<OpusEncoderConfig::BitstreamFormat>>(lexicalGlobalObject, throwScope, dictionary.format);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "format"_s), formatValue);
    auto frameDurationValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, dictionary.frameDuration);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "frameDuration"_s), frameDurationValue);
    auto packetlosspercValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, dictionary.packetlossperc);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "packetlossperc"_s), packetlosspercValue);
    auto usedtxValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.usedtx);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "usedtx"_s), usedtxValue);
    auto useinbandfecValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.useinbandfec);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "useinbandfec"_s), useinbandfecValue);
    return result;
}

#endif

#if ENABLE(WEB_CODECS)

String convertEnumerationToString(OpusEncoderConfig::BitstreamFormat enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("opus"),
        MAKE_STATIC_STRING_IMPL("ogg"),
    };
    static_assert(static_cast<size_t>(OpusEncoderConfig::BitstreamFormat::Opus) == 0, "OpusEncoderConfig::BitstreamFormat::Opus is not 0 as expected");
    static_assert(static_cast<size_t>(OpusEncoderConfig::BitstreamFormat::Ogg) == 1, "OpusEncoderConfig::BitstreamFormat::Ogg is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, OpusEncoderConfig::BitstreamFormat enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<OpusEncoderConfig::BitstreamFormat> parseEnumerationFromString<OpusEncoderConfig::BitstreamFormat>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, OpusEncoderConfig::BitstreamFormat> mappings[] = {
        { "ogg", OpusEncoderConfig::BitstreamFormat::Ogg },
        { "opus", OpusEncoderConfig::BitstreamFormat::Opus },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<OpusEncoderConfig::BitstreamFormat> parseEnumeration<OpusEncoderConfig::BitstreamFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<OpusEncoderConfig::BitstreamFormat>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<OpusEncoderConfig::BitstreamFormat>()
{
    return "\"opus\", \"ogg\""_s;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
