/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNavigationDestination.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsNavigationDestinationPrototypeFunction_getState);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsNavigationDestinationConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationDestination_url);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationDestination_key);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationDestination_id);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationDestination_index);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationDestination_sameDocument);

class JSNavigationDestinationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNavigationDestinationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNavigationDestinationPrototype* ptr = new (NotNull, JSC::allocateCell<JSNavigationDestinationPrototype>(vm)) JSNavigationDestinationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigationDestinationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNavigationDestinationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigationDestinationPrototype, JSNavigationDestinationPrototype::Base);

using JSNavigationDestinationDOMConstructor = JSDOMConstructorNotConstructable<JSNavigationDestination>;

template<> const ClassInfo JSNavigationDestinationDOMConstructor::s_info = { "NavigationDestination"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationDestinationDOMConstructor) };

template<> JSValue JSNavigationDestinationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSNavigationDestinationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "NavigationDestination"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSNavigationDestination::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSNavigationDestinationPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationDestinationConstructor, 0 } },
    { "url"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationDestination_url, 0 } },
    { "key"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationDestination_key, 0 } },
    { "id"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationDestination_id, 0 } },
    { "index"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationDestination_index, 0 } },
    { "sameDocument"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationDestination_sameDocument, 0 } },
    { "getState"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationDestinationPrototypeFunction_getState, 0 } },
};

const ClassInfo JSNavigationDestinationPrototype::s_info = { "NavigationDestination"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationDestinationPrototype) };

void JSNavigationDestinationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNavigationDestination::info(), JSNavigationDestinationPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNavigationDestination::s_info = { "NavigationDestination"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationDestination) };

JSNavigationDestination::JSNavigationDestination(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NavigationDestination>&& impl)
    : JSDOMWrapper<NavigationDestination>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, NavigationDestination>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSNavigationDestination::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNavigationDestinationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSNavigationDestinationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSNavigationDestination::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNavigationDestination>(vm, globalObject);
}

JSValue JSNavigationDestination::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNavigationDestinationDOMConstructor, DOMConstructorID::NavigationDestination>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSNavigationDestination::destroy(JSC::JSCell* cell)
{
    JSNavigationDestination* thisObject = static_cast<JSNavigationDestination*>(cell);
    thisObject->JSNavigationDestination::~JSNavigationDestination();
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationDestinationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNavigationDestinationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNavigationDestination::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsNavigationDestination_urlGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationDestination& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.url())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationDestination_url, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationDestination>::get<jsNavigationDestination_urlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigationDestination_keyGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationDestination& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.key())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationDestination_key, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationDestination>::get<jsNavigationDestination_keyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigationDestination_idGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationDestination& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationDestination_id, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationDestination>::get<jsNavigationDestination_idGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigationDestination_indexGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationDestination& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLongLong>(lexicalGlobalObject, throwScope, impl.index())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationDestination_index, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationDestination>::get<jsNavigationDestination_indexGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigationDestination_sameDocumentGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationDestination& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.sameDocument())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationDestination_sameDocument, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationDestination>::get<jsNavigationDestination_sameDocumentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsNavigationDestinationPrototypeFunction_getStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNavigationDestination>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, impl.getState(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationDestinationPrototypeFunction_getState, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNavigationDestination>::call<jsNavigationDestinationPrototypeFunction_getStateBody>(*lexicalGlobalObject, *callFrame, "getState");
}

JSC::GCClient::IsoSubspace* JSNavigationDestination::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNavigationDestination, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNavigationDestination.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNavigationDestination = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNavigationDestination.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNavigationDestination = std::forward<decltype(space)>(space); }
    );
}

void JSNavigationDestination::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNavigationDestination*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSNavigationDestinationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSNavigationDestinationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNavigationDestination = static_cast<JSNavigationDestination*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNavigationDestination->protectedWrapped().ptr(), jsNavigationDestination);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7NavigationDestination@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21NavigationDestinationE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, NavigationDestination>, void>> static inline void verifyVTable(NavigationDestination* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7NavigationDestination@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21NavigationDestinationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // NavigationDestination has subclasses. If NavigationDestination has subclasses that get passed
        // to toJS() we currently require NavigationDestination you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<NavigationDestination>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<NavigationDestination>(impl.ptr());
#endif
    return createWrapper<NavigationDestination>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NavigationDestination& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

NavigationDestination* JSNavigationDestination::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNavigationDestination*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
