/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUTextureViewDimension.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUTextureViewDimension enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("1d"),
        MAKE_STATIC_STRING_IMPL("2d"),
        MAKE_STATIC_STRING_IMPL("2d-array"),
        MAKE_STATIC_STRING_IMPL("cube"),
        MAKE_STATIC_STRING_IMPL("cube-array"),
        MAKE_STATIC_STRING_IMPL("3d"),
    };
    static_assert(static_cast<size_t>(GPUTextureViewDimension::_1d) == 0, "GPUTextureViewDimension::_1d is not 0 as expected");
    static_assert(static_cast<size_t>(GPUTextureViewDimension::_2d) == 1, "GPUTextureViewDimension::_2d is not 1 as expected");
    static_assert(static_cast<size_t>(GPUTextureViewDimension::_2dArray) == 2, "GPUTextureViewDimension::_2dArray is not 2 as expected");
    static_assert(static_cast<size_t>(GPUTextureViewDimension::Cube) == 3, "GPUTextureViewDimension::Cube is not 3 as expected");
    static_assert(static_cast<size_t>(GPUTextureViewDimension::CubeArray) == 4, "GPUTextureViewDimension::CubeArray is not 4 as expected");
    static_assert(static_cast<size_t>(GPUTextureViewDimension::_3d) == 5, "GPUTextureViewDimension::_3d is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUTextureViewDimension enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUTextureViewDimension> parseEnumerationFromString<GPUTextureViewDimension>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, GPUTextureViewDimension> mappings[] = {
        { "1d", GPUTextureViewDimension::_1d },
        { "2d", GPUTextureViewDimension::_2d },
        { "2d-array", GPUTextureViewDimension::_2dArray },
        { "3d", GPUTextureViewDimension::_3d },
        { "cube", GPUTextureViewDimension::Cube },
        { "cube-array", GPUTextureViewDimension::CubeArray },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUTextureViewDimension> parseEnumeration<GPUTextureViewDimension>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUTextureViewDimension>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPUTextureViewDimension>()
{
    return "\"1d\", \"2d\", \"2d-array\", \"cube\", \"cube-array\", \"3d\""_s;
}

} // namespace WebCore
