/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBufferBindingLayout.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSGPUBufferBindingType.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUBufferBindingLayout>> convertDictionary<GPUBufferBindingLayout>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUBufferBindingLayout result;
    JSValue hasDynamicOffsetValue;
    if (isNullOrUndefined)
        hasDynamicOffsetValue = jsUndefined();
    else {
        hasDynamicOffsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hasDynamicOffset"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto hasDynamicOffsetConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, hasDynamicOffsetValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(hasDynamicOffsetConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.hasDynamicOffset = hasDynamicOffsetConversionResult.releaseReturnValue();
    JSValue minBindingSizeValue;
    if (isNullOrUndefined)
        minBindingSizeValue = jsUndefined();
    else {
        minBindingSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "minBindingSize"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto minBindingSizeConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, minBindingSizeValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType { 0 }; });
    if (UNLIKELY(minBindingSizeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.minBindingSize = minBindingSizeConversionResult.releaseReturnValue();
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto typeConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUBufferBindingType>>(lexicalGlobalObject, typeValue, [&]() -> ConversionResult<IDLEnumeration<GPUBufferBindingType>> { return Converter<IDLEnumeration<GPUBufferBindingType>>::ReturnType { GPUBufferBindingType::Uniform }; });
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.type = typeConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
