/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBindGroupDescriptor.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUBindGroupEntry.h"
#include "JSGPUBindGroupLayout.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUBindGroupDescriptor>> convertDictionary<GPUBindGroupDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUBindGroupDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (UNLIKELY(labelConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue entriesValue;
    if (isNullOrUndefined)
        entriesValue = jsUndefined();
    else {
        entriesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "entries"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (entriesValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "entries"_s, "GPUBindGroupDescriptor"_s, "sequence"_s);
        return ConversionResultException { };
    }
    auto entriesConversionResult = convert<IDLSequence<IDLDictionary<GPUBindGroupEntry>>>(lexicalGlobalObject, entriesValue);
    if (UNLIKELY(entriesConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.entries = entriesConversionResult.releaseReturnValue();
    JSValue layoutValue;
    if (isNullOrUndefined)
        layoutValue = jsUndefined();
    else {
        layoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "layout"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (layoutValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "layout"_s, "GPUBindGroupDescriptor"_s, "GPUBindGroupLayout"_s);
        return ConversionResultException { };
    }
    auto layoutConversionResult = convert<IDLInterface<GPUBindGroupLayout>>(lexicalGlobalObject, layoutValue);
    if (UNLIKELY(layoutConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.layout = layoutConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
