/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSChannelSplitterOptions.h"

#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> ConversionResult<IDLDictionary<ChannelSplitterOptions>> convertDictionary<ChannelSplitterOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ChannelSplitterOptions result;
    JSValue channelCountValue;
    if (isNullOrUndefined)
        channelCountValue = jsUndefined();
    else {
        channelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelCountValue.isUndefined()) {
        auto channelCountConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, channelCountValue);
        if (UNLIKELY(channelCountConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.channelCount = channelCountConversionResult.releaseReturnValue();
    }
    JSValue channelCountModeValue;
    if (isNullOrUndefined)
        channelCountModeValue = jsUndefined();
    else {
        channelCountModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCountMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelCountModeValue.isUndefined()) {
        auto channelCountModeConversionResult = convert<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, channelCountModeValue);
        if (UNLIKELY(channelCountModeConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.channelCountMode = channelCountModeConversionResult.releaseReturnValue();
    }
    JSValue channelInterpretationValue;
    if (isNullOrUndefined)
        channelInterpretationValue = jsUndefined();
    else {
        channelInterpretationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelInterpretation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelInterpretationValue.isUndefined()) {
        auto channelInterpretationConversionResult = convert<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, channelInterpretationValue);
        if (UNLIKELY(channelInterpretationConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.channelInterpretation = channelInterpretationConversionResult.releaseReturnValue();
    }
    JSValue numberOfOutputsValue;
    if (isNullOrUndefined)
        numberOfOutputsValue = jsUndefined();
    else {
        numberOfOutputsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "numberOfOutputs"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto numberOfOutputsConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, numberOfOutputsValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 6 }; });
    if (UNLIKELY(numberOfOutputsConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.numberOfOutputs = numberOfOutputsConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
