/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSSkewY.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSNumericValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSSkewYConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSSkewY_ay);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSSkewY_ay);

class JSCSSSkewYPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSSkewYPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSSkewYPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSSkewYPrototype>(vm)) JSCSSSkewYPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSSkewYPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSSkewYPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSSkewYPrototype, JSCSSSkewYPrototype::Base);

using JSCSSSkewYDOMConstructor = JSDOMConstructor<JSCSSSkewY>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSSkewYDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSSkewYDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto ayConversionResult = convert<IDLInterface<CSSNumericValue>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "ay"_s, "CSSSkewY"_s, nullptr, "CSSNumericValue"_s); });
    if (UNLIKELY(ayConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = CSSSkewY::create(*ayConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSSkewY>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSSkewY>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSSkewYDOMConstructorConstruct, JSCSSSkewYDOMConstructor::construct);

template<> const ClassInfo JSCSSSkewYDOMConstructor::s_info = { "CSSSkewY"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSSkewYDOMConstructor) };

template<> JSValue JSCSSSkewYDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSTransformComponent::getConstructor(vm, &globalObject);
}

template<> void JSCSSSkewYDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSSkewY"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSSkewY::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSSkewYPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSSkewYConstructor, 0 } },
    { "ay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSSkewY_ay, setJSCSSSkewY_ay } },
};

const ClassInfo JSCSSSkewYPrototype::s_info = { "CSSSkewY"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSSkewYPrototype) };

void JSCSSSkewYPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSSkewY::info(), JSCSSSkewYPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSSkewY::s_info = { "CSSSkewY"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSSkewY) };

JSCSSSkewY::JSCSSSkewY(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSSkewY>&& impl)
    : JSCSSTransformComponent(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSSkewY> JSCSSSkewY::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSSkewY>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSSkewY::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSSkewYPrototype::createStructure(vm, &globalObject, JSCSSTransformComponent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSSkewYPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSSkewY::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSSkewY>(vm, globalObject);
}

JSValue JSCSSSkewY::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSSkewYDOMConstructor, DOMConstructorID::CSSSkewY>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSSkewYConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSSkewYPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSSkewY::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSSkewY_ayGetter(JSGlobalObject& lexicalGlobalObject, JSCSSSkewY& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSNumericValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ay())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSSkewY_ay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSSkewY>::get<jsCSSSkewY_ayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSSkewY_aySetter(JSGlobalObject& lexicalGlobalObject, JSCSSSkewY& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLInterface<CSSNumericValue>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "CSSSkewY"_s, "ay"_s, "CSSNumericValue"_s); });
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAy(*nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSSkewY_ay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSSkewY>::set<setJSCSSSkewY_aySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSSkewY::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSSkewY, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSSkewY.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSSkewY = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSSkewY.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSSkewY = std::forward<decltype(space)>(space); }
    );
}

void JSCSSSkewY::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSSkewY*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSSkewY@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8CSSSkewYE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, CSSSkewY>, void>> static inline void verifyVTable(CSSSkewY* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSSkewY@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore8CSSSkewYE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSSkewY has subclasses. If CSSSkewY has subclasses that get passed
        // to toJS() we currently require CSSSkewY you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSSkewY>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSSkewY>(impl.ptr());
#endif
    return createWrapper<CSSSkewY>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSSkewY& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
