/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMediaConfiguration.h"

#include "JSAudioConfiguration.h"
#include "JSVideoConfiguration.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> MediaConfiguration convertDictionary<MediaConfiguration>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaConfiguration result;
    JSValue audioValue;
    if (isNullOrUndefined)
        audioValue = jsUndefined();
    else {
        audioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "audio"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!audioValue.isUndefined()) {
        result.audio = convert<IDLDictionary<AudioConfiguration>>(lexicalGlobalObject, audioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue videoValue;
    if (isNullOrUndefined)
        videoValue = jsUndefined();
    else {
        videoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "video"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!videoValue.isUndefined()) {
        result.video = convert<IDLDictionary<VideoConfiguration>>(lexicalGlobalObject, videoValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
