/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.CardSlot;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.Embellishment;
import VASSAL.counters.GamePiece;
import VASSAL.counters.MultiImagePicker;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.Resources;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.swing.Dialogs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class MassPieceLoader {
    protected static final int DESC_COL = 0;
    protected static final int NAME_COL = 2;
    protected static final int IMAGE_COL = 1;
    protected static final int SKIP_COL = 3;
    protected static final int COPIES_COL = 4;
    protected static final int COLUMN_COUNT = 5;
    protected static final Color EDITABLE_COLOR = Color.blue;
    protected Configurable target;
    protected ConfigureTree configureTree;
    protected ArrayList<String> imageNames = new ArrayList();
    protected ArrayList<String> baseImages = new ArrayList();
    protected ArrayList<String> levelImages = new ArrayList();
    protected HashMap<String, PieceInfo> pieceInfo = new HashMap();
    protected ArrayList<Emb> layers = new ArrayList();
    protected MassLoaderDialog dialog;
    private static DirectoryConfigurer dirConfig = new DirectoryConfigurer(null, "Image Directory: ");
    private static BooleanConfigurer basicConfig = new BooleanConfigurer(null, "Do not load images into Basic Piece traits?", Boolean.FALSE);
    private static MassPieceDefiner definer = new MassPieceDefiner();
    protected static final String ENDS_WITH = "ends with";
    protected static final String INCLUDES = "includes";
    protected static final String MATCHES = "matches";
    protected static final String EQUALS = "same as";
    protected static final String BASE_IMAGE = "use Base Image";

    public MassPieceLoader(ConfigureTree configureTree, Configurable configurable) {
        this.target = configurable;
        this.configureTree = configureTree;
    }

    public void load() {
        this.dialog = new MassLoaderDialog();
        this.dialog.setVisible(true);
        if (!this.dialog.isCancelled()) {
            this.dialog.load();
        }
    }

    protected void addImageToModule(String string) {
        if (string != null && string.length() > 0) {
            try {
                GameModule.getGameModule().getArchiveWriter().addImage(new File(dirConfig.getFileValue(), string).getCanonicalPath(), string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String getPieceName(String string) {
        PieceInfo pieceInfo = this.pieceInfo.get(string);
        return pieceInfo == null ? ImageUtils.stripImageSuffix(string) : pieceInfo.getName();
    }

    static class Entry
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private StringEnumConfigurer typeConfig;
        private StringConfigurer nameConfig;
        private JLabel warning = new JLabel("Warning - Image suffix included");

        public Entry() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(new JLabel("Do NOT include image suffix (eg. .gif, .png) in level match strings"));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Image name "));
            this.typeConfig = new StringEnumConfigurer(null, "", new String[]{MassPieceLoader.ENDS_WITH, MassPieceLoader.INCLUDES, MassPieceLoader.MATCHES, MassPieceLoader.EQUALS, MassPieceLoader.BASE_IMAGE});
            box.add(this.typeConfig.getControls());
            this.nameConfig = new StringConfigurer(null, "");
            box.add(this.nameConfig.getControls());
            this.add(box);
            this.warning.setVisible(false);
            this.add(this.warning);
            this.typeConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Entry.this.updateVisibility();
                }
            });
            this.nameConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Entry.this.updateVisibility();
                }
            });
        }

        protected void updateVisibility() {
            this.warning.setVisible(ImageUtils.hasImageSuffix(this.nameConfig.getValueString()));
            this.nameConfig.getControls().setVisible(!this.typeConfig.getValueString().equals(MassPieceLoader.BASE_IMAGE));
        }

        public String toString() {
            return this.typeConfig.getValueString().charAt(0) + this.nameConfig.getValueString();
        }

        public void setImageName(String string) {
            switch (string.charAt(0)) {
                case 'e': {
                    this.typeConfig.setValue(MassPieceLoader.ENDS_WITH);
                    break;
                }
                case 'i': {
                    this.typeConfig.setValue(MassPieceLoader.INCLUDES);
                    break;
                }
                case 'm': {
                    this.typeConfig.setValue(MassPieceLoader.MATCHES);
                    break;
                }
                case 's': {
                    this.typeConfig.setValue(MassPieceLoader.EQUALS);
                    break;
                }
                case 'u': {
                    this.typeConfig.setValue(MassPieceLoader.BASE_IMAGE);
                }
            }
            this.nameConfig.setValue(string.substring(1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LoaderImagePicker
    extends MultiImagePicker {
        private static final long serialVersionUID = 1L;

        LoaderImagePicker() {
        }

        @Override
        public void addEntry() {
            String string = "Image " + (this.imageListElements.size() + 1);
            this.imageListElements.addElement(string);
            Entry entry = new Entry();
            this.multiPanel.add(string, entry);
            this.imageList.setSelectedIndex(this.imageListElements.size() - 1);
            this.cl.show(this.multiPanel, (String)this.imageList.getSelectedValue());
        }

        @Override
        public List<String> getImageNameList() {
            int n = this.imageListElements.size();
            ArrayList<String> arrayList = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(((Entry)this.multiPanel.getComponent(i)).toString());
            }
            return arrayList;
        }

        @Override
        public void clear() {
            this.multiPanel.removeAll();
            this.imageListElements.removeAllElements();
        }

        @Override
        public void setImageList(String[] stringArray) {
            while (stringArray.length > this.multiPanel.getComponentCount()) {
                this.addEntry();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                ((Entry)this.multiPanel.getComponent(i)).setImageName(stringArray[i]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Emb
    extends Embellishment {
        private ArrayList<String> builtImages = new ArrayList();

        public Emb() {
        }

        public Emb(String string, GamePiece gamePiece) {
            super(string, gamePiece);
        }

        public String[] getImageNames() {
            return this.imageName;
        }

        public String[] getLevelNames() {
            return this.commonName;
        }

        public boolean matchLayer(String string) {
            for (String string2 : this.imageName) {
                if (!this.match(string.split("\\.")[0], string2)) continue;
                return true;
            }
            return false;
        }

        protected boolean match(String string, String string2) {
            if (string2 != null && string2.length() > 1) {
                if (string2.charAt(0) == MassPieceLoader.BASE_IMAGE.charAt(0)) {
                    return false;
                }
                if (string2.charAt(0) == MassPieceLoader.ENDS_WITH.charAt(0)) {
                    return string.endsWith(string2.substring(1));
                }
                if (string2.charAt(0) == MassPieceLoader.INCLUDES.charAt(0)) {
                    return string.indexOf(string2.substring(1)) >= 0;
                }
                if (string2.charAt(0) == MassPieceLoader.EQUALS.charAt(0)) {
                    return string.equals(string2.substring(1));
                }
                try {
                    return Pattern.matches(string2.substring(1), string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean buildLayers(String string, ArrayList<String> arrayList) {
            String string2 = string.split("\\.")[0];
            int n = 0;
            this.builtImages.clear();
            for (int i = 0; i < this.imageName.length; ++i) {
                String string3 = this.imageName[i];
                String string4 = null;
                if (string3.charAt(0) == MassPieceLoader.BASE_IMAGE.charAt(0)) {
                    string4 = string;
                } else {
                    Iterator<String> iterator = arrayList.iterator();
                    while (iterator.hasNext() && string4 == null) {
                        String string5 = iterator.next();
                        String string6 = string5.split("\\.")[0];
                        if (string3.charAt(0) == MassPieceLoader.EQUALS.charAt(0)) {
                            if (!this.match(string6, string3)) continue;
                            string4 = string5;
                            continue;
                        }
                        if (!string5.startsWith(string2) || !this.match(string6, string3)) continue;
                        string4 = string5;
                    }
                }
                this.imageName[i] = string4;
                if (string4 == null) continue;
                ++n;
                this.builtImages.add(string4);
            }
            return n > 0;
        }

        public List<String> getBuiltImageList() {
            return this.builtImages;
        }

        @Override
        public PieceEditor getEditor() {
            return new LoaderEd(this);
        }

        public class LoaderEd
        extends Embellishment.Ed {
            public LoaderEd(Embellishment embellishment) {
                super(embellishment);
            }

            protected MultiImagePicker getImagePicker() {
                return new LoaderImagePicker();
            }
        }
    }

    class PieceInfo {
        protected String name;
        protected boolean skip;

        public PieceInfo(String string, boolean bl) {
            this.name = string;
            this.skip = bl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean bl) {
            this.skip = bl;
        }
    }

    class LevelNode
    extends BasicNode {
        int levelNumber;

        public LevelNode(String string, String string2, int n) {
            super(string, string2);
            this.levelNumber = n;
        }

        public String getDescription() {
            return "Level " + (this.levelNumber + 1) + (this.name.length() > 0 ? " [" + this.name + "]" : "");
        }

        public String getName() {
            return "";
        }
    }

    class LayerNode
    extends BasicNode {
        public LayerNode(String string) {
            super(string, "");
        }

        public String getDescription() {
            return "Layer" + (this.name.length() > 0 ? " [" + this.name + "]" : "");
        }

        public String getName() {
            return "";
        }
    }

    class PieceNode
    extends BasicNode {
        boolean noBasicPieceImage;

        public PieceNode(String string) {
            this.setImageName(string);
            PieceInfo pieceInfo = MassPieceLoader.this.pieceInfo.get(string);
            if (pieceInfo == null) {
                this.setName(ImageUtils.stripImageSuffix(string));
                this.setSkip(false);
            } else {
                this.setName(pieceInfo.getName());
                this.setSkip(pieceInfo.isSkip());
            }
        }

        public String getImageName() {
            if (basicConfig.booleanValue().booleanValue()) {
                return "";
            }
            return super.getImageName();
        }

        public String getDescription() {
            return "Piece";
        }

        public void setName(String string) {
            super.setName(string);
            MassPieceLoader.this.pieceInfo.put(this.getImageName(), new PieceInfo(string, this.isSkip()));
        }

        public void setSkip(boolean bl) {
            super.setSkip(bl);
            MassPieceLoader.this.pieceInfo.put(this.getImageName(), new PieceInfo(this.getName(), bl));
        }
    }

    class BasicNode
    extends DefaultMutableTreeTableNode {
        protected String name;
        protected String imageName;
        protected boolean skip;
        protected int copies;

        public BasicNode() {
            this("", "");
        }

        public BasicNode(String string, String string2) {
            this.name = string;
            this.imageName = string2;
            this.skip = false;
            this.copies = 1;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getImageName() {
            return this.imageName;
        }

        public void setImageName(String string) {
            this.imageName = string;
        }

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean bl) {
            this.skip = bl;
        }

        public void setCopies(int n) {
            this.copies = n;
        }

        public int getCopies() {
            return this.copies;
        }

        public String getDescription() {
            return "Root";
        }

        public Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.getDescription();
                }
                case 2: {
                    return this.getName();
                }
                case 1: {
                    return this.getImageName();
                }
                case 3: {
                    return this.isSkip();
                }
                case 4: {
                    return this.getCopies();
                }
            }
            return "";
        }
    }

    class NullRenderer
    implements TableCellRenderer {
        NullRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return new JLabel("");
        }
    }

    class MyTreeTable
    extends JXTreeTable {
        private static final long serialVersionUID = 1L;

        public MyTreeTable() {
            this.setRootVisible(false);
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (!(n2 != 3 && n2 != 4 || this.getPathForRow(n).getLastPathComponent() instanceof PieceNode)) {
                return new NullRenderer();
            }
            return super.getCellRenderer(n, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyTreeTableModel
    extends DefaultTreeTableModel {
        public MyTreeTableModel(BasicNode basicNode) {
            super((TreeTableNode)basicNode);
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Item";
                }
                case 2: {
                    return "Piece Name";
                }
                case 1: {
                    return "Image File";
                }
                case 3: {
                    return "Skip?";
                }
                case 4: {
                    return "Copies";
                }
            }
            return "";
        }

        public Class<?> getColumnClass(int n) {
            if (n == 3) {
                return Boolean.class;
            }
            if (n == 4) {
                return Integer.class;
            }
            return String.class;
        }

        public boolean isCellEditable(Object object, int n) {
            if (object instanceof PieceNode) {
                if (n == 2 || n == 4) {
                    return !((PieceNode)((Object)object)).isSkip();
                }
                if (n == 3) {
                    return true;
                }
            }
            return false;
        }

        public Object getValueAt(Object object, int n) {
            return ((BasicNode)((Object)object)).getValueAt(n);
        }

        public void setValueAt(Object object, Object object2, int n) {
            if (object2 instanceof PieceNode) {
                if (n == 2) {
                    ((PieceNode)((Object)object2)).setName((String)object);
                } else if (n == 3) {
                    ((PieceNode)((Object)object2)).setSkip((Boolean)object);
                } else if (n == 4) {
                    int n2;
                    int n3 = n2 = object == null ? 1 : (Integer)object;
                    if (n2 < 1) {
                        n2 = 1;
                    }
                    ((PieceNode)((Object)object2)).setCopies(n2);
                }
            } else {
                super.setValueAt(object, object2, n);
            }
        }
    }

    class DefineDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        protected boolean cancelled = false;

        public DefineDialog(JDialog jDialog) {
            this.setModal(true);
            this.setVisible(false);
            this.setTitle("Multiple Piece Template");
            this.setLocationRelativeTo(jDialog);
            Box box = Box.createVerticalBox();
            box.add(definer);
            JButton jButton = new JButton(Resources.getString("General.save"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DefineDialog.this.save();
                }
            });
            JButton jButton2 = new JButton(Resources.getString("General.cancel"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DefineDialog.this.cancel();
                }
            });
            Box box2 = Box.createHorizontalBox();
            box2.add(jButton);
            box2.add(jButton2);
            box.add(box2);
            this.add(box);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    DefineDialog.this.cancel();
                }
            });
            this.pack();
        }

        protected void save() {
            this.cancelled = false;
            this.setVisible(false);
        }

        protected void cancel() {
            this.cancelled = true;
            this.setVisible(false);
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }

    static class MassPieceDefiner
    extends PrototypeDefinition.Config.Definer {
        private static final long serialVersionUID = 1L;
        protected static DefaultListModel newModel;

        public MassPieceDefiner() {
            super(GameModule.getGameModule().getGpIdSupport());
            if (newModel == null) {
                newModel = new DefaultListModel();
                Enumeration enumeration = availableModel.elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (e instanceof Embellishment) {
                        newModel.addElement(new Emb());
                        continue;
                    }
                    newModel.addElement(e);
                }
            }
            this.availableList.setModel(newModel);
            this.setPiece(null);
        }
    }

    class MassLoaderDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        protected boolean cancelled;
        protected DefineDialog defineDialog;
        protected MyTreeTable tree;
        protected MyTreeTableModel model;
        protected BasicNode root;
        protected File loadDirectory;

        public MassLoaderDialog() {
            super(MassPieceLoader.this.configureTree.getFrame());
            this.cancelled = false;
            this.setModal(true);
            this.setTitle("Load Multiple Pieces");
            this.setLayout(new BoxLayout(this.getContentPane(), 1));
            this.setPreferredSize(new Dimension(800, 600));
            dirConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        MassLoaderDialog.this.buildTree((File)propertyChangeEvent.getNewValue());
                    }
                }
            });
            this.add(dirConfig.getControls());
            basicConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        MassLoaderDialog.this.buildTree(dirConfig.getFileValue());
                    }
                }
            });
            this.add(basicConfig.getControls());
            this.defineDialog = new DefineDialog(this);
            JButton jButton = new JButton("Edit Piece Template");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GamePiece gamePiece = definer.getPiece();
                    MassLoaderDialog.this.defineDialog.setVisible(true);
                    if (MassLoaderDialog.this.defineDialog.isCancelled()) {
                        definer.setPiece(gamePiece);
                    } else {
                        MassLoaderDialog.this.buildTree(dirConfig.getFileValue());
                    }
                }
            });
            this.add(jButton);
            this.tree = new MyTreeTable();
            this.buildTree(dirConfig.getFileValue());
            JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.tree));
            this.add(jScrollPane);
            Box box = Box.createHorizontalBox();
            JButton jButton2 = new JButton(Resources.getString("General.ok"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MassLoaderDialog.this.save();
                }
            });
            box.add(jButton2);
            JButton jButton3 = new JButton(Resources.getString("General.cancel"));
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MassLoaderDialog.this.cancel();
                }
            });
            box.add(jButton3);
            JButton jButton4 = new JButton(Resources.getString("General.help"));
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HelpFile helpFile = HelpFile.getReferenceManualPage("MassPieceLoader.htm");
                    BrowserSupport.openURL(helpFile.getContents().toString());
                }
            });
            box.add(jButton4);
            this.add(box);
            this.pack();
            this.setLocationRelativeTo(this.getParent());
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MassLoaderDialog.this.cancel();
                }
            });
        }

        public void cancel() {
            this.cancelled = true;
            this.dispose();
        }

        public void save() {
            int n = 0;
            for (int i = 0; i < this.root.getChildCount(); ++i) {
                PieceNode pieceNode = (PieceNode)this.root.getChildAt(i);
                if (pieceNode.isSkip()) continue;
                n += pieceNode.getCopies();
            }
            if (n > 0) {
                String string = "This will load " + n + " piece" + (n > 1 ? "s" : "") + " into component " + MassPieceLoader.this.target.getConfigureName() + ". There is no UNDO option for this process. Are you sure you wish to continue with the load?";
                int n2 = Dialogs.showConfirmDialog(null, "Confirm Load", "Confirm Load", string, 2, 1);
                if (n2 == 1) {
                    this.cancel();
                    return;
                }
                if (n2 == 2) {
                    return;
                }
            }
            this.cancelled = false;
            this.dispose();
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public File getDirectory() {
            return dirConfig.getFileValue();
        }

        protected void buildTree(File file) {
            this.loadDirectory = file;
            MassPieceLoader.this.layers.clear();
            GamePiece gamePiece = definer.getPiece();
            while (gamePiece instanceof Decorator) {
                if (!((gamePiece = Decorator.getDecorator(gamePiece, Emb.class)) instanceof Emb)) continue;
                MassPieceLoader.this.layers.add(0, (Emb)gamePiece);
                gamePiece = ((Emb)gamePiece).getInner();
            }
            this.loadImageNames(file);
            MassPieceLoader.this.baseImages.clear();
            MassPieceLoader.this.levelImages.clear();
            for (String string : MassPieceLoader.this.imageNames) {
                Emb emb;
                boolean bl = false;
                Iterator<Emb> iterator = MassPieceLoader.this.layers.iterator();
                while (iterator.hasNext() && !(bl = (emb = iterator.next()).matchLayer(string))) {
                }
                if (bl) {
                    MassPieceLoader.this.levelImages.add(string);
                    continue;
                }
                MassPieceLoader.this.baseImages.add(string);
            }
            this.root = new BasicNode();
            for (String string : MassPieceLoader.this.baseImages) {
                PieceNode pieceNode = new PieceNode(string);
                for (Emb emb : MassPieceLoader.this.layers) {
                    Emb emb2 = new Emb(emb.getType(), null);
                    if (!emb2.buildLayers(string, MassPieceLoader.this.levelImages)) continue;
                    LayerNode layerNode = new LayerNode(emb2.getLayerName());
                    for (int i = 0; i < emb2.getImageNames().length; ++i) {
                        String string2 = emb2.getLevelNames()[i];
                        LevelNode levelNode = new LevelNode(string2 == null ? "" : string2, emb2.getImageNames()[i], i);
                        layerNode.add((MutableTreeTableNode)levelNode);
                    }
                    pieceNode.add((MutableTreeTableNode)layerNode);
                }
                this.root.add((MutableTreeTableNode)pieceNode);
            }
            this.model = new MyTreeTableModel(this.root);
            this.tree.setTreeTableModel((TreeTableModel)this.model);
            TableColumnModel tableColumnModel = this.tree.getColumnModel();
            tableColumnModel.getColumn(0).setPreferredWidth(100);
            tableColumnModel.getColumn(0).setCellRenderer(new ImageNameRenderer());
            tableColumnModel.getColumn(2).setPreferredWidth(200);
            tableColumnModel.getColumn(2).setCellRenderer(new NameRenderer());
            tableColumnModel.getColumn(2).setCellEditor(new NameEditor(new JTextField()));
            tableColumnModel.getColumn(1).setPreferredWidth(200);
            tableColumnModel.getColumn(1).setCellRenderer(new ImageNameRenderer());
            tableColumnModel.getColumn(3).setPreferredWidth(50);
            tableColumnModel.getColumn(3).setMaxWidth(50);
            tableColumnModel.getColumn(4).setPreferredWidth(50);
            tableColumnModel.getColumn(4).setMaxWidth(50);
            tableColumnModel.getColumn(4).setCellRenderer(new CopiesRenderer());
        }

        protected void loadImageNames(File file) {
            MassPieceLoader.this.imageNames.clear();
            if (file != null && file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    String string = file2.getName();
                    if (!ImageUtils.hasImageSuffix(string)) continue;
                    MassPieceLoader.this.imageNames.add(string);
                }
            }
        }

        public void load() {
            File file = MassPieceLoader.this.dialog.getDirectory();
            if (file == null) {
                return;
            }
            for (int i = 0; i < this.root.getChildCount(); ++i) {
                PieceNode pieceNode = (PieceNode)this.root.getChildAt(i);
                if (pieceNode.isSkip()) continue;
                this.load(pieceNode);
            }
        }

        public void load(PieceNode pieceNode) {
            String string = pieceNode.getImageName();
            MassPieceLoader.this.addImageToModule(string);
            String string2 = new SequenceEncoder("", ';').append("").append(string).append(pieceNode.getName()).getValue();
            BasicPiece basicPiece = (BasicPiece)GameModule.getGameModule().createPiece("piece;" + string2);
            GamePiece gamePiece = definer.getPiece();
            ArrayList<Decorator> arrayList = new ArrayList<Decorator>();
            while (gamePiece != null && gamePiece instanceof Decorator) {
                arrayList.add(0, (Decorator)gamePiece);
                gamePiece = ((Decorator)gamePiece).getInner();
            }
            for (int i = 0; i < pieceNode.getCopies(); ++i) {
                GamePiece gamePiece2 = basicPiece;
                for (Decorator decorator : arrayList) {
                    Object object;
                    Decorator decorator2;
                    if (decorator instanceof Emb) {
                        decorator2 = new Emb(decorator.getType(), null);
                        if (!((Emb)decorator2).buildLayers(string, MassPieceLoader.this.levelImages)) continue;
                        for (String string3 : ((Emb)decorator2).getBuiltImageList()) {
                            MassPieceLoader.this.addImageToModule(string3);
                        }
                        decorator2.setInner(gamePiece2);
                        object = decorator2.getState();
                        gamePiece2 = GameModule.getGameModule().createPiece(decorator2.getType());
                        gamePiece2.setState((String)object);
                        continue;
                    }
                    decorator2 = (Decorator)GameModule.getGameModule().createPiece(decorator.getType());
                    decorator2.setState(decorator.getState());
                    decorator2.setInner(gamePiece2);
                    object = decorator2.getState();
                    gamePiece2 = GameModule.getGameModule().createPiece(decorator2.getType());
                    gamePiece2.setState((String)object);
                }
                Object object = null;
                Class[] classArray2 = MassPieceLoader.this.target.getAllowableConfigureComponents();
                for (int j = 0; j < classArray2.length && object == null; ++j) {
                    if (!classArray2[j].equals(CardSlot.class)) continue;
                    object = new CardSlot();
                    ((PieceSlot)object).setPiece(gamePiece2);
                }
                if (object == null) {
                    object = new PieceSlot(gamePiece2);
                }
                MassPieceLoader.this.configureTree.updateGpIds((Configurable)object);
                MassPieceLoader.this.configureTree.externalInsert(MassPieceLoader.this.target, (Configurable)object);
            }
        }

        class SkipRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;

            SkipRenderer() {
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (!(MassLoaderDialog.this.tree.getPathForRow(n).getLastPathComponent() instanceof PieceNode)) {
                    return new JLabel("");
                }
                return component;
            }
        }

        class NameEditor
        extends DefaultCellEditor {
            private static final long serialVersionUID = 1L;

            public NameEditor(JTextField jTextField) {
                super(jTextField);
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                component.setForeground(Color.blue);
                return component;
            }
        }

        class ImageNameRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;

            ImageNameRenderer() {
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                BasicNode basicNode = (BasicNode)((Object)MassLoaderDialog.this.tree.getPathForRow(n).getLastPathComponent());
                defaultTableCellRenderer.setEnabled(!basicNode.isSkip());
                if (basicNode instanceof PieceNode) {
                    String string = ((PieceNode)basicNode).getImageName();
                    String string2 = "<html><img src=\"file:/" + MassLoaderDialog.this.loadDirectory.getAbsolutePath() + "/" + string + "\"></html>";
                    defaultTableCellRenderer.setToolTipText(string2);
                }
                return defaultTableCellRenderer;
            }
        }

        class CopiesRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;

            CopiesRenderer() {
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                BasicNode basicNode = (BasicNode)((Object)MassLoaderDialog.this.tree.getPathForRow(n).getLastPathComponent());
                jLabel.setHorizontalAlignment(0);
                jLabel.setEnabled(!basicNode.isSkip());
                jLabel.setForeground(EDITABLE_COLOR);
                return jLabel;
            }
        }

        class NameRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;

            NameRenderer() {
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                BasicNode basicNode = (BasicNode)((Object)MassLoaderDialog.this.tree.getPathForRow(n).getLastPathComponent());
                component.setEnabled(!basicNode.isSkip());
                component.setForeground(EDITABLE_COLOR);
                return component;
            }
        }
    }
}

