/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.tools.ArrayUtils;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ImageFileFilter;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OpIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ImagePicker
extends JPanel
implements MouseListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static final String NO_IMAGE = "(No Image)";
    private String imageName = null;
    protected static Font FONT = new Font("Dialog", 0, 11);
    private final JTextArea noImage = new JTextArea(1, 10);
    private final JComboBox select;
    private final OpIcon icon;
    private final JLabel imageView;
    private final JPanel imageViewer;
    private final JScrollPane imageScroller;

    public ImagePicker() {
        this.noImage.setFont(FONT);
        this.noImage.setText("Double-click here to add new image");
        this.noImage.addMouseListener(this);
        this.noImage.setEditable(false);
        this.noImage.setLineWrap(true);
        this.noImage.setWrapStyleWord(true);
        this.noImage.setMinimumSize(new Dimension(15, 32));
        this.icon = new OpIcon();
        this.imageView = new JLabel(this.icon);
        this.imageView.addMouseListener(this);
        this.imageViewer = new JPanel(new BorderLayout());
        this.imageScroller = new ScrollPane(this.imageView, 20, 30);
        this.imageViewer.add((Component)this.imageScroller, "Center");
        this.select = new JComboBox<String>(ArrayUtils.prepend(GameModule.getGameModule().getDataArchive().getImageNames(), NO_IMAGE));
        this.select.addItemListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.noImage);
        this.add(this.select);
    }

    public String getImageName() {
        return this.imageName;
    }

    protected void setViewSize() {
    }

    public void setImageName(String string) {
        Serializable serializable;
        this.imageName = string;
        this.remove(0);
        if (string == null || string.trim().length() == 0 || string.equals(NO_IMAGE)) {
            this.imageName = "";
            this.add((Component)this.noImage, 0);
        } else {
            this.icon.setOp(Op.load(this.imageName));
            serializable = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
            if (((Dimension)serializable).width > 200) {
                ((Dimension)serializable).width = 200;
            }
            ((Dimension)serializable).height = ((Dimension)serializable).height > 200 ? 200 : (((Dimension)serializable).height += 4);
            this.imageScroller.setPreferredSize((Dimension)serializable);
            this.imageScroller.setMinimumSize((Dimension)serializable);
            this.add((Component)this.imageViewer, 0);
        }
        this.select.removeItemListener(this);
        this.select.setSelectedItem(string);
        if (string != null && !string.equals(this.select.getSelectedItem())) {
            this.select.setSelectedItem(string + ".gif");
        }
        this.select.addItemListener(this);
        this.revalidate();
        serializable = SwingUtilities.getWindowAncestor(this);
        if (serializable != null) {
            ((Window)serializable).pack();
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.pickImage();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setImageName((String)this.select.getSelectedItem());
    }

    public void pickImage() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        fileChooser.setFileFilter(new ImageFileFilter());
        if (fileChooser.showOpenDialog(this) == 0 && fileChooser.getSelectedFile().exists()) {
            String string = fileChooser.getSelectedFile().getName();
            GameModule.getGameModule().getArchiveWriter().addImage(fileChooser.getSelectedFile().getPath(), string);
            this.select.setModel(new DefaultComboBoxModel<String>(ArrayUtils.prepend(GameModule.getGameModule().getDataArchive().getImageNames(), NO_IMAGE)));
            this.setImageName(string);
        } else {
            this.setImageName(NO_IMAGE);
        }
        this.repaint();
    }
}

