/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.turn;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.turn.TurnLevel;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.ArrayUtils;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterTurnLevel
extends TurnLevel {
    protected static final String START = "start";
    protected static final String INCR = "incr";
    protected static final String LOOP = "loop";
    protected static final String LOOP_LIMIT = "loopLimit";
    protected int incr = 1;
    protected boolean loop = false;
    protected int loopLimit = -1;
    private VisibilityCondition loopCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return CounterTurnLevel.this.loop;
        }
    };

    @Override
    protected void reset() {
        super.reset();
        this.setLow();
    }

    @Override
    protected void setLow() {
        this.current = this.start;
        super.setLow();
    }

    @Override
    protected void setHigh() {
        this.current = this.loopLimit;
        super.setHigh();
    }

    @Override
    protected String getState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.current);
        sequenceEncoder.append(this.currentSubLevel);
        sequenceEncoder.append(this.loop);
        sequenceEncoder.append(this.loopLimit);
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            sequenceEncoder.append(this.getTurnLevel(i).getState());
        }
        return sequenceEncoder.getValue();
    }

    @Override
    protected void setState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.current = decoder.nextInt(this.start);
        this.currentSubLevel = decoder.nextInt(0);
        this.loop = decoder.nextBoolean(false);
        this.loopLimit = decoder.nextInt(-1);
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            this.getTurnLevel(i).setState(decoder.nextToken(""));
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    protected String getValueString() {
        return String.valueOf(this.current);
    }

    @Override
    protected String getLongestValueName() {
        return this.start < 10000 ? "9999" : String.valueOf(this.start);
    }

    @Override
    protected void advance() {
        super.advance();
        if (this.getTurnLevelCount() == 0 || this.getTurnLevelCount() > 0 && this.hasSubLevelRolledOver()) {
            this.current += this.incr;
            if (this.loop && this.current > this.loopLimit) {
                this.current = this.start;
                this.setRolledOver(true);
            }
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    protected void retreat() {
        super.retreat();
        int n = this.current;
        if (this.getTurnLevelCount() == 0 || this.getTurnLevelCount() > 0 && this.hasSubLevelRolledOver()) {
            this.current -= this.incr;
            if (this.loop && n <= this.start) {
                this.current = this.loopLimit;
                this.setRolledOver(true);
            }
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    protected Component getSetControl() {
        IntConfigurer intConfigurer = new IntConfigurer("", " " + this.getConfigureName() + ":  ", (Integer)this.current);
        intConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CounterTurnLevel.this.current = (Integer)((IntConfigurer)propertyChangeEvent.getSource()).getValue();
                CounterTurnLevel.this.myValue.setPropertyValue(CounterTurnLevel.this.getValueString());
            }
        });
        return intConfigurer.getControls();
    }

    @Override
    public String[] getAttributeDescriptions() {
        return ArrayUtils.append(super.getAttributeDescriptions(), "Start Value:  ", "Increment By:  ", "Loop?", "Maximum value:  ");
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return ArrayUtils.append(super.getAttributeTypes(), Integer.class, Integer.class, Boolean.class, Integer.class);
    }

    @Override
    public String[] getAttributeNames() {
        return ArrayUtils.append(super.getAttributeNames(), START, INCR, LOOP, LOOP_LIMIT);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (START.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.current = this.start = ((Integer)object).intValue();
            this.myValue.setPropertyValue(this.getValueString());
        } else if (INCR.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.incr = (Integer)object;
        } else if (LOOP.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.loop = (Boolean)object;
        } else if (LOOP_LIMIT.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.loopLimit = (Integer)object;
        } else {
            super.setAttribute(string, object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (START.equals(string)) {
            return this.start + "";
        }
        if (INCR.equals(string)) {
            return this.incr + "";
        }
        if (LOOP.equals(string)) {
            return this.loop + "";
        }
        if (LOOP_LIMIT.equals(string)) {
            return this.loopLimit + "";
        }
        return super.getAttributeValueString(string);
    }

    public static String getConfigureTypeName() {
        return "Counter";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TurnTracker.htm", "Counter");
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (LOOP_LIMIT.equals(string)) {
            return this.loopCond;
        }
        return null;
    }
}

