/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.SizeConfigurer;
import VASSAL.build.module.gamepieceimage.SymbolConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.tools.SequenceEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolItemInstance
extends ItemInstance {
    public static final String SIZE = "size";
    public static final String SIZE_COLOR = "sizeColor";
    public static final String SYMBOL1 = "symbol1";
    public static final String SYMBOL2 = "symbol2";
    protected String size;
    protected String symbol1;
    protected String symbol2;
    private ColorSwatch sizeColor = ColorSwatch.getBlack();

    public SymbolItemInstance() {
    }

    public SymbolItemInstance(String string, String string2, String string3, String string4, String string5, String string6) {
        super(string, string2, string3);
        this.setSize(string4);
        this.setSymbol1(string5);
        this.setSymbol2(string6);
    }

    public SymbolItemInstance(String string, GamePieceImage gamePieceImage) {
        super(gamePieceImage);
        this.decode(string);
    }

    @Override
    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.getType());
        sequenceEncoder.append(this.getName());
        sequenceEncoder.append(this.getLocation());
        sequenceEncoder.append(this.getFgColor().encode());
        sequenceEncoder.append(this.getBgColor().encode());
        sequenceEncoder.append(this.getSize());
        sequenceEncoder.append(this.getSymbol1());
        sequenceEncoder.append(this.getSymbol2());
        sequenceEncoder.append(this.getSizeColor().encode());
        return sequenceEncoder.getValue();
    }

    public void decode(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.setType(decoder.nextToken(""));
        this.setName(decoder.nextToken(""));
        this.setLocation(decoder.nextToken(""));
        this.setFgColor(new ColorSwatch(decoder.nextToken("")));
        this.setBgColor(new ColorSwatch(decoder.nextToken("")));
        this.setSize(decoder.nextToken(""));
        this.setSymbol1(decoder.nextToken(""));
        this.setSymbol2(decoder.nextToken(""));
        this.setSizeColor(new ColorSwatch(decoder.nextToken("")));
    }

    public void setSize(String string) {
        this.size = string;
    }

    public String getSize() {
        return this.size;
    }

    protected void setSizeColor(ColorSwatch colorSwatch) {
        this.sizeColor = colorSwatch;
    }

    protected ColorSwatch getSizeColor() {
        return this.sizeColor;
    }

    public void setSymbol1(String string) {
        this.symbol1 = string;
    }

    public String getSymbol1() {
        return this.symbol1;
    }

    public void setSymbol2(String string) {
        this.symbol2 = string;
    }

    public String getSymbol2() {
        return this.symbol2;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Unit Size:  ", "1st Symbol:  ", "2nd Symbol:  ", "Symbol Color:  ", "Background Color:  ", "Size Color:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{SizeConfig.class, Symbol1Config.class, Symbol2Config.class, FgColorSwatchConfig.class, BgColorSwatchConfig.class, SizeColorSwatchConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{SIZE, SYMBOL1, SYMBOL2, "fgColor", "bgColor", SIZE_COLOR};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (SIZE.equals(string)) {
            this.size = (String)object;
        } else if (SYMBOL1.equals(string)) {
            this.symbol1 = (String)object;
        } else if (SYMBOL2.equals(string)) {
            this.symbol2 = (String)object;
        } else if ("fgColor".equals(string)) {
            if (object instanceof String) {
                object = new ColorSwatch((String)object);
            }
            this.fgColor = (ColorSwatch)object;
        } else if ("bgColor".equals(string)) {
            if (object instanceof String) {
                object = new ColorSwatch((String)object);
            }
            this.bgColor = (ColorSwatch)object;
        } else if (SIZE_COLOR.equals(string)) {
            if (object instanceof String) {
                object = new ColorSwatch((String)object);
            }
            this.sizeColor = (ColorSwatch)object;
        }
        if (this.myConfig != null) {
            this.myConfig.rebuildViz();
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (SIZE.equals(string)) {
            return this.size;
        }
        if (SYMBOL1.equals(string)) {
            return this.symbol1;
        }
        if (SYMBOL2.equals(string)) {
            return this.symbol2;
        }
        if ("fgColor".equals(string)) {
            return this.fgColor.encode();
        }
        if ("bgColor".equals(string)) {
            return this.bgColor.encode();
        }
        if (SIZE_COLOR.equals(string)) {
            return this.sizeColor.encode();
        }
        return null;
    }

    public static class SizeColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((SymbolItemInstance)autoConfigurable).getFgColor());
        }
    }

    public static class FgColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((SymbolItemInstance)autoConfigurable).getFgColor());
        }
    }

    public static class BgColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((SymbolItemInstance)autoConfigurable).getBgColor());
        }
    }

    public static class Symbol2Config
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new SymbolConfigurer(string, string2);
        }
    }

    public static class Symbol1Config
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new SymbolConfigurer(string, string2);
        }
    }

    public static class SizeConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new SizeConfigurer(string, string2);
        }
    }
}

