/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.build.module.ExtensionsManager;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.ModulePlugin;
import VASSAL.command.Command;
import VASSAL.i18n.Resources;
import VASSAL.tools.DataArchive;
import VASSAL.tools.SequenceEncoder;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;

public class PluginsLoader
extends ExtensionsLoader {
    public static final String COMMAND_PREFIX = "PLUGIN\t";
    private ExtensionsManager extMgr = new ExtensionsManager("plugins");

    public void addTo(GameModule gameModule) {
        gameModule.addCommandEncoder(this);
        for (File file : this.extMgr.getActiveExtensions()) {
            this.addExtension(file);
        }
    }

    protected ModuleExtension createExtension(String string) throws ZipException, IOException {
        return new ModulePlugin(new DataArchive(string));
    }

    public Command decode(String string) {
        Command command = null;
        if (string.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(COMMAND_PREFIX.length()), '\t');
            command = new ModulePlugin.RegCmd(decoder.nextToken(), decoder.nextToken());
        } else {
            command = super.decode(string);
        }
        return command;
    }

    public String encode(Command command) {
        String string = null;
        if (command instanceof ModulePlugin.RegCmd) {
            ModulePlugin.RegCmd regCmd = (ModulePlugin.RegCmd)command;
            SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
            sequenceEncoder.append(regCmd.getName()).append(regCmd.getVersion());
            string = COMMAND_PREFIX + sequenceEncoder.getValue();
        } else {
            string = super.encode(command);
        }
        return string;
    }

    public static String getPluginDirectory() {
        return new ExtensionsManager("plugins").getExtensionsDirectory(false).getPath();
    }

    protected String getLoadedMessage(String string, String string2) {
        return Resources.getString("PluginsLoader.plugin_loaded", string, string2);
    }

    protected String getErrorMessage(String string, String string2) {
        return Resources.getString("PluginsLoader.unable_to_load", string, string2);
    }

    public static interface PluginElement {
    }
}

