/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Translatable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurable
extends AbstractBuildable
implements AutoConfigurable {
    protected PropertyChangeSupport changeSupport;
    protected String name;
    protected String localizedName;
    protected Configurer config;
    protected ComponentI18nData myI18nData;

    @Override
    public void remove(Buildable buildable) {
        this.buildComponents.remove(buildable);
    }

    @Override
    public String getConfigureName() {
        return this.name;
    }

    public String getLocalizedConfigureName() {
        return this.localizedName;
    }

    public void setConfigureName(String string) {
        String string2 = this.name;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("name", string2, string);
        }
        if (Localization.getInstance().isTranslationInProgress()) {
            this.localizedName = string;
        } else if (Localization.getInstance().isTranslationComplete()) {
            this.name = string;
        } else {
            this.name = string;
            this.localizedName = string;
        }
    }

    @Override
    public abstract String[] getAttributeDescriptions();

    @Override
    public abstract Class<?>[] getAttributeTypes();

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        return null;
    }

    @Override
    public ComponentI18nData getI18nData() {
        if (this.myI18nData == null) {
            this.myI18nData = new ComponentI18nData(this, this.getI18nPrefix());
        }
        return this.myI18nData;
    }

    protected String getI18nPrefix() {
        String string = this.getClass().getSimpleName();
        if (this.getConfigureName() != null && this.getConfigureName().length() > 0) {
            string = string + "." + this.getConfigureName();
        }
        return string + ".";
    }

    protected void setAttributeTranslatable(String string, boolean bl) {
        this.getI18nData().setAttributeTranslatable(string, bl);
    }

    protected void setAllAttributesUntranslatable() {
        this.getI18nData().setAllAttributesUntranslatable();
    }

    @Override
    public void add(Buildable buildable) {
        super.add(buildable);
        if (buildable instanceof Translatable) {
            ((Translatable)buildable).getI18nData().setOwningComponent(this);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public Configurable[] getConfigureComponents() {
        ArrayList<Configurable> arrayList = new ArrayList<Configurable>();
        for (Buildable buildable : this.getBuildables()) {
            if (!(buildable instanceof Configurable)) continue;
            arrayList.add((Configurable)buildable);
        }
        return arrayList.toArray(new Configurable[arrayList.size()]);
    }

    @Override
    public Configurer getConfigurer() {
        if (this.config == null) {
            this.config = new AutoConfigurer(this);
        } else {
            ((AutoConfigurer)this.config).reset();
        }
        return this.config;
    }
}

